/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.DefinitionObject;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;
import org.eclipse.epf.publishing.services.index.KeyWordFile;
import org.eclipse.epf.publishing.services.index.KeyWordHolder;
import org.eclipse.epf.publishing.services.index.KeyWordIndexException;
import org.eclipse.epf.publishing.services.index.KeyWordStatic;
import org.eclipse.epf.publishing.services.index.MiscStatic;
import org.eclipse.epf.publishing.services.index.StringDefinitions;

public class KeyWordIndexHelper {
    KeyWordHolder holder = new KeyWordHolder();
    static DefinitionObject defObj = null;
    private static String deffile = null;
    private static String charSet = null;
    private static String helpFile = null;

    KeyWordIndexHelper() {
        deffile = null;
    }

    public KeyWordIndexHelper(String string, String string2, String string3) {
        deffile = string;
        charSet = string2;
        helpFile = string3;
    }

    void setDeffile(String string) {
        deffile = string;
    }

    void setCharSet(String string) {
        charSet = string;
    }

    void setHelpFile(String string) {
        helpFile = string;
    }

    public DefinitionObject loadDefinition(String string) throws Exception {
        if (deffile == null) {
            throw new KeyWordIndexException("KeyWordIndexHelper:execute()", StringDefinitions.ERROR_DEFINITION_FILE_NOT_FOUND);
        }
        if (helpFile != null) {
            HelpMessages.loadHelpMessages(helpFile, charSet);
        }
        defObj = new DefinitionObject(string, deffile, charSet);
        return defObj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(IProgressMonitor iProgressMonitor) throws KeyWordIndexException {
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (!defObj.enoughInput()) throw new KeyWordIndexException("KeyWordIndexHelper:execute()", HelpMessages.NOT_ENOUGH_INPUT);
        File file = new File(defObj.getWwwRoot());
        if (!file.isDirectory()) {
            throw new KeyWordIndexException("KeyWordIndexHelper:execute()", String.valueOf(Def.StartDir) + ": " + defObj.getWwwRoot() + HelpMessages.NO_DIRECTORY);
        }
        System.out.println(String.valueOf(HelpMessages.PARSE_DIRECTORY) + defObj.getWwwRoot());
        System.out.println(HelpMessages.TAKE_A_WHILE);
        this.readDir(file, iProgressMonitor);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        this.holder.divide();
        String string = defObj.getKeyWordFile();
        if (string != null) {
            String string2 = MiscStatic.loadFile(string, defObj.getCharacterSet());
            if (string2.equals(Def.None)) throw new KeyWordIndexException("KeyWordIndexHelper:execute()", String.valueOf(string) + HelpMessages.KEYWORD_FILE_SYNTAX_ERROR);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t\n");
            this.holder.readSpecKeyWords(stringTokenizer);
        }
        this.holder.print();
    }

    private void readDir(File file, IProgressMonitor iProgressMonitor) {
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            String string = file.getAbsolutePath();
            try {
                string = file.getCanonicalPath();
            }
            catch (Exception exception) {
                System.out.println("KeyWordIndexHelper:readDir\n" + HelpMessages.EXCEPTION + exception.toString());
            }
            string = string.replace('\\', '/');
            File file2 = new File(String.valueOf(string) + "/" + stringArray[n]);
            if (file2.isDirectory()) {
                String string2 = file2.getAbsolutePath();
                try {
                    string2 = file2.getCanonicalPath();
                }
                catch (Exception exception) {
                    System.out.println("KeyWordIndexHelper:readDir\n" + HelpMessages.EXCEPTION + exception.toString());
                }
                string2 = string2.replace('\\', '/');
                if (!defObj.isInStopdir(string2)) {
                    this.readDir(file2, iProgressMonitor);
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                } else {
                    try {
                        System.out.println(String.valueOf(HelpMessages.DIRECTORY_NOT_PARSED) + file2.getCanonicalPath());
                    }
                    catch (Exception exception) {
                        System.out.println("KeyWordIndexHelper:readDir\n" + HelpMessages.EXCEPTION + exception.toString());
                    }
                }
            } else if (stringArray[n].endsWith(".htm") || stringArray[n].endsWith(".html") || stringArray[n].endsWith(".shtml") || stringArray[n].endsWith(".shtm")) {
                this.loadFile(String.valueOf(file.getAbsolutePath()) + "/" + stringArray[n]);
            }
            ++n;
        }
    }

    private void loadFile(String string) {
        List list;
        String string2 = MiscStatic.loadFile(string, defObj.getCharacterSet());
        if (string2 != null && string2.length() > 0 && (list = KeyWordStatic.getKeyWords(string2)) != null && list.size() > 0) {
            IO.printDebug("keyword " + list);
            String string3 = MiscStatic.getTitle(string2);
            this.holder.add(new KeyWordFile(string3, String.valueOf(defObj.getRelativePath()) + string.substring(defObj.getWwwRootLength()), list));
        }
    }
}

