/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.richtext.dialogs.FindReplaceDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class FindReplaceAction
extends RichTextAction {
    public static final int FIND_TEXT = 1;
    public static final int REPLACE_TEXT = 2;
    public static final int REPLACE_FIND_TEXT = 3;
    public static final int REPLACE_ALL_TEXT = 4;
    public static final int FORWARD_MATCH = 1;
    public static final int BACKWARD_MATCH = -1;
    public static final int WHOLE_WORD_MATCH = 2;
    public static final int CASE_SENSITIVE_MATCH = 4;
    private static final String ENCODED_SINGLE_QUOTE = "%sq%";
    private IRichText richText;
    private StyledText styledText;
    protected boolean foundMatch = false;
    protected FindReplaceDialog dialog;

    public FindReplaceAction(IRichText iRichText) {
        super(iRichText, 1);
        this.setImageDescriptor(RichTextImages.IMG_DESC_FIND_REPLACE);
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_FIND_REPLACE);
        this.setToolTipText(RichTextResources.findReplaceAction_toolTipText);
    }

    public boolean disableInReadOnlyMode() {
        return false;
    }

    public boolean disableInSourceMode() {
        return false;
    }

    public void execute(IRichText iRichText) {
        if (this.richText == null) {
            this.richText = iRichText;
        }
        if (this.richText != null) {
            try {
                if (this.dialog != null) {
                    this.dialog.setFindOnly(!this.richText.getEditable());
                    this.dialog.open();
                } else {
                    this.dialog = new FindReplaceDialog(Display.getCurrent().getActiveShell(), this, !this.richText.getEditable());
                    this.dialog.open();
                }
            }
            catch (Exception exception) {
                RichTextPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    }

    public boolean getFoundMatch() {
        return this.foundMatch;
    }

    public void run(int n, String string, String string2, int n2, int n3) {
        this.styledText = null;
        if (this.richText instanceof RichTextEditor && ((RichTextEditor)this.richText).isHTMLTabSelected()) {
            this.styledText = ((RichTextEditor)this.richText).getSourceEdit();
        }
        if (this.styledText == null) {
            if (string.indexOf("'") != -1) {
                string = string.replaceAll("'", ENCODED_SINGLE_QUOTE);
            }
            if (string2.indexOf("'") != -1) {
                string2 = string2.replaceAll("'", ENCODED_SINGLE_QUOTE);
            }
        }
        try {
            this.foundMatch = false;
            int n4 = 0;
            switch (n) {
                case 1: {
                    n4 = this.findText(string, n2, n3);
                    break;
                }
                case 2: {
                    n4 = this.replaceText(string2, n2, n3);
                    break;
                }
                case 3: {
                    n4 = this.replaceFindText(string, string2, n2, n3);
                    break;
                }
                case 4: {
                    this.replaceAll(string, string2, n3);
                }
            }
            if (n4 > 0) {
                this.foundMatch = true;
            }
        }
        catch (Exception exception) {
            RichTextPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    private static String escape(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private int findText(String string, int n, int n2) {
        int n3 = 0;
        n3 = this.styledText != null ? this.styledTextFindTextAndSelect(string, n, n2) : this.richText.executeCommand("findText", new String[]{string, "" + n, "" + n2});
        return n3;
    }

    private int replaceText(String string, int n, int n2) {
        int n3 = 0;
        n3 = this.styledText != null ? this.styledTextReplaceTextAndSelect(string) : this.richText.executeCommand("replaceText", new String[]{string, "" + n, "" + n2});
        return n3;
    }

    private int replaceFindText(String string, String string2, int n, int n2) {
        int n3 = 0;
        if (this.styledText != null) {
            this.styledTextReplaceTextAndSelect(string2);
            n3 = this.styledTextFindTextAndSelect(string, n, n2);
        } else {
            this.richText.executeCommand("replaceText", new String[]{string2, "" + n, "" + n2});
            n3 = this.richText.executeCommand("findText", new String[]{string, "" + n, "" + n2});
        }
        return n3;
    }

    private void replaceAll(String string, String string2, int n) {
        if (this.styledText != null) {
            this.styledTextReplaceAll(string, string2, n);
        } else {
            this.richText.executeCommand("replaceAllText", new String[]{FindReplaceAction.escape(string), FindReplaceAction.escape(string2), "" + n});
        }
    }

    private int styledTextFindTextAndSelect(String string, int n, int n2) {
        Point point = this.styledText.getSelectionRange();
        int n3 = point.x;
        int n4 = point.x + point.y - 1;
        String string2 = this.styledText.getText();
        int n5 = -1;
        if ((n2 & 4) == 0) {
            string2 = string2.toUpperCase();
            string = string.toUpperCase();
        }
        do {
            if (n5 == -1) continue;
            n4 = n5 + 1;
            n3 = n5 - 1;
        } while ((n5 = n == 1 ? string2.indexOf(string, n4 + 1) : string2.lastIndexOf(string, n3 - 1)) != -1 && (n2 & 2) == 2 && this.isPartOfWord(string2, n5, string.length()));
        if (n5 != -1) {
            this.styledText.setSelectionRange(n5, string.length());
            this.styledText.showSelection();
        } else {
            String string3 = this.styledText.getSelectionText();
            if ((n2 & 4) == 0) {
                string3 = string3.toUpperCase();
            }
            if (string3.equals(string)) {
                n5 = this.styledText.getSelectionRange().x;
            }
        }
        return n5;
    }

    private int styledTextReplaceTextAndSelect(String string) {
        Point point = this.styledText.getSelectionRange();
        this.styledText.replaceTextRange(point.x, point.y, string);
        this.styledText.setSelectionRange(point.x, string.length());
        return 1;
    }

    private void styledTextReplaceAll(String string, String string2, int n) {
        this.styledText.setSelectionRange(0, 0);
        while (this.styledTextFindTextAndSelect(string, 1, n) != -1) {
            this.styledTextReplaceTextAndSelect(string2);
        }
    }

    private boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c);
    }

    private boolean isPartOfWord(String string, int n, int n2) {
        if (n > 0 && this.isWordChar(string.charAt(n - 1))) {
            return true;
        }
        return string.length() >= n + n2 && this.isWordChar(string.charAt(n + n2));
    }

    public IRichText getRichText() {
        return this.richText;
    }

    public void setRichText(IRichText iRichText) {
        this.richText = iRichText;
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.close();
            this.dialog = null;
        }
    }
}

