/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextComboAction;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontNameAction
extends RichTextComboAction {
    public FontNameAction(final IRichText iRichText) {
        super(iRichText);
        this.setToolTipText(RichTextResources.fontNameAction_toolTipText);
        TreeSet<String> treeSet = new TreeSet<String>();
        FontData[] fontDataArray = Display.getCurrent().getFontList(null, true);
        int n = 0;
        while (n < fontDataArray.length) {
            treeSet.add(fontDataArray[n].getName());
            ++n;
        }
        this.input = new ArrayList();
        this.input.add(RichTextResources.fontNameAction_DefaultFontName);
        for (String string : treeSet) {
            this.input.add(string);
        }
        iRichText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                String string = iRichText.getSelected().getFontName();
                if (string.equals(RichTextResources.fontNameAction_CSS_Default) || string.equals(RichTextResources.fontNameAction_CSS_Default_Mozilla) || string.equals("default")) {
                    string = RichTextResources.fontNameAction_DefaultFontName;
                }
                int n = FontNameAction.this.findFontNameInItems(string);
                FontNameAction.this.setNotifyListeners(false);
                FontNameAction.this.getCCombo().select(n);
                FontNameAction.this.setNotifyListeners(true);
            }
        });
    }

    private int findFontNameInItems(String string) {
        int n = -1;
        for (String string2 : this.input) {
            ++n;
            if (!string2.equalsIgnoreCase(string)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public void execute(IRichText iRichText) {
        if (iRichText != null) {
            String string = this.getCComboSelection();
            if (string.equals(RichTextResources.fontNameAction_DefaultFontName)) {
                iRichText.executeCommand("setFontName", "");
            } else {
                iRichText.executeCommand("setFontName", string);
            }
        }
    }

    @Override
    public Collection<String> getInput() {
        return this.input;
    }
}

