/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.html;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.richtext.RichTextResources;

public class FontName {
    private static final String NAME_DEFAULT = RichTextResources.fontName_default;
    private static final String NAME_ARIAL = RichTextResources.fontName_arial;
    private static final String NAME_COURIER_NEW = RichTextResources.fontName_courierNew;
    private static final String NAME_TIMES_NEW_ROMAN = RichTextResources.fontName_timesNewRoman;
    private static final String NAME_VERDANA = RichTextResources.fontName_verdana;
    private static final String VALUE_DEFAULT = "";
    private static final String VALUE_ARIAL = "Arial, Helvetica, sans-serif";
    private static final String VALUE_COURIER_NEW = "Courier New, Courier, mono";
    private static final String VALUE_TIMES_NEW_ROMAN = "Times New Roman, Times, serif";
    private static final String VALUE_VERDANA = "Verdana, Arial, Helvetica, sans-serif";
    public static final FontName DEFAULT = new FontName(NAME_DEFAULT, "");
    public static final FontName ARIAL = new FontName(NAME_ARIAL, "Arial, Helvetica, sans-serif");
    public static final FontName COURIER_NEW = new FontName(NAME_COURIER_NEW, "Courier New, Courier, mono");
    public static final FontName TIMES_NEW_ROMAN = new FontName(NAME_TIMES_NEW_ROMAN, "Times New Roman, Times, serif");
    public static final FontName VERDANA = new FontName(NAME_VERDANA, "Verdana, Arial, Helvetica, sans-serif");
    private static final List<FontName> FONT_NAMES = new ArrayList<FontName>();
    private String name;
    private String value;

    static {
        FONT_NAMES.add(DEFAULT);
        FONT_NAMES.add(ARIAL);
        FONT_NAMES.add(COURIER_NEW);
        FONT_NAMES.add(TIMES_NEW_ROMAN);
        FONT_NAMES.add(VERDANA);
    }

    public FontName(String string, String string2) {
        this.name = string;
        this.value = string2;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static FontName getFontName(int n) {
        FontName fontName = FONT_NAMES.get(n);
        if (fontName != null) {
            return fontName;
        }
        return DEFAULT;
    }
}

