/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.ad.map;

import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.util.DiagramCoreUtil;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.migration.diagram.ad.map.IMapConstants;
import org.eclipse.epf.migration.diagram.ad.map.MapUtil;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.UMLPackage;

public class MapNode
implements IMapConstants {
    protected Node node;
    protected org.eclipse.gmf.runtime.notation.Node notationNode;
    private Activity activity;
    private Diagram diagram;
    protected String name;
    protected ActivityNode umlNode;
    private static final int IMAGE_HEIGHT = 32;

    public MapNode(Node node) {
        this.node = node;
    }

    public MapNode() {
    }

    public org.eclipse.gmf.runtime.notation.Node updateResource() {
        ActivityNode activityNode;
        org.eclipse.gmf.runtime.notation.Node node;
        Diagram diagram = this.getDiagram();
        if (graphUMLNodeMap.get(this.node) != null && (node = this.findNotationNode(diagram, activityNode = (ActivityNode)graphUMLNodeMap.get(this.node))) != null) {
            return node;
        }
        this.updateNode();
        this.notationNode = MapUtil.createNotationNode_AD(diagram, this.umlNode);
        diagram.insertChild((View)this.notationNode);
        this.setLayoutConstraint(this.node, this.notationNode);
        this.notationNode.setElement((EObject)this.umlNode);
        this.setInheritedAttribute(this.node, this.notationNode);
        return this.notationNode;
    }

    private void setLayoutConstraint(Node node, org.eclipse.gmf.runtime.notation.Node node2) {
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        int n = new Integer(node2.getType());
        if (node.getHeight() == -1) {
            if (n == 1005 || n == 1002) {
                bounds.setHeight(24);
            } else if (n == 1003 || n == 1006) {
                bounds.setHeight(5);
            } else if (n == 1001) {
                bounds.setHeight(24);
            }
        } else {
            bounds.setHeight(node.getHeight());
        }
        if (node.getWidth() == -1 && (n == 1005 || n == 1002)) {
            bounds.setWidth(48);
        } else {
            bounds.setWidth(node.getWidth());
        }
        int n2 = bounds.getWidth();
        int n3 = bounds.getHeight();
        Dimension dimension = DiagramCoreUtil.getTextSizeInWrapLabel((String)this.name, null, (int)n2, (int)n3, null);
        int n4 = dimension.width;
        if (n2 < n4 && n4 != 0) {
            bounds.setWidth(n4);
        }
        bounds.setX(node.getLocation().x);
        bounds.setY(node.getLocation().y);
        node2.setLayoutConstraint((LayoutConstraint)bounds);
    }

    private void setInheritedAttribute(Node node, org.eclipse.gmf.runtime.notation.Node node2) {
        if (node.getLinkedElement() == null && node.getGraphNode().getBriefDescription() != null && !node.getGraphNode().getBriefDescription().trim().equals("")) {
            BridgeHelper.markInherited((EModelElement)node2);
        }
    }

    private org.eclipse.gmf.runtime.notation.Node findNotationNode(Diagram diagram, ActivityNode activityNode) {
        EList eList = diagram.getChildren();
        if (eList != null && eList.size() > 0) {
            for (org.eclipse.gmf.runtime.notation.Node node : eList) {
                if (!activityNode.equals(node.getElement())) continue;
                return node;
            }
        }
        return null;
    }

    public void updateNode() {
        if (this.node instanceof NamedNode) {
            this.name = ((NamedNode)this.node).getName();
        }
    }

    public void outgoingConnections(Node node) {
        EList eList = node.getOutgoingConnections();
        if (eList != null && eList.size() > 0) {
            for (Link link : eList) {
                Edge edge = this.createConnection(link);
                ActivityNode activityNode = (ActivityNode)graphUMLNodeMap.get(node);
                org.eclipse.gmf.runtime.notation.Node node2 = this.findNotationNode(this.getDiagram(), activityNode);
                node2.getSourceEdges().add((Object)edge);
                node2.getDiagram().insertEdge(edge);
            }
        }
    }

    private ControlFlow createControlFlow() {
        ControlFlow controlFlow = (ControlFlow)this.getActivity().createEdge("", UMLPackage.eINSTANCE.getControlFlow());
        return controlFlow;
    }

    private void loadSourceAndTargetEndPoint(Edge edge, Link link) {
        Bounds bounds;
        IdentityAnchor identityAnchor;
        Point point = link.getSourceEndPoint();
        Point point2 = link.getTargetEndPoint();
        View view = edge.getSource();
        View view2 = edge.getTarget();
        int n = new Integer(view.getType());
        int n2 = new Integer(view2.getType());
        if ((n == 1003 || n == 1006 || n == 1005 || n == 1002) && point != null && view instanceof org.eclipse.gmf.runtime.notation.Node && (identityAnchor = this.createIdentityAnchor(point, bounds = (Bounds)((org.eclipse.gmf.runtime.notation.Node)view).getLayoutConstraint())) != null) {
            edge.setSourceAnchor((Anchor)identityAnchor);
        }
        if ((n2 == 1003 || n2 == 1006 || n2 == 1005 || n2 == 1002) && point2 != null && view2 instanceof org.eclipse.gmf.runtime.notation.Node && (identityAnchor = this.createIdentityAnchor(point2, bounds = (Bounds)((org.eclipse.gmf.runtime.notation.Node)view2).getLayoutConstraint())) != null) {
            edge.setTargetAnchor((Anchor)identityAnchor);
        }
    }

    private IdentityAnchor createIdentityAnchor(Point point, Bounds bounds) {
        Point point2 = new Point(bounds.getX() + point.x, bounds.getY() + point.y);
        PrecisionPoint precisionPoint = MapUtil.getAnchorRelativeLocation(point2, bounds);
        String string = MapUtil.composeTerminalString(precisionPoint);
        IdentityAnchor identityAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        identityAnchor.setId(string);
        return identityAnchor;
    }

    private void loadBendPoints(Edge edge, Link link) {
        EList eList = link.getBendpoints();
        ArrayList<RelativeBendpoint> arrayList = new ArrayList<RelativeBendpoint>();
        RelativeBendpoint relativeBendpoint = new RelativeBendpoint(0, 0, 0, 0);
        arrayList.add(relativeBendpoint);
        if (eList != null && eList.size() > 0) {
            for (AbsoluteBendpoint absoluteBendpoint : eList) {
                Point point;
                org.eclipse.gmf.runtime.notation.Node node = (org.eclipse.gmf.runtime.notation.Node)edge.getSource();
                org.eclipse.gmf.runtime.notation.Node node2 = (org.eclipse.gmf.runtime.notation.Node)edge.getTarget();
                int n = new Integer(node.getType());
                int n2 = new Integer(node2.getType());
                Bounds bounds = (Bounds)node.getLayoutConstraint();
                Bounds bounds2 = (Bounds)node2.getLayoutConstraint();
                int n3 = MapUtil.getNoOfLines(node);
                int n4 = MapUtil.getNoOfLines(node2);
                int n5 = MapUtil.getTextHeight(node);
                int n6 = MapUtil.getTextHeight(node2);
                int n7 = bounds.getX() + bounds.getWidth() / 2;
                int n8 = bounds.getY() + (32 + n3 * n5) / 2;
                int n9 = bounds2.getX() + bounds2.getWidth() / 2;
                int n10 = bounds2.getY() + (32 + n4 * n6) / 2;
                if ((n == 1003 || n == 1006 || n == 1005 || n == 1002) && (point = link.getSourceEndPoint()) != null) {
                    n7 = bounds.getX() + point.x;
                    n8 = bounds.getY() + point.y;
                }
                if ((n2 == 1003 || n2 == 1006 || n2 == 1005 || n2 == 1002) && (point = link.getTargetEndPoint()) != null) {
                    n9 = bounds2.getX() + point.x;
                    n10 = bounds2.getY() + point.y;
                }
                if (n2 == 1001) {
                    n9 = bounds2.getX() + bounds2.getWidth() / 2;
                    n10 = bounds2.getY() + bounds2.getHeight() / 2;
                }
                int n11 = absoluteBendpoint.x - n7;
                int n12 = absoluteBendpoint.y - n8;
                int n13 = absoluteBendpoint.x - n9;
                int n14 = absoluteBendpoint.y - n10;
                RelativeBendpoint relativeBendpoint2 = new RelativeBendpoint(n11, n12, n13, n14);
                arrayList.add(relativeBendpoint2);
            }
        }
        arrayList.add(relativeBendpoint);
        if (arrayList.size() > 0) {
            RelativeBendpoints relativeBendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
            relativeBendpoints.setPoints(arrayList);
            edge.setBendpoints((Bendpoints)relativeBendpoints);
        }
    }

    private Edge findEdge(org.eclipse.gmf.runtime.notation.Node node, org.eclipse.gmf.runtime.notation.Node node2) {
        EList eList = this.notationNode.getDiagram().getEdges();
        if (eList != null && eList.size() > 0) {
            for (Edge edge : eList) {
                if (edge.getTarget() == null || !node2.equals(edge.getTarget()) || edge.getSource() == null || !node.equals(edge.getSource())) continue;
                return edge;
            }
        }
        return null;
    }

    public void incomingConnections(Node node) {
        EList eList = node.getIncomingConnections();
        if (eList != null && eList.size() > 0) {
            for (Link link : eList) {
                Edge edge = this.createConnection(link);
                ActivityNode activityNode = (ActivityNode)graphUMLNodeMap.get(node);
                org.eclipse.gmf.runtime.notation.Node node2 = this.findNotationNode(this.getDiagram(), activityNode);
                node2.getTargetEdges().add((Object)edge);
                node2.getDiagram().insertEdge(edge);
            }
        }
    }

    private Edge createConnection(Link link) {
        org.eclipse.gmf.runtime.notation.Node node;
        Node node2 = link.getSource();
        Node node3 = link.getTarget();
        ActivityNode activityNode = (ActivityNode)graphUMLNodeMap.get(node2);
        ActivityNode activityNode2 = (ActivityNode)graphUMLNodeMap.get(node3);
        org.eclipse.gmf.runtime.notation.Node node4 = this.findNotationNode(this.getDiagram(), activityNode);
        Edge edge = this.findEdge(node4, node = this.findNotationNode(this.getDiagram(), activityNode2));
        if (edge == null && node != null) {
            ControlFlow controlFlow = this.createControlFlow();
            if (activityNode2 instanceof ActivityNode) {
                controlFlow.setSource(activityNode);
                controlFlow.setTarget(activityNode2);
            }
            edge = MapUtil.createEdge_AD(node4, node, (ActivityEdge)controlFlow);
            edge.setElement((EObject)controlFlow);
            this.loadSourceAndTargetEndPoint(edge, link);
            this.loadBendPoints(edge, link);
        }
        return edge;
    }

    private Diagram getDiagram() {
        return this.diagram;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }
}

