/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.ad.wizards;

import java.util.Map;
import org.eclipse.epf.migration.diagram.DiagramMigrationPlugin;
import org.eclipse.epf.migration.diagram.MigrationResources;
import org.eclipse.epf.migration.diagram.util.MigrationUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class MigrationExportWizardPage
extends WizardPage
implements IWizardPage,
Listener {
    public static final String PAGE_NAME = MigrationExportWizardPage.class.getName();
    private static final String[] EMPTY_ARRAY = new String[0];
    private Button capabilityPatternRadioButton;
    private Button deliveryProcessRadioButton;
    private Combo processCombo;
    private Combo activityCombo;
    private Combo templateNameCombo;
    private Combo templateDirCombo;
    private Map capabilityPatterns;
    private Map deliveryProcesses;
    private Map activities;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            MigrationExportWizardPage.this.setPageComplete(MigrationExportWizardPage.this.isPageComplete());
        }
    };

    protected MigrationExportWizardPage() {
        super(PAGE_NAME);
        this.setTitle(MigrationResources.workflow_export_wizard_title);
        this.setDescription(MigrationResources.workflow_export_wizard_text);
        this.setImageDescriptor(DiagramMigrationPlugin.getDefault().getImageDescriptor("full/wizban/ExportXML.gif"));
    }

    public void createControl(Composite composite) {
        final Shell shell = composite.getShell();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(MigrationResources.workflow_export_wizard_processGroup_text);
        Composite composite3 = new Composite((Composite)group, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        this.capabilityPatternRadioButton = new Button(composite3, 16);
        this.capabilityPatternRadioButton.setText(MigrationResources.workflow_export_wizard_capabilityPatternRadioButton_text);
        this.capabilityPatternRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MigrationExportWizardPage.this.updateProcessCombo(MigrationExportWizardPage.this.capabilityPatterns);
                MigrationExportWizardPage.this.updateActivityCombo(MigrationExportWizardPage.this.getProcess());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.deliveryProcessRadioButton = new Button(composite3, 16);
        this.deliveryProcessRadioButton.setText(MigrationResources.workflow_export_wizard_deliveryProcessRadioButton_text);
        this.deliveryProcessRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MigrationExportWizardPage.this.updateProcessCombo(MigrationExportWizardPage.this.deliveryProcesses);
                MigrationExportWizardPage.this.updateActivityCombo(MigrationExportWizardPage.this.getProcess());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Composite composite4 = new Composite((Composite)group, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        composite4.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite4, 0);
        label.setText(MigrationResources.workflow_export_wizard_processNameLabel_text);
        this.processCombo = new Combo(composite4, 2056);
        this.processCombo.setLayoutData((Object)new GridData(768));
        this.processCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MigrationExportWizardPage.this.updateActivityCombo(MigrationExportWizardPage.this.getProcess());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label2 = new Label(composite4, 0);
        label2.setText(MigrationResources.workflow_export_wizard_activitiesNameLabel_text);
        this.activityCombo = new Combo(composite4, 2056);
        this.activityCombo.setLayoutData((Object)new GridData(768));
        this.activityCombo.addModifyListener(this.modifyListener);
        this.capabilityPatterns = MigrationUtil.getCapabilityPatterns();
        this.deliveryProcesses = MigrationUtil.getDeliveryProcesses();
        String string = DiagramMigrationPlugin.getDefault().getPreferenceStore().getString("processType");
        if (string != null && string.equals("DeliveryProcess") && this.deliveryProcesses.size() > 0) {
            this.deliveryProcessRadioButton.setSelection(true);
            this.updateProcessCombo(this.deliveryProcesses);
        } else if (string != null && this.capabilityPatterns != null && this.capabilityPatterns.size() > 0) {
            this.capabilityPatternRadioButton.setSelection(true);
            this.updateProcessCombo(this.capabilityPatterns);
        } else if (this.capabilityPatterns != null && this.capabilityPatterns.size() > 0) {
            this.capabilityPatternRadioButton.setSelection(true);
            this.updateProcessCombo(this.capabilityPatterns);
        } else {
            this.deliveryProcessRadioButton.setSelection(true);
            this.updateProcessCombo(this.deliveryProcesses);
        }
        this.updateActivityCombo(this.getProcess());
        Group group2 = new Group(composite2, 0);
        group2.setLayout((Layout)new GridLayout(1, false));
        group2.setLayoutData((Object)new GridData(768));
        group2.setText(MigrationResources.workflow_export_wizard_templateGroup_text);
        Composite composite5 = new Composite((Composite)group2, 0);
        composite5.setLayout((Layout)new GridLayout(3, false));
        composite5.setLayoutData((Object)new GridData(768));
        Label label3 = new Label(composite5, 0);
        label3.setText(MigrationResources.workflow_export_wizard_templateNameLabel_text);
        this.templateNameCombo = new Combo(composite5, 2048);
        this.templateNameCombo.setLayoutData((Object)new GridData(768));
        String string2 = DiagramMigrationPlugin.getDefault().getPreferenceStore().getString("templateNames");
        if (string2 != null) {
            this.templateNameCombo.add(string2);
        }
        this.templateNameCombo.addModifyListener(this.modifyListener);
        new Label(composite5, 0);
        Label label4 = new Label(composite5, 0);
        label4.setText(MigrationResources.workflow_export_wizard_dirLabel_text);
        this.templateDirCombo = new Combo(composite5, 2048);
        this.templateDirCombo.setLayoutData((Object)new GridData(768));
        String string3 = DiagramMigrationPlugin.getDefault().getPreferenceStore().getString("targetDirs");
        if (string3 != null) {
            this.templateDirCombo.add(string3);
            this.templateDirCombo.setText(string3);
        }
        this.templateDirCombo.addModifyListener(this.modifyListener);
        Button button = new Button(composite5, 0);
        button.setText(MigrationResources.workflow_export_wizard_browseButton_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    DirectoryDialog directoryDialog = new DirectoryDialog(shell, 0);
                    String string = directoryDialog.open();
                    if (string != null) {
                        MigrationExportWizardPage.this.templateDirCombo.add(string, 0);
                        MigrationExportWizardPage.this.templateDirCombo.setText(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.setControl((Control)composite2);
    }

    public void handleEvent(Event event) {
    }

    protected void updateProcessCombo(Map map) {
        if (map != null && map.size() > 0) {
            String[] stringArray = new String[map.size()];
            map.keySet().toArray(stringArray);
            this.processCombo.setItems(stringArray);
            String string = DiagramMigrationPlugin.getDefault().getPreferenceStore().getString("processName");
            if (string != null && map.containsKey(string)) {
                this.processCombo.setText(string);
            } else {
                this.processCombo.setText(this.processCombo.getItem(0));
            }
        } else {
            this.processCombo.setItems(EMPTY_ARRAY);
        }
    }

    protected void updateActivityCombo(Process process) {
        try {
            this.activities = MigrationUtil.getActivities(process);
            if (this.activities != null && this.activities.size() > 0) {
                String[] stringArray = new String[this.activities.size()];
                this.activities.keySet().toArray(stringArray);
                this.activityCombo.setItems(stringArray);
                this.activityCombo.setText(stringArray[0]);
            } else {
                this.activityCombo.setItems(EMPTY_ARRAY);
            }
        }
        catch (Exception exception) {}
    }

    public Process getProcess() {
        if (this.capabilityPatternRadioButton.getSelection()) {
            String string = this.processCombo.getText();
            return (Process)this.capabilityPatterns.get(string);
        }
        String string = this.processCombo.getText();
        return (Process)this.deliveryProcesses.get(string);
    }

    public String getTemplateName() {
        return this.templateNameCombo.getText();
    }

    public String getTargetDirectory() {
        return this.templateDirCombo.getText();
    }

    public boolean isPageComplete() {
        return this.processCombo.getText().trim().length() > 0 && this.templateNameCombo.getText().trim().length() > 0 && this.templateDirCombo.getText().trim().length() > 0 && this.activityCombo.getText().trim().length() > 0;
    }

    public Activity getActivity() {
        if (this.activityCombo.getSelectionIndex() != -1) {
            String string = this.activityCombo.getText();
            Activity activity = (Activity)this.activities.get(string);
            return activity;
        }
        return null;
    }
}

