/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui;

import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.search.ui.SearchUIPlugin;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.MethodSearchInput;
import org.eclipse.epf.search.ui.internal.MethodSearchQuery;
import org.eclipse.epf.search.ui.internal.MethodSearchScope;
import org.eclipse.epf.search.ui.internal.MethodSearchScopeViewer;
import org.eclipse.epf.search.ui.preferences.SearchUIPreferences;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MethodSearchPage
extends DialogPage
implements ISearchPage {
    public static final String SEARCH_PAGE_ID = MethodSearchPage.class.getName();
    private Combo searchStringCombo;
    private Combo namePatternCombo;
    private Button caseSensitiveCheckbox;
    private MethodSearchScopeViewer searchScopeViewer;
    private ISearchPageContainer container;

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(SearchUIResources.searchStringLabel_text);
        new Label(composite2, 0);
        this.searchStringCombo = new Combo(composite2, 0);
        this.searchStringCombo.setLayoutData((Object)new GridData(768));
        String string = SearchUIPreferences.getSearchString();
        if (string != null && string.length() > 0) {
            this.searchStringCombo.setText(string);
        }
        this.caseSensitiveCheckbox = new Button(composite2, 32);
        this.caseSensitiveCheckbox.setText(SearchUIResources.caseSensitiveCheckbox_text);
        this.caseSensitiveCheckbox.setSelection(SearchUIPreferences.getCaseSensitive());
        Label label2 = new Label(composite2, 0);
        label2.setText(SearchUIResources.elementNameLabel_text);
        new Label(composite2, 0);
        this.namePatternCombo = new Combo(composite2, 0);
        this.namePatternCombo.setLayoutData((Object)new GridData(768));
        String string2 = SearchUIPreferences.getNamePattern();
        if (string2 != null && string2.length() > 0) {
            this.namePatternCombo.setText(string2);
        } else {
            this.namePatternCombo.setText("*");
        }
        this.namePatternCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodSearchPage.this.container.setPerformActionEnabled(MethodSearchPage.this.getSearchButtonEnabled());
            }
        });
        this.namePatternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                MethodSearchPage.this.container.setPerformActionEnabled(MethodSearchPage.this.getSearchButtonEnabled());
            }
        });
        new Label(composite2, 0);
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        group.setLayoutData((Object)gridData);
        group.setText(SearchUIResources.scopeGroup_text);
        this.searchScopeViewer = new MethodSearchScopeViewer((Composite)group, 0);
        this.container.setPerformActionEnabled(this.getSearchButtonEnabled());
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public boolean performAction() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            SearchUIPlugin.getDefault().getMsgDialog().displayError(SearchUIResources.searchError_title, SearchUIResources.searchError_msg, SearchUIResources.searchError_reason);
            return false;
        }
        String string = this.searchStringCombo.getText();
        String string2 = this.namePatternCombo.getText();
        MethodSearchScope methodSearchScope = this.searchScopeViewer.getSearchScope();
        MethodSearchInput methodSearchInput = new MethodSearchInput(string, string2, this.caseSensitiveCheckbox.getSelection(), false, false, methodSearchScope);
        MethodSearchQuery methodSearchQuery = new MethodSearchQuery(methodSearchInput);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)methodSearchQuery);
        SearchUIPreferences.setSearchString(this.searchStringCombo.getText());
        SearchUIPreferences.setNamePattern(this.namePatternCombo.getText());
        SearchUIPreferences.setCaseSensitive(this.caseSensitiveCheckbox.getSelection());
        return true;
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.container = iSearchPageContainer;
    }

    public boolean performReplace() {
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    private boolean getSearchButtonEnabled() {
        return this.namePatternCombo.getText().trim().length() > 0;
    }
}

