/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.ISearchResultCollector;
import org.eclipse.epf.search.ui.internal.MethodSearchInput;
import org.eclipse.epf.search.ui.internal.MethodSearchOperation;
import org.eclipse.epf.search.ui.internal.MethodSearchResult;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class MethodSearchQuery
implements ISearchQuery {
    private MethodSearchInput searchInput;
    private MethodSearchResult searchResult;

    public MethodSearchQuery(MethodSearchInput methodSearchInput) {
        this.searchInput = methodSearchInput;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) {
        final MethodSearchResult methodSearchResult = (MethodSearchResult)this.getSearchResult();
        methodSearchResult.removeAll();
        ISearchResultCollector iSearchResultCollector = new ISearchResultCollector(){

            public void accept(Object object) {
                if (object instanceof MethodElement && !TngUtil.isPredefined((MethodElement)((MethodElement)object))) {
                    methodSearchResult.addMatch(new Match(object, 1, 1, 1));
                }
            }
        };
        MethodSearchOperation methodSearchOperation = new MethodSearchOperation(this.searchInput, iSearchResultCollector);
        methodSearchOperation.execute(iProgressMonitor);
        iProgressMonitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return SearchUIResources.searchQuery_text;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new MethodSearchResult(this);
        }
        return this.searchResult;
    }

    public MethodSearchInput getSearchInput() {
        return this.searchInput;
    }
}

