/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.serviceability;

import org.eclipse.epf.common.serviceability.VersionUtil;
import org.osgi.framework.Version;

public class EPFVersion {
    protected Version toolVersion;
    protected Version libraryVersion;
    protected Version xmlSchemaVersion;

    public EPFVersion() {
        this.toolVersion = Version.emptyVersion;
        this.libraryVersion = Version.emptyVersion;
        this.xmlSchemaVersion = Version.emptyVersion;
    }

    public EPFVersion(String string, String string2, String string3) {
        this.toolVersion = new Version(string);
        this.libraryVersion = new Version(string2);
        this.xmlSchemaVersion = new Version(string3);
    }

    public Version getToolVersion() {
        return this.toolVersion;
    }

    public Version getLibraryVersion() {
        return this.libraryVersion;
    }

    public Version getXMLSchemaVersion() {
        return this.xmlSchemaVersion;
    }

    public int compareToolVersionTo(Version version) {
        if (!VersionUtil.isVersionCheckingDisabled()) {
            return this.getToolVersion().compareTo((Object)version);
        }
        return 0;
    }

    public int compareLibraryVersionTo(Version version) {
        if (!VersionUtil.isVersionCheckingDisabled()) {
            return this.getLibraryVersion().compareTo((Object)version);
        }
        return 0;
    }

    public int compareXMLSchemaVersionTo(Version version) {
        if (!VersionUtil.isVersionCheckingDisabled()) {
            return this.getXMLSchemaVersion().compareTo((Object)version);
        }
        return 0;
    }

    public String toString() {
        return String.valueOf(this.getToolVersion().toString()) + "," + this.getLibraryVersion().toString() + "," + this.getXMLSchemaVersion().toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EPFVersion)) {
            return false;
        }
        EPFVersion ePFVersion = (EPFVersion)object;
        return this.getToolVersion().equals((Object)ePFVersion.getToolVersion()) && this.getLibraryVersion().equals((Object)ePFVersion.getLibraryVersion()) && this.getXMLSchemaVersion().equals((Object)ePFVersion.getXMLSchemaVersion());
    }

    public int hashCode() {
        int n = this.toolVersion.hashCode();
        n ^= this.libraryVersion.hashCode();
        return n ^= this.xmlSchemaVersion.hashCode();
    }
}

