/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.ui.EPFUIPlugin;
import org.eclipse.epf.ui.wizards.INewWizardPageContribution;
import org.eclipse.epf.ui.wizards.IWizardExtender;
import org.eclipse.epf.ui.wizards.NewWizardPageContribution;
import org.eclipse.epf.ui.wizards.ReplaceWizardPageContribution;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWizard
extends Wizard {
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected IWizardExtender wizardExtender;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.processWizardExtenderExtensionPoint();
        this.initializeExtender();
    }

    protected void initializeExtender() {
        if (this.wizardExtender != null) {
            this.wizardExtender.init(this);
        }
    }

    public abstract String getWizardExtenderExtensionPointId();

    public IWizardExtender getWizardExtender() {
        return this.wizardExtender;
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        IWizardPage iWizardPage2 = null;
        if (this.wizardExtender != null) {
            iWizardPage2 = this.wizardExtender.getNextPage(iWizardPage);
        }
        if (iWizardPage2 == null) {
            iWizardPage2 = super.getNextPage(iWizardPage);
        }
        return iWizardPage2;
    }

    public boolean canFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.canFinish();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.doFinish();
        }
        return this.doFinish();
    }

    public boolean doFinish() {
        return true;
    }

    protected IWizardExtender createWizardExtender(IWizardExtender iWizardExtender) {
        return iWizardExtender;
    }

    protected void processWizardExtenderExtensionPoint() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        String string = this.getWizardExtenderExtensionPointId();
        if (string == null) {
            return;
        }
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        if (iExtensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                try {
                    IWizardExtender iWizardExtender = (IWizardExtender)iConfigurationElement.createExecutableExtension("class");
                    if (this.wizardExtender == null) {
                        this.wizardExtender = this.createWizardExtender(iWizardExtender);
                        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("wizardPage");
                        int n3 = 0;
                        while (n3 < iConfigurationElementArray2.length) {
                            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n3];
                            IWizardPage iWizardPage = (IWizardPage)iConfigurationElement2.createExecutableExtension("class");
                            String string2 = iConfigurationElement2.getAttribute("type");
                            String string3 = iConfigurationElement2.getAttribute("target");
                            String string4 = iConfigurationElement2.getAttribute("insert");
                            if (iWizardPage != null && string2 != null && string2.length() > 0) {
                                if (string2.equals("replace")) {
                                    this.wizardExtender.addReplaceWizardPageContribution(new ReplaceWizardPageContribution(iWizardPage, string3));
                                } else if (string2.equals("new")) {
                                    boolean bl = true;
                                    if (string4 != null && string4.equals("before")) {
                                        bl = false;
                                    }
                                    this.wizardExtender.addNewWizardPageContribution(new NewWizardPageContribution(iWizardPage, string3, bl));
                                }
                            }
                            ++n3;
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    EPFUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void getNewWizardPages(List<IWizardPage> list) {
        List<INewWizardPageContribution> list2 = this.wizardExtender.getNewWizardPageContributions();
        if (list2 != null) {
            for (NewWizardPageContribution newWizardPageContribution : list2) {
                IWizardPage iWizardPage = newWizardPageContribution.getWizardPage();
                String string = newWizardPageContribution.getTargetWizardPage();
                if (string == null) continue;
                int n = list.size();
                int n2 = 0;
                Iterator<IWizardPage> iterator = list.iterator();
                while (list.size() == n && iterator.hasNext()) {
                    IWizardPage iWizardPage2 = iterator.next();
                    if (iWizardPage2.getName().equals(string)) {
                        if (newWizardPageContribution.getInsertAfter()) {
                            list.add(n2 + 1, iWizardPage);
                        } else {
                            list.add(n2, iWizardPage);
                        }
                    }
                    ++n2;
                }
                if (list.size() != n) continue;
                list.add(iWizardPage);
            }
        }
    }
}

