/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveInCategoryCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private ContentCategory category;
    private EStructuralFeature feature;
    private List elementsList;
    private ContentElementOrderList elementOrderList;
    private String[] categoryPkgPath;
    private ContentCategory usedCategory = null;
    private Collection<Resource> modifiedResources;
    private static int UP = 1;
    private static int Down = 0;
    private int direction = -1;
    private boolean moved;

    public MoveInCategoryCommand(ContentCategory contentCategory, List list, ContentElementOrderList contentElementOrderList, EStructuralFeature eStructuralFeature, String[] stringArray, int n) {
        this.category = contentCategory;
        this.feature = eStructuralFeature;
        this.elementsList = list;
        this.elementOrderList = contentElementOrderList;
        this.categoryPkgPath = stringArray;
        this.direction = n;
        this.modifiedResources = new HashSet<Resource>();
    }

    protected boolean prepare() {
        return true;
    }

    public MoveInCategoryCommand(String string) {
        super(string);
    }

    public MoveInCategoryCommand(String string, String string2) {
        super(string, string2);
    }

    @Override
    public Collection<Resource> getModifiedResources() {
        this.modifiedResources.add(this.category.eResource());
        return this.modifiedResources;
    }

    public void execute() {
        MethodPlugin methodPlugin;
        MethodPlugin methodPlugin2 = UmaUtil.getMethodPlugin((EObject)this.category);
        this.usedCategory = methodPlugin2 != (methodPlugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)this.elementsList.get(0)))) && Misc.isBaseOf(methodPlugin2, methodPlugin) ? TngUtil.findContributor(UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])this.categoryPkgPath), this.category) : this.category;
        this.redo();
    }

    public void redo() {
        if (this.usedCategory == null) {
            return;
        }
        for (Object e : this.elementsList) {
            if (this.feature.isMany()) {
                int n = this.elementOrderList.indexOf(e);
                if (this.direction == UP) {
                    if (n > 0) {
                        this.elementOrderList.move(n - 1, e);
                    }
                } else if (this.direction == Down && n < this.elementOrderList.size()) {
                    this.elementOrderList.move(n + this.elementsList.size(), e);
                }
                this.moved = true;
                continue;
            }
            this.usedCategory.eSet(this.feature, null);
        }
        this.elementOrderList.apply();
    }

    public void undo() {
        if (this.moved) {
            for (Object e : this.elementsList) {
                if (this.feature.isMany()) {
                    int n = this.elementOrderList.indexOf(e);
                    if (this.direction == UP) {
                        if (n < this.elementOrderList.size()) {
                            this.elementOrderList.move(n + this.elementsList.size(), e);
                        }
                    } else if (this.direction == Down && n > 0) {
                        this.elementOrderList.move(n - 1, e);
                    }
                    this.moved = true;
                    continue;
                }
                this.usedCategory.eSet(this.feature, e);
            }
            this.elementOrderList.apply();
            this.moved = false;
        }
        if (TngUtil.isEmpty(this.usedCategory)) {
            EcoreUtil.remove((EObject)this.usedCategory);
            this.usedCategory = null;
        }
    }

    public Collection<ContentCategory> getAffectedObjects() {
        return Collections.singletonList(this.usedCategory);
    }
}

