/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class RemoveReferencesCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private MethodPlugin plugin;
    private MethodPlugin base;
    private Map featureValuePairToObjectMap;
    private Collection modifiedResources;

    public RemoveReferencesCommand(MethodPlugin methodPlugin, MethodPlugin methodPlugin2) {
        this.plugin = methodPlugin;
        this.base = methodPlugin2;
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }

    public void execute() {
        EStructuralFeature eStructuralFeature;
        EObject eObject;
        this.featureValuePairToObjectMap = new HashMap();
        this.modifiedResources = new HashSet();
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)this.plugin.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            eObject = (EObject)featureIterator.next();
            eStructuralFeature = featureIterator.feature();
            if (eStructuralFeature == UmaPackage.eINSTANCE.getMethodPlugin_Bases() || UmaUtil.getMethodPlugin((EObject)eObject) != this.base) continue;
            this.featureValuePairToObjectMap.put(new FeatureValuePair(eStructuralFeature, eObject), this.plugin);
        }
        featureIterator = this.plugin.eAllContents();
        while (featureIterator.hasNext()) {
            eObject = (EObject)featureIterator.next();
            if (eObject instanceof ProcessElement) continue;
            eStructuralFeature = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
            while (eStructuralFeature.hasNext()) {
                EObject eObject2 = (EObject)eStructuralFeature.next();
                if (UmaUtil.getMethodPlugin((EObject)eObject2) != this.base) continue;
                EStructuralFeature eStructuralFeature2 = eStructuralFeature.feature();
                this.featureValuePairToObjectMap.put(new FeatureValuePair(eStructuralFeature2, eObject2), eObject);
            }
        }
        this.redo();
    }

    public void redo() {
        for (Map.Entry entry : this.featureValuePairToObjectMap.entrySet()) {
            FeatureValuePair featureValuePair = (FeatureValuePair)entry.getKey();
            EObject eObject = (EObject)entry.getValue();
            if (featureValuePair.feature.isMany()) {
                ((Collection)eObject.eGet(featureValuePair.feature)).remove(featureValuePair.value);
            } else {
                eObject.eSet(featureValuePair.feature, null);
            }
            if (eObject.eResource() == null) continue;
            this.modifiedResources.add(eObject.eResource());
        }
    }

    public void undo() {
        for (Map.Entry entry : this.featureValuePairToObjectMap.entrySet()) {
            FeatureValuePair featureValuePair = (FeatureValuePair)entry.getKey();
            EObject eObject = (EObject)entry.getValue();
            if (featureValuePair.feature.isMany()) {
                ((Collection)eObject.eGet(featureValuePair.feature)).add(featureValuePair.value);
                continue;
            }
            eObject.eSet(featureValuePair.feature, featureValuePair.value);
        }
    }

    private static class FeatureValuePair {
        EStructuralFeature feature;
        Object value;

        FeatureValuePair(EStructuralFeature eStructuralFeature, Object object) {
            this.feature = eStructuralFeature;
            this.value = object;
        }
    }
}

