/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IGroupContainer;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.category.CustomCategoriesItemProvider;
import org.eclipse.epf.library.edit.category.DisciplineCategoriesItemProvider;
import org.eclipse.epf.library.edit.category.RoleSetsItemProvider;
import org.eclipse.epf.library.edit.configuration.CategoriesItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.ProcessesItemProvider;
import org.eclipse.epf.library.edit.configuration.WorkProductTypesItemProvider;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.swt.graphics.Image;

public class MethodConfigurationItemProvider
extends org.eclipse.epf.uma.provider.MethodConfigurationItemProvider
implements IGroupContainer,
IConfigurable,
IStatefulItemProvider {
    private Map groupItemProviderMap;
    protected ArrayList children;
    private IFilter disciplinesFilter = new IFilter(){

        public boolean accept(Object object) {
            ContentCategory contentCategory = (ContentCategory)object;
            return DisciplineCategoriesItemProvider.accept(contentCategory);
        }
    };
    private static final IFilter domainFilter = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof Domain;
        }
    };
    private static final IFilter workProductTypesFilter = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof WorkProductType;
        }
    };
    private IFilter roleSetsFilter = new IFilter(){

        public boolean accept(Object object) {
            return RoleSetsItemProvider.accept(object);
        }
    };
    private static final IFilter toolsFilter = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof Tool;
        }
    };
    private static final IFilter customCategoriesFilter = new IFilter(){

        public boolean accept(Object object) {
            return CustomCategoriesItemProvider.accept(object);
        }
    };
    private IFilter uncategorizedTaskFilter = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof Task && AssociationHelper.getDisciplines((Task)((Task)object)).isEmpty();
        }
    };
    private IFilter domainUncategorizedWorkProductFilter = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof WorkProduct && !AssociationHelper.getDomains((WorkProduct)((WorkProduct)object)).isEmpty();
        }
    };
    private IFilter wpTypeUncategorizedWorkProductFilter = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof WorkProduct && AssociationHelper.getWorkProductTypes((WorkProduct)((WorkProduct)object)).isEmpty();
        }
    };
    private IFilter uncategorizedRoleFilter = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof Role && AssociationHelper.getRoleSets((Role)((Role)object)).isEmpty();
        }
    };
    private IFilter uncategorizedToolMentorFilter = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof ToolMentor && AssociationHelper.getTool((ToolMentor)((ToolMentor)object)) == null;
        }
    };
    private IConfigurator configurator;
    private IFilter filter;

    public MethodConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void dispose() {
        if (this.groupItemProviderMap != null) {
            for (Object v : this.groupItemProviderMap.values()) {
                if (!(v instanceof IDisposable)) continue;
                ((IDisposable)v).dispose();
            }
            this.groupItemProviderMap.clear();
            this.groupItemProviderMap = null;
        }
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
        super.dispose();
    }

    public Collection getChildren(Object object) {
        MethodConfiguration methodConfiguration = (MethodConfiguration)object;
        if (this.children == null) {
            this.children = new ArrayList();
            this.groupItemProviderMap = new HashMap();
            String string = LibraryEditPlugin.INSTANCE.getString("_UI_Disciplines_group");
            CategoriesItemProvider categoriesItemProvider = new CategoriesItemProvider(this.adapterFactory, methodConfiguration, string, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tasks_cfv"), ModelStructure.DEFAULT.disciplineDefinitionPath);
            categoriesItemProvider.setParent(methodConfiguration);
            categoriesItemProvider.setUncategorizedFilter(this.uncategorizedTaskFilter);
            categoriesItemProvider.setCategorizedFilter(this.disciplinesFilter);
            categoriesItemProvider.setUncategorizedLabel(LibraryEditPlugin.INSTANCE.getString("_UI_Uncategorized_Tasks_text"));
            Image image = LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tasks");
            categoriesItemProvider.setUncategorizedImage(image);
            this.children.add(categoriesItemProvider);
            this.groupItemProviderMap.put(string, categoriesItemProvider);
            string = LibraryEditPlugin.INSTANCE.getString("_UI_Domains_group");
            categoriesItemProvider = new CategoriesItemProvider(this.adapterFactory, methodConfiguration, string, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Domains"), ModelStructure.DEFAULT.domainPath);
            categoriesItemProvider.setParent(methodConfiguration);
            categoriesItemProvider.setUncategorizedFilter(this.domainUncategorizedWorkProductFilter);
            image = LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProducts");
            categoriesItemProvider.setUncategorizedImage(image);
            categoriesItemProvider.setCategorizedFilter(domainFilter);
            this.children.add(categoriesItemProvider);
            this.groupItemProviderMap.put(string, categoriesItemProvider);
            string = LibraryEditPlugin.INSTANCE.getString("_UI_WorkProductTypes_group");
            categoriesItemProvider = new WorkProductTypesItemProvider(this.adapterFactory, methodConfiguration, string, LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProducts"), ModelStructure.DEFAULT.workProductTypePath);
            categoriesItemProvider.setParent(methodConfiguration);
            categoriesItemProvider.setUncategorizedFilter(this.wpTypeUncategorizedWorkProductFilter);
            image = LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProducts");
            categoriesItemProvider.setUncategorizedImage(image);
            categoriesItemProvider.setCategorizedFilter(workProductTypesFilter);
            this.children.add(categoriesItemProvider);
            this.groupItemProviderMap.put(string, categoriesItemProvider);
            string = LibraryEditPlugin.INSTANCE.getString("_UI_Role_Sets_group");
            categoriesItemProvider = new CategoriesItemProvider(this.adapterFactory, methodConfiguration, string, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Roles"), ModelStructure.DEFAULT.roleSetPath);
            categoriesItemProvider.setParent(methodConfiguration);
            categoriesItemProvider.setUncategorizedFilter(this.uncategorizedRoleFilter);
            categoriesItemProvider.setCategorizedFilter(this.roleSetsFilter);
            categoriesItemProvider.setUncategorizedLabel(LibraryEditPlugin.INSTANCE.getString("_UI_Uncategorized_Roles_text"));
            image = LibraryEditPlugin.INSTANCE.getImage("full/obj16/Roles");
            categoriesItemProvider.setUncategorizedImage(image);
            this.children.add(categoriesItemProvider);
            this.groupItemProviderMap.put(string, categoriesItemProvider);
            string = LibraryEditPlugin.INSTANCE.getString("_UI_Tools_group");
            categoriesItemProvider = new CategoriesItemProvider(this.adapterFactory, methodConfiguration, string, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tools"), ModelStructure.DEFAULT.toolPath);
            categoriesItemProvider.setParent(methodConfiguration);
            categoriesItemProvider.setCategorizedFilter(toolsFilter);
            categoriesItemProvider.setUncategorizedFilter(this.uncategorizedToolMentorFilter);
            image = LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tools");
            categoriesItemProvider.setUncategorizedImage(image);
            this.children.add(categoriesItemProvider);
            this.groupItemProviderMap.put(string, categoriesItemProvider);
            string = LibraryEditPlugin.INSTANCE.getString("_UI_Processes_group");
            ProcessesItemProvider processesItemProvider = new ProcessesItemProvider(this.adapterFactory, methodConfiguration, ModelStructure.DEFAULT);
            this.children.add(processesItemProvider);
            this.groupItemProviderMap.put(string, processesItemProvider);
            string = LibraryEditPlugin.INSTANCE.getString("_UI_Custom_Categories_group");
            categoriesItemProvider = new CategoriesItemProvider(this.adapterFactory, methodConfiguration, string, LibraryEditPlugin.INSTANCE.getImage("full/obj16/MethodPackages"), ModelStructure.DEFAULT.customCategoryPath);
            categoriesItemProvider.setParent(methodConfiguration);
            categoriesItemProvider.setCategorizedFilter(customCategoriesFilter);
            this.children.add(categoriesItemProvider);
            this.groupItemProviderMap.put(string, categoriesItemProvider);
            string = LibraryEditPlugin.INSTANCE.getString("_UI_Guidances_group");
            GuidanceGroupingItemProvider guidanceGroupingItemProvider = new GuidanceGroupingItemProvider(this.adapterFactory, methodConfiguration);
            guidanceGroupingItemProvider.setFilter(this.filter);
            this.children.add(guidanceGroupingItemProvider);
            this.groupItemProviderMap.put(string, guidanceGroupingItemProvider);
        }
        return this.children;
    }

    public boolean hasChildren(Object object) {
        return super.hasChildren(object);
    }

    public String getText(Object object) {
        return TngUtil.getLabel(object, this.getString("_UI_MethodConfiguration_type"));
    }

    public Object getGroupItemProvider(String string) {
        return this.groupItemProviderMap.get(string);
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object object2) {
        return Collections.EMPTY_LIST;
    }

    public void setFilter(IFilter iFilter) {
        if (iFilter != this.configurator && iFilter instanceof IConfigurator) {
            this.configurator = (IConfigurator)iFilter;
            if (this.configurator != null) {
                this.uncategorizedTaskFilter = this.configurator.getUncategorizedTaskFilter();
                this.domainUncategorizedWorkProductFilter = this.configurator.getDomainUncategorizedWorkProductFilter();
                this.wpTypeUncategorizedWorkProductFilter = this.configurator.getWpTypeUncategorizedWorkProductFilter();
                this.uncategorizedRoleFilter = this.configurator.getUncategorizedRoleFilter();
                this.uncategorizedToolMentorFilter = this.configurator.getUncategorizedToolMentorFilter();
                this.disciplinesFilter = this.configurator.getDisciplinesFilter();
                this.roleSetsFilter = this.configurator.getRoleSetsFilter();
            }
        }
        this.filter = iFilter;
    }

    public void setLabel(String string) {
    }

    public void setParent(Object object) {
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.configurator != null) {
            switch (notification.getFeatureID(MethodConfiguration.class)) {
                case 12: 
                case 13: {
                    this.configurator.notifyChanged(notification);
                }
            }
        }
    }
}

