/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.command.MethodElementCreateChildCommand;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.process.IProcessItemProvider;
import org.eclipse.epf.library.edit.process.command.CreateProcessComponentCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.edit.command.MethodElementCreateCopyCommand;
import org.eclipse.epf.uma.edit.command.MethodElementInitializeCopyCommand;
import org.eclipse.epf.uma.provider.UmaEditPlugin;

public class ProcessPackageItemProvider
extends org.eclipse.epf.uma.provider.ProcessPackageItemProvider
implements IProcessItemProvider,
IStatefulItemProvider {
    protected EClass processType;
    private String label;
    private Object parent;

    public ProcessPackageItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public EClass getProcessType() {
        return this.processType;
    }

    protected void collectNewChildDescriptors(Collection collection, Object object) {
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getMethodPackage_ChildPackages(), UmaFactory.eINSTANCE.createProcessPackage()));
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getMethodPackage_ChildPackages(), UmaFactory.eINSTANCE.createProcessComponent()));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getMethodPackage_ChildPackages());
        }
        return this.childrenFeatures;
    }

    public Collection getChildren(Object object) {
        Collection collection = super.getChildren(object);
        for (Object e : collection) {
            if (e instanceof ProcessComponent || !(e instanceof ProcessPackage)) continue;
            ProcessPackageItemProvider processPackageItemProvider = (ProcessPackageItemProvider)this.getRootAdapterFactory().adapt(e, ITreeItemContentProvider.class);
            if (this.processType == null) continue;
            processPackageItemProvider.setProcessType(this.processType);
        }
        Collections.sort((List)collection, PresentationContext.INSTANCE.getProcessPackageComparator());
        return collection;
    }

    public String getText(Object object) {
        if (this.label != null) {
            return this.label;
        }
        return TngUtil.getLabel(object);
    }

    public Object getImage(Object object) {
        Object object2;
        EClass eClass = this.getProcessType();
        if (eClass != null && (object2 = this.getParent(object)) != null && object2 instanceof ProcessesItemProvider) {
            if (eClass.equals(UmaPackage.eINSTANCE.getCapabilityPattern())) {
                return LibraryEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPatterns");
            }
            if (eClass.equals(UmaPackage.eINSTANCE.getDeliveryProcess())) {
                return LibraryEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcesses");
            }
        }
        return UmaEditPlugin.INSTANCE.getImage("full/obj16/ProcessPackage");
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setProcessType(EClass eClass) {
        this.processType = eClass;
    }

    protected Command createCreateChildCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n, Collection collection) {
        if (object instanceof ProcessComponent) {
            return new CreateProcessComponentCommand(editingDomain, eObject, eStructuralFeature, object, n, collection, (CreateChildCommand.Helper)this);
        }
        return new MethodElementCreateChildCommand(editingDomain, eObject, eStructuralFeature, object, n, collection, (CreateChildCommand.Helper)this);
    }

    public String getCreateChildText(Object object, Object object2, Object object3, Collection collection) {
        EClass eClass;
        if (object3 instanceof ProcessComponent && (eClass = this.getProcessType()) != null) {
            if (eClass.equals(UmaPackage.eINSTANCE.getCapabilityPattern())) {
                return LibraryEditPlugin.INSTANCE.getString("_UI_CapabilityPattern_text");
            }
            if (eClass.equals(UmaPackage.eINSTANCE.getDeliveryProcess())) {
                return LibraryEditPlugin.INSTANCE.getString("_UI_DeliveryProcess_text");
            }
            if (eClass == UmaPackage.eINSTANCE.getProcessPlanningTemplate()) {
                return this.getString("_UI_ProcessPlanningTemplate_type");
            }
        }
        return super.getCreateChildText(object, object2, object3, collection);
    }

    public Object getCreateChildImage(Object object, Object object2, Object object3, Collection collection) {
        EClass eClass;
        if (object3 instanceof ProcessComponent && (eClass = this.getProcessType()) != null) {
            if (eClass.equals(UmaPackage.eINSTANCE.getCapabilityPattern())) {
                return UmaEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPattern");
            }
            if (eClass.equals(UmaPackage.eINSTANCE.getDeliveryProcess())) {
                return UmaEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcess");
            }
            if (eClass == UmaPackage.eINSTANCE.getProcessPlanningTemplate()) {
                return UmaEditPlugin.INSTANCE.getImage("full/obj16/ProcessPlanningTemplate");
            }
        }
        return super.getCreateChildImage(object, object2, object3, collection);
    }

    protected Command createAddCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Collection collection, int n) {
        ArrayList arrayList = new ArrayList();
        for (Object e : collection) {
            if (!(e instanceof ProcessPackage) || ProcessUtil.hasProcessNotOfType((ProcessPackage)e, this.processType)) continue;
            arrayList.add(e);
        }
        if (arrayList.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new MethodElementAddCommand((Command)((AddCommand)super.createAddCommand(editingDomain, eObject, eStructuralFeature, arrayList, n))){

            protected void featureChanged(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
                Process process;
                if (eObject instanceof ProcessComponent && eStructuralFeature == UmaPackage.eINSTANCE.getNamedElement_Name() && (process = ((ProcessComponent)eObject).getProcess()) != null) {
                    process.setName((String)object);
                }
            }
        };
    }

    protected Command createInitializeCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementInitializeCopyCommand(editingDomain, eObject, helper);
    }

    protected Command createCreateCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementCreateCopyCommand(editingDomain, eObject, helper);
    }

    public void setParent(Object object) {
        this.parent = object;
    }

    public Object getParent(Object object) {
        if (this.parent != null) {
            return this.parent;
        }
        return super.getParent(object);
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        TngUtil.refreshParentIfNameChanged(notification, (ItemProviderAdapter)this);
        super.notifyChanged(notification);
    }
}

