/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.ui.ReferenceSelection;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;

public class DeleteTaskDescriptor
extends RemoveUnusedDescriptorsCommand {
    private Activity activity;
    private TaskDescriptor taskDesc;
    private Collection modifiedResources;
    private List notUsedReferences = new ArrayList();
    private boolean forceRemoveUnusedReferences;

    public DeleteTaskDescriptor(TaskDescriptor taskDescriptor) {
        this.taskDesc = taskDescriptor;
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)taskDescriptor, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)taskDescriptor);
        if (object instanceof Activity) {
            this.activity = (Activity)object;
        }
        this.modifiedResources = new HashSet();
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        if (taskDescriptor.eResource() != null) {
            this.modifiedResources.add(taskDescriptor.eResource());
        }
    }

    public DeleteTaskDescriptor(TaskDescriptor taskDescriptor, boolean bl) {
        this(taskDescriptor);
        this.forceRemoveUnusedReferences = bl;
    }

    public void execute() {
        HashSet<RoleDescriptor> hashSet = new HashSet<RoleDescriptor>();
        hashSet.addAll(this.taskDesc.getAdditionallyPerformedBy());
        hashSet.addAll(this.taskDesc.getAssistedBy());
        hashSet.add(this.taskDesc.getPerformedPrimarilyBy());
        hashSet.addAll(this.taskDesc.getMandatoryInput());
        hashSet.addAll(this.taskDesc.getExternalInput());
        hashSet.addAll(this.taskDesc.getOptionalInput());
        hashSet.addAll(this.taskDesc.getOutput());
        for (Object e : hashSet) {
            if (!(e instanceof Descriptor) || ProcessUtil.checkDescriptorReferences((Descriptor)this.taskDesc, (Descriptor)e) || !this.activity.getBreakdownElements().contains(e)) continue;
            this.notUsedReferences.add(e);
        }
        if (!this.notUsedReferences.isEmpty()) {
            try {
                Object[] objectArray = this.forceRemoveUnusedReferences ? this.notUsedReferences.toArray() : ReferenceSelection.getReferences(this.notUsedReferences, (Descriptor)this.taskDesc);
                this.delete(objectArray);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.aborted = true;
            }
        }
        this.clear(this.taskDesc.getAdditionallyPerformedBy());
        this.clear(this.taskDesc.getAssistedBy());
        this.clear(this.taskDesc.getMandatoryInput());
        this.clear(this.taskDesc.getExternalInput());
        this.clear(this.taskDesc.getOptionalInput());
        this.clear(this.taskDesc.getOutput());
        this.taskDesc.setPerformedPrimarilyBy(null);
        this.redo();
    }

    private void clear(List list) {
        try {
            if (list != null && list.size() > 0) {
                list.clear();
            }
        }
        catch (Exception exception) {}
    }

    public void redo() {
    }

    public void undo() {
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

