/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.dataexchange.util.BaseResourceHandler;
import org.eclipse.epf.dataexchange.util.UrlInfo;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.xml.uma.MethodElement;

public class ExportResourceHandler
extends BaseResourceHandler {
    public ExportResourceHandler(File file, File file2) {
        super(file, file2);
    }

    public UrlInfo resolveFileUrl(Object object, String string) throws Exception {
        return this.loadUrlInfoWithFixedPath(object, string);
    }

    private UrlInfo loadUrlInfoWithFixedPath(Object object, String string) {
        UrlInfo urlInfo = new UrlInfo();
        urlInfo.sourceUrl = string;
        urlInfo.targetUrl = string;
        String string2 = this.getFileRelPath(object, string);
        MethodElement methodElement = null;
        if (object instanceof MethodElement) {
            methodElement = (MethodElement)object;
        }
        if (string2 != null && methodElement != null) {
            MethodPlugin methodPlugin = ExportResourceHandler.getSourcePlugin(methodElement);
            ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr((org.eclipse.epf.uma.MethodElement)methodPlugin);
            String string3 = iLibraryResourceManager.getPhysicalPluginPath((org.eclipse.epf.uma.MethodElement)methodPlugin);
            File file = new File(string3).getParentFile();
            urlInfo.sourceFile = new File(file, string2);
            if (!urlInfo.sourceFile.isFile() || !urlInfo.sourceFile.exists()) {
                String string4 = null;
                try {
                    string4 = NetUtil.decodeURL((String)string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (string4 != null) {
                    string2 = string4;
                    urlInfo.sourceFile = new File(file, string2);
                }
            }
            urlInfo.targetFile = new File(this.targetLibRoot, string2);
            urlInfo.targetUrl = string2.replace(File.separatorChar, '/');
        }
        return urlInfo;
    }

    protected static MethodPlugin getSourcePlugin(MethodElement methodElement) {
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager == null) {
            throw new UnsupportedOperationException();
        }
        org.eclipse.epf.uma.MethodElement methodElement2 = iLibraryManager.getMethodElement(methodElement.getId());
        if (methodElement2 == null) {
            throw new UnsupportedOperationException();
        }
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement2);
        if (methodPlugin == null) {
            throw new UnsupportedOperationException();
        }
        return methodPlugin;
    }

    private String getFileRelPath(Object object, String string) {
        try {
            if (object instanceof MethodElement) {
                org.eclipse.epf.uma.MethodElement methodElement;
                String string2 = ((MethodElement)object).getId();
                ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
                if (iLibraryManager != null && (methodElement = iLibraryManager.getMethodElement(string2)) != null) {
                    File file = new File(new File(this.sourceLibRoot, ResourceHelper.getElementPath((org.eclipse.epf.uma.MethodElement)methodElement)), string);
                    String string3 = file.getCanonicalPath();
                    return string3.substring(this.sourceLibRoot.getCanonicalPath().length() + 1);
                }
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public void copyResource(String string, EObject eObject, MethodPlugin methodPlugin) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr((org.eclipse.epf.uma.MethodElement)methodPlugin);
        String string2 = iLibraryResourceManager.getPhysicalPluginPath((org.eclipse.epf.uma.MethodElement)methodPlugin);
        File file = new File(string2);
        File file2 = new File(file.getParentFile(), string);
        if (file2.exists()) {
            File file3 = new File(this.targetLibRoot, string);
            FileUtil.copyFile((File)file2, (File)file3);
        }
    }
}

