/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;

public class FeatureManager {
    public static FeatureManager INSTANCE = new FeatureManager();
    private Map featureNameMap = new TreeMap();
    private List unneededRmcFeatures = new ArrayList();
    private List unneededXmlFeatures = new ArrayList();
    private Map xmlEClassMap = new TreeMap();
    private Map umaEClassMap = new TreeMap();

    private FeatureManager() {
        this.featureNameMap.put("OptionalInputTo", "optionalInputTo");
        this.featureNameMap.put("Role", "role");
        this.featureNameMap.put("Task", "task");
        this.featureNameMap.put("activityReferences", "activityReference");
        this.featureNameMap.put("aggregatedRoles", "aggregatedRole");
        this.featureNameMap.put("assets", "reusableAsset");
        this.featureNameMap.put("attachments", "attachment");
        this.featureNameMap.put("baseConfigurations", "baseConfiguration");
        this.featureNameMap.put("basedOnProcesses", "baseProcess");
        this.featureNameMap.put("bases", "referencedMethodPlugin");
        this.featureNameMap.put("body", "mainDescription");
        this.featureNameMap.put("breakdownElements", "breakdownElement");
        this.featureNameMap.put("categorizedElements", "categorizedElement");
        this.featureNameMap.put("checklists", "checklist");
        this.featureNameMap.put("childPackages", "methodPackage");
        this.featureNameMap.put("communicationsMaterials", "communicationsMaterial");
        this.featureNameMap.put("concepts", "concept,whitepaper");
        this.featureNameMap.put("conceptsAndPapers", "concept,whitepaper");
        this.featureNameMap.put("containedArtifacts", "containedArtifact");
        this.featureNameMap.put("contentElements", "contentElement");
        this.featureNameMap.put("contentReferences", "contentReference");
        this.featureNameMap.put("copyrightStatement", "copyright");
        this.featureNameMap.put("deliveredWorkProducts", "deliveredWorkProduct");
        this.featureNameMap.put("disciplines", "discipline");
        this.featureNameMap.put("educationMaterials", "educationMaterial");
        this.featureNameMap.put("estimationConderations", "estimationConsiderations");
        this.featureNameMap.put("examples", "example");
        this.featureNameMap.put("guid", "id");
        this.featureNameMap.put("guidelines", "guideline");
        this.featureNameMap.put("howtoStaff", "howToStaff");
        this.featureNameMap.put("includesPatterns", "includesPattern");
        this.featureNameMap.put("interfaces", "interface");
        this.featureNameMap.put("linkToPredecessor", "predecessor");
        this.featureNameMap.put("methodPackages", "methodPackage");
        this.featureNameMap.put("methodPlugins", "methodPlugin");
        this.featureNameMap.put("ownedRules", "ownedRule");
        this.featureNameMap.put("predefinedConfigurations", "methodConfiguration");
        this.featureNameMap.put("processElements", "processElement");
        this.featureNameMap.put("processViews", "processView");
        this.featureNameMap.put("referenceWorkflows", "referenceWorkflow");
        this.featureNameMap.put("reports", "report");
        this.featureNameMap.put("reusableAssets", "reusableAsset");
        this.featureNameMap.put("reusedPackages", "reusedPackage");
        this.featureNameMap.put("roadmaps", "roadmap");
        this.featureNameMap.put("roleSets", "roleSet");
        this.featureNameMap.put("roles", "role");
        this.featureNameMap.put("sectionDescription", "description");
        this.featureNameMap.put("sections", "section");
        this.featureNameMap.put("selectedSteps", "step");
        this.featureNameMap.put("subCategories", "subCategory");
        this.featureNameMap.put("subdiscipline", "subDiscipline");
        this.featureNameMap.put("subPractices", "subPractice");
        this.featureNameMap.put("subSections", "subSection");
        this.featureNameMap.put("subdomains", "subdomain");
        this.featureNameMap.put("superActivities", "superActivity");
        this.featureNameMap.put("supportingMaterials", "supportingMaterial");
        this.featureNameMap.put("tasks", "task");
        this.featureNameMap.put("teamRoles", "role");
        this.featureNameMap.put("templates", "template");
        this.featureNameMap.put("toolMentors", "toolMentor");
        this.featureNameMap.put("WorkProduct", "workProduct");
        this.featureNameMap.put("workProducts", "workProduct");
        this.featureNameMap.put("pred", "value");
        this.featureNameMap.put("methodElementProperty", "methodElementProperty");
        this.unneededRmcFeatures.add("containerArtifact");
        this.unneededRmcFeatures.add("modifies");
        this.unneededRmcFeatures.add("parentPackage");
        this.unneededRmcFeatures.add("diagrams");
        this.unneededRmcFeatures.add("modifies");
        this.unneededRmcFeatures.add("steps");
        this.unneededRmcFeatures.add("workedOnBy");
        this.unneededRmcFeatures.add("diagrams");
        this.unneededXmlFeatures.add("group");
        this.unneededXmlFeatures.add("group1");
        this.unneededXmlFeatures.add("group2");
        this.unneededXmlFeatures.add("predecessor1");
        this.loadXmlClasses();
        this.loadRmcClasses();
    }

    private void loadRmcClasses() {
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getActivity());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getActivityDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getArtifact());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getArtifactDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getBreakdownElement());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getBreakdownElementDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getCapabilityPattern());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getChecklist());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getCompositeRole());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getConcept());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getConstraint());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getContentCategory());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getContentDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getContentElement());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getContentPackage());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getCustomCategory());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDeliverable());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDeliverableDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDeliveryProcess());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDeliveryProcessDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDescribableElement());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDescriptor());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDescriptorDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDiscipline());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDisciplineGrouping());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getDomain());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getEstimationConsiderations());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getExample());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getGuidance());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getGuidanceDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getGuideline());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getIteration());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getMethodConfiguration());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getMethodElement());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getMethodLibrary());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getMethodPackage());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getMethodPlugin());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getMethodUnit());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getMilestone());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getNamedElement());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getOutcome());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getPackageableElement());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getPhase());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getPlanningData());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getPractice());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getPracticeDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getProcess());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getProcessComponent());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getProcessComponentInterface());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getProcessDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getProcessElement());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getProcessPackage());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getProcessPlanningTemplate());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getReport());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getReusableAsset());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getRoadmap());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getRole());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getRoleDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getRoleDescriptor());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getRoleSet());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getRoleSetGrouping());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getSection());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getSupportingMaterial());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getTask());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getTaskDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getTaskDescriptor());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getTeamProfile());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getTemplate());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getTermDefinition());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getTool());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getToolMentor());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getWhitepaper());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getWorkBreakdownElement());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getWorkDefinition());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getWorkOrder());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getWorkProduct());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getWorkProductDescription());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getWorkProductDescriptor());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getWorkProductType());
        this.loadModelClasses(this.umaEClassMap, UmaPackage.eINSTANCE.getMethodElementProperty());
    }

    private void loadXmlClasses() {
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getActivity());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getActivityDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getArtifact());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getArtifactDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getBreakdownElement());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getBreakdownElementDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getCapabilityPattern());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getChecklist());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getCompositeRole());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getConcept());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getConstraint());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getContentCategory());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getContentCategoryPackage());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getContentDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getContentElement());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getContentPackage());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getCustomCategory());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDeliverable());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDeliverableDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDeliveryProcess());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDeliveryProcessDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDescribableElement());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDescriptor());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDescriptorDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDiscipline());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDisciplineGrouping());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getDomain());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getEstimate());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getEstimatingMetric());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getEstimationConsiderations());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getExample());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getGuidance());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getGuidanceDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getGuideline());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getIteration());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getMethodConfiguration());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getMethodElement());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getMethodLibrary());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getMethodPackage());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getMethodPlugin());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getMethodUnit());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getMilestone());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getNamedElement());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getOutcome());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getPackageableElement());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getPhase());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getPlanningData());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getPractice());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getPracticeDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getProcess());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getProcessComponent());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getProcessComponentInterface());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getProcessDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getProcessElement());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getProcessPackage());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getProcessPlanningTemplate());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getReport());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getReusableAsset());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getRoadmap());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getRole());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getRoleDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getRoleDescriptor());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getRoleSet());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getRoleSetGrouping());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getSection());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getSupportingMaterial());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getTask());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getTaskDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getTaskDescriptor());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getTeamProfile());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getTemplate());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getTermDefinition());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getTool());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getToolMentor());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getWhitepaper());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getWorkBreakdownElement());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getWorkDefinition());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getWorkOrder());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getWorkProduct());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getWorkProductDescription());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getWorkProductDescriptor());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getWorkProductType());
        this.loadModelClasses(this.xmlEClassMap, org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getMethodElementProperty());
    }

    private void loadModelClasses(Map map, EClass eClass) {
        String string = eClass.getName();
        if (map.containsKey(string)) {
            return;
        }
        map.put(string, eClass);
        for (EStructuralFeature eStructuralFeature : ExtendedMetaData.INSTANCE.getAllElements(eClass)) {
            EClassifier eClassifier = eStructuralFeature.getEType();
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass2 = (EClass)eClassifier;
            this.loadModelClasses(map, eClass2);
        }
    }

    public EStructuralFeature getXmlFeature(EClass eClass, String string) {
        return this.getXmlFeature(eClass, string, null);
    }

    public EStructuralFeature getRmcFeature(EClass eClass, String string) {
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            int n;
            String string2 = eStructuralFeature.getName();
            if (string2.equals(string)) {
                return eStructuralFeature;
            }
            String string3 = (String)this.featureNameMap.get(string2);
            if (string3 == null || !((n = string3.indexOf(",")) > 0 ? string3.substring(0, n).equals(string) || string3.substring(n + 1).equals(string) : string3.equals(string))) continue;
            return eStructuralFeature;
        }
        return null;
    }

    public EStructuralFeature getXmlFeature(EClass eClass, String string, String string2) {
        int n;
        String string3 = string;
        if (this.featureNameMap.containsKey(string3) && (n = (string3 = (String)this.featureNameMap.get(string3)).indexOf(",")) > 0) {
            String string4 = string3.substring(0, n);
            if (string2 != null) {
                if (!string4.equalsIgnoreCase(string2)) {
                    string4 = string3.substring(n + 1);
                }
                if (!string4.equalsIgnoreCase(string2)) {
                    string4 = null;
                }
            }
            string3 = string4;
        }
        if (string3 == null) {
            return null;
        }
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(string3);
        if (eStructuralFeature == null && eClass.getName().equals("ContentCategoryPackage") && string3.equals("contentElement")) {
            eStructuralFeature = org.eclipse.epf.xml.uma.UmaPackage.eINSTANCE.getContentCategoryPackage_ContentCategory();
        }
        return eStructuralFeature;
    }

    public EClass getXmlEClass(String string) {
        EClass eClass = (EClass)this.xmlEClassMap.get(string);
        return eClass;
    }

    public EClass getRmcEClass(String string) {
        EClass eClass = (EClass)this.umaEClassMap.get(string);
        return eClass;
    }

    public boolean isUnneededRmcFeature(String string) {
        return this.unneededRmcFeatures.contains(string);
    }

    public boolean isUnneededXmlFeature(String string) {
        return this.unneededXmlFeatures.contains(string);
    }

    public void printFeatureNameMapping() {
        this.printFeature((EObject)UmaFactory.eINSTANCE.createActivity(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createActivity());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createActivityDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createActivityDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createArtifact(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createArtifact());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createArtifactDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createArtifactDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createBreakdownElementDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createBreakdownElementDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createCapabilityPattern(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createCapabilityPattern());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createChecklist(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createChecklist());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createCompositeRole(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createCompositeRole());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createConcept(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createConcept());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createConstraint(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createConstraint());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createContentDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createContentDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createContentPackage(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createContentPackage());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createCustomCategory(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createCustomCategory());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createDeliverable(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createDeliverable());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createDeliverableDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createDeliverableDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createDeliveryProcess(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createDeliveryProcess());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createDeliveryProcessDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createDeliveryProcessDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createDescriptorDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createDescriptorDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createDiscipline(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createDiscipline());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createDisciplineGrouping(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createDisciplineGrouping());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createDomain(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createDomain());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createEstimationConsiderations(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createEstimationConsiderations());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createExample(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createExample());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createGuidanceDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createGuidanceDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createGuideline(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createGuideline());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createIteration(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createIteration());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createMethodConfiguration(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createMethodConfiguration());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createMethodLibrary(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createMethodLibrary());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createMethodPlugin(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createMethodPlugin());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createMilestone(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createMilestone());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createOutcome(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createOutcome());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createPhase(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createPhase());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createPlanningData(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createPlanningData());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createPractice(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createPractice());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createPracticeDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createPracticeDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createProcessComponent(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createProcessComponent());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createProcessDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createProcessDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createProcessPackage(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createProcessPackage());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createProcessPlanningTemplate(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createProcessPlanningTemplate());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createReport(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createReport());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createReusableAsset(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createReusableAsset());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createRoadmap(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createRoadmap());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createRole(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createRole());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createRoleDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createRoleDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createRoleDescriptor(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createRoleDescriptor());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createRoleSet(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createRoleSet());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createRoleSetGrouping(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createRoleSetGrouping());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createSection(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createSection());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createSupportingMaterial(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createSupportingMaterial());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createTask(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createTask());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createTaskDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createTaskDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createTaskDescriptor(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createTaskDescriptor());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createTeamProfile(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createTeamProfile());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createTemplate(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createTemplate());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createTermDefinition(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createTermDefinition());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createTool(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createTool());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createToolMentor(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createToolMentor());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createWhitepaper(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createWhitepaper());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createWorkOrder(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createWorkOrder());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createWorkProductDescription(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createWorkProductDescription());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createWorkProductDescriptor(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createWorkProductDescriptor());
        this.printFeature((EObject)UmaFactory.eINSTANCE.createWorkProductType(), (EObject)org.eclipse.epf.xml.uma.UmaFactory.eINSTANCE.createWorkProductType());
    }

    private void printFeature(EObject eObject, EObject eObject2) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        EList eList = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature object : eList) {
            string = object.getName();
            if (this.featureNameMap.containsKey(string)) {
                String string2 = (String)this.featureNameMap.get(string);
                int n = string2.indexOf(",");
                if (n > 0) {
                    arrayList.add(string2.substring(0, n));
                    arrayList.add(string2.substring(n + 1).trim());
                    continue;
                }
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
                continue;
            }
            if (this.unneededRmcFeatures.contains(string) || arrayList3.contains(string)) continue;
            arrayList3.add(string);
        }
        eList = eObject2.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eList) {
            string = eStructuralFeature.getName();
            if (arrayList3.contains(string)) {
                arrayList3.remove(string);
                continue;
            }
            if (this.unneededXmlFeatures.contains(string) || arrayList.contains(string) || arrayList2.contains(string)) continue;
            arrayList2.add(string);
        }
        if (arrayList3.size() + arrayList2.size() == 0) {
            return;
        }
        System.out.println("============== un-matched features for " + eObject.eClass().getName() + " ==================");
        for (String string3 : arrayList3) {
            System.out.println("\tfeatureNameMap.put(\"" + string3 + "\", \"\");");
        }
        for (String string4 : arrayList2) {
            System.out.println("\t\t" + string4);
        }
        System.out.println("");
    }
}

