/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.wizards;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.preferences.ExportXMLPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectXMLFilePage
extends WizardPage {
    public static final String PAGE_NAME = SelectXMLFilePage.class.getName();
    private Text pathText;
    private String path;

    public SelectXMLFilePage() {
        super(PAGE_NAME);
        this.setTitle(ExportXMLResources.selectXMLFilePage_title);
        this.setDescription(ExportXMLResources.selectXMLFilePage_desc);
        this.setImageDescriptor(ExportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ExportXML.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(ExportXMLResources.fileLabel_text);
        this.pathText = new Text(composite2, 2048);
        this.pathText.setLayoutData((Object)new GridData(768));
        this.pathText.setText(ExportXMLPreferences.getXMLFile());
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (SelectXMLFilePage.this.isValidPath(SelectXMLFilePage.this.pathText.getText().trim())) {
                    SelectXMLFilePage.this.setPageComplete(true);
                    SelectXMLFilePage.this.setErrorMessage(null);
                } else {
                    SelectXMLFilePage.this.setPageComplete(false);
                    SelectXMLFilePage.this.setErrorMessage(ExportXMLResources.invalidXMLFile_error);
                }
            }
        });
        Button button = new Button(composite2, 8);
        button.setLayoutData((Object)new GridData(3));
        button.setText(ExportXMLResources.browseButton_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                fileDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String string = fileDialog.open();
                boolean bl = false;
                if (string != null) {
                    SelectXMLFilePage.this.pathText.setText(string);
                    bl = SelectXMLFilePage.this.isValidPath(string);
                }
                SelectXMLFilePage.this.setPageComplete(bl);
                SelectXMLFilePage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite2);
        this.setPageComplete(this.isValidPath(this.pathText.getText().trim()));
    }

    private boolean isValidPath(String string) {
        IPath iPath = Path.fromOSString((String)string);
        if (iPath.isValidPath(string) && string.endsWith(".xml")) {
            this.path = string;
            return true;
        }
        return false;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public String getPath() {
        return this.path;
    }
}

