/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.wizards.DiffReportContentProvider;
import org.eclipse.epf.importing.wizards.DiffReportLabelProvider;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class DiffReportViewer {
    protected Composite parent;
    protected CheckboxTreeViewer treeViewer;
    ConfigurationImportData data;

    DiffReportViewer(Composite composite, ConfigurationImportData configurationImportData) {
        this.parent = composite;
        this.data = configurationImportData;
        this.treeViewer = new CheckboxTreeViewer(composite);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new DiffReportContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DiffReportLabelProvider());
        this.createTableColumns();
        this.addListeners();
    }

    private void createTableColumns() {
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn treeColumn = new TreeColumn(tree, 0, 0);
        treeColumn.setText(ImportResources.DiffReportViewer_content);
        treeColumn.setWidth(200);
        treeColumn = new TreeColumn(tree, 0, 1);
        treeColumn.setText(ImportResources.DiffReportViewer_type);
        treeColumn.setWidth(150);
        treeColumn = new TreeColumn(tree, 0, 2);
        treeColumn.setText(ImportResources.DiffReportViewer_in_import);
        treeColumn.setWidth(75);
        treeColumn = new TreeColumn(tree, 0, 3);
        treeColumn.setText(ImportResources.DiffReportViewer_in_lib);
        treeColumn.setWidth(75);
        treeColumn = new TreeColumn(tree, 0, 4);
        treeColumn.setText(ImportResources.DiffReportViewer_status);
        treeColumn.setWidth(100);
    }

    public void showReport(Object object) {
        this.treeViewer.getTree().setVisible(false);
        this.treeViewer.setInput(object);
        this.setCheckStates();
        this.treeViewer.expandAll();
        this.treeViewer.getTree().setVisible(true);
    }

    private void addListeners() {
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                boolean bl = checkStateChangedEvent.getChecked();
                DiffReportViewer.this.updateCheckStates(checkStateChangedEvent.getElement(), bl);
            }
        });
    }

    private void updateCheckStates(Object object, boolean bl) {
        if (bl) {
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
            this.checkParent(iTreeContentProvider, object);
        } else {
            this.treeViewer.setChecked(object, false);
        }
        this.selectionChildren(object, bl);
        this.setData(this.treeViewer.getCheckedElements());
    }

    public void selectionChildren(Object object, boolean bl) {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] objectArray = iTreeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            this.treeViewer.setChecked(objectArray[n], bl);
            this.selectionChildren(objectArray[n], bl);
            ++n;
        }
    }

    private void checkParent(ITreeContentProvider iTreeContentProvider, Object object) {
        if (object == null || object instanceof MethodLibrary) {
            return;
        }
        Object object2 = LibraryUtil.unwrap((Object)iTreeContentProvider.getParent(object));
        if (object2 != null) {
            this.treeViewer.setChecked(object2, true);
            this.checkParent(iTreeContentProvider, object2);
        }
    }

    private void setCheckStates() {
        this.treeViewer.getTree().setVisible(false);
        try {
            Object object = this.treeViewer.getInput();
            this.selectionChildren(object, true);
        }
        finally {
            this.treeViewer.getTree().setVisible(true);
        }
        this.setData(this.treeViewer.getCheckedElements());
    }

    private void setData(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        this.data.importList.clear();
        int n = 0;
        while (n < objectArray.length) {
            this.data.importList.add(objectArray[n]);
            ++n;
        }
    }
}

