/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.conditions;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.query.conditions.Condition;

public abstract class ConditionPolicy {
    public static final ConditionPolicy ALL = new ConditionPolicy(){

        public boolean isSatisfied(Condition condition, Collection objects) {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                if (condition.isSatisfied(it.next())) continue;
                return false;
            }
            return true;
        }

        public boolean isSatisfied(Condition[] conditions, Object object) {
            int i = 0;
            while (i < conditions.length) {
                if (!conditions[i].isSatisfied(object)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    };
    public static final ConditionPolicy ANY = new ConditionPolicy(){

        public boolean isSatisfied(Condition condition, Collection objects) {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                if (!condition.isSatisfied(it.next())) continue;
                return true;
            }
            return false;
        }

        public boolean isSatisfied(Condition[] conditions, Object object) {
            int i = 0;
            while (i < conditions.length) {
                if (conditions[i].isSatisfied(object)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    };

    protected ConditionPolicy() {
    }

    public abstract boolean isSatisfied(Condition var1, Collection var2);

    public abstract boolean isSatisfied(Condition[] var1, Object var2);

    public boolean isSatisfied(Condition condition, Object object) {
        return condition.isSatisfied(object);
    }
}

