/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.dataexchange.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.eclipse.epf.dataexchange.util.DefaultLogger;

public class FileLogger
extends DefaultLogger {
    public static final String ERROR_LOG_FILENAME = "error.log";
    public static final String WARNING_LOG_FILENAME = "warning.log";
    public static final String INFO_LOG_FILENAME = "info.log";
    protected File logPath;

    public FileLogger(File file) {
        this.logPath = file;
        if (!this.logPath.exists()) {
            this.logPath.mkdirs();
        }
        this.info = this.getStream(new File(file, INFO_LOG_FILENAME));
        this.warning = this.getStream(new File(file, WARNING_LOG_FILENAME));
        this.error = this.getStream(new File(file, ERROR_LOG_FILENAME));
    }

    private PrintStream getStream(File file) {
        try {
            File file2 = file.getParentFile();
            file2.mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
            return new PrintStream(new FileOutputStream(file), true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void dispose() {
        this.info.close();
        this.warning.close();
        this.error.close();
    }

    public File getLogPath() {
        return this.logPath;
    }
}

