/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.commands.ChangePropertyValueCommand;
import org.eclipse.epf.authoring.gef.edit.LabelTextCellEditorLocator;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.edit.ValidatingFreeTextEditManager;
import org.eclipse.epf.authoring.gef.figures.SelectableLabel;
import org.eclipse.epf.authoring.gef.util.TemplateConstants;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.uma.Property;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;

public class FreeTextEditPart
extends NodeEditPart {
    private Font font;
    private Color color;
    private FontData fData;
    private NodeEditPart part = this;

    public FreeTextEditPart(Node node) {
        super(node);
    }

    protected IFigure createFigure() {
        SelectableLabel selectableLabel = new SelectableLabel();
        selectableLabel.setLabelAlignment(1);
        selectableLabel.setTextPlacement(4);
        return selectableLabel;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (!((Node)this.getModel()).isReadOnly()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.createDirectEditPolicy());
        }
    }

    protected DirectEditPolicy createDirectEditPolicy() {
        return new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest directEditRequest) {
                return new ChangePropertyValueCommand(FreeTextEditPart.this.part, (String)directEditRequest.getCellEditor().getValue());
            }

            protected void showCurrentEditValue(DirectEditRequest directEditRequest) {
                IFigure iFigure = FreeTextEditPart.this.getDirectEditFigure();
                if (iFigure instanceof Label) {
                    ((Label)iFigure).setText((String)directEditRequest.getCellEditor().getValue());
                    iFigure.getUpdateManager().performUpdate();
                }
            }
        };
    }

    protected void handlePropertyChanged(Notification notification) {
        switch (notification.getFeatureID(Node.class)) {
            case 7: {
                this.refreshVisuals();
                return;
            }
        }
        super.handlePropertyChanged(notification);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && !((Node)this.getModel()).isReadOnly()) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFigure iFigure = this.getDirectEditFigure();
        if (iFigure instanceof Label) {
            Label label = (Label)iFigure;
            List list = ((Node)this.getModel()).getGraphNode().getProperty();
            String string = TemplateConstants.DEFAULT_FONT_NAME;
            int n = 0;
            int n2 = 8;
            int n3 = 3;
            int n4 = 9;
            int n5 = 5;
            if (list.size() > 0) {
                for (Property property : list) {
                    if (property.getKey().equals("free text")) {
                        label.setText(property.getValue());
                        continue;
                    }
                    if (property.getKey().equals("property_font_name")) {
                        string = property.getValue();
                        continue;
                    }
                    if (property.getKey().equals("property_font_style")) {
                        n = new Integer(property.getValue());
                        continue;
                    }
                    if (property.getKey().equals("property_font_height")) {
                        n2 = new Integer(property.getValue());
                        continue;
                    }
                    if (property.getKey().equals("property_font_red")) {
                        n3 = new Integer(property.getValue());
                        continue;
                    }
                    if (property.getKey().equals("property_font_blue")) {
                        n4 = new Integer(property.getValue());
                        continue;
                    }
                    if (!property.getKey().equals("property_font_green")) continue;
                    n5 = new Integer(property.getValue());
                }
            } else {
                label.setText(((Node)this.getModel()).getGraphNode().getName());
            }
            if (this.font != null && !this.font.isDisposed()) {
                this.font.dispose();
            }
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
            }
            this.fData = new FontData(string, n2, n);
            this.font = new Font((Device)PlatformUI.getWorkbench().getDisplay(), this.fData);
            this.color = new Color(null, n3, n5, n4);
            label.setFont(this.font);
            label.setForegroundColor(this.color);
        }
    }

    protected DirectEditManager createDirectEditManager() {
        Label label = (Label)this.getFigure();
        return new ValidatingFreeTextEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelTextCellEditorLocator(label), label){

            protected String validate(String string) {
                return super.validate(string);
            }
        };
    }

    IFigure getDirectEditFigure() {
        return this.getFigure();
    }

    public void deactivate() {
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        if (this.color != null && !this.color.isDisposed()) {
            this.color.dispose();
        }
        super.deactivate();
    }
}

