/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import com.ibm.icu.util.StringTokenizer;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.commands.CreateLinkCommand;
import org.eclipse.epf.authoring.gef.commands.ReconnectLinkCommand;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.RaisedMarginBorder;
import org.eclipse.epf.authoring.gef.util.ConnectionAnchorLocator;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.WorkProductComposite;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class WorkProductCompositeEditPart
extends NodeContainerEditPart
implements NodeEditPart {
    private static Color BG_COLOR;

    public WorkProductCompositeEditPart(WorkProductComposite workProductComposite) {
        super((NodeContainer)workProductComposite);
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMinorSpacing(20);
        figure.setLayoutManager((LayoutManager)flowLayout);
        figure.setBorder((Border)new RaisedMarginBorder());
        figure.setBackgroundColor(this.getBackgroundColor());
        figure.setOpaque(true);
        return figure;
    }

    protected void handlePropertyChanged(Notification notification) {
        switch (notification.getFeatureID(NodeContainer.class)) {
            case 7: {
                this.refreshChildren();
                this.adjustSize();
                EditPart editPart = this.getParent();
                editPart.refresh();
                return;
            }
        }
        super.handlePropertyChanged(notification);
    }

    private void adjustSize() {
        List list = this.getChildren();
        int n = 20;
        int n2 = 20;
        for (GraphicalEditPart graphicalEditPart : list) {
            n += graphicalEditPart.getFigure().getPreferredSize().height;
            if (n2 >= graphicalEditPart.getFigure().getPreferredSize().width) continue;
            n2 = graphicalEditPart.getFigure().getPreferredSize().width;
        }
        ((Node)this.getModel()).setHeight(n);
        ((Node)this.getModel()).setWidth(n2 + 20);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy(){

            protected Command getConnectionCompleteCommand(CreateConnectionRequest createConnectionRequest) {
                CreateLinkCommand createLinkCommand = (CreateLinkCommand)createConnectionRequest.getStartCommand();
                createLinkCommand.setTarget((Node)this.getHost().getModel());
                if (createConnectionRequest.getTargetEditPart() instanceof ConnectionAnchorLocator && !createConnectionRequest.getTargetEditPart().equals(createConnectionRequest.getSourceEditPart())) {
                    createLinkCommand.setTargetEndPoint(((ConnectionAnchorLocator)createConnectionRequest.getTargetEditPart()).getLocation(createConnectionRequest.getLocation()));
                }
                return createLinkCommand;
            }

            protected Command getConnectionCreateCommand(CreateConnectionRequest createConnectionRequest) {
                CreateLinkCommand createLinkCommand = new CreateLinkCommand(ModelFactory.eINSTANCE.createLink(), (Node)this.getHost().getModel());
                if (createConnectionRequest.getTargetEditPart() instanceof ConnectionAnchorLocator) {
                    createLinkCommand.setSourceEndPoint(((ConnectionAnchorLocator)createConnectionRequest.getTargetEditPart()).getLocation(createConnectionRequest.getLocation()));
                } else {
                    createLinkCommand.setSourceEndPoint(createConnectionRequest.getLocation());
                }
                createConnectionRequest.setStartCommand((Command)createLinkCommand);
                return createLinkCommand;
            }

            protected Command getReconnectSourceCommand(ReconnectRequest reconnectRequest) {
                Link link = (Link)reconnectRequest.getConnectionEditPart().getModel();
                ReconnectLinkCommand reconnectLinkCommand = new ReconnectLinkCommand(link, (Node)this.getHost().getModel(), true);
                if (reconnectRequest.getTarget() instanceof ConnectionAnchorLocator) {
                    reconnectLinkCommand.setEndPoint(((ConnectionAnchorLocator)reconnectRequest.getTarget()).getLocation(reconnectRequest.getLocation()));
                }
                return reconnectLinkCommand;
            }

            protected Command getReconnectTargetCommand(ReconnectRequest reconnectRequest) {
                Link link = (Link)reconnectRequest.getConnectionEditPart().getModel();
                ReconnectLinkCommand reconnectLinkCommand = new ReconnectLinkCommand(link, (Node)this.getHost().getModel(), false);
                if (reconnectRequest.getTarget() instanceof ConnectionAnchorLocator) {
                    reconnectLinkCommand.setEndPoint(((ConnectionAnchorLocator)reconnectRequest.getTarget()).getLocation(reconnectRequest.getLocation()));
                }
                return reconnectLinkCommand;
            }
        });
        this.installEditPolicy("LayoutEditPolicy", null);
        this.installEditPolicy("ComponentEditPolicy", null);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connectionEditPart) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionEditPart) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    protected List getModelSourceConnections() {
        return this.getNode().getOutgoingConnections();
    }

    protected List getModelTargetConnections() {
        return this.getNode().getIncomingConnections();
    }

    protected Node getNode() {
        return (Node)this.getModel();
    }

    protected Color getBackgroundColor() {
        String string;
        if (BG_COLOR != null) {
            return BG_COLOR;
        }
        if (BG_COLOR == null && (string = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("ADD_WP_BOX_BG_COLOR_RGB")) != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            BG_COLOR = new Color(null, n, n2, n3);
            return BG_COLOR;
        }
        if (BG_COLOR == null) {
            BG_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 205);
        }
        return BG_COLOR;
    }
}

