/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationWizard;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryWizard;
import org.eclipse.epf.authoring.ui.wizards.NewPluginWizard;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public class AuthoringPerspective
implements IPerspectiveFactory {
    public static final String PERSPECTIVE_ID = AuthoringPerspective.class.getName();
    private static List<String> newWizardShortcuts = new ArrayList<String>();

    static {
        newWizardShortcuts.add(NewLibraryWizard.WIZARD_ID);
        newWizardShortcuts.add(NewPluginWizard.WIZARD_ID);
        newWizardShortcuts.add(NewConfigurationWizard.WIZARD_ID);
    }

    public static IPerspectiveDescriptor open() {
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor iPerspectiveDescriptor = iWorkbenchPage.getPerspective();
            if (!iPerspectiveDescriptor.getId().equals(PERSPECTIVE_ID)) {
                IPerspectiveDescriptor iPerspectiveDescriptor2 = iPerspectiveRegistry.findPerspectiveWithId(PERSPECTIVE_ID);
                iWorkbenchPage.setPerspective(iPerspectiveDescriptor2);
            }
            return iPerspectiveDescriptor;
        }
        return null;
    }

    public void createInitialLayout(IPageLayout iPageLayout) {
        iPageLayout.setEditorAreaVisible(true);
        String string = iPageLayout.getEditorArea();
        IFolderLayout iFolderLayout = iPageLayout.createFolder("topLeft", 1, 0.3f, string);
        IFolderLayout iFolderLayout2 = iPageLayout.createFolder("bottomLeft", 4, 0.5f, "topLeft");
        iFolderLayout.addView(LibraryView.VIEW_ID);
        iFolderLayout2.addView(ConfigurationView.VIEW_ID);
        IPlaceholderFolderLayout iPlaceholderFolderLayout = iPageLayout.createPlaceholderFolder("bottom", 4, 0.65f, string);
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.views.PropertySheet");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.views.ProblemView");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.views.ProgressView");
        iPageLayout.addNewWizardShortcut(NewLibraryWizard.WIZARD_ID);
        iPageLayout.addNewWizardShortcut(NewPluginWizard.WIZARD_ID);
        iPageLayout.addNewWizardShortcut(NewConfigurationWizard.WIZARD_ID);
        IWizardRegistry iWizardRegistry = PlatformUI.getWorkbench().getNewWizardRegistry();
        IWizardCategory iWizardCategory = iWizardRegistry.findCategory("org.eclipse.epf.ui.newWizards.category");
        IWizardDescriptor[] iWizardDescriptorArray = iWizardCategory.getWizards();
        int n = 0;
        while (n < iWizardDescriptorArray.length) {
            IWizardDescriptor iWizardDescriptor = iWizardDescriptorArray[n];
            String string2 = iWizardDescriptor.getId();
            if (!newWizardShortcuts.contains(string2)) {
                iPageLayout.addNewWizardShortcut(string2);
            }
            ++n;
        }
        PerspectiveListUtil.addPerspectiveShortList(iPageLayout);
    }
}

