/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dnd;

import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class LibraryViewerDragAdapter
extends ViewerDragAdapter {
    public LibraryViewerDragAdapter(Viewer viewer) {
        super(viewer);
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        super.dragStart(dragSourceEvent);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        dragSourceEvent.doit = false;
        Iterator iterator = iStructuredSelection.toList().iterator();
        while (iterator.hasNext()) {
            Object object = TngUtil.unwrap(iterator.next());
            if (!(object instanceof MethodElement) || object instanceof MethodConfiguration || object instanceof ContentPackage) continue;
            dragSourceEvent.doit = true;
        }
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        if (HTMLTransfer.getInstance().isSupportedType(dragSourceEvent.dataType) || TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
            String string = "";
            Iterator iterator = iStructuredSelection.toList().iterator();
            while (iterator.hasNext()) {
                Object object = TngUtil.unwrap(iterator.next());
                if (!(object instanceof MethodElement)) continue;
                String string2 = this.getHyperlink((MethodElement)object);
                if (Platform.getOS().equals("win32")) {
                    if (string.length() > 0) {
                        string = String.valueOf(string) + StrUtil.LINE_FEED;
                    }
                    string = String.valueOf(string) + new String(StrUtil.getUTF8Bytes((String)string2));
                    continue;
                }
                if (string.length() > 0) {
                    string = String.valueOf(string) + StrUtil.LINE_FEED;
                }
                string = String.valueOf(string) + string2;
            }
            if (string.length() > 0) {
                dragSourceEvent.data = string;
            }
        }
        super.dragSetData(dragSourceEvent);
    }

    protected String getHyperlink(MethodElement methodElement) {
        Object object;
        MethodElement methodElement2 = null;
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart != null && (object = iEditorPart.getEditorInput()) instanceof MethodElementEditorInput) {
            methodElement2 = ((MethodElementEditorInput)object).getMethodElement();
        }
        if (methodElement instanceof ProcessComponent) {
            methodElement = ((ProcessComponent)methodElement).getProcess();
        }
        object = ResourceHelper.getUrl((MethodElement)methodElement, methodElement2, (String)".html");
        String string = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("libViewDNDDefaultLinkType");
        String string2 = "";
        string2 = "elementLinkWithType".equals(string) ? ResourceHelper.getElementLinkText((MethodElement)methodElement, (boolean)true) : ResourceHelper.getElementLinkText((MethodElement)methodElement, (boolean)false);
        return ResourceHelper.getElementLink((MethodElement)methodElement, (String)string2, (String)("file://" + (String)object), (String)string);
    }
}

