/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.epf.authoring.gef.commands.ChangeBoundsCommand;
import org.eclipse.epf.authoring.gef.commands.CreateBendpointCommand;
import org.eclipse.epf.authoring.gef.commands.CreateLinkCommand;
import org.eclipse.epf.authoring.gef.commands.CreateNodeCommand;
import org.eclipse.epf.authoring.gef.commands.MoveBendpointCommand;
import org.eclipse.epf.authoring.gef.edit.DecisionNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.DiagramActionService;
import org.eclipse.epf.authoring.gef.edit.FreeTextNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.LinkEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.edit.SynchBarNodeEditPart;
import org.eclipse.epf.authoring.gef.figures.FreeTextFigure;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.actions.DiagramPrintAction;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.ui.editors.IMethodEditor;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Property;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.CopyTemplateAction;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractDiagramEditor
extends GraphicalEditorWithFlyoutPalette
implements IMethodEditor {
    private static final String REFRESH_FROM_BASE_ACTIVITY = "refresh_from_base_activity";
    private static final String FONT_DIALOG = "font_dialog";
    private static final String CREATE_LINK = "create_link";
    private static final String SELECT_LINK = "select_link";
    private static final String CREATE_BEND_POINT = "create_bend_point";
    protected static final String CREATE_FREE_TEXT = "create_free_text";
    public static final String MOVE = "move";
    protected static final String REFRESH = "refresh";
    protected static final String ALIGN_BEND_POINT = "align_bend_point";
    protected static final String PALETTE_DOCK_LOCATION = "Dock location";
    protected static final String PALETTE_SIZE = "Palette Size";
    protected static final String PALETTE_STATE = "Palette state";
    protected static final int DEFAULT_PALETTE_SIZE = 130;
    protected static final String DELETE_DIAGRAM = "delete_actvity_detail_diagram";
    private KeyHandler sharedKeyHandler;
    private PaletteRoot paletteRoot;
    protected EditPart editPart;
    private CommandStackEventListener cmdStackEventListener;
    protected CreationFactory freeTxtNodeCreationFactory;
    protected DiagramActionService actionService = null;
    private boolean disposed;
    protected IEditorPart parentEditor = null;
    protected IPartListener partListener = new IPartListener(){
        IEditorPart me;
        {
            this.me = AbstractDiagramEditor.this;
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart == this.me) {
                AbstractDiagramEditor.this.setParentEditor(null);
                IWorkbenchPage iWorkbenchPage = AbstractDiagramEditor.this.getSite().getPage();
                iWorkbenchPage.removePartListener(AbstractDiagramEditor.this.partListener);
                org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.getGraphicalViewer().getContents().getModel();
                if (diagram.isNew()) {
                    if (diagram.getUMADiagram() != null) {
                        EcoreUtil.remove((EObject)diagram.getUMADiagram());
                    }
                    if (AbstractDiagramEditor.this.isResourceChangedByOther()) {
                        AbstractDiagramEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
        }
    };
    private Font font;
    private Color color;
    private org.eclipse.gef.commands.Command refreshFromBaseCommand = new org.eclipse.gef.commands.Command(DiagramUIResources.AbstractDiagramEditorrefreshfrombase){
        private ArrayList oldContent;
        {
            this.oldContent = new ArrayList();
        }

        public void execute() {
            org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.editPart.getModel();
            this.oldContent.clear();
            this.oldContent.addAll(diagram.getUMADiagram().getContained());
            GraphicalDataHelper.refreshFromBase((Diagram)diagram.getUMADiagram());
            if (AbstractDiagramEditor.this.editPart.isActive()) {
                AbstractDiagramEditor.this.editPart.deactivate();
            }
            diagram.removeConsumer((Object)this);
            AbstractDiagramEditor.this.createEditPart();
            AbstractDiagramEditor.this.getGraphicalViewer().setContents(AbstractDiagramEditor.this.editPart);
        }

        public void undo() {
            org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.editPart.getModel();
            diagram.getUMADiagram().getContained().clear();
            diagram.getUMADiagram().getContained().addAll(this.oldContent);
            if (AbstractDiagramEditor.this.editPart.isActive()) {
                AbstractDiagramEditor.this.editPart.deactivate();
            }
            diagram.removeConsumer((Object)this);
            AbstractDiagramEditor.this.createEditPart();
            AbstractDiagramEditor.this.getGraphicalViewer().setContents(AbstractDiagramEditor.this.editPart);
        }
    };
    protected Map templateNameToCreationFactoryMap;
    protected long changeTime = -1L;
    protected MethodConfiguration currentConfig;
    private ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        public void libraryChanged(int n, Collection collection) {
            switch (n) {
                case 8: {
                    if (collection == null || !collection.contains(AbstractDiagramEditor.this.currentConfig)) break;
                    MethodConfiguration methodConfiguration = ProcessAuthoringConfigurator.INSTANCE.getMethodConfiguration();
                    try {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(AbstractDiagramEditor.this.currentConfig);
                        IAction iAction = AbstractDiagramEditor.this.getActionRegistry().getAction((Object)AbstractDiagramEditor.REFRESH);
                        iAction.run();
                    }
                    finally {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(methodConfiguration);
                    }
                }
            }
        }
    };
    private ILibraryServiceListener libSvcListener = new ILibraryServiceListener(){

        public void configurationSet(MethodConfiguration methodConfiguration) {
            AbstractDiagramEditor.this.configChanged();
        }

        public void libraryClosed(MethodLibrary methodLibrary) {
        }

        public void libraryCreated(MethodLibrary methodLibrary) {
        }

        public void libraryOpened(MethodLibrary methodLibrary) {
        }

        public void libraryReopened(MethodLibrary methodLibrary) {
        }

        public void librarySet(MethodLibrary methodLibrary) {
        }
    };

    public AbstractDiagramEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getEditDomain().setCommandStack(new CommandStack(){

            public boolean isDirty() {
                org.eclipse.gef.commands.Command command = this.getUndoCommand();
                if (command != null && !command.canUndo()) {
                    return false;
                }
                return super.isDirty();
            }

            public void execute(org.eclipse.gef.commands.Command command) {
                if (command == null || !command.canExecute()) {
                    return;
                }
                if (AbstractDiagramEditor.this.changeTime == -1L) {
                    AbstractDiagramEditor.this.changeTime = System.currentTimeMillis();
                }
                super.execute(command);
            }
        });
        this.cmdStackEventListener = new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent commandStackEvent) {
                if (commandStackEvent.getDetail() == 8) {
                    AbstractDiagramEditor.this.firePropertyChange(257);
                }
            }
        };
        this.getEditDomain().getCommandStack().addCommandStackEventListener(this.cmdStackEventListener);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        iWorkbenchPage.addPartListener(this.partListener);
    }

    public void dispose() {
        org.eclipse.epf.diagram.model.Diagram diagram;
        this.getCommandStack().removeCommandStackEventListener(this.cmdStackEventListener);
        if (this.isDirty()) {
            this.reverseToSaved();
        }
        if (this.editPart != null && (diagram = (org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel()) != null) {
            diagram.removeConsumer((Object)this);
        }
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        if (this.color != null && !this.color.isDisposed()) {
            this.color.dispose();
        }
        if ((diagram = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            diagram.removeListener(this.libraryListener);
        }
        LibraryService.getInstance().removeListener(this.libSvcListener);
        super.dispose();
        this.disposed = true;
    }

    private boolean isResourceChangedByOther() {
        Resource resource = this.getMethodElementFromInput().eResource();
        if (resource != null && resource.getURI().isFile()) {
            File file = new File(resource.getURI().toFileString());
            return file.lastModified() > this.changeTime;
        }
        return false;
    }

    private void reverseToSaved() {
        boolean bl = this.getCommandStack().isDirty() && this.isResourceChangedByOther();
        this.changeTime = -1L;
        while (this.getCommandStack().isDirty()) {
            this.getCommandStack().undo();
        }
        if (bl) {
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            try {
                failSafeMethodLibraryPersister.save(this.getMethodElementFromInput().eResource());
                failSafeMethodLibraryPersister.commit();
            }
            catch (Exception exception) {
                CommonPlugin.INSTANCE.log((Object)exception);
                try {
                    failSafeMethodLibraryPersister.rollback();
                }
                catch (Exception exception2) {
                    ViewHelper.reloadCurrentLibrary(this.getSite().getShell(), null);
                }
            }
        }
    }

    protected void contributeToContextMenu(IMenuManager iMenuManager) {
        IContributionItem iContributionItem;
        boolean bl = !this.isReadOnly();
        IAction iAction = this.getActionRegistry().getAction((Object)REFRESH_FROM_BASE_ACTIVITY);
        if (iAction.isEnabled() && bl) {
            iMenuManager.appendToGroup("additions", iAction);
        }
        if ((iContributionItem = this.createAlignMenu()).isEnabled() && bl) {
            iMenuManager.appendToGroup("additions", (IContributionItem)new Separator());
            iMenuManager.appendToGroup("additions", iContributionItem);
            iMenuManager.appendToGroup("additions", (IContributionItem)new Separator());
        }
        if ((iAction = this.getActionRegistry().getAction((Object)DELETE_DIAGRAM)).isEnabled() && bl) {
            iMenuManager.appendToGroup("additions", (IContributionItem)new Separator());
            iMenuManager.appendToGroup("additions", iAction);
            iMenuManager.appendToGroup("additions", (IContributionItem)new Separator());
        }
    }

    protected IContributionItem createAlignMenu() {
        MenuManager menuManager = new MenuManager(DiagramUIResources.AbstractDiagramEditor_alignMenu_text){

            public boolean isEnabled() {
                int n = 0;
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (list.size() > 1) {
                    int n2 = 0;
                    while (n2 < list.size()) {
                        EditPart editPart = (EditPart)list.get(n2);
                        if ((editPart instanceof NodeEditPart || editPart instanceof NodeContainerEditPart) && ++n > 1) break;
                        ++n2;
                    }
                }
                return n > 1;
            }
        };
        menuManager.add(this.getActionRegistry().getAction((Object)"align_horizontal_to_average"));
        menuManager.add(this.getActionRegistry().getAction((Object)"align_horizontal_to_first_selection"));
        menuManager.add(this.getActionRegistry().getAction((Object)"align_vertical_to_average"));
        menuManager.add(this.getActionRegistry().getAction((Object)"align_vertical_to_first_selection"));
        return menuManager;
    }

    protected void refreshFromBase() {
        this.getCommandStack().execute(this.refreshFromBaseCommand);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry actionRegistry = this.getActionRegistry();
        Object object = actionRegistry.getAction((Object)ActionFactory.DELETE.getId());
        if (object != null) {
            actionRegistry.removeAction(object);
            this.getSelectionActions().remove(object);
        }
        object = new DeleteAction((IWorkbenchPart)this){

            public boolean isEnabled() {
                return super.isEnabled();
            }

            public void run() {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object e : this.getSelectedObjects()) {
                    Object object;
                    Object object2;
                    if (!(e instanceof EditPart) || !((object2 = ((EditPart)e).getModel()) instanceof NamedNode) || !((object = ((NamedNode)object2).getObject()) instanceof BreakdownElement)) continue;
                    arrayList.add(object);
                }
                if (!arrayList.isEmpty()) {
                    Iterator iterator = new ProcessDeleteAction(){

                        public Command createCommand(Collection collection) {
                            this.domain = null;
                            for (Object e : collection) {
                                if (!(e instanceof WorkProductDescriptor)) continue;
                                this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (org.eclipse.emf.common.command.CommandStack)new BasicCommandStack());
                                break;
                            }
                            if (this.domain == null) {
                                this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (org.eclipse.emf.common.command.CommandStack)new BasicCommandStack());
                            }
                            return super.createCommand(collection);
                        }
                    };
                    iterator.updateSelection((IStructuredSelection)new StructuredSelection(arrayList));
                    iterator.run();
                    if (iterator.isDeletionConfirmed()) {
                        super.run();
                        BusyIndicator.showWhile((Display)AbstractDiagramEditor.this.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(){

                            public void run() {
                                AbstractDiagramEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                            }
                        });
                    }
                } else {
                    super.run();
                }
            }
        };
        actionRegistry.registerAction(object);
        this.getSelectionActions().add(object.getId());
        object = new CopyTemplateAction((IEditorPart)this);
        actionRegistry.registerAction(object);
        object = new Action(DiagramUIResources.AbstractDiagramEditor_refreshFromBaseActivity_text){

            public String getId() {
                return AbstractDiagramEditor.REFRESH_FROM_BASE_ACTIVITY;
            }

            public void run() {
                AbstractDiagramEditor.this.refreshFromBase();
            }

            public boolean isEnabled() {
                Activity activity = (Activity)AbstractDiagramEditor.this.getMethodElementFromInput();
                return activity.getVariabilityBasedOnElement() != null;
            }
        };
        actionRegistry.registerAction(object);
        Action action = new Action(DiagramUIResources.AbstractDiagramEditor_formatTextBoxActivity_text){

            public String getId() {
                return AbstractDiagramEditor.FONT_DIALOG;
            }

            public void run() {
                try {
                    try {
                        FontData fontData;
                        EditPart editPart = (EditPart)AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().get(0);
                        FontDialog fontDialog = new FontDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        if (editPart != null) {
                            this.restoreFontData(editPart, fontDialog);
                        }
                        fontDialog.open();
                        if (editPart instanceof FreeTextNodeEditPart && fontDialog.getFontList() != null && (fontData = fontDialog.getFontList()[0]) != null) {
                            if (AbstractDiagramEditor.this.font != null && !AbstractDiagramEditor.this.font.isDisposed()) {
                                AbstractDiagramEditor.this.font.dispose();
                            }
                            AbstractDiagramEditor.this.font = new Font((Device)PlatformUI.getWorkbench().getDisplay(), fontData);
                            if (fontDialog.getRGB() != null) {
                                AbstractDiagramEditor.this.color = new Color(null, fontDialog.getRGB());
                            }
                            ((FreeTextFigure)((FreeTextNodeEditPart)editPart).getFigure()).setFont(AbstractDiagramEditor.this.font);
                            if (AbstractDiagramEditor.this.color != null) {
                                ((FreeTextFigure)((FreeTextNodeEditPart)editPart).getFigure()).setForegroundColor(AbstractDiagramEditor.this.color);
                            }
                            GraphNode graphNode = ((Node)editPart.getModel()).getGraphNode();
                            List list = graphNode.getList(10);
                            String string = ((FreeTextFigure)((FreeTextNodeEditPart)editPart).getFigure()).getText();
                            Property property = this.getPropertyByKey(list, "free text");
                            if (property != null) {
                                property.setValue(string);
                                list.add(property);
                            }
                            this.setProperty(list, "property_font_name", fontData.getName());
                            this.setProperty(list, "property_font_style", new Integer(fontData.getStyle()).toString());
                            this.setProperty(list, "property_font_height", new Integer(fontData.getHeight()).toString());
                            if (fontDialog.getRGB() != null) {
                                this.setProperty(list, "property_font_red", new Integer(fontDialog.getRGB().red).toString());
                                this.setProperty(list, "property_font_blue", new Integer(fontDialog.getRGB().blue).toString());
                                this.setProperty(list, "property_font_green", new Integer(fontDialog.getRGB().green).toString());
                            }
                            editPart.refresh();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }

            public boolean isEnabled() {
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (list.size() != 1) {
                    return false;
                }
                EditPart editPart = (EditPart)list.get(0);
                if (editPart.getModel() instanceof TypedNode) {
                    return ((TypedNode)editPart.getModel()).getType() == 6;
                }
                return false;
            }

            public Property getPropertyByKey(List list, String string) {
                if (!list.isEmpty()) {
                    for (Property property : list) {
                        if (property == null || !property.getKey().equals(string)) continue;
                        return property;
                    }
                }
                return null;
            }

            public void setProperty(List list, String string, String string2) {
                Property property = this.getPropertyByKey(list, string);
                if (property != null) {
                    property.setValue(string2);
                } else {
                    property = UmaFactory.eINSTANCE.createProperty();
                    property.setKey(string);
                    property.setValue(string2);
                }
                list.add(property);
            }

            public void restoreFontData(EditPart editPart, FontDialog fontDialog) {
                GraphNode graphNode = ((Node)editPart.getModel()).getGraphNode();
                List list = graphNode.getList(10);
                if (list != null && !list.isEmpty()) {
                    Property property = null;
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    property = this.getPropertyByKey(list, "property_font_name");
                    if (property == null) {
                        return;
                    }
                    string = property.getValue();
                    property = this.getPropertyByKey(list, "property_font_style");
                    if (property != null) {
                        string2 = property.getValue();
                    }
                    if ((property = this.getPropertyByKey(list, "property_font_height")) != null) {
                        string3 = property.getValue();
                    }
                    if ((property = this.getPropertyByKey(list, "property_font_red")) != null) {
                        string4 = property.getValue();
                    }
                    if ((property = this.getPropertyByKey(list, "property_font_blue")) != null) {
                        string5 = property.getValue();
                    }
                    if ((property = this.getPropertyByKey(list, "property_font_green")) != null) {
                        string6 = property.getValue();
                    }
                    FontData fontData = new FontData();
                    fontData.setName(string);
                    fontData.setHeight(new Integer(string3).intValue());
                    fontData.setStyle(new Integer(string2).intValue());
                    if (string4 != null && string5 != null && string6 != null) {
                        RGB rGB = new RGB(new Integer(string4).intValue(), new Integer(string6).intValue(), new Integer(string5).intValue());
                        fontDialog.setRGB(rGB);
                    }
                    fontDialog.setFontList(new FontData[]{fontData});
                }
            }
        };
        this.getActionRegistry().registerAction((IAction)action);
        this.actionService = new DiagramActionService(this.getGraphicalViewer(), this.getEditDomain(), actionRegistry);
        this.actionService.registerHorizontalAlignAverageAction();
        this.actionService.registerHorizontalAlignFirstSelectedAction();
        this.actionService.registerVerticalAlignAverageAction();
        this.actionService.registerVerticalAlignFirstSelectedAction();
        object = this.createAnAction(DiagramUIResources.AbstractDiagram_FreeText_text, this.freeTxtNodeCreationFactory, CREATE_FREE_TEXT, DiagramUIResources.AbstractDiagram_FreeText_tooltip, AuthoringUIPlugin.getDefault().getImageDescriptor("freetext_pal16.gif"));
        this.getActionRegistry().registerAction(object);
        object = new Action(DiagramUIResources.moveAction_label){

            public void setImageDescriptor(ImageDescriptor imageDescriptor) {
                super.setImageDescriptor(imageDescriptor);
            }

            public void runWithEvent(Event event) {
                super.runWithEvent(event);
            }

            public void run() {
                super.run();
            }

            public boolean isEnabled() {
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                return list.size() > 0;
            }

            public String getId() {
                return AbstractDiagramEditor.MOVE;
            }
        };
        this.getActionRegistry().registerAction(object);
        Action action2 = new Action(DiagramUIResources.AbstractDiagram_Link_text){

            public void run() {
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (list.size() == 2) {
                    Object object2;
                    EditPart editPart = (EditPart)list.get(0);
                    EditPart editPart2 = (EditPart)list.get(1);
                    List list2 = new ArrayList();
                    if (editPart instanceof FreeTextNodeEditPart || editPart2 instanceof FreeTextNodeEditPart) {
                        return;
                    }
                    if (editPart instanceof NodeEditPart) {
                        list2 = ((NodeEditPart)editPart).getSourceConnections();
                        if (!list2.isEmpty()) {
                            for (Object object2 : list2) {
                                if (editPart2.equals(object2.getSource())) {
                                    return;
                                }
                                if (!editPart2.equals(object2.getTarget())) continue;
                                return;
                            }
                        }
                        if (!(list2 = ((NodeEditPart)editPart).getTargetConnections()).isEmpty()) {
                            for (Object object2 : list2) {
                                if (editPart2.equals(object2.getSource())) {
                                    return;
                                }
                                if (!editPart2.equals(object2.getTarget())) continue;
                                return;
                            }
                        }
                    }
                    Link link = ModelFactory.eINSTANCE.createLink();
                    if (editPart.getModel() instanceof Node) {
                        link.setSource((Node)editPart.getModel());
                    }
                    if (editPart2.getModel() instanceof Node) {
                        link.setTarget((Node)editPart2.getModel());
                    }
                    object2 = new CreateLinkCommand(link, (Node)editPart.getModel());
                    AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)object2);
                }
            }

            public boolean isEnabled() {
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                for (Object e : list) {
                    if (!(e instanceof FreeTextNodeEditPart)) continue;
                    return false;
                }
                return list.size() == 2;
            }

            public String getId() {
                return AbstractDiagramEditor.CREATE_LINK;
            }
        };
        this.getActionRegistry().registerAction((IAction)action2);
        Action action3 = new Action(DiagramUIResources.AbstractDiagram_Link_select){

            public void run() {
                List list;
                EditPart editPart;
                List list2 = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (list2.size() == 1 && (editPart = (EditPart)list2.get(0)) instanceof NodeEditPart && (list = ((NodeEditPart)editPart).getSourceConnections()) != null && !list.isEmpty()) {
                    LinkEditPart linkEditPart = (LinkEditPart)((Object)list.get(0));
                    linkEditPart.setSelected(1);
                    AbstractDiagramEditor.this.getGraphicalViewer().select((EditPart)linkEditPart);
                }
            }

            public boolean isEnabled() {
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                return list.size() == 1;
            }

            public String getId() {
                return AbstractDiagramEditor.SELECT_LINK;
            }
        };
        this.getActionRegistry().registerAction((IAction)action3);
        Action action4 = new Action(DiagramUIResources.AbstractDiagram_BendPoint_create){

            public void run() {
                Link link;
                EList eList;
                EditPart editPart;
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (list.size() == 1 && (editPart = (EditPart)list.get(0)) instanceof LinkEditPart && ((eList = (link = (Link)((LinkEditPart)editPart).getModel()).getBendpoints()) == null || eList.size() < 1)) {
                    Point point = link.getSourceEndPoint();
                    Point point2 = link.getTargetEndPoint();
                    if (point == null) {
                        point = link.getSource() == null ? ((Node)link.eContainer()).getLocation() : link.getSource().getLocation();
                    }
                    if (point2 == null) {
                        point2 = link.getTarget().getLocation();
                    }
                    Point point3 = new Point();
                    point3.x = (point.x + point2.x) / 2;
                    point3.y = (point.y + point2.y) / 2;
                    CreateBendpointCommand createBendpointCommand = new CreateBendpointCommand(link, point3, 0);
                    AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)createBendpointCommand);
                }
            }

            public boolean isEnabled() {
                EditPart editPart;
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                return list.size() == 1 && (editPart = (EditPart)list.get(0)) instanceof LinkEditPart;
            }

            public String getId() {
                return AbstractDiagramEditor.CREATE_BEND_POINT;
            }
        };
        this.getActionRegistry().registerAction((IAction)action4);
        Action action5 = new Action(DiagramUIResources.refreshAction_label){

            public void run() {
                org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.editPart.getModel();
                if (AbstractDiagramEditor.this.editPart.isActive()) {
                    AbstractDiagramEditor.this.editPart.deactivate();
                }
                diagram.removeConsumer((Object)AbstractDiagramEditor.this);
                AbstractDiagramEditor.this.createEditPart();
                AbstractDiagramEditor.this.getGraphicalViewer().setContents(AbstractDiagramEditor.this.editPart);
            }

            public String getId() {
                return AbstractDiagramEditor.REFRESH;
            }
        };
        this.getActionRegistry().registerAction((IAction)action5);
        Action action6 = new Action(DiagramUIResources.DeleteDiagram_text){

            public void run() {
                if (AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(DiagramUIResources.DeleteDiagram_text, DiagramUIResources.DeleteDiagram_prompt)) {
                    org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.getGraphicalViewer().getContents().getModel();
                    EcoreUtil.remove((EObject)diagram.getUMADiagram());
                    AbstractDiagramEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                    AbstractDiagramEditor.this.getSite().getPage().closeEditor(AbstractDiagramEditor.this.getSite().getPage().getActiveEditor(), false);
                }
            }

            public boolean isEnabled() {
                return AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().size() == 0;
            }

            public String getId() {
                return AbstractDiagramEditor.DELETE_DIAGRAM;
            }
        };
        this.getActionRegistry().registerAction((IAction)action6);
        Action action7 = new Action(DiagramUIResources.align_bend_point_text){

            public void run() {
                LinkEditPart linkEditPart;
                Link link;
                EditPart editPart = (EditPart)AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().get(0);
                if (editPart instanceof LinkEditPart && (link = (Link)(linkEditPart = (LinkEditPart)editPart).getModel()).getBendpoints().size() > 0) {
                    Point point;
                    List list;
                    GraphicalEditPart graphicalEditPart = (GraphicalEditPart)linkEditPart.getSource();
                    GraphicalEditPart graphicalEditPart2 = (GraphicalEditPart)linkEditPart.getTarget();
                    Point point2 = graphicalEditPart.getFigure().getBounds().getCenter();
                    Point point3 = graphicalEditPart2.getFigure().getBounds().getCenter();
                    if (graphicalEditPart instanceof DecisionNodeEditPart || graphicalEditPart instanceof SynchBarNodeEditPart) {
                        point2 = ((TypedNode)graphicalEditPart.getModel()).getLocation();
                        list = ((NodeEditPart)graphicalEditPart).getSourceConnections();
                        for (LinkEditPart linkEditPart2 : list) {
                            if (!linkEditPart2.getTarget().equals(graphicalEditPart2)) continue;
                            point = ((Link)linkEditPart2.getModel()).getSourceEndPoint();
                            point2 = point2.getTranslated(point);
                        }
                    }
                    if (graphicalEditPart2 instanceof DecisionNodeEditPart || graphicalEditPart2 instanceof SynchBarNodeEditPart) {
                        point3 = ((TypedNode)graphicalEditPart2.getModel()).getLocation();
                        list = ((NodeEditPart)graphicalEditPart2).getTargetConnections();
                        for (LinkEditPart linkEditPart2 : list) {
                            if (!linkEditPart2.getSource().equals(graphicalEditPart)) continue;
                            point = ((Link)linkEditPart2.getModel()).getTargetEndPoint();
                            point3 = point3.getTranslated(point);
                        }
                    }
                    int n = 0;
                    while (n < link.getBendpoints().size()) {
                        MoveBendpointCommand moveBendpointCommand;
                        LinkEditPart linkEditPart2;
                        AbsoluteBendpoint absoluteBendpoint = (AbsoluteBendpoint)link.getBendpoints().get(n);
                        linkEditPart2 = new AbsoluteBendpoint(new Point(-1, -1));
                        point = null;
                        int n2 = 40;
                        int n3 = 0;
                        if (n == 0) {
                            n3 = point2.getPosition((Point)absoluteBendpoint);
                        } else {
                            point = (AbsoluteBendpoint)link.getBendpoints().get(n - 1);
                            n3 = point.getPosition((Point)absoluteBendpoint);
                        }
                        if (n3 == 4 || n3 == 1) {
                            if (n == 0) {
                                if (point2.x - n2 < absoluteBendpoint.x && point2.x + n2 > absoluteBendpoint.x && point2.x != absoluteBendpoint.x) {
                                    ((AbsoluteBendpoint)linkEditPart2).x = point2.x;
                                }
                            } else if (point.x - n2 < absoluteBendpoint.x && point.x + n2 > absoluteBendpoint.x && point.x != absoluteBendpoint.x) {
                                ((AbsoluteBendpoint)linkEditPart2).x = point.x;
                            }
                            if (link.getBendpoints().size() - 1 == n) {
                                if (point3.y - n2 < absoluteBendpoint.y && point3.y + n2 > absoluteBendpoint.y && point3.y != absoluteBendpoint.y) {
                                    ((AbsoluteBendpoint)linkEditPart2).y = point3.y;
                                }
                            } else {
                                ((AbsoluteBendpoint)linkEditPart2).y = absoluteBendpoint.y;
                            }
                        }
                        if (n3 == 16 || n3 == 8) {
                            if (n == 0) {
                                if (point2.y - n2 < absoluteBendpoint.y && point2.y + n2 > absoluteBendpoint.y && point2.y != absoluteBendpoint.y) {
                                    ((AbsoluteBendpoint)linkEditPart2).y = point2.y;
                                }
                            } else if (point.y - n2 < absoluteBendpoint.y && point.y + n2 > absoluteBendpoint.y && point.y != absoluteBendpoint.y) {
                                ((AbsoluteBendpoint)linkEditPart2).y = point.y;
                            }
                            if (link.getBendpoints().size() - 1 == n) {
                                if (point3.x - n2 < absoluteBendpoint.x && point3.x + n2 > absoluteBendpoint.x && point3.x != absoluteBendpoint.x) {
                                    ((AbsoluteBendpoint)linkEditPart2).x = point3.x;
                                }
                            } else {
                                ((AbsoluteBendpoint)linkEditPart2).x = absoluteBendpoint.x;
                            }
                        }
                        if (((AbsoluteBendpoint)linkEditPart2).x == -1 && ((AbsoluteBendpoint)linkEditPart2).y != -1) {
                            moveBendpointCommand = new MoveBendpointCommand(link, new Point(absoluteBendpoint.x, ((AbsoluteBendpoint)linkEditPart2).y), n);
                            AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)moveBendpointCommand);
                        }
                        if (((AbsoluteBendpoint)linkEditPart2).x != -1 && ((AbsoluteBendpoint)linkEditPart2).y == -1) {
                            moveBendpointCommand = new MoveBendpointCommand(link, new Point(((AbsoluteBendpoint)linkEditPart2).x, absoluteBendpoint.y), n);
                            AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)moveBendpointCommand);
                        }
                        if (((AbsoluteBendpoint)linkEditPart2).x != -1 && ((AbsoluteBendpoint)linkEditPart2).y != -1) {
                            moveBendpointCommand = new MoveBendpointCommand(link, new Point(((AbsoluteBendpoint)linkEditPart2).x, ((AbsoluteBendpoint)linkEditPart2).y), n);
                            AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)moveBendpointCommand);
                        }
                        ++n;
                    }
                }
            }

            public boolean isEnabled() {
                LinkEditPart linkEditPart;
                Link link;
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                return list.size() == 1 && list.get(0) instanceof LinkEditPart && (link = (Link)(linkEditPart = (LinkEditPart)((Object)list.get(0))).getModel()).getBendpoints().size() > 0;
            }

            public String getId() {
                return AbstractDiagramEditor.ALIGN_BEND_POINT;
            }
        };
        object = new DiagramPrintAction((IWorkbenchPart)this, this.getGraphicalViewer());
        actionRegistry.registerAction(object);
        this.getActionRegistry().registerAction((IAction)action7);
    }

    protected IAction createAnAction(String string, CreationFactory creationFactory, String string2, String string3, ImageDescriptor imageDescriptor) {
        final CreationFactory creationFactory2 = creationFactory;
        final String string4 = string2;
        final String string5 = string3;
        final ImageDescriptor imageDescriptor2 = imageDescriptor;
        return new Action(string){

            public void run() {
                CreateRequest createRequest = new CreateRequest();
                if (creationFactory2 == null) {
                    return;
                }
                createRequest.setFactory(creationFactory2);
                createRequest.setLocation(new Point(10, 10));
                if (createRequest.getNewObject() instanceof Node) {
                    Point point = createRequest.getLocation();
                    org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.editPart.getModel();
                    CreateNodeCommand createNodeCommand = new CreateNodeCommand((Node)createRequest.getNewObject(), diagram, point);
                    AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)createNodeCommand);
                }
            }

            public String getId() {
                return string4;
            }

            public boolean isEnabled() {
                return !TngUtil.isLocked((EObject)AbstractDiagramEditor.this.getMethodElementFromInput());
            }

            public String getToolTipText() {
                return string5;
            }

            public void setImageDescriptor(ImageDescriptor imageDescriptor) {
                super.setImageDescriptor(imageDescriptor2);
            }

            public ImageDescriptor getImageDescriptor() {
                return imageDescriptor2;
            }
        };
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){
            private IMenuListener menuListener;

            protected void configurePaletteViewer(PaletteViewer paletteViewer) {
                super.configurePaletteViewer(paletteViewer);
                paletteViewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)paletteViewer));
            }

            protected void hookPaletteViewer(PaletteViewer paletteViewer) {
                super.hookPaletteViewer(paletteViewer);
                final CopyTemplateAction copyTemplateAction = (CopyTemplateAction)AbstractDiagramEditor.this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
                paletteViewer.addSelectionChangedListener((ISelectionChangedListener)copyTemplateAction);
                if (this.menuListener == null) {
                    this.menuListener = new IMenuListener(){

                        public void menuAboutToShow(IMenuManager iMenuManager) {
                            iMenuManager.appendToGroup("org.eclipse.gef.group.copy", (IAction)copyTemplateAction);
                        }
                    };
                }
                paletteViewer.getContextMenu().addMenuListener(this.menuListener);
            }
        };
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return AuthoringUIPlugin.getDefault().getPreferenceStore().getInt(AbstractDiagramEditor.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return AuthoringUIPlugin.getDefault().getPreferenceStore().getInt(AbstractDiagramEditor.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return AuthoringUIPlugin.getDefault().getPreferenceStore().getInt(AbstractDiagramEditor.PALETTE_SIZE);
            }

            public void setDockLocation(int n) {
                AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(AbstractDiagramEditor.PALETTE_DOCK_LOCATION, n);
            }

            public void setPaletteState(int n) {
                AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(AbstractDiagramEditor.PALETTE_STATE, n);
            }

            public void setPaletteWidth(int n) {
                AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(AbstractDiagramEditor.PALETTE_SIZE, n);
            }
        };
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler(){

                public boolean keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 0x1000004) {
                        this.move(1);
                    }
                    if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 0x1000002) {
                        this.move(2);
                    }
                    if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 0x1000001) {
                        this.move(3);
                    }
                    if (keyEvent.stateMask == 262144 && keyEvent.keyCode == 0x1000003) {
                        this.move(4);
                    }
                    return super.keyPressed(keyEvent);
                }

                public boolean move(int n) {
                    List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                    GraphicalEditPart graphicalEditPart = (GraphicalEditPart)list.get(0);
                    if (graphicalEditPart.getModel() instanceof Node) {
                        Node node = (Node)graphicalEditPart.getModel();
                        Point point = node.getLocation();
                        int n2 = point.x;
                        int n3 = point.y;
                        int n4 = 1;
                        switch (n) {
                            case 1: {
                                n2 = point.x + n4;
                                break;
                            }
                            case 2: {
                                n3 += n4;
                                break;
                            }
                            case 3: {
                                n3 -= n4;
                                break;
                            }
                            case 4: {
                                n2 -= n4;
                                break;
                            }
                        }
                        ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand(node, new Point(n2, n3), node.getWidth());
                        AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)changeBoundsCommand);
                        return true;
                    }
                    if (graphicalEditPart.getModel() instanceof Link) {
                        Link link = (Link)graphicalEditPart.getModel();
                        EList eList = link.getBendpoints();
                        int n5 = 0;
                        if (eList != null && eList.size() > 0) {
                            AbsoluteBendpoint absoluteBendpoint = (AbsoluteBendpoint)eList.get(n5);
                            int n6 = absoluteBendpoint.x;
                            int n7 = absoluteBendpoint.y;
                            int n8 = 5;
                            switch (n) {
                                case 1: {
                                    n6 = absoluteBendpoint.x + n8;
                                    break;
                                }
                                case 2: {
                                    n7 += n8;
                                    break;
                                }
                                case 3: {
                                    n7 -= n8;
                                    break;
                                }
                                case 4: {
                                    n6 -= n8;
                                    break;
                                }
                            }
                            MoveBendpointCommand moveBendpointCommand = new MoveBendpointCommand(link, new Point(n6, n7), n5);
                            AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)moveBendpointCommand);
                        }
                    }
                    return true;
                }
            };
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        super.setGraphicalViewer(graphicalViewer);
        if (this.actionService != null) {
            this.actionService.setGraphicalViewer(graphicalViewer);
        }
    }

    protected void configureGraphicalViewer() {
        IAction iAction;
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer scrollingGraphicalViewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart scalableFreeformRootEditPart = new ScalableFreeformRootEditPart();
        scrollingGraphicalViewer.setRootEditPart((RootEditPart)scalableFreeformRootEditPart);
        scrollingGraphicalViewer.setEditPartFactory(this.createEditPartFactory());
        DiagramContextMenuProvider diagramContextMenuProvider = new DiagramContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)diagramContextMenuProvider);
        this.getSite().registerContextMenu("org.eclipse.epf.authoring.ui.editors.workflow.contextmenu", (MenuManager)diagramContextMenuProvider, (ISelectionProvider)this.getGraphicalViewer());
        scrollingGraphicalViewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)scrollingGraphicalViewer).setParent(this.getCommonKeyHandler()));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                AbstractDiagramEditor.this.handleActivationChanged(event);
            }
        };
        this.getGraphicalControl().addListener(26, listener);
        this.getGraphicalControl().addListener(27, listener);
        this.getGraphicalControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                AbstractDiagramEditor.this.handleDoubleClick(event);
            }
        });
        if (this.getDiagramType().equalsIgnoreCase("ActivityDetail")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getGraphicalControl(), AuthoringUIHelpContexts.FORM_EDITOR_ACTIVITY_DETAIL_DIAGRAM_CONTEXT);
        } else if (this.getDiagramType().equalsIgnoreCase("Activity")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getGraphicalControl(), AuthoringUIHelpContexts.FORM_EDITOR_ACTIVITY_DIAGRAM_CONTEXT);
        } else if (this.getDiagramType().equalsIgnoreCase("WPDependency")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getGraphicalControl(), AuthoringUIHelpContexts.FORM_EDITOR_WP_DEPENDENCY_DIAGRAM_CONTEXT);
        }
        Display display = this.getGraphicalControl().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    block4: {
                        if (AbstractDiagramEditor.this.getPaletteRoot() == null) break block4;
                        MethodElement methodElement = AbstractDiagramEditor.this.getMethodElementFromInput();
                        if (TngUtil.isLocked((EObject)((EObject)methodElement))) {
                            List list = AbstractDiagramEditor.this.getPaletteRoot().getChildren();
                            for (PaletteEntry paletteEntry : list) {
                                paletteEntry.setVisible(false);
                            }
                        } else {
                            List list = AbstractDiagramEditor.this.getPaletteRoot().getChildren();
                            for (PaletteEntry paletteEntry : list) {
                                paletteEntry.setVisible(true);
                            }
                        }
                    }
                }
            });
        }
        this.currentConfig = LibraryService.getInstance().getCurrentMethodConfiguration();
        LibraryService.getInstance().addListener(this.libSvcListener);
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.addListener(this.libraryListener);
        }
        if ((iAction = this.getActionRegistry().getAction((Object)ActionFactory.PRINT.getId())) instanceof DiagramPrintAction) {
            ((DiagramPrintAction)iAction).setViewer((GraphicalViewer)scrollingGraphicalViewer);
        }
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected void handleDoubleClick(Event event) {
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getGraphicalViewer().setContents(this.editPart);
        TransferDropTargetListener transferDropTargetListener = this.createDropTargetListener();
        if (transferDropTargetListener != null) {
            this.getGraphicalViewer().addDropTargetListener(transferDropTargetListener);
        }
    }

    protected void initializeCreationFactories() {
        this.templateNameToCreationFactoryMap = new HashMap();
        if (this.freeTxtNodeCreationFactory == null) {
            this.freeTxtNodeCreationFactory = new CreationFactory(){

                public Object getNewObject() {
                    TypedNode typedNode = ModelFactory.eINSTANCE.createTypedNode();
                    typedNode.setType(6);
                    typedNode.setObject((Object)GraphicalDataHelper.newTypedGraphNode((int)6));
                    return typedNode;
                }

                public Object getObjectType() {
                    return "free text";
                }
            };
        }
        CreationFactory creationFactory = this.freeTxtNodeCreationFactory;
        this.templateNameToCreationFactoryMap.put(creationFactory.getObjectType(), creationFactory);
    }

    protected TransferDropTargetListener createDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object object) {
                return (CreationFactory)AbstractDiagramEditor.this.templateNameToCreationFactoryMap.get(object);
            }
        };
    }

    protected void handleActivationChanged(Event event) {
        IAction iAction = null;
        if (event.type == 27) {
            iAction = this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
        }
        if (this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()) != iAction) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), iAction);
            this.getEditorSite().getActionBars().updateActionBars();
        }
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.createPaletteRoot();
        }
        return this.paletteRoot;
    }

    private void createPaletteRoot() {
        this.paletteRoot = new PaletteRoot();
        this.paletteRoot.addAll(this.createCategories(this.paletteRoot));
    }

    private List createCategories(PaletteRoot paletteRoot) {
        ArrayList<PaletteContainer> arrayList = new ArrayList<PaletteContainer>();
        PaletteContainer paletteContainer = this.createControlGroup(paletteRoot);
        if (paletteContainer != null) {
            arrayList.add(paletteContainer);
        }
        return arrayList;
    }

    protected PaletteContainer createControlGroup(PaletteRoot paletteRoot) {
        return null;
    }

    protected MethodElement getMethodElementFromInput() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof MethodElementEditorInput) {
            return ((MethodElementEditorInput)iEditorInput).getMethodElement();
        }
        return null;
    }

    public void doSave(final IProgressMonitor iProgressMonitor) {
        final MethodElement methodElement = this.getMethodElementFromInput();
        if (methodElement == null) {
            return;
        }
        SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() throws Exception {
                iProgressMonitor.beginTask(DiagramUIResources.AbstractDiagramEditor_Save_text, -1);
                iProgressMonitor.setTaskName(DiagramUIResources.bind(DiagramUIResources.AbstractDiagramEditor_Save_message, methodElement.eResource().getURI().isFile() ? methodElement.eResource().getURI().toFileString() : methodElement.getName()));
                ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
                try {
                    failSafeMethodLibraryPersister.save(methodElement.eResource());
                    failSafeMethodLibraryPersister.commit();
                    org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.getGraphicalViewer().getContents().getModel();
                    diagram.setNew(false);
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                    try {
                        failSafeMethodLibraryPersister.rollback();
                    }
                    catch (Exception exception2) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception2);
                        ViewHelper.reloadCurrentLibaryOnRollbackError(AbstractDiagramEditor.this.getSite().getShell());
                        return;
                    }
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AbstractDiagramEditor.this.getSite().getShell().getText(), DiagramUIResources.diagram_saveError, exception.getMessage(), (Throwable)exception);
                    return;
                }
                AbstractDiagramEditor.this.getEditDomain().getCommandStack().flush();
                AbstractDiagramEditor.this.changeTime = -1L;
                AbstractDiagramEditor.this.firePropertyChange(257);
                return;
                finally {
                    iProgressMonitor.done();
                }
            }
        });
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.getEditDomain().getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected boolean isReadOnly() {
        if (this.editPart != null) {
            org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel();
            return diagram != null && diagram.isReadOnly();
        }
        return false;
    }

    private void createEditPart() {
        BreakdownElementEditorInput breakdownElementEditorInput = (BreakdownElementEditorInput)this.getEditorInput();
        Object object = breakdownElementEditorInput.getWrapper() != null ? breakdownElementEditorInput.getWrapper() : breakdownElementEditorInput.getMethodElement();
        this.changeTime = System.currentTimeMillis();
        this.editPart = this.createDiagramEditPart();
        org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel();
        diagram.setSuppression(breakdownElementEditorInput.getSuppression());
        diagram.setObject(object);
        diagram.addConsumer((Object)this);
        if (!diagram.isNew()) {
            this.changeTime = -1L;
        }
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        MethodElement methodElement = this.getMethodElementFromInput();
        if (methodElement != null) {
            this.createEditPart();
            BreakdownElementEditorInput breakdownElementEditorInput = (BreakdownElementEditorInput)this.getEditorInput();
            this.setPartName(String.valueOf(this.getPartNamePrefix()) + methodElement.getName() + ", " + breakdownElementEditorInput.getSuppression().getProcess().getName());
        }
    }

    protected abstract EditPart createDiagramEditPart();

    protected abstract String getPartNamePrefix();

    protected abstract String getDiagramType();

    public IEditorPart getParentEditor() {
        return this.parentEditor;
    }

    public void setParentEditor(IEditorPart iEditorPart) {
        this.parentEditor = iEditorPart;
    }

    private void configChanged() {
        MethodConfiguration methodConfiguration = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (this.currentConfig != methodConfiguration) {
            MethodElementEditorInput methodElementEditorInput;
            boolean bl;
            IWorkbenchPart iWorkbenchPart = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
            boolean bl2 = bl = iWorkbenchPart == this;
            if (!bl && iWorkbenchPart instanceof ProcessEditor) {
                methodElementEditorInput = (MethodElementEditorInput)((ProcessEditor)iWorkbenchPart).getEditorInput();
                MethodElement methodElement = methodElementEditorInput.getMethodElement();
                Diagram diagram = ((org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel()).getUMADiagram();
                bl = UmaUtil.isContainedBy((EObject)diagram, (Object)methodElement);
            }
            if (bl) {
                this.currentConfig = methodConfiguration;
                methodElementEditorInput = this.getActionRegistry().getAction((Object)REFRESH);
                methodElementEditorInput.run();
            }
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        org.eclipse.epf.diagram.model.Diagram diagram;
        super.selectionChanged(iWorkbenchPart, iSelection);
        if (this.editPart != null && ((diagram = (org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel()).isReadOnly() || TngUtil.isLocked((EObject)this.getMethodElementFromInput()))) {
            this.getGraphicalViewer().select(this.editPart);
        }
    }

    public void refreshDiagram() {
        this.getActionRegistry().getAction((Object)REFRESH).run();
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    class DiagramContextMenuProvider
    extends ContextMenuProvider {
        private ActionRegistry actionRegistry;

        public DiagramContextMenuProvider(EditPartViewer editPartViewer, ActionRegistry actionRegistry) {
            super(editPartViewer);
            this.setActionRegistry(actionRegistry);
        }

        public void buildContextMenu(IMenuManager iMenuManager) {
            IAction iAction;
            IAction iAction2;
            IAction iAction3;
            IAction iAction4;
            IAction iAction5;
            GEFActionConstants.addStandardActionGroups((IMenuManager)iMenuManager);
            IAction iAction6 = this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId());
            iMenuManager.appendToGroup("org.eclipse.gef.group.undo", iAction6);
            iAction6 = this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId());
            iMenuManager.appendToGroup("org.eclipse.gef.group.undo", iAction6);
            boolean bl = !AbstractDiagramEditor.this.isReadOnly();
            iAction6 = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId());
            if (iAction6.isEnabled() && bl && !TngUtil.isLocked((EObject)AbstractDiagramEditor.this.getMethodElementFromInput())) {
                iMenuManager.appendToGroup("org.eclipse.gef.group.edit", iAction6);
            }
            iAction6 = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.REFRESH);
            iMenuManager.appendToGroup("org.eclipse.gef.group.view", iAction6);
            iAction6 = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.FONT_DIALOG);
            if (iAction6.isEnabled() && bl) {
                iMenuManager.appendToGroup("additions", iAction6);
            }
            if ((iAction5 = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.CREATE_FREE_TEXT)).isEnabled() && bl) {
                iMenuManager.appendToGroup("additions", iAction5);
            }
            if ((iAction4 = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.CREATE_LINK)).isEnabled() && bl) {
                iMenuManager.appendToGroup("additions", iAction4);
            }
            if ((iAction3 = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.SELECT_LINK)).isEnabled()) {
                iMenuManager.appendToGroup("additions", iAction3);
            }
            if ((iAction2 = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.CREATE_BEND_POINT)).isEnabled() && bl) {
                iMenuManager.appendToGroup("additions", iAction2);
            }
            if ((iAction = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.ALIGN_BEND_POINT)).isEnabled() && bl) {
                iMenuManager.appendToGroup("additions", iAction);
            }
            AbstractDiagramEditor.this.contributeToContextMenu(iMenuManager);
        }

        private ActionRegistry getActionRegistry() {
            return this.actionRegistry;
        }

        public void setActionRegistry(ActionRegistry actionRegistry) {
            this.actionRegistry = actionRegistry;
        }
    }
}

