/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPartFactory;
import org.eclipse.epf.authoring.gef.edit.DiagramUpdateService;
import org.eclipse.epf.authoring.gef.edit.FreeTextNodeEditPart;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.AbstractDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.WorkProductDescriptorNode;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class ActivityDetailDiagramEditor
extends AbstractDiagramEditor {
    private static final String RESET_DIAGRAM_LAYOUT = "reset_diagram_layout";
    private CreationFactory roleNodeCreationFactory;
    private CreationFactory taskNodeCreationFactory;
    private CreationFactory wpdNodeCreationFactory;
    private boolean initialCleanUp = false;
    private BreakdownAdapterFactory factory = null;

    protected EditPartFactory createEditPartFactory() {
        return new ActivityDetailDiagramEditPartFactory();
    }

    protected EditPart createDiagramEditPart() {
        return new ActivityDetailDiagramEditPart(ModelFactory.eINSTANCE.createActivityDetailDiagram());
    }

    protected String getPartNamePrefix() {
        return DiagramUIResources.ActivityDetailDiagram_prefix;
    }

    protected PaletteContainer createControlGroup(PaletteRoot paletteRoot) {
        this.initializeCreationFactories();
        PaletteGroup paletteGroup = new PaletteGroup("Control Group");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PanningSelectionToolEntry panningSelectionToolEntry = new PanningSelectionToolEntry(DiagramUIResources.AbstractDiagram_Select_text, DiagramUIResources.AbstractDiagram_Select_tooltip);
        panningSelectionToolEntry.setSmallIcon(AuthoringUIPlugin.getDefault().getImageDescriptor("select_pal16.gif"));
        panningSelectionToolEntry.setLargeIcon(AuthoringUIPlugin.getDefault().getImageDescriptor("select_pal24.gif"));
        arrayList.add(panningSelectionToolEntry);
        paletteRoot.setDefaultEntry((ToolEntry)panningSelectionToolEntry);
        panningSelectionToolEntry = new MarqueeToolEntry();
        panningSelectionToolEntry.setSmallIcon(AuthoringUIPlugin.getDefault().getImageDescriptor("marq_pal16.gif"));
        panningSelectionToolEntry.setLargeIcon(AuthoringUIPlugin.getDefault().getImageDescriptor("marq_pal24.gif"));
        arrayList.add(panningSelectionToolEntry);
        CombinedTemplateCreationEntry combinedTemplateCreationEntry = new CombinedTemplateCreationEntry(DiagramUIResources.AbstractDiagram_FreeText_text, DiagramUIResources.AbstractDiagram_FreeText_tooltip, (Object)"free text", this.freeTxtNodeCreationFactory, AuthoringUIPlugin.getDefault().getImageDescriptor("freetext_pal16.gif"), AuthoringUIPlugin.getDefault().getImageDescriptor("freetext_pal24.gif"));
        arrayList.add(combinedTemplateCreationEntry);
        paletteGroup.addAll(arrayList);
        return paletteGroup;
    }

    protected void initializeCreationFactories() {
        super.initializeCreationFactories();
        if (this.roleNodeCreationFactory == null) {
            this.roleNodeCreationFactory = new CreationFactory(){

                public Object getNewObject() {
                    RoleTaskComposite roleTaskComposite = ModelFactory.eINSTANCE.createRoleTaskComposite();
                    Diagram diagram = (Diagram)ActivityDetailDiagramEditor.this.editPart.getModel();
                    roleTaskComposite.setUMADiagram(diagram.getUMADiagram());
                    roleTaskComposite.setObject((Object)UmaFactory.eINSTANCE.createRoleDescriptor());
                    return roleTaskComposite;
                }

                public Object getObjectType() {
                    return "role descriptor template";
                }
            };
        }
        CreationFactory creationFactory = this.roleNodeCreationFactory;
        this.templateNameToCreationFactoryMap.put(creationFactory.getObjectType(), creationFactory);
        if (this.taskNodeCreationFactory == null) {
            this.taskNodeCreationFactory = new CreationFactory(){

                public Object getNewObject() {
                    TaskNode taskNode = ModelFactory.eINSTANCE.createTaskNode();
                    Diagram diagram = (Diagram)ActivityDetailDiagramEditor.this.editPart.getModel();
                    taskNode.setUMADiagram(diagram.getUMADiagram());
                    taskNode.setObject((Object)UmaFactory.eINSTANCE.createTaskDescriptor());
                    return taskNode;
                }

                public Object getObjectType() {
                    return "task descriptor template";
                }
            };
        }
        creationFactory = this.taskNodeCreationFactory;
        this.templateNameToCreationFactoryMap.put(creationFactory.getObjectType(), creationFactory);
        if (this.wpdNodeCreationFactory == null) {
            this.wpdNodeCreationFactory = new CreationFactory(){

                public Object getNewObject() {
                    WorkProductDescriptorNode workProductDescriptorNode = ModelFactory.eINSTANCE.createWorkProductDescriptorNode();
                    Diagram diagram = (Diagram)ActivityDetailDiagramEditor.this.editPart.getModel();
                    workProductDescriptorNode.setUMADiagram(diagram.getUMADiagram());
                    workProductDescriptorNode.setObject((Object)UmaFactory.eINSTANCE.createWorkProductDescriptor());
                    return workProductDescriptorNode;
                }

                public Object getObjectType() {
                    return "task descriptor template";
                }
            };
        }
        creationFactory = this.wpdNodeCreationFactory;
        this.templateNameToCreationFactoryMap.put(creationFactory.getObjectType(), creationFactory);
    }

    public void setFocus() {
        super.setFocus();
        this.getGraphicalViewer().getContents().refresh();
        if (!this.initialCleanUp) {
            this.cleanUpDiagram();
            this.initialCleanUp = true;
            if (TngUtil.isLocked((EObject)this.getMethodElementFromInput())) {
                this.getCommandStack().flush();
                this.firePropertyChange(257);
            }
        }
    }

    protected String getDiagramType() {
        return "ActivityDetail";
    }

    public void cleanUpDiagram() {
        DiagramUpdateService diagramUpdateService = new DiagramUpdateService(this.getGraphicalViewer(), this.getEditDomain(), this.getActionRegistry());
        diagramUpdateService.cleanUpDiagram();
    }

    protected void contributeToContextMenu(IMenuManager iMenuManager) {
        super.contributeToContextMenu(iMenuManager);
        boolean bl = !this.isReadOnly();
        IAction iAction = this.getActionRegistry().getAction((Object)RESET_DIAGRAM_LAYOUT);
        if (iAction.isEnabled() && bl) {
            iMenuManager.insertBefore("delete_actvity_detail_diagram", iAction);
        }
    }

    protected void createActions() {
        super.createActions();
        Action action = new Action(DiagramUIResources.ActivityDetailDiagramEditor_ResetDiagramLayout_text){

            public void run() {
                ActivityDetailDiagramEditor.this.getActionRegistry().getAction((Object)"refresh").run();
                if (ActivityDetailDiagramEditor.this.getGraphicalViewer().getContents() instanceof ActivityDetailDiagramEditPart) {
                    ActivityDetailDiagramEditPart activityDetailDiagramEditPart = (ActivityDetailDiagramEditPart)ActivityDetailDiagramEditor.this.getGraphicalViewer().getContents();
                    ArrayList arrayList = new ArrayList();
                    if (activityDetailDiagramEditPart.getChildren() != null && !activityDetailDiagramEditPart.getChildren().isEmpty()) {
                        for (Object e : activityDetailDiagramEditPart.getChildren()) {
                            if (e instanceof FreeTextNodeEditPart) continue;
                            arrayList.add(e);
                        }
                    }
                    activityDetailDiagramEditPart.getRecentlyAddedParts().addAll(arrayList);
                    ActivityDetailDiagramEditor.this.cleanUpDiagram();
                }
            }

            public boolean isEnabled() {
                return ActivityDetailDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().size() == 0;
            }

            public String getId() {
                return ActivityDetailDiagramEditor.RESET_DIAGRAM_LAYOUT;
            }
        };
        this.getActionRegistry().registerAction((IAction)action);
    }

    public void dispose() {
        if (this.factory != null) {
            this.factory.clear();
        }
        super.dispose();
    }

    public class BreakdownAdapterFactory {
        public ConfigurableComposedAdapterFactory wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWBSComposedAdapterFactory();
        public ConfigurableComposedAdapterFactory tbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createTBSComposedAdapterFactory();
        public ConfigurableComposedAdapterFactory wpbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWPBSComposedAdapterFactory();
        public ConfigurableComposedAdapterFactory cbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createProcessComposedAdapterFactory();

        public BreakdownAdapterFactory(MethodConfiguration methodConfiguration) {
            DiagramAdapterFactoryFilter diagramAdapterFactoryFilter = new DiagramAdapterFactoryFilter(methodConfiguration, this);
            this.wbsAdapterFactory.setFilter((IFilter)diagramAdapterFactoryFilter);
            this.tbsAdapterFactory.setFilter((IFilter)diagramAdapterFactoryFilter);
            this.wpbsAdapterFactory.setFilter((IFilter)diagramAdapterFactoryFilter);
            this.cbsAdapterFactory.setFilter((IFilter)diagramAdapterFactoryFilter);
        }

        public void clear() {
            if (this.wbsAdapterFactory != null) {
                this.wbsAdapterFactory.dispose();
                this.wbsAdapterFactory = null;
            }
            if (this.tbsAdapterFactory != null) {
                this.tbsAdapterFactory.dispose();
                this.tbsAdapterFactory = null;
            }
            if (this.wpbsAdapterFactory != null) {
                this.wpbsAdapterFactory.dispose();
                this.wpbsAdapterFactory = null;
            }
            if (this.cbsAdapterFactory != null) {
                this.cbsAdapterFactory.dispose();
                this.cbsAdapterFactory = null;
            }
        }
    }

    public class DiagramAdapterFactoryFilter
    extends ProcessConfigurator
    implements IAdapterFactoryFilter {
        private BreakdownAdapterFactory factory;

        public DiagramAdapterFactoryFilter(MethodConfiguration methodConfiguration, BreakdownAdapterFactory breakdownAdapterFactory) {
            super(methodConfiguration, null);
            this.factory = breakdownAdapterFactory;
        }

        public AdapterFactory getWBSAdapterFactory() {
            return this.factory.wbsAdapterFactory;
        }

        public AdapterFactory getTBSAdapterFactory() {
            return this.factory.tbsAdapterFactory;
        }

        public AdapterFactory getWPBSAdapterFactory() {
            return this.factory.wpbsAdapterFactory;
        }

        public AdapterFactory getCBSAdapterFactory() {
            return this.factory.cbsAdapterFactory;
        }

        public boolean accept(Object object) {
            return super.accept(object);
        }
    }

    public static class EditorInput
    extends BreakdownElementEditorInput {
        public EditorInput(Object object, Suppression suppression) {
            super(object, suppression);
        }
    }
}

