/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.util.MethodRichTextMarkerHelper;
import org.eclipse.epf.common.html.HTMLFormatter;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.RichTextContentValidator;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.RichText;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class MethodRichText
extends RichText
implements IMethodRichText {
    private MethodElement methodElement;
    private ContentDescription contentDescription;
    private EObject modalObject;
    private EStructuralFeature modalObjectFeature;
    protected Resource resource;
    protected Label label;
    protected ControlDecoration controlDecoration;
    protected final Image errorFieldDecorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
    protected String fieldName = "";
    protected String fieldNameTrim;
    protected MethodRichTextMarkerHelper markerHelper;

    public MethodRichText(Composite composite, int n, String string) {
        super(composite, n, string);
    }

    protected String tidyText(String string) {
        return ResourceHelper.validateRichTextContent((MethodElement)this.methodElement, (String)string, (IContentValidator)new RichTextContentValidator());
    }

    public void setMethodElement(MethodElement methodElement) {
        this.methodElement = methodElement;
        if (this.methodElement instanceof ProcessComponent) {
            this.methodElement = ((ProcessComponent)this.methodElement).getProcess();
        }
        if (this.methodElement instanceof DescribableElement) {
            this.contentDescription = ((DescribableElement)this.methodElement).getPresentation();
        }
    }

    public MethodElement getMethodElement() {
        return this.methodElement;
    }

    public EObject getModalObject() {
        return this.modalObject;
    }

    public void setModalObject(EObject eObject) {
        this.modalObject = eObject;
    }

    public EStructuralFeature getModalObjectFeature() {
        return this.modalObjectFeature;
    }

    public void setModalObjectFeature(EStructuralFeature eStructuralFeature) {
        this.modalObjectFeature = eStructuralFeature;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setDecoratedFieldLabel(Label label) {
        this.label = label;
        if (label != null) {
            Object object = label.getData(BaseFormPage.LABEL_DECORATOR_KEY);
            if (object instanceof ControlDecoration) {
                this.controlDecoration = (ControlDecoration)object;
                this.controlDecoration.setImage(this.errorFieldDecorationImage);
                this.controlDecoration.hide();
            }
            this.updateFieldNameFromLabel(label);
        }
    }

    private boolean updateFieldNameFromLabel(Label label) {
        String string;
        if (label != null && !this.fieldName.equals(string = label.getText())) {
            this.fieldName = string;
            int n = string.indexOf(58);
            if (n == -1) {
                n = string.length();
            }
            this.fieldNameTrim = string.substring(0, n).trim();
            return true;
        }
        return false;
    }

    public void init(MethodElement methodElement, Label label) {
        this.setMethodElement(methodElement);
        this.setDecoratedFieldLabel(label);
        this.markerHelper = MethodRichTextMarkerHelper.INSTANCE;
    }

    protected String formatHTML(String string) {
        try {
            this.clearMarkers();
            String string2 = this.htmlFormatter.formatHTML(string);
            if (this.htmlFormatter.getLastErrorStr() != null) {
                String string3 = this.htmlFormatter.getLastErrorStr();
                try {
                    this.createMarker(string3);
                }
                catch (CoreException coreException) {
                    this.logger.logError((Throwable)coreException);
                }
            }
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.logError((Throwable)unsupportedEncodingException);
            return string;
        }
    }

    protected void clearMarkers() {
        this.markerHelper.deleteMarkers(this.contentDescription, this.fieldNameTrim);
        this.setErrorDescription("");
        this.hideErrorDecoration();
        this.refreshDecorators();
    }

    protected void setErrorDescription(String string) {
        if (this.controlDecoration != null) {
            this.controlDecoration.setDescriptionText(string);
        }
    }

    protected void refreshDecorators() {
    }

    protected void createMarker(String string) throws CoreException {
        Matcher matcher;
        if (this.contentDescription.eContainer() instanceof DescribableElement && (matcher = HTMLFormatter.jTidyErrorParser.matcher(string)).find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(4);
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic("org.eclipse.epf.common.HTMLFormatter", 0, "", new Object[]{this.contentDescription, this.fieldNameTrim});
            basicDiagnostic.add((Diagnostic)new BasicDiagnostic(4, string2, 0, string3, new Object[]{this.contentDescription, this.fieldNameTrim}));
            this.markerHelper.createMarkers((Diagnostic)basicDiagnostic);
            this.setErrorDescription(string3);
            this.showErrorDecoration();
            this.refreshDecorators();
        }
    }

    public void dispose() {
        super.dispose();
        this.clearMarkers();
        this.refreshDecorators();
    }

    public void showErrorDecoration() {
        if (this.controlDecoration != null) {
            this.controlDecoration.show();
        }
    }

    public void hideErrorDecoration() {
        if (this.controlDecoration != null) {
            this.controlDecoration.hide();
        }
    }

    public void setText(String string) {
        if (this.updateFieldNameFromLabel(this.label)) {
            this.hideErrorDecoration();
        }
        super.setText(string);
    }
}

