/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ConfigurationDescription
extends FormPage
implements IRefreshable {
    private static final String FORM_PREFIX = AuthoringUIResources.ConfigurationDescriptionFormPrefix;
    private MethodConfiguration config = null;
    private ScrolledForm form = null;
    private Text nameText;
    private Text despText;
    private ModifyListener modelModifyListener;
    private IActionManager actionMgr;

    public ConfigurationDescription(FormEditor formEditor) {
        super(formEditor, AuthoringUIResources.ConfigurationDescriptionDescription, AuthoringUIResources.ConfigurationDescriptionDescription);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        ConfigurationEditorInput configurationEditorInput = (ConfigurationEditorInput)iEditorInput;
        this.config = configurationEditorInput.getConfiguration();
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        this.form = iManagedForm.getForm();
        this.form.setText(String.valueOf(FORM_PREFIX) + this.config.getName());
        FormToolkit formToolkit = iManagedForm.getToolkit();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)tableWrapLayout);
        Section section = formToolkit.createSection(this.form.getBody(), 450);
        this.createGeneralContent(formToolkit, section);
        this.addListeners();
    }

    public void createGeneralContent(FormToolkit formToolkit, Section section) {
        section.setLayoutData((Object)new TableWrapData(256));
        section.setText(AuthoringUIResources.ConfigurationDescriptionGeneralInfo);
        section.setDescription(AuthoringUIResources.ConfigurationDescriptionDescription_text);
        Composite composite = formToolkit.createComposite((Composite)section);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 2;
        composite.setLayout((Layout)tableWrapLayout);
        formToolkit.createLabel(composite, AuthoringUIResources.ConfigurationDescriptionName, 0);
        this.nameText = formToolkit.createText(composite, "", 0);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.nameText.setLayoutData((Object)tableWrapData);
        this.nameText.setText(this.config.getName());
        Label label = formToolkit.createLabel(composite, AuthoringUIResources.ConfigurationDescriptionDescriptionLabel, 0);
        TableWrapData tableWrapData2 = new TableWrapData();
        label.setLayoutData((Object)tableWrapData2);
        this.despText = formToolkit.createText(composite, "", 578);
        TableWrapData tableWrapData3 = new TableWrapData(256);
        tableWrapData3.heightHint = 50;
        this.despText.setLayoutData((Object)tableWrapData3);
        this.despText.setText(this.config.getBriefDescription());
        section.setClient((Control)composite);
        formToolkit.paintBordersFor(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite.getParent(), AuthoringUIHelpContexts.CONFIGURATION_EDITOR_ALL_CONTEXT);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    ConfigurationDescription.this.nameText.setFocus();
                    ConfigurationDescription.this.nameText.setSelection(0, ConfigurationDescription.this.nameText.getText().length());
                }
            });
        }
    }

    private void addListeners() {
        final ConfigurationEditor configurationEditor = (ConfigurationEditor)this.getEditor();
        this.modelModifyListener = configurationEditor.createModifyListener((EObject)this.config);
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        this.nameText.addModifyListener(this.modelModifyListener);
        this.nameText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)ConfigurationDescription.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = ConfigurationDescription.this.config.getName();
                final MethodConfiguration methodConfiguration = ConfigurationDescription.this.config;
                if (((MethodElementEditor)ConfigurationDescription.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                if (ConfigurationDescription.isTextNonEmpty(ConfigurationDescription.this.nameText)) {
                    boolean bl;
                    String string2 = ConfigurationDescription.this.nameText.getText();
                    String string3 = null;
                    if (string.indexOf("&") < 0 && string2.indexOf("&") > -1) {
                        string3 = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)string2);
                    } else {
                        IValidator iValidator = IValidatorFactory.INSTANCE.createNameValidator((Object)ConfigurationDescription.this.config.eContainer(), (NamedElement)ConfigurationDescription.this.config);
                        string3 = iValidator.isValid(string2);
                    }
                    if (string3 != null) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, string3);
                        ConfigurationDescription.this.nameText.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ConfigurationDescription.this.nameText.setText(methodConfiguration.getName());
                                ConfigurationDescription.this.nameText.selectAll();
                                ConfigurationDescription.this.nameText.setFocus();
                            }
                        });
                        return;
                    }
                    if (!(string2 = string2.trim()).equals(ConfigurationDescription.this.config.getName()) && (bl = ConfigurationDescription.this.actionMgr.doAction(1, (EObject)ConfigurationDescription.this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)string2, -1))) {
                        Resource resource = ConfigurationDescription.this.config.eResource();
                        if (resource != null && resource != ConfigurationDescription.this.config.eContainer().eResource()) {
                            configurationEditor.addResourceToAdjustLocation(ConfigurationDescription.this.config.eResource());
                        }
                        ConfigurationDescription.this.form.setText(String.valueOf(FORM_PREFIX) + ConfigurationDescription.this.config.getName());
                        ConfigurationDescription.this.nameText.setText(string2);
                    }
                } else {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.emptyElementNameError_msg, (Object)StrUtil.toLower((String)LibraryUIText.TEXT_METHOD_CONFIGURATON)));
                    ConfigurationDescription.this.nameText.setText(ConfigurationDescription.this.config.getName());
                    ConfigurationDescription.this.nameText.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ConfigurationDescription.this.nameText.setFocus();
                            ConfigurationDescription.this.nameText.setSelection(0, ConfigurationDescription.this.nameText.getText().length());
                        }
                    });
                }
            }
        });
        this.despText.addModifyListener(this.modelModifyListener);
        this.despText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)ConfigurationDescription.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = ConfigurationDescription.this.config.getBriefDescription();
                if (((MethodElementEditor)ConfigurationDescription.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = ConfigurationDescription.this.despText.getText();
                if (!string2.equals(ConfigurationDescription.this.config.getBriefDescription())) {
                    ConfigurationDescription.this.actionMgr.doAction(1, (EObject)ConfigurationDescription.this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)string2, -1);
                }
            }
        });
    }

    private static boolean isTextNonEmpty(Text text) {
        String string = text.getText();
        return string != null && string.trim().length() > 0;
    }

    public void dispose() {
        super.dispose();
    }

    public void refreshName(String string) {
        if (string != null && this.nameText != null && !this.nameText.isDisposed()) {
            this.nameText.removeModifyListener(this.modelModifyListener);
            this.nameText.setText(string);
            this.nameText.addModifyListener(this.modelModifyListener);
            this.form.setText(String.valueOf(FORM_PREFIX) + this.config.getName());
        }
    }
}

