/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MethodLibraryDescriptionFormPage
extends FormPage {
    private static final int DEFAULT_VERTICAL_INDENT = 2;
    private Text ctrl_name;
    private Text ctrl_brief_desc;
    private Section generalSection;
    private Composite generalComposite;
    private MethodLibrary library;
    private Text textAuthors;
    private Text ctrl_change_date;
    private Text ctrl_change_desc;
    private Text ctrl_version;
    private Text ctrl_copyright;

    public MethodLibraryDescriptionFormPage(FormEditor formEditor) {
        super(formEditor, AuthoringUIResources.descriptionPage_title, AuthoringUIResources.descriptionPage_title);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)iEditorInput;
        MethodElement methodElement = methodElementEditorInput.getMethodElement();
        if (methodElement instanceof MethodLibrary) {
            this.library = (MethodLibrary)methodElement;
        }
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(this.getEditor().getPartName());
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
        this.createEditorContent(formToolkit, scrolledForm.getBody());
    }

    private void createEditorContent(FormToolkit formToolkit, Composite composite) {
        this.generalSection = formToolkit.createSection(composite, 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.generalSection.setLayoutData((Object)tableWrapData);
        this.generalSection.setText(AuthoringUIResources.MethodLibraryDescriptionFormPage_section_title);
        this.generalSection.setDescription(AuthoringUIResources.MethodLibraryDescriptionFormPage_section_description);
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = formToolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(1808));
        this.generalComposite.setLayout((Layout)new GridLayout(2, false));
        this.generalSection.setClient((Control)this.generalComposite);
        Label label = formToolkit.createLabel(this.generalComposite, AuthoringUIResources.name_text);
        GridData gridData = new GridData(1);
        gridData.verticalIndent = 2;
        label.setLayoutData((Object)gridData);
        this.ctrl_name = formToolkit.createText(this.generalComposite, "", 4);
        gridData = new GridData(768);
        gridData.widthHint = 400;
        gridData.verticalIndent = 2;
        this.ctrl_name.setLayoutData((Object)gridData);
        gridData = formToolkit.createLabel(this.generalComposite, AuthoringUIResources.description_text);
        GridData gridData2 = new GridData(1);
        gridData2.verticalIndent = 2;
        gridData.setLayoutData((Object)gridData2);
        this.ctrl_brief_desc = formToolkit.createText(this.generalComposite, "", 66);
        gridData2 = new GridData(768);
        gridData2.heightHint = 40;
        gridData2.widthHint = 400;
        gridData2.verticalIndent = 2;
        this.ctrl_brief_desc.setLayoutData((Object)gridData2);
        gridData2 = formToolkit.createLabel(this.generalComposite, AuthoringUIResources.authors_text);
        GridData gridData3 = new GridData(1);
        gridData3.verticalIndent = 2;
        gridData2.setLayoutData((Object)gridData3);
        this.textAuthors = formToolkit.createText(this.generalComposite, "", 66);
        gridData3 = new GridData(768);
        gridData3.heightHint = 40;
        gridData3.widthHint = 400;
        gridData3.verticalIndent = 2;
        this.textAuthors.setLayoutData((Object)gridData3);
        gridData3 = formToolkit.createLabel(this.generalComposite, "");
        GridData gridData4 = new GridData(1);
        gridData4.verticalIndent = 2;
        gridData3.setLayoutData((Object)gridData4);
        this.ctrl_change_date = formToolkit.createText(this.generalComposite, "", 8);
        gridData4 = new GridData(768);
        gridData4.verticalIndent = 2;
        this.ctrl_change_date.setLayoutData((Object)gridData4);
        gridData4 = formToolkit.createLabel(this.generalComposite, AuthoringUIText.CHANGE_DESCRIPTION_TEXT);
        GridData gridData5 = new GridData(1);
        gridData5.verticalIndent = 2;
        gridData4.setLayoutData((Object)gridData5);
        this.ctrl_change_desc = formToolkit.createText(this.generalComposite, "", 2);
        gridData5 = new GridData(768);
        gridData5.heightHint = 40;
        gridData5.verticalIndent = 2;
        this.ctrl_change_desc.setLayoutData((Object)gridData5);
        gridData5 = formToolkit.createLabel(this.generalComposite, AuthoringUIText.VERSION_TEXT);
        GridData gridData6 = new GridData(1);
        gridData6.verticalIndent = 2;
        gridData5.setLayoutData((Object)gridData6);
        this.ctrl_version = formToolkit.createText(this.generalComposite, "", 2);
        gridData6 = new GridData(768);
        gridData6.verticalIndent = 2;
        this.ctrl_version.setLayoutData((Object)gridData6);
        gridData6 = formToolkit.createLabel(this.generalComposite, AuthoringUIResources.copyright_text);
        GridData gridData7 = new GridData(1);
        gridData7.verticalIndent = 2;
        gridData6.setLayoutData((Object)gridData7);
        this.ctrl_copyright = formToolkit.createText(this.generalComposite, "");
        gridData7 = new GridData(768);
        gridData7.heightHint = 40;
        gridData7.widthHint = 400;
        gridData7.horizontalSpan = 1;
        gridData7.verticalIndent = 2;
        this.ctrl_copyright.setLayoutData((Object)gridData7);
        formToolkit.paintBordersFor(this.generalComposite);
        this.addListeners();
        this.loadData();
        gridData7 = composite.getDisplay();
        if (gridData7 != null && !gridData7.isDisposed()) {
            gridData7.asyncExec(new Runnable(){

                public void run() {
                    MethodLibraryDescriptionFormPage.this.ctrl_name.setFocus();
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
    }

    private void loadData() {
        String string = this.library.getName();
        String string2 = this.library.getBriefDescription();
        this.ctrl_name.setText(TngUtil.checkNull((String)string));
        this.ctrl_brief_desc.setText(TngUtil.checkNull((String)string2));
        this.textAuthors.setText(TngUtil.checkNull((String)this.library.getAuthors()));
        if (this.library.getChangeDate() != null) {
            this.ctrl_change_date.setText(TngUtil.checkNull((String)this.library.getChangeDate().toLocaleString()));
        }
        this.ctrl_change_desc.setText(TngUtil.checkNull((String)this.library.getChangeDescription()));
        this.ctrl_version.setText(TngUtil.checkNull((String)this.library.getVersion()));
    }

    private void addListeners() {
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodLibraryDescriptionFormPage.this.library.setName(MethodLibraryDescriptionFormPage.this.ctrl_name.getText());
            }
        });
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodLibraryDescriptionFormPage.this.library.setBriefDescription(MethodLibraryDescriptionFormPage.this.ctrl_brief_desc.getText());
            }
        });
        this.textAuthors.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodLibraryDescriptionFormPage.this.library.setAuthors(MethodLibraryDescriptionFormPage.this.textAuthors.getText());
            }
        });
        this.ctrl_change_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodLibraryDescriptionFormPage.this.library.setChangeDescription(MethodLibraryDescriptionFormPage.this.ctrl_change_desc.getText());
            }
        });
        this.ctrl_version.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MethodLibraryDescriptionFormPage.this.library.setVersion(MethodLibraryDescriptionFormPage.this.ctrl_version.getText());
            }
        });
        this.ctrl_copyright.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
            }
        });
    }
}

