/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ProcessEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    private static final String WBS_TXT = AuthoringUIResources.ProcessEditor_WorkBreakdownStructure;
    private static final String TBS_TXT = AuthoringUIResources.ProcessEditor_TeamAllocation;
    private static final String WPBS_TXT = AuthoringUIResources.ProcessEditor_WorkProductUsage;
    private ListViewer selectedColumnListViewer;
    private List wbsColumnDescriptors;
    private List tbsColumnDescriptors;
    private List wpbsColumnDescriptors;
    private Button addButton;
    private Button removeButton;
    private Button downButton;
    private Button upButton;
    private static final String[] BS_NAMES = new String[]{WBS_TXT, TBS_TXT, WPBS_TXT};
    private List[] columnDescriptorLists;
    private static final List[] ALL_COLUMN_DESCRIPTOR_LISTS = new List[]{ProcessEditor.ALL_WBS_COLUMNS, ProcessEditor.ALL_TBS_COLUMNS, ProcessEditor.ALL_WPBS_COLUMNS};
    private Button configSwitchAlwaysButton;
    private Button configSwitchNeverButton;
    private Button configSwitchPromptButton;
    private Button inheritSuppressionButton;

    public void init(IWorkbench iWorkbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LibraryPlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite composite) {
        this.initData();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData(768));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(1, false));
        composite3.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite3, 0);
        label.setText(AuthoringUIResources.columnselection_text);
        final Combo combo = new Combo(composite3, 2056);
        combo.setItems(BS_NAMES);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Combo combo = (Combo)selectionEvent.getSource();
                int n = combo.getSelectionIndex();
                if (n != -1) {
                    ProcessEditorPreferencePage.this.selectedColumnListViewer.setInput((Object)ProcessEditorPreferencePage.this.columnDescriptorLists[n]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        combo.select(0);
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(768));
        Composite composite5 = new Composite(composite4, 0);
        gridLayout = new GridLayout();
        gridLayout.marginLeft = 0;
        gridLayout.marginWidth = 0;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)new GridData(768));
        this.selectedColumnListViewer = new ListViewer(composite5, 2818);
        final ColumnDescriptorProvider columnDescriptorProvider = new ColumnDescriptorProvider();
        this.selectedColumnListViewer.setContentProvider((IContentProvider)columnDescriptorProvider);
        this.selectedColumnListViewer.setLabelProvider((IBaseLabelProvider)columnDescriptorProvider);
        this.selectedColumnListViewer.setInput((Object)this.wbsColumnDescriptors);
        this.selectedColumnListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                List list = ((IStructuredSelection)ProcessEditorPreferencePage.this.selectedColumnListViewer.getSelection()).toList();
                if (list.contains(ProcessEditor.COL_DESC_ID) || list.contains(ProcessEditor.COL_DESC_PRESENTATION_NAME)) {
                    if (ProcessEditorPreferencePage.this.removeButton.isEnabled()) {
                        ProcessEditorPreferencePage.this.removeButton.setEnabled(false);
                    }
                    if (ProcessEditorPreferencePage.this.upButton.isEnabled()) {
                        ProcessEditorPreferencePage.this.upButton.setEnabled(false);
                    }
                    if (ProcessEditorPreferencePage.this.downButton.isEnabled()) {
                        ProcessEditorPreferencePage.this.downButton.setEnabled(false);
                    }
                } else {
                    if (!ProcessEditorPreferencePage.this.removeButton.isEnabled()) {
                        ProcessEditorPreferencePage.this.removeButton.setEnabled(true);
                    }
                    if (!ProcessEditorPreferencePage.this.upButton.isEnabled()) {
                        ProcessEditorPreferencePage.this.upButton.setEnabled(true);
                    }
                    if (!ProcessEditorPreferencePage.this.downButton.isEnabled()) {
                        ProcessEditorPreferencePage.this.downButton.setEnabled(true);
                    }
                }
            }
        });
        this.selectedColumnListViewer.getControl().setLayoutData((Object)new GridData(768));
        Composite composite6 = new Composite(composite4, 0);
        composite6.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(512);
        gridData.widthHint = 100;
        composite6.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData(800);
        this.addButton = new Button(composite6, 0);
        this.addButton.setText(AuthoringUIText.ADD_BUTTON_TEXT);
        this.addButton.setLayoutData((Object)gridData2);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = combo.getSelectionIndex();
                List list = ALL_COLUMN_DESCRIPTOR_LISTS[n];
                final List list2 = ProcessEditorPreferencePage.this.columnDescriptorLists[n];
                ListSelectionDialog listSelectionDialog = new ListSelectionDialog(Display.getCurrent().getActiveShell(), list, (IStructuredContentProvider)columnDescriptorProvider, columnDescriptorProvider, AuthoringUIResources.selectColumnstoAdd_text){

                    protected Control createDialogArea(Composite composite) {
                        Control control = super.createDialogArea(composite);
                        this.getViewer().addFilter(new ViewerFilter(){

                            public boolean select(Viewer viewer, Object object, Object object2) {
                                return !list2.contains(object2);
                            }
                        });
                        return control;
                    }
                };
                if (listSelectionDialog.open() == 0) {
                    list2.addAll((Collection)Arrays.asList(listSelectionDialog.getResult()));
                    ProcessEditorPreferencePage.this.selectedColumnListViewer.refresh();
                }
            }
        });
        this.removeButton = new Button(composite6, 0);
        this.removeButton.setText(AuthoringUIResources.removeButton_text);
        this.removeButton.setLayoutData((Object)gridData2);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List list = (List)ProcessEditorPreferencePage.this.selectedColumnListViewer.getInput();
                List list2 = ((IStructuredSelection)ProcessEditorPreferencePage.this.selectedColumnListViewer.getSelection()).toList();
                if (list2.contains(ProcessEditor.COL_DESC_ID) || list2.contains(ProcessEditor.COL_DESC_PRESENTATION_NAME)) {
                    return;
                }
                list.removeAll(list2);
                ProcessEditorPreferencePage.this.selectedColumnListViewer.refresh();
            }
        });
        this.upButton = new Button(composite6, 0);
        this.upButton.setText(AuthoringUIText.UP_BUTTON_TEXT);
        this.upButton.setLayoutData((Object)gridData2);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ProcessEditorPreferencePage.this.selectedColumnListViewer.getSelection();
                if (iStructuredSelection.size() > 1) {
                    return;
                }
                EList eList = (EList)ProcessEditorPreferencePage.this.selectedColumnListViewer.getInput();
                Object object = iStructuredSelection.getFirstElement();
                int n = eList.indexOf(object);
                if (combo.getSelectionIndex() == 0 && n < 3) {
                    return;
                }
                if (combo.getSelectionIndex() > 0 && n < 2) {
                    return;
                }
                eList.move(n - 1, n);
                ProcessEditorPreferencePage.this.selectedColumnListViewer.refresh();
                ProcessEditorPreferencePage.this.selectedColumnListViewer.setSelection((ISelection)new StructuredSelection(object), true);
            }
        });
        this.downButton = new Button(composite6, 0);
        this.downButton.setText(AuthoringUIText.DOWN_BUTTON_TEXT);
        this.downButton.setLayoutData((Object)gridData2);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ProcessEditorPreferencePage.this.selectedColumnListViewer.getSelection();
                if (iStructuredSelection.size() > 1) {
                    return;
                }
                EList eList = (EList)ProcessEditorPreferencePage.this.selectedColumnListViewer.getInput();
                int n = eList.indexOf(object = iStructuredSelection.getFirstElement());
                if (n == eList.size() - 1 || combo.getSelectionIndex() == 0 && n < 2) {
                    return;
                }
                if (n == eList.size() - 1 || combo.getSelectionIndex() > 0 && n < 1) {
                    return;
                }
                eList.move(n + 1, n);
                ProcessEditorPreferencePage.this.selectedColumnListViewer.refresh();
                ProcessEditorPreferencePage.this.selectedColumnListViewer.setSelection((ISelection)new StructuredSelection(object), true);
            }
        });
        Group group = new Group(composite2, 8);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(AuthoringUIResources.ProcessEditorPreferencePage_switchConfiguration);
        this.configSwitchAlwaysButton = new Button((Composite)group, 16);
        this.configSwitchAlwaysButton.setText(LibraryUIResources.alwaysButton_text);
        this.configSwitchNeverButton = new Button((Composite)group, 16);
        this.configSwitchNeverButton.setText(LibraryUIResources.neverButton_text);
        this.configSwitchPromptButton = new Button((Composite)group, 16);
        this.configSwitchPromptButton.setText(LibraryUIResources.promptButton_text);
        this.setSwitchConfigButton(LibraryUIPreferences.getSwitchConfig());
        Group group2 = new Group(composite2, 8);
        group2.setLayout((Layout)new GridLayout());
        group2.setLayoutData((Object)new GridData(768));
        group2.setText(AuthoringUIResources.ProcessEditorPreferencePage_suppressionGroupTitle);
        this.inheritSuppressionButton = new Button((Composite)group2, 32);
        this.inheritSuppressionButton.setText(AuthoringUIResources.ProcessEditorPreferencePage_inheritSuppressionState);
        this.inheritSuppressionButton.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.epf.library.edit.inherit_suppression_state"));
        return composite2;
    }

    private void initData() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = iPreferenceStore.getString("org.eclipse.epf.library.edit.wbs_columns");
        if (string == null) {
            string = iPreferenceStore.getDefaultString("org.eclipse.epf.library.edit.wbs_columns");
        }
        this.wbsColumnDescriptors = ProcessEditor.toColumnDescriptorList(string);
        string = iPreferenceStore.getString("org.eclipse.epf.library.edit.tbs_columns");
        if (string == null) {
            string = iPreferenceStore.getDefaultString("org.eclipse.epf.library.edit.tbs_columns");
        }
        this.tbsColumnDescriptors = ProcessEditor.toColumnDescriptorList(string);
        string = iPreferenceStore.getString("org.eclipse.epf.library.edit.wpbs_columns");
        if (string == null) {
            string = iPreferenceStore.getDefaultString("org.eclipse.epf.library.edit.wpbs_columns");
        }
        this.wpbsColumnDescriptors = ProcessEditor.toColumnDescriptorList(string);
        if (this.wbsColumnDescriptors.size() == 0) {
            this.wbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_WBS_COLUMNS);
            iPreferenceStore.setValue("org.eclipse.epf.library.edit.wbs_columns", ProcessEditorPreferencePage.toString(this.wbsColumnDescriptors));
        }
        if (this.tbsColumnDescriptors.size() == 0) {
            this.tbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_TBS_COLUMNS);
            iPreferenceStore.setValue("org.eclipse.epf.library.edit.tbs_columns", ProcessEditorPreferencePage.toString(this.tbsColumnDescriptors));
        }
        if (this.wpbsColumnDescriptors.size() == 0) {
            this.wpbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_WPBS_COLUMNS);
            iPreferenceStore.setValue("org.eclipse.epf.library.edit.wpbs_columns", ProcessEditorPreferencePage.toString(this.wpbsColumnDescriptors));
        }
        this.columnDescriptorLists = new List[]{this.wbsColumnDescriptors, this.tbsColumnDescriptors, this.wpbsColumnDescriptors};
    }

    protected void performDefaults() {
        super.performDefaults();
        this.wbsColumnDescriptors.clear();
        this.wbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_WBS_COLUMNS);
        this.tbsColumnDescriptors.clear();
        this.tbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_TBS_COLUMNS);
        this.wpbsColumnDescriptors.clear();
        this.wpbsColumnDescriptors.addAll(ProcessEditor.DEFAULT_WPBS_COLUMNS);
        this.inheritSuppressionButton.setSelection(this.getPreferenceStore().getDefaultBoolean("org.eclipse.epf.library.edit.inherit_suppression_state"));
        this.setSwitchConfigButton("prompt");
    }

    public boolean performOk() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("org.eclipse.epf.library.edit.wbs_columns", ProcessEditorPreferencePage.toString(this.wbsColumnDescriptors));
        iPreferenceStore.setValue("org.eclipse.epf.library.edit.tbs_columns", ProcessEditorPreferencePage.toString(this.tbsColumnDescriptors));
        iPreferenceStore.setValue("org.eclipse.epf.library.edit.wpbs_columns", ProcessEditorPreferencePage.toString(this.wpbsColumnDescriptors));
        iPreferenceStore.setValue("org.eclipse.epf.library.edit.inherit_suppression_state", this.inheritSuppressionButton.getSelection());
        LibraryUIPreferences.setSwitchConfig((String)this.getSwitchConfigValue());
        return true;
    }

    public static String toString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(((ColumnDescriptor)list.get((int)n2)).id).append(',');
            ++n2;
        }
        stringBuffer.append(((ColumnDescriptor)list.get((int)n)).id);
        return stringBuffer.toString();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void modifyText(ModifyEvent modifyEvent) {
    }

    private String getSwitchConfigValue() {
        if (this.configSwitchAlwaysButton.getSelection()) {
            return "always";
        }
        if (this.configSwitchNeverButton.getSelection()) {
            return "never";
        }
        if (this.configSwitchPromptButton.getSelection()) {
            return "prompt";
        }
        return "prompt";
    }

    private void setSwitchConfigButton(String string) {
        if ("always".equals(string)) {
            this.configSwitchAlwaysButton.setSelection(true);
            this.configSwitchNeverButton.setSelection(false);
            this.configSwitchPromptButton.setSelection(false);
        } else if ("never".equals(string)) {
            this.configSwitchAlwaysButton.setSelection(false);
            this.configSwitchNeverButton.setSelection(true);
            this.configSwitchPromptButton.setSelection(false);
        } else {
            this.configSwitchAlwaysButton.setSelection(false);
            this.configSwitchNeverButton.setSelection(false);
            this.configSwitchPromptButton.setSelection(true);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return LibraryPlugin.getDefault().getPreferenceStore();
    }

    private static class ColumnDescriptorProvider
    implements ITreeContentProvider,
    ILabelProvider {
        public Object[] getChildren(Object object) {
            return null;
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return false;
        }

        public Object[] getElements(Object object) {
            return ((List)object).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Image getImage(Object object) {
            return null;
        }

        public String getText(Object object) {
            return ((ColumnDescriptor)object).label;
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }
}

