/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessGuidanceFilter;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterInitializer;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.AddGuidanceToActivityCommand;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ActivityGuidanceSection
extends AbstractSection {
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    private FormToolkit toolkit;
    private Button ctrl_add_1;
    private Button ctrl_remove_1;
    private Button ctrl_add_2;
    private Button ctrl_remove_2;
    private Button ctrl_add_3;
    private Button ctrl_remove_3;
    private Button ctrl_add_4;
    private Button ctrl_remove_4;
    private Table ctrl_table_1;
    private Table ctrl_table_2;
    private Table ctrl_table_3;
    private Table ctrl_table_4;
    private Section communicationMaterialSection;
    private Section educationMaterialSection;
    private TableViewer viewer_1;
    private TableViewer viewer_2;
    private TableViewer viewer_3;
    private TableViewer viewer_4;
    private Activity element;
    private IActionManager actionMgr;
    public final String tabName = FilterConstants.GUIDANCE;
    private IFilter roadMapFilter = null;
    private IFilter generalGuidanceFilter = null;
    private IFilter supportingMaterialFilter = null;

    public IFilter getRoadMapFilter() {
        if (this.roadMapFilter == null) {
            this.roadMapFilter = new ProcessGuidanceFilter(this.getConfiguration(), null, this.tabName){

                public boolean childAccept(Object object) {
                    if (object instanceof GuidanceGroupingItemProvider) {
                        return true;
                    }
                    if (object instanceof GuidanceItemProvider) {
                        String string = ((GuidanceItemProvider)object).getText(object);
                        return string.equalsIgnoreCase(LibraryEditPlugin.INSTANCE.getString("_UI_Guidances_Roadmap")) && !((GuidanceItemProvider)object).getChildren(object).isEmpty();
                    }
                    return object instanceof Roadmap;
                }
            };
        } else {
            ((ProcessGuidanceFilter)this.roadMapFilter).setMethodConfiguration(this.getConfiguration());
        }
        return this.roadMapFilter;
    }

    public IFilter getGeneralGuidanceFilter() {
        if (this.generalGuidanceFilter == null) {
            this.generalGuidanceFilter = new ProcessGuidanceFilter(this.getConfiguration(), null, this.tabName){

                public boolean childAccept(Object object) {
                    if (super.childAccept(object)) {
                        return true;
                    }
                    if (object instanceof GuidanceItemProvider) {
                        return !((GuidanceItemProvider)object).getChildren(object).isEmpty();
                    }
                    Class clazz = FilterInitializer.getInstance().getClassForType(this.helper.getFilterTypeStr());
                    if (clazz != null) {
                        return clazz.isInstance(object);
                    }
                    return object instanceof Checklist || object instanceof Concept || object instanceof Example || object instanceof Guideline || object instanceof ReusableAsset || object instanceof SupportingMaterial;
                }
            };
        } else {
            ((ProcessGuidanceFilter)this.generalGuidanceFilter).setMethodConfiguration(this.getConfiguration());
        }
        return this.generalGuidanceFilter;
    }

    public IFilter getSupportingMaterialFilter() {
        if (this.supportingMaterialFilter == null) {
            this.supportingMaterialFilter = new ProcessGuidanceFilter(this.getConfiguration(), null, this.tabName){

                public boolean childAccept(Object object) {
                    if (super.childAccept(object)) {
                        return true;
                    }
                    return object instanceof GuidanceItemProvider || object instanceof SupportingMaterial;
                }
            };
        } else {
            ((ProcessGuidanceFilter)this.supportingMaterialFilter).setMethodConfiguration(this.getConfiguration());
        }
        return this.supportingMaterialFilter;
    }

    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
        this.init();
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createGuidanceSection(composite);
        this.addListeners();
        this.updateControls();
    }

    private void init() {
        this.element = (Activity)this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = EPFPropertySheetPage.getActionManager();
    }

    private void toggleSection() {
        if (!(this.element instanceof DeliveryProcess)) {
            if (this.communicationMaterialSection.isExpanded()) {
                this.communicationMaterialSection.setExpanded(false);
            }
            if (this.educationMaterialSection.isExpanded()) {
                this.educationMaterialSection.setExpanded(false);
            }
            if (this.communicationMaterialSection.isVisible()) {
                this.communicationMaterialSection.setVisible(false);
            }
            if (this.educationMaterialSection.isVisible()) {
                this.educationMaterialSection.setVisible(false);
            }
        } else {
            if (!this.communicationMaterialSection.isExpanded()) {
                this.communicationMaterialSection.setExpanded(true);
            }
            if (!this.educationMaterialSection.isExpanded()) {
                this.educationMaterialSection.setExpanded(true);
            }
            if (!this.communicationMaterialSection.isVisible()) {
                this.communicationMaterialSection.setVisible(true);
            }
            if (!this.educationMaterialSection.isVisible()) {
                this.educationMaterialSection.setVisible(true);
            }
        }
    }

    public void updateControls() {
        this.ctrl_add_1.setEnabled(this.editable);
        this.ctrl_add_2.setEnabled(this.editable);
        this.ctrl_add_3.setEnabled(this.editable);
        this.ctrl_add_4.setEnabled(this.editable);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer_1.getSelection();
        if (iStructuredSelection.size() > 0 && this.editable) {
            this.ctrl_remove_1.setEnabled(true);
        } else {
            this.ctrl_remove_1.setEnabled(false);
        }
        iStructuredSelection = (IStructuredSelection)this.viewer_2.getSelection();
        if (iStructuredSelection.size() > 0 && this.editable) {
            this.ctrl_remove_2.setEnabled(true);
        } else {
            this.ctrl_remove_2.setEnabled(false);
        }
        iStructuredSelection = (IStructuredSelection)this.viewer_3.getSelection();
        if (iStructuredSelection.size() > 0 && this.editable) {
            this.ctrl_remove_3.setEnabled(true);
        } else {
            this.ctrl_remove_3.setEnabled(false);
        }
        iStructuredSelection = (IStructuredSelection)this.viewer_4.getSelection();
        if (iStructuredSelection.size() > 0 && this.editable) {
            this.ctrl_remove_4.setEnabled(true);
        } else {
            this.ctrl_remove_4.setEnabled(false);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof Activity) {
                this.element = (Activity)this.getElement();
                this.viewer_1.refresh();
                this.viewer_2.refresh();
                this.viewer_3.refresh();
                this.viewer_4.refresh();
                this.toggleSection();
                this.updateControls();
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing activity guidance section: ", (Throwable)exception);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    private void createGuidanceSection(Composite composite) {
        int n = 50;
        String string = null;
        String string2 = null;
        String string3 = null;
        string = PropertiesResources.Activity_RoadmapTitle;
        string2 = PropertiesResources.Activity_RoadmapDescription;
        string3 = PropertiesResources.Activity_Selected_Roadmap;
        Section section = FormUI.createSection(this.toolkit, composite, string, string2);
        Composite composite2 = FormUI.createComposite(this.toolkit, section, 2, false);
        Composite composite3 = FormUI.createComposite(this.toolkit, composite2, 1808);
        FormUI.createLabel(this.toolkit, composite3, string3);
        this.ctrl_table_1 = FormUI.createTable(this.toolkit, composite3, n);
        this.viewer_1 = new TableViewer(this.ctrl_table_1);
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                return ActivityGuidanceSection.this.getFilteredList(ActivityGuidanceSection.this.element.getRoadmaps()).toArray();
            }
        };
        this.viewer_1.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.viewer_1.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_1.setInput((Object)this.element);
        Composite composite4 = FormUI.createComposite(this.toolkit, composite2, 68);
        this.ctrl_add_1 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Add);
        this.ctrl_remove_1 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Remove);
        this.toolkit.paintBordersFor(composite3);
        string = PropertiesResources.Activity_GeneralGuidanceTitle;
        string2 = PropertiesResources.Activity_GeneralGuidanceDescription;
        string3 = PropertiesResources.Activity_Selected_GeneralGuidance;
        section = FormUI.createSection(this.toolkit, composite, string, string2);
        composite2 = FormUI.createComposite(this.toolkit, section, 2, false);
        composite3 = FormUI.createComposite(this.toolkit, composite2, 1808);
        FormUI.createLabel(this.toolkit, composite3, string3);
        this.ctrl_table_2 = FormUI.createTable(this.toolkit, composite3, n);
        this.viewer_2 = new TableViewer(this.ctrl_table_2);
        adapterFactoryContentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                return ActivityGuidanceSection.this.getFilteredList(ActivityGuidanceSection.this.getSelectedGuidances()).toArray();
            }
        };
        this.viewer_2.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.viewer_2.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_2.setInput((Object)this.element);
        composite4 = FormUI.createComposite(this.toolkit, composite2, 68);
        this.ctrl_add_2 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Add);
        this.ctrl_remove_2 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Remove);
        this.toolkit.paintBordersFor(composite3);
        string = PropertiesResources.Activity_CommunicationMaterialTitle;
        string2 = PropertiesResources.Activity_CommunicationMaterialDescription;
        string3 = PropertiesResources.Activity_Selected_CommunicationMaterial;
        section = FormUI.createSection(this.toolkit, composite, string, string2);
        composite2 = FormUI.createComposite(this.toolkit, section, 2, false);
        composite3 = FormUI.createComposite(this.toolkit, composite2, 1808);
        FormUI.createLabel(this.toolkit, composite3, string3);
        this.ctrl_table_3 = FormUI.createTable(this.toolkit, composite3, n);
        this.viewer_3 = new TableViewer(this.ctrl_table_3);
        adapterFactoryContentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                    return ActivityGuidanceSection.this.getFilteredList(((DeliveryProcess)ActivityGuidanceSection.this.element).getCommunicationsMaterials()).toArray();
                }
                return Collections.EMPTY_LIST.toArray();
            }
        };
        this.viewer_3.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.viewer_3.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_3.setInput((Object)this.element);
        composite4 = FormUI.createComposite(this.toolkit, composite2, 68);
        this.ctrl_add_3 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Add);
        this.ctrl_remove_3 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Remove);
        this.toolkit.paintBordersFor(composite3);
        this.communicationMaterialSection = section;
        string = PropertiesResources.Activity_EducationMaterialTitle;
        string2 = PropertiesResources.Activity_EducationMaterialDescription;
        string3 = PropertiesResources.Activity_Selected_EducationMaterial;
        section = FormUI.createSection(this.toolkit, composite, string, string2);
        composite2 = FormUI.createComposite(this.toolkit, section, 2, false);
        composite3 = FormUI.createComposite(this.toolkit, composite2, 1808);
        FormUI.createLabel(this.toolkit, composite3, string3);
        this.ctrl_table_4 = FormUI.createTable(this.toolkit, composite3, n);
        this.viewer_4 = new TableViewer(this.ctrl_table_4);
        adapterFactoryContentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                    return ActivityGuidanceSection.this.getFilteredList(((DeliveryProcess)ActivityGuidanceSection.this.element).getEducationMaterials()).toArray();
                }
                return Collections.EMPTY_LIST.toArray();
            }
        };
        this.viewer_4.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.viewer_4.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer_4.setInput((Object)this.element);
        composite4 = FormUI.createComposite(this.toolkit, composite2, 68);
        this.ctrl_add_4 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Add);
        this.ctrl_remove_4 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Remove);
        this.toolkit.paintBordersFor(composite3);
        this.educationMaterialSection = section;
        this.toggleSection();
    }

    private void addListeners() {
        ItemProviderAdapter itemProviderAdapter = this.getAdapter();
        if (!(itemProviderAdapter instanceof IBSItemProvider)) {
            this.logger.logError("ActivityGuidanceSection::addListeners - IBSItemProvider is null");
            return;
        }
        IBSItemProvider iBSItemProvider = (IBSItemProvider)itemProviderAdapter;
        iBSItemProvider.getTopItem();
        this.ctrl_table_1.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_1.getSelection();
                if (iStructuredSelection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.viewer_1.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_1.getSelection();
                if (iStructuredSelection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.ctrl_add_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IFilter iFilter = ActivityGuidanceSection.this.getRoadMapFilter();
                ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iFilter, ActivityGuidanceSection.this.element, FilterConstants.ROADMAP, ActivityGuidanceSection.this.element.getRoadmaps());
                itemsFilterDialog.setTitle(FilterConstants.ROADMAP);
                itemsFilterDialog.setInput(UmaUtil.getMethodLibrary((EObject)ActivityGuidanceSection.this.element));
                itemsFilterDialog.setBlockOnOpen(true);
                itemsFilterDialog.open();
                ActivityGuidanceSection.this.addGuidances(itemsFilterDialog.getSelectedItems());
                ActivityGuidanceSection.this.viewer_1.refresh();
            }
        });
        this.ctrl_remove_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_1.getSelection();
                if (iStructuredSelection.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(iStructuredSelection.toList());
                    ActivityGuidanceSection.this.removeGuidances(arrayList);
                    ActivityGuidanceSection.this.viewer_1.refresh();
                    ActivityGuidanceSection.this.viewer_1.setSelection(null, true);
                }
                ActivityGuidanceSection.this.ctrl_remove_1.setEnabled(false);
            }
        });
        this.ctrl_table_2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_2.getSelection();
                if (iStructuredSelection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_2.setEnabled(true);
                }
            }
        });
        this.viewer_2.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_2.getSelection();
                if (iStructuredSelection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_2.setEnabled(true);
                }
            }
        });
        this.ctrl_add_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IFilter iFilter = ActivityGuidanceSection.this.getGeneralGuidanceFilter();
                ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iFilter, ActivityGuidanceSection.this.element, FilterConstants.GUIDANCE, ActivityGuidanceSection.this.getExistingElements());
                itemsFilterDialog.setTitle(FilterConstants.GUIDANCE);
                itemsFilterDialog.setInput(UmaUtil.getMethodLibrary((EObject)ActivityGuidanceSection.this.element));
                itemsFilterDialog.setBlockOnOpen(true);
                itemsFilterDialog.setTypes(ActivityGuidanceSection.this.getFilterTypes());
                itemsFilterDialog.open();
                ActivityGuidanceSection.this.addGuidances(itemsFilterDialog.getSelectedItems());
                ActivityGuidanceSection.this.viewer_2.refresh();
            }
        });
        this.ctrl_remove_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_2.getSelection();
                if (iStructuredSelection.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(iStructuredSelection.toList());
                    ActivityGuidanceSection.this.removeGuidances(arrayList);
                    ActivityGuidanceSection.this.viewer_2.refresh();
                    ActivityGuidanceSection.this.viewer_2.setSelection(null, true);
                }
                ActivityGuidanceSection.this.ctrl_remove_2.setEnabled(false);
            }
        });
        this.ctrl_table_3.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_3.getSelection();
                if (iStructuredSelection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_3.setEnabled(true);
                }
            }
        });
        this.viewer_3.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_3.getSelection();
                if (iStructuredSelection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_3.setEnabled(true);
                }
            }
        });
        this.ctrl_add_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                    DeliveryProcess deliveryProcess = (DeliveryProcess)ActivityGuidanceSection.this.element;
                    IFilter iFilter = ActivityGuidanceSection.this.getSupportingMaterialFilter();
                    ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iFilter, deliveryProcess, FilterConstants.SUPPORTING_MATERIALS, deliveryProcess.getCommunicationsMaterials());
                    itemsFilterDialog.setTitle(FilterConstants.GUIDANCE);
                    itemsFilterDialog.setInput(UmaUtil.getMethodLibrary((EObject)ActivityGuidanceSection.this.element));
                    itemsFilterDialog.setBlockOnOpen(true);
                    itemsFilterDialog.open();
                    ActivityGuidanceSection.this.actionMgr.doAction(5, (EObject)deliveryProcess, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_CommunicationsMaterials(), (Object)itemsFilterDialog.getSelectedItems(), -1);
                }
                ActivityGuidanceSection.this.viewer_3.refresh();
            }
        });
        this.ctrl_remove_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_3.getSelection();
                if (iStructuredSelection.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(iStructuredSelection.toList());
                    if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                        DeliveryProcess deliveryProcess = (DeliveryProcess)ActivityGuidanceSection.this.element;
                        ActivityGuidanceSection.this.actionMgr.doAction(6, (EObject)deliveryProcess, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_CommunicationsMaterials(), arrayList, -1);
                    }
                    ActivityGuidanceSection.this.viewer_3.refresh();
                    ActivityGuidanceSection.this.viewer_3.setSelection(null, true);
                }
                ActivityGuidanceSection.this.ctrl_remove_3.setEnabled(false);
            }
        });
        this.ctrl_table_4.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_4.getSelection();
                if (iStructuredSelection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_4.setEnabled(true);
                }
            }
        });
        this.viewer_4.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_4.getSelection();
                if (iStructuredSelection.size() > 0 && ActivityGuidanceSection.this.editable) {
                    ActivityGuidanceSection.this.ctrl_remove_4.setEnabled(true);
                }
            }
        });
        this.ctrl_add_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                    DeliveryProcess deliveryProcess = (DeliveryProcess)ActivityGuidanceSection.this.element;
                    IFilter iFilter = ActivityGuidanceSection.this.getSupportingMaterialFilter();
                    ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iFilter, deliveryProcess, FilterConstants.SUPPORTING_MATERIALS, deliveryProcess.getEducationMaterials());
                    itemsFilterDialog.setTitle(FilterConstants.GUIDANCE);
                    itemsFilterDialog.setInput(UmaUtil.getMethodLibrary((EObject)ActivityGuidanceSection.this.element));
                    itemsFilterDialog.setBlockOnOpen(true);
                    itemsFilterDialog.open();
                    ActivityGuidanceSection.this.actionMgr.doAction(5, (EObject)deliveryProcess, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_EducationMaterials(), (Object)itemsFilterDialog.getSelectedItems(), -1);
                    ActivityGuidanceSection.this.viewer_4.refresh();
                }
            }
        });
        this.ctrl_remove_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGuidanceSection.this.viewer_4.getSelection();
                if (iStructuredSelection.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(iStructuredSelection.toList());
                    if (ActivityGuidanceSection.this.element instanceof DeliveryProcess) {
                        DeliveryProcess deliveryProcess = (DeliveryProcess)ActivityGuidanceSection.this.element;
                        ActivityGuidanceSection.this.actionMgr.doAction(6, (EObject)deliveryProcess, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcess_EducationMaterials(), arrayList, -1);
                    }
                    ActivityGuidanceSection.this.viewer_4.refresh();
                    ActivityGuidanceSection.this.viewer_4.setSelection(null, true);
                }
                ActivityGuidanceSection.this.ctrl_remove_4.setEnabled(false);
            }
        });
    }

    private void addGuidances(ArrayList arrayList) {
        AddGuidanceToActivityCommand addGuidanceToActivityCommand = new AddGuidanceToActivityCommand(this.element, (List)arrayList);
        this.actionMgr.execute((IResourceAwareCommand)addGuidanceToActivityCommand);
    }

    private void removeGuidances(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (Guidance guidance : arrayList) {
                if (guidance instanceof Checklist) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Checklists(), (Object)guidance, -1);
                    continue;
                }
                if (guidance instanceof Concept) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Concepts(), (Object)guidance, -1);
                    continue;
                }
                if (guidance instanceof Example) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Examples(), (Object)guidance, -1);
                    continue;
                }
                if (guidance instanceof SupportingMaterial) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_SupportingMaterials(), (Object)guidance, -1);
                    continue;
                }
                if (guidance instanceof Guideline) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Guidelines(), (Object)guidance, -1);
                    continue;
                }
                if (guidance instanceof ReusableAsset) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_ReusableAssets(), (Object)guidance, -1);
                    continue;
                }
                if (guidance instanceof Roadmap) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getActivity_Roadmaps(), (Object)guidance, -1);
                    continue;
                }
                this.logger.logError("Can't remove Guidance: " + guidance.getType().getName() + ":" + guidance.getName());
            }
        }
    }

    private List getExistingElements() {
        ArrayList<SupportingMaterial> arrayList = new ArrayList<SupportingMaterial>();
        arrayList.addAll(this.element.getChecklists());
        arrayList.addAll(this.element.getConcepts());
        arrayList.addAll(this.element.getExamples());
        arrayList.addAll(this.element.getGuidelines());
        arrayList.addAll(this.element.getReusableAssets());
        arrayList.addAll(this.element.getSupportingMaterials());
        DiagramInfo diagramInfo = new DiagramInfo(this.element);
        if (diagramInfo.getActivityDiagram() != null) {
            arrayList.add(diagramInfo.getActivityDiagram());
        }
        if (diagramInfo.getActivityDetailDiagram() != null) {
            arrayList.add(diagramInfo.getActivityDetailDiagram());
        }
        if (diagramInfo.getWPDDiagram() != null) {
            arrayList.add(diagramInfo.getWPDDiagram());
        }
        return arrayList;
    }

    private List getSelectedGuidances() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.element.getChecklists());
        arrayList.addAll(this.element.getConcepts());
        arrayList.addAll(this.element.getExamples());
        arrayList.addAll(this.element.getGuidelines());
        arrayList.addAll(this.element.getReusableAssets());
        List list = this.element.getSupportingMaterials();
        DiagramInfo diagramInfo = new DiagramInfo(this.element);
        for (Object e : list) {
            if (!(e instanceof SupportingMaterial) || diagramInfo.isDiagram((SupportingMaterial)e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    protected String[] getFilterTypes() {
        String[] stringArray = new String[14];
        int n = 0;
        stringArray[n++] = FilterConstants.GUIDANCE;
        stringArray[n++] = "-" + FilterConstants.CHECKLISTS;
        stringArray[n++] = "-" + FilterConstants.CONCEPTS;
        stringArray[n++] = "-" + FilterConstants.ESTIMATE_CONSIDERATIONS;
        stringArray[n++] = "-" + FilterConstants.EXAMPLES;
        stringArray[n++] = "-" + FilterConstants.GUIDELINES;
        stringArray[n++] = "-" + FilterConstants.PRACTICES;
        stringArray[n++] = "-" + FilterConstants.REPORTS;
        stringArray[n++] = "-" + FilterConstants.REUSABLE_ASSETS;
        stringArray[n++] = "-" + FilterConstants.SUPPORTING_MATERIALS;
        stringArray[n++] = "-" + FilterConstants.TEMPLATES;
        stringArray[n++] = "-" + FilterConstants.TOOL_MENTORS;
        stringArray[n++] = "-" + FilterConstants.WHITE_PAPERS;
        stringArray[n++] = "-" + FilterConstants.TERM_DEFINITIONS;
        return stringArray;
    }
}

