/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EPFPropertySheetPage
extends TabbedPropertySheetPage {
    private IPropertySheetEntry rootEntry;
    private static IPropertySourceProvider sourceProvider;
    private static ISelection selection;
    private static IActionManager actionMgr;
    private static ProcessEditor processEditor;
    public static String formPageID;
    private static ProcessBreakdownStructureFormPage formPage;

    static {
        selection = null;
        formPageID = null;
        formPage = null;
    }

    public EPFPropertySheetPage(ProcessEditor processEditor) {
        super((ITabbedPropertySheetPageContributor)processEditor);
        actionMgr = processEditor.getActionManager();
        EPFPropertySheetPage.processEditor = processEditor;
    }

    public static IActionManager getActionManager() {
        return actionMgr;
    }

    public static ProcessEditor getEditor() {
        return processEditor;
    }

    public void setPropertySourceProvider(IPropertySourceProvider iPropertySourceProvider) {
        sourceProvider = iPropertySourceProvider;
        if (this.rootEntry == null) {
            PropertySheetEntry propertySheetEntry = new PropertySheetEntry();
            this.rootEntry = propertySheetEntry;
        }
        if (sourceProvider != null && this.rootEntry instanceof PropertySheetEntry) {
            ((PropertySheetEntry)this.rootEntry).setPropertySourceProvider(sourceProvider);
        }
    }

    public static IPropertySourceProvider getPropertySourceProvider() {
        return sourceProvider;
    }

    public static ISelection getSelection() {
        return selection;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        selection = iSelection;
        if (iWorkbenchPart instanceof ProcessEditor) {
            processEditor = (ProcessEditor)iWorkbenchPart;
            actionMgr = processEditor.getActionManager();
            IFormPage iFormPage = processEditor.getActivePageInstance();
            if (iFormPage instanceof ProcessBreakdownStructureFormPage) {
                formPage = (ProcessBreakdownStructureFormPage)iFormPage;
            }
            formPageID = iFormPage != null ? iFormPage.getId() : null;
        }
        super.selectionChanged(iWorkbenchPart, selection);
    }

    public void handlePartActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof ProcessEditor) {
            processEditor = (ProcessEditor)iWorkbenchPart;
            selection = processEditor.getSelection();
            actionMgr = processEditor.getActionManager();
            IFormPage iFormPage = processEditor.getActivePageInstance();
            if (iFormPage instanceof ProcessBreakdownStructureFormPage) {
                formPage = (ProcessBreakdownStructureFormPage)iFormPage;
            }
            formPageID = iFormPage != null ? iFormPage.getId() : null;
        }
        super.handlePartActivated(iWorkbenchPart);
        this.refresh();
    }

    public static AdapterFactory getAdapterFactory() {
        return formPage.getAdapterFactory();
    }

    public void refresh() {
        try {
            super.refresh();
        }
        catch (Exception exception) {}
    }
}

