/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.filters.ProcessRoleFilter;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class OBSRelationSection
extends AbstractSection {
    protected IStructuredContentProvider contentProvider = null;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
    private FormToolkit toolkit;
    private Button ctrl_add_1;
    private Button ctrl_add_2;
    private Button ctrl_remove;
    private Table ctrl_selected;
    protected TableViewer viewer;
    private String title;
    private String desc;
    private String table1;
    protected BreakdownElement element;
    protected IActionManager actionMgr;
    protected boolean showAddFromProcessButton = false;
    private IFilter filter = null;

    public IFilter getFilter() {
        if (this.filter == null) {
            this.filter = new ProcessRoleFilter(this.getConfiguration(), null, FilterConstants.ROLES);
        }
        return this.filter;
    }

    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
        this.init();
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createSection(composite);
        this.addListeners();
        this.updateControls();
    }

    protected void init() {
        this.element = this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = EPFPropertySheetPage.getActionManager();
    }

    protected void setTabData(String string, String string2, String string3) {
        this.title = string;
        this.desc = string2;
        this.table1 = string3;
    }

    private void createSection(Composite composite) {
        Section section = FormUI.createSection(this.toolkit, composite, this.title, this.desc);
        Composite composite2 = FormUI.createComposite(this.toolkit, section, 2, false);
        Composite composite3 = FormUI.createComposite(this.toolkit, composite2, 1808);
        FormUI.createLabel(this.toolkit, composite3, this.table1);
        this.ctrl_selected = FormUI.createTable(this.toolkit, composite3);
        this.viewer = new TableViewer(this.ctrl_selected);
        this.initContentProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)this.element);
        Composite composite4 = FormUI.createComposite(this.toolkit, composite2, 68);
        this.ctrl_add_1 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Add);
        if (this.showAddFromProcessButton) {
            this.ctrl_add_2 = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_AddFromProcess);
        }
        this.ctrl_remove = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Remove);
        this.toolkit.paintBordersFor(composite2);
        this.toolkit.paintBordersFor(composite3);
        this.toolkit.paintBordersFor(composite4);
    }

    protected MethodConfiguration getDefaultConfiguration() {
        ItemProviderAdapter itemProviderAdapter = this.getAdapter();
        Object object = null;
        if (itemProviderAdapter instanceof IBSItemProvider) {
            IBSItemProvider iBSItemProvider = (IBSItemProvider)itemProviderAdapter;
            object = iBSItemProvider.getTopItem();
            MethodConfiguration methodConfiguration = ((Process)object).getDefaultContext();
            return methodConfiguration;
        }
        this.logger.logError("OBSRelationSection::getDefaultConfiguration - IBSItemProvider is null");
        return null;
    }

    private void addListeners() {
        this.ctrl_selected.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)OBSRelationSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0 && OBSRelationSection.this.editable) {
                    OBSRelationSection.this.ctrl_remove.setEnabled(true);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)OBSRelationSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0 && OBSRelationSection.this.editable) {
                    OBSRelationSection.this.ctrl_remove.setEnabled(true);
                }
            }
        });
        this.ctrl_add_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OBSRelationSection.this.openAddDialog();
                OBSRelationSection.this.viewer.refresh();
            }
        });
        if (this.showAddFromProcessButton) {
            this.ctrl_add_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    OBSRelationSection.this.openAddFromProcessDialog();
                    OBSRelationSection.this.viewer.refresh();
                }
            });
        }
        this.ctrl_remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)OBSRelationSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(iStructuredSelection.toList());
                    OBSRelationSection.this.remove(arrayList);
                    OBSRelationSection.this.viewer.refresh();
                    OBSRelationSection.this.viewer.setSelection(null, true);
                }
                OBSRelationSection.this.ctrl_remove.setEnabled(false);
            }
        });
    }

    public void updateControls() {
        IStructuredSelection iStructuredSelection;
        if (this.ctrl_add_1 != null) {
            this.ctrl_add_1.setEnabled(this.editable);
        }
        if (this.ctrl_add_2 != null) {
            this.ctrl_add_2.setEnabled(this.editable);
        }
        if ((iStructuredSelection = (IStructuredSelection)this.viewer.getSelection()).size() > 0 && this.editable) {
            if (this.ctrl_remove != null) {
                this.ctrl_remove.setEnabled(true);
            }
        } else if (this.ctrl_remove != null) {
            this.ctrl_remove.setEnabled(false);
        }
    }

    public void refresh() {
        this.updateControls();
        super.refresh();
    }

    protected void initContentProvider() {
    }

    protected void openAddDialog() {
    }

    protected void openAddFromProcessDialog() {
    }

    protected void remove(ArrayList arrayList) {
    }

    public void disose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
    }
}

