/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.properties.PredecessorMap;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PredecessorDialog
extends Dialog {
    private Text predIdText;
    private Text presentationName;
    private Combo dependency;
    private static final String FINISH_TO_START = PropertiesResources.WorkOrderType_FINISH_TO_START;
    private static final String FINISH_TO_FINISH = PropertiesResources.WorkOrderType_FINISH_TO_FINISH;
    private static final String START_TO_START = PropertiesResources.WorkOrderType_START_TO_START;
    private static final String START_TO_FINISH = PropertiesResources.WorkOrderType_START_TO_FINISH;
    private String[] dependencyList = new String[]{FINISH_TO_START, FINISH_TO_FINISH, START_TO_START, START_TO_FINISH};
    private WorkBreakdownElement element;
    private Object process;
    private AdapterFactory adapterFactory;
    private List predecessors = new ArrayList();
    private List predMapList;
    private IActionManager actionMgr;
    private PredecessorMap predMap;

    public PredecessorDialog(Shell shell, WorkBreakdownElement workBreakdownElement, Object object, AdapterFactory adapterFactory, PredecessorMap predecessorMap, List list, IActionManager iActionManager) {
        super(shell);
        this.element = workBreakdownElement;
        this.process = object;
        this.adapterFactory = adapterFactory;
        this.predMap = predecessorMap;
        this.predMapList = list;
        this.actionMgr = iActionManager;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 0);
        label.setText(PropertiesResources.PredecessorDialog_HeaderMessage);
        gridData = new GridData(1);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData(1);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText(PropertiesResources.PredecessorDialog_Index);
        gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.predIdText = new Text(composite2, 2048);
        gridData = new GridData(512);
        gridData.widthHint = 100;
        this.predIdText.setLayoutData((Object)gridData);
        this.predIdText.setText(new Integer(this.predMap.getId()).toString());
        label = new Label(composite2, 0);
        label.setText(PropertiesResources.PredecessorDialog_PresentationName);
        gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.presentationName = new Text(composite2, 2048);
        gridData = new GridData(512);
        gridData.widthHint = 400;
        this.presentationName.setEditable(false);
        this.presentationName.setLayoutData((Object)gridData);
        WorkOrder workOrder = this.predMap.getWorkOrder();
        this.presentationName.setText(ProcessUtil.getPresentationName((BreakdownElement)workOrder.getPred()));
        label = new Label(composite2, 0);
        label.setText(PropertiesResources.PredecessorDialog_Dependency);
        gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.dependency = new Combo(composite2, 12);
        gridData = new GridData(1);
        this.dependency.setLayoutData((Object)gridData);
        this.dependency.setItems(this.dependencyList);
        String string = workOrder.getLinkType().getName();
        if (workOrder.getLinkType().getValue() == 1) {
            string = FINISH_TO_FINISH;
        } else if (workOrder.getLinkType().getValue() == 0) {
            string = FINISH_TO_START;
        } else if (workOrder.getLinkType().getValue() == 3) {
            string = START_TO_FINISH;
        } else if (workOrder.getLinkType().getValue() == 2) {
            string = START_TO_START;
        }
        this.dependency.setText(string);
        Label label2 = new Label(composite2, 259);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label2.setLayoutData((Object)gridData);
        this.predIdText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                int n;
                try {
                    n = new Integer(PredecessorDialog.this.predIdText.getText());
                    if (n < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(PropertiesResources.Process_predecessors_validNumberTitle, PropertiesResources.Process_predecessors_validNumberMessage);
                    PredecessorDialog.this.predIdText.setText(new Integer(PredecessorDialog.this.predMap.getId()).toString());
                    PredecessorDialog.this.predIdText.setFocus();
                    PredecessorDialog.this.predIdText.selectAll();
                    return;
                }
                if (PredecessorDialog.this.alreadyExists(n)) {
                    PredecessorDialog.this.predIdText.setText(new Integer(PredecessorDialog.this.predMap.getId()).toString());
                    PredecessorDialog.this.predIdText.selectAll();
                    return;
                }
                String string = PredecessorDialog.this.getPredId(n);
                if (string == null) {
                    return;
                }
                String string2 = ProcessUtil.checkPredecessorList((WorkBreakdownElement)PredecessorDialog.this.element, (String)string, (AdapterFactory)PredecessorDialog.this.adapterFactory, (Object)PredecessorDialog.this.process, (List)PredecessorDialog.this.predecessors);
                if (string2 != null) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.PredecessorDialog_PredecessorErrorDialogTitle, string2);
                    PredecessorDialog.this.predIdText.setText(new Integer(PredecessorDialog.this.predMap.getId()).toString());
                    return;
                }
                PredecessorDialog.this.presentationName.setText(PredecessorDialog.this.getName(n));
            }
        });
        return composite2;
    }

    private String getName(int n) {
        String string = null;
        AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator(this.adapterFactory, this.process);
        while (adapterFactoryTreeIterator.hasNext()) {
            Object object = adapterFactoryTreeIterator.next();
            IBSItemProvider iBSItemProvider = (IBSItemProvider)this.adapterFactory.adapt(object, ITreeItemContentProvider.class);
            Integer n2 = new Integer(iBSItemProvider.getId());
            object = TngUtil.unwrap(object);
            if (n != n2 || !StrUtil.isBlank((String)(string = ((BreakdownElement)object).getPresentationName()))) continue;
            string = ((BreakdownElement)object).getName();
        }
        return string;
    }

    private boolean alreadyExists(int n) {
        for (PredecessorMap predecessorMap : this.predMapList) {
            if (predecessorMap.getId() != n || this.predMap.getId() == n) continue;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.PredecessorDialog_PredecessorErrorDialogTitle, PropertiesResources.PredecessorDialog_PredecessorErrorMessage);
            return true;
        }
        return false;
    }

    private String getPredId(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (PredecessorMap predecessorMap : this.predMapList) {
            if (this.predMap.getId() == predecessorMap.getId()) {
                stringBuffer.append(n);
            } else {
                stringBuffer.append(predecessorMap.getId());
            }
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PropertiesResources.PredecessorDialog_Title);
    }

    protected void okPressed() {
        int n = new Integer(this.predIdText.getText());
        WorkOrderType workOrderType = this.getWorkOrderType();
        if (n != this.predMap.getId() || !workOrderType.equals(this.predMap.getWorkOrder().getLinkType())) {
            boolean bl;
            String string = this.getPredId(n);
            if (string == null) {
                return;
            }
            String string2 = ProcessUtil.checkPredecessorList((WorkBreakdownElement)this.element, (String)string, (AdapterFactory)this.adapterFactory, (Object)this.process, (List)this.predecessors);
            if (string2 != null) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(PropertiesResources.PredecessorDialog_PredecessorErrorDialogTitle, string2);
                this.predIdText.setText(new Integer(this.predMap.getId()).toString());
            }
            if (!(bl = this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)this.predMap.getWorkOrder(), -1))) {
                this.close();
                return;
            }
            this.predMapList.remove(this.predMap);
            int n2 = this.predecessors.size();
            int n3 = 0;
            while (n3 < n2) {
                WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)this.predecessors.get(n3);
                boolean bl2 = false;
                for (WorkOrder workOrder : this.element.getLinkToPredecessor()) {
                    if (workOrder.getPred() != workBreakdownElement) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    WorkOrder workOrder = UmaFactory.eINSTANCE.createWorkOrder();
                    workOrder.setPred(workBreakdownElement);
                    workOrder.setLinkType(workOrderType);
                    boolean bl3 = this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)workOrder, -1);
                    if (!bl3) {
                        return;
                    }
                    this.predMap.setId(n);
                    this.predMap.setWorkOrder(workOrder);
                    this.predMapList.add(this.predMap);
                }
                ++n3;
            }
        }
        super.okPressed();
    }

    private WorkOrderType getWorkOrderType() {
        int n = this.dependency.getSelectionIndex();
        WorkOrderType workOrderType = n == 0 ? WorkOrderType.FINISH_TO_START_LITERAL : (n == 1 ? WorkOrderType.FINISH_TO_FINISH_LITERAL : (n == 2 ? WorkOrderType.START_TO_START_LITERAL : WorkOrderType.START_TO_FINISH_LITERAL));
        return workOrderType;
    }

    public boolean close() {
        return super.close();
    }
}

