/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.properties.BreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PredecessorDialog;
import org.eclipse.epf.authoring.ui.properties.PredecessorMap;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class WorkBreakdownElementGeneralSection
extends BreakdownElementGeneralSection {
    protected WorkBreakdownElement element;
    protected Button eventDrivenButton;
    protected Button ongoingButton;
    protected Button repeatableButton;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;
    private TableViewer viewer;
    private TextCellEditor textCellEditor;
    private ValidatingTextCellEditor idCellEditor;
    private ComboBoxCellEditor comboBoxCellEditor;
    private List predMapList = new ArrayList();
    private static final String FINISH_TO_START = PropertiesResources.WorkOrderType_FINISH_TO_START;
    private static final String FINISH_TO_FINISH = PropertiesResources.WorkOrderType_FINISH_TO_FINISH;
    private static final String START_TO_START = PropertiesResources.WorkOrderType_START_TO_START;
    private static final String START_TO_FINISH = PropertiesResources.WorkOrderType_START_TO_FINISH;
    private static final String COL_ID = "id";
    private static final String COL_PRESENTATION_NAME = "presentation_name";
    private static final String COL_DEPENDENCY = "dependency";
    public static final ColumnDescriptor COL_DESC_ID = new ColumnDescriptor("id", PropertiesResources.WorkBreakdownElement_Dependency_COL_ID_TEXT, 0, 100, true, 1, 0x1000000);
    public static final ColumnDescriptor COL_DESC_PRESENTATION_NAME = new ColumnDescriptor("presentation_name", PropertiesResources.WorkBreakdownElement_Dependency_COL_PRESENTATION_NAME_TEXT, 1, 250, true, 0);
    public static final ColumnDescriptor COL_DESC_DEPENDENCY = new ColumnDescriptor("dependency", PropertiesResources.WorkBreakdownElement_Dependency_COL_DEPENDENCY_TEXT, 2, 100, true, 2);
    ColumnDescriptor[] columnDescriptors = new ColumnDescriptor[]{COL_DESC_ID, COL_DESC_PRESENTATION_NAME, COL_DESC_DEPENDENCY};

    protected void init() {
        super.init();
        this.element = (WorkBreakdownElement)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        this.eventDrivenButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.eventDrivenButton.setText(PropertiesResources.WorkBreakdownElement_EventDriven);
        this.ongoingButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.ongoingButton.setText(PropertiesResources.WorkBreakdownElement_Ongoing);
        this.repeatableButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 2);
        this.repeatableButton.setText(PropertiesResources.WorkBreakdownElement_Repeatable);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.WorkBreakdownElement_Dependency);
        try {
            this.createViewer(this.generalComposite, 2);
        }
        catch (Exception exception) {
            this.logger.logError("Error creating viewer for workbreakdown element general section: ", (Throwable)exception);
        }
        Composite composite2 = this.toolkit.createComposite(this.generalComposite);
        composite2.setLayoutData((Object)new GridData(1040));
        composite2.setLayout((Layout)new GridLayout());
        FormUI.createLabel(this.toolkit, composite2, "");
        this.addButton = FormUI.createButton(this.toolkit, composite2, PropertiesResources.WorkBreakdownElement_Dependency_Add);
        this.editButton = FormUI.createButton(this.toolkit, composite2, PropertiesResources.WorkBreakdownElement_Dependency_Edit);
        this.removeButton = FormUI.createButton(this.toolkit, composite2, PropertiesResources.WorkBreakdownElement_Dependency_Remove);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    protected void addListeners() {
        super.addListeners();
        this.eventDrivenButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkBreakdownElementGeneralSection.this.element = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                boolean bl = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)WorkBreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), (Object)WorkBreakdownElementGeneralSection.this.eventDrivenButton.getSelection(), -1);
                if (!bl) {
                    WorkBreakdownElementGeneralSection.this.eventDrivenButton.setSelection(WorkBreakdownElementGeneralSection.this.element.getIsEventDriven().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.ongoingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkBreakdownElementGeneralSection.this.element = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                boolean bl = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)WorkBreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), (Object)WorkBreakdownElementGeneralSection.this.ongoingButton.getSelection(), -1);
                if (!bl) {
                    WorkBreakdownElementGeneralSection.this.ongoingButton.setSelection(WorkBreakdownElementGeneralSection.this.element.getIsOngoing().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.repeatableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkBreakdownElementGeneralSection.this.element = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                boolean bl = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)WorkBreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), (Object)WorkBreakdownElementGeneralSection.this.repeatableButton.getSelection(), -1);
                if (!bl) {
                    WorkBreakdownElementGeneralSection.this.repeatableButton.setSelection(WorkBreakdownElementGeneralSection.this.element.getIsRepeatable().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkOrder workOrder = UmaFactory.eINSTANCE.createWorkOrder();
                workOrder.setLinkType(WorkOrderType.FINISH_TO_START_LITERAL);
                PredecessorMap predecessorMap = new PredecessorMap(-1, workOrder);
                WorkBreakdownElementGeneralSection.this.predMapList.add(predecessorMap);
                WorkBreakdownElementGeneralSection.this.viewer.refresh();
                WorkBreakdownElementGeneralSection.this.viewer.editElement((Object)predecessorMap, 0);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)WorkBreakdownElementGeneralSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0) {
                    PredecessorMap predecessorMap = (PredecessorMap)iStructuredSelection.getFirstElement();
                    IBSItemProvider iBSItemProvider = (IBSItemProvider)WorkBreakdownElementGeneralSection.this.getBSAdapter();
                    Object object = iBSItemProvider.getTopItem();
                    PredecessorDialog predecessorDialog = new PredecessorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkBreakdownElementGeneralSection.this.element, object, WorkBreakdownElementGeneralSection.this.getAdapterFactory(), predecessorMap, WorkBreakdownElementGeneralSection.this.predMapList, WorkBreakdownElementGeneralSection.this.actionMgr);
                    predecessorDialog.open();
                    WorkBreakdownElementGeneralSection.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)WorkBreakdownElementGeneralSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0) {
                    PredecessorMap predecessorMap = (PredecessorMap)iStructuredSelection.getFirstElement();
                    WorkBreakdownElementGeneralSection.this.predMapList.remove(predecessorMap);
                    WorkOrder workOrder = predecessorMap.getWorkOrder();
                    WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                    WorkBreakdownElementGeneralSection.this.actionMgr.doAction(4, (EObject)workBreakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)workOrder, -1);
                    WorkBreakdownElementGeneralSection.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)WorkBreakdownElementGeneralSection.this.viewer.getSelection();
                if (iStructuredSelection.size() == 1 && WorkBreakdownElementGeneralSection.this.editable) {
                    WorkBreakdownElementGeneralSection.this.removeButton.setEnabled(true);
                    WorkBreakdownElementGeneralSection.this.editButton.setEnabled(true);
                }
            }
        });
    }

    protected void updateControls() {
        super.updateControls();
        this.eventDrivenButton.setEnabled(this.editable);
        this.ongoingButton.setEnabled(this.editable);
        this.repeatableButton.setEnabled(this.editable);
        this.viewer.getTable().setEnabled(this.editable);
        this.addButton.setEnabled(this.editable);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
        if (iStructuredSelection.size() == 1 && this.editable) {
            this.removeButton.setEnabled(this.editable);
            this.editButton.setEnabled(this.editable);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
        if (!EPFPropertySheetPage.formPageID.equals("wbs") && !EPFPropertySheetPage.formPageID.equals("consolidated")) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.viewer.getTable().setEnabled(false);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof WorkBreakdownElement) {
                super.refresh();
                this.element = (WorkBreakdownElement)this.getElement();
                this.eventDrivenButton.setSelection(this.element.getIsEventDriven().booleanValue());
                this.ongoingButton.setSelection(this.element.getIsOngoing().booleanValue());
                this.repeatableButton.setSelection(this.element.getIsRepeatable().booleanValue());
                this.predMapList = new ArrayList();
                this.initializePredList();
                this.viewer.refresh();
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing Workbreakdown element general section:", (Throwable)exception);
        }
    }

    private void createViewer(Composite composite, int n) {
        Object object;
        this.viewer = new TableViewer(composite, 68356);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 10;
        gridData.heightHint = 50;
        gridData.horizontalSpan = n;
        this.viewer.getControl().setLayoutData((Object)gridData);
        String[] stringArray = new String[this.columnDescriptors.length];
        int n2 = 0;
        while (n2 < this.columnDescriptors.length) {
            stringArray[n2] = this.columnDescriptors[n2].id;
            object = new TableColumn(this.viewer.getTable(), this.columnDescriptors[n2].alignment);
            object.setText(this.columnDescriptors[n2].label);
            object.setResizable(this.columnDescriptors[n2].resizable);
            object.setWidth(this.columnDescriptors[n2].width);
            ++n2;
        }
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setColumnProperties(stringArray);
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                if (object instanceof List) {
                    return WorkBreakdownElementGeneralSection.this.predMapList.toArray();
                }
                return null;
            }
        };
        this.viewer.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        object = new AdapterFactoryLabelProvider(this.getAdapterFactory()){

            public String getColumnText(Object object, int n) {
                if (object instanceof PredecessorMap) {
                    int n2 = ((PredecessorMap)object).getId();
                    WorkOrder workOrder = ((PredecessorMap)object).getWorkOrder();
                    if (n == 0) {
                        return String.valueOf(n2);
                    }
                    if (n == 1) {
                        String string = "";
                        if (workOrder.getPred() != null && StrUtil.isBlank((String)(string = workOrder.getPred().getPresentationName()))) {
                            return workOrder.getPred().getName();
                        }
                        return string;
                    }
                    if (n == 2) {
                        if (workOrder.getLinkType().getValue() == 1) {
                            return FINISH_TO_FINISH;
                        }
                        if (workOrder.getLinkType().getValue() == 0) {
                            return FINISH_TO_START;
                        }
                        if (workOrder.getLinkType().getValue() == 2) {
                            return START_TO_START;
                        }
                        if (workOrder.getLinkType().getValue() == 3) {
                            return START_TO_FINISH;
                        }
                        return workOrder.getLinkType().getName();
                    }
                }
                return "";
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)object);
        this.textCellEditor = new TextCellEditor((Composite)this.viewer.getTable());
        this.comboBoxCellEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), new String[]{FINISH_TO_START, FINISH_TO_FINISH, START_TO_START, START_TO_FINISH});
        this.setCellEditors();
        this.setCellModifiers();
        this.initializePredList();
        this.viewer.setInput((Object)this.predMapList);
        this.viewer.refresh();
    }

    private int getCellEditorType(String string) {
        int n = 0;
        while (n < this.columnDescriptors.length) {
            ColumnDescriptor columnDescriptor = this.columnDescriptors[n];
            if (columnDescriptor.id == string) {
                return columnDescriptor.cellEditorType;
            }
            ++n;
        }
        return 0;
    }

    public CellEditor getCellEditor(String string, int n) {
        if (string == COL_ID) {
            if (this.idCellEditor == null) {
                this.idCellEditor = new ValidatingTextCellEditor((Composite)this.viewer.getTable()){

                    protected String isValid(Object object, String string) {
                        object = TngUtil.unwrap((Object)object);
                        IBSItemProvider iBSItemProvider = (IBSItemProvider)WorkBreakdownElementGeneralSection.this.getBSAdapter();
                        Object object2 = iBSItemProvider.getTopItem();
                        ArrayList arrayList = new ArrayList();
                        WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                        String string2 = WorkBreakdownElementGeneralSection.this.getPredId();
                        String string3 = ProcessUtil.checkPredecessorList((WorkBreakdownElement)workBreakdownElement, (String)string2, (AdapterFactory)WorkBreakdownElementGeneralSection.this.getAdapterFactory(), (Object)object2, arrayList);
                        return string3;
                    }
                };
                this.idCellEditor.setValidator(new CellEditorValidator(this.idCellEditor));
                this.idCellEditor.getControl().addListener(27, (Listener)new ValidatingDeactivateListener(this.idCellEditor));
            }
            this.idCellEditor.setColumnIndex(n);
            return this.idCellEditor;
        }
        return null;
    }

    private void setCellEditors() {
        CellEditor[] cellEditorArray = new CellEditor[this.columnDescriptors.length];
        int n = 0;
        while (n < this.columnDescriptors.length) {
            CellEditor cellEditor = this.getCellEditor(this.columnDescriptors[n].id, n);
            if (cellEditor != null) {
                cellEditorArray[n] = cellEditor;
            } else {
                switch (this.columnDescriptors[n].cellEditorType) {
                    case 1: {
                        cellEditorArray[n] = this.textCellEditor;
                        break;
                    }
                    case 2: {
                        cellEditorArray[n] = this.comboBoxCellEditor;
                        break;
                    }
                    default: {
                        cellEditorArray[n] = null;
                    }
                }
            }
            ++n;
        }
        this.viewer.setCellEditors(cellEditorArray);
    }

    private void setCellModifiers() {
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object object, String string) {
                if (!(object instanceof PredecessorMap)) {
                    return false;
                }
                return string != WorkBreakdownElementGeneralSection.COL_PRESENTATION_NAME;
            }

            public Object getValue(Object object, String string) {
                String string2 = null;
                switch (WorkBreakdownElementGeneralSection.this.getCellEditorType(string)) {
                    case 1: {
                        string2 = new Integer(((PredecessorMap)object).getId()).toString();
                        return string2;
                    }
                    case 2: {
                        int n = ((PredecessorMap)object).getWorkOrder().getLinkType().getValue();
                        if (n == 0) {
                            return new Integer(0);
                        }
                        if (1 == n) {
                            return new Integer(1);
                        }
                        if (2 == n) {
                            return new Integer(2);
                        }
                        return new Integer(3);
                    }
                }
                return "";
            }

            public void modify(Object object, String string, Object object2) {
                int n;
                TableItem tableItem = (TableItem)object;
                PredecessorMap predecessorMap = (PredecessorMap)tableItem.getData();
                WorkOrder workOrder = predecessorMap.getWorkOrder();
                if (string.equals(WorkBreakdownElementGeneralSection.COL_ID)) {
                    tableItem.setText(0, object2.toString());
                    try {
                        n = new Integer(object2.toString());
                        if (n < 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception exception) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(PropertiesResources.Process_predecessors_validNumberTitle, PropertiesResources.Process_predecessors_validNumberMessage);
                        WorkBreakdownElementGeneralSection.this.predMapList.remove(predecessorMap);
                        WorkBreakdownElementGeneralSection.this.viewer.refresh();
                        return;
                    }
                    predecessorMap.setId(n);
                }
                n = WorkBreakdownElementGeneralSection.this.getColumnIndex(string);
                CellEditor cellEditor = WorkBreakdownElementGeneralSection.this.viewer.getCellEditors()[n];
                String string2 = cellEditor.getErrorMessage();
                if (string2 != null) {
                    return;
                }
                IBSItemProvider iBSItemProvider = (IBSItemProvider)WorkBreakdownElementGeneralSection.this.getBSAdapter();
                WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                switch (WorkBreakdownElementGeneralSection.this.getCellEditorType(string)) {
                    case 1: {
                        Object object3 = iBSItemProvider.getTopItem();
                        ArrayList arrayList = new ArrayList();
                        String string3 = WorkBreakdownElementGeneralSection.this.getPredId();
                        String string4 = ProcessUtil.checkPredecessorList((WorkBreakdownElement)workBreakdownElement, (String)string3, (AdapterFactory)WorkBreakdownElementGeneralSection.this.getAdapterFactory(), (Object)object3, arrayList);
                        if (string4 == null) {
                            ArrayList arrayList2 = new ArrayList();
                            ArrayList arrayList3 = new ArrayList();
                            PredecessorList.prepareUpdatePredecessors((AdapterFactory)WorkBreakdownElementGeneralSection.this.getAdapterFactory(), (WorkBreakdownElement)workBreakdownElement, arrayList, arrayList2, arrayList3);
                            if (!arrayList3.isEmpty()) {
                                WorkBreakdownElementGeneralSection.this.actionMgr.doAction(6, (EObject)workBreakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), arrayList3, -1);
                            }
                            if (arrayList2.isEmpty()) break;
                            boolean bl = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(5, (EObject)workBreakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), arrayList2, -1);
                            if (bl) {
                                predecessorMap.setWorkOrder((WorkOrder)arrayList2.get(arrayList2.size() - 1));
                                break;
                            }
                            WorkBreakdownElementGeneralSection.this.predMapList.remove(predecessorMap);
                            break;
                        }
                        String string5 = WorkBreakdownElementGeneralSection.this.getEditor().getTitle();
                        String string6 = PropertiesResources.ProcessEditorFormProperties_cellEditor_invalidPredcessor_problem_msg;
                        MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        msgDialog.displayWarning(string5, string6, string4);
                        WorkBreakdownElementGeneralSection.this.predMapList.remove(predecessorMap);
                        break;
                    }
                    case 2: {
                        boolean bl = false;
                        WorkBreakdownElement workBreakdownElement2 = null;
                        WorkOrder workOrder2 = null;
                        int n2 = ((Number)object2).intValue();
                        Iterator iterator = workBreakdownElement.getLinkToPredecessor().iterator();
                        while (iterator.hasNext()) {
                            workOrder2 = (WorkOrder)iterator.next();
                            if (workOrder2.getPred() != workOrder.getPred() || workOrder2.getLinkType().getValue() == n2) continue;
                            workBreakdownElement2 = workOrder2.getPred();
                            iterator.remove();
                            bl = true;
                        }
                        WorkOrderType workOrderType = n2 == 0 ? WorkOrderType.FINISH_TO_START_LITERAL : (n2 == 1 ? WorkOrderType.FINISH_TO_FINISH_LITERAL : (n2 == 2 ? WorkOrderType.START_TO_START_LITERAL : WorkOrderType.START_TO_FINISH_LITERAL));
                        if (bl && workBreakdownElement2 != null) {
                            workOrder.setPred(workBreakdownElement2);
                            workOrder.setLinkType(workOrderType);
                            boolean bl2 = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(3, (EObject)workBreakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)workOrder, -1);
                            if (!bl2) break;
                            predecessorMap.setWorkOrder(workOrder2);
                            break;
                        }
                        WorkBreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)workOrder, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkOrder_LinkType(), (Object)workOrderType, -1);
                        break;
                    }
                    default: {
                        WorkOrderType workOrderType = WorkOrderType.FINISH_TO_FINISH_LITERAL;
                    }
                }
                WorkBreakdownElementGeneralSection.this.viewer.refresh();
            }
        });
    }

    private ItemProviderAdapter getBSAdapter() {
        try {
            AdapterFactory adapterFactory = this.getAdapterFactory();
            this.element = (WorkBreakdownElement)this.getElement();
            ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
            return itemProviderAdapter;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getColumnIndex(String string) {
        Object[] objectArray = this.viewer.getColumnProperties();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == string) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getNamePrefix() {
        if (this.element instanceof TeamProfile) {
            return String.valueOf(LibraryUIText.TEXT_TEAM_PROFILE) + ": ";
        }
        if (this.element instanceof Milestone) {
            return String.valueOf(LibraryUIText.TEXT_MILESTONE) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_WORK_PRODUCT_ELEMENT) + ": ";
    }

    private String getPredId() {
        StringBuffer stringBuffer = new StringBuffer();
        for (PredecessorMap predecessorMap : this.predMapList) {
            stringBuffer.append(predecessorMap.getId());
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    private void initializePredList() {
        try {
            Object object;
            ISelection iSelection;
            PredecessorList predecessorList = null;
            this.element = (WorkBreakdownElement)this.getElement();
            AdapterFactory adapterFactory = this.getAdapterFactory();
            if (adapterFactory != null && (iSelection = (ItemProviderAdapter)adapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class)) instanceof IBSItemProvider) {
                predecessorList = ((IBSItemProvider)iSelection).getPredecessors();
            }
            if ((iSelection = this.getSelection()) instanceof IStructuredSelection && (object = ((IStructuredSelection)iSelection).getFirstElement()) instanceof BreakdownElementWrapperItemProvider) {
                predecessorList = ((BreakdownElementWrapperItemProvider)object).getPredecessors();
            }
            if (this.element != null && predecessorList != null) {
                object = this.element.getLinkToPredecessor();
                Iterator iterator = predecessorList.iterator();
                while (iterator.hasNext()) {
                    VariabilityElement variabilityElement;
                    int n;
                    boolean bl = false;
                    Object e = iterator.next();
                    Object object2 = null;
                    if (e instanceof WrapperItemProvider) {
                        object2 = ((WrapperItemProvider)e).getValue();
                    }
                    if (e instanceof ItemProviderAdapter) {
                        object2 = ((ItemProviderAdapter)e).getTarget();
                    }
                    if (object2 == null || (bl = this.addPredecessor((List)object, n = ((IBSItemProvider)e).getId(), object2)) || !(object2 instanceof VariabilityElement) || (variabilityElement = (VariabilityElement)object2).getVariabilityBasedOnElement() == null) continue;
                    VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
                    object2 = variabilityElement2;
                    this.addPredecessor((List)object, n, object2);
                }
            }
        }
        catch (Exception exception) {
            this.logger.logError("Initializing Predecessor List", (Throwable)exception);
        }
    }

    private boolean addPredecessor(List list, int n, Object object) {
        for (Object e : list) {
            WorkBreakdownElement workBreakdownElement;
            if (!(e instanceof WorkOrder) || !object.equals(workBreakdownElement = ((WorkOrder)e).getPred())) continue;
            PredecessorMap predecessorMap = new PredecessorMap(n, (WorkOrder)e);
            this.predMapList.add(predecessorMap);
            return true;
        }
        return false;
    }

    private static class CellEditorValidator
    implements ICellEditorValidator {
        private ValidatingTextCellEditor cellEditor;

        public CellEditorValidator(ValidatingTextCellEditor validatingTextCellEditor) {
            this.cellEditor = validatingTextCellEditor;
        }

        public String isValid(Object object) {
            return this.cellEditor.isValid((String)object);
        }
    }

    private class ValidatingDeactivateListener
    implements Listener {
        private ValidatingTextCellEditor cellEditor;

        ValidatingDeactivateListener(ValidatingTextCellEditor validatingTextCellEditor) {
            this.cellEditor = validatingTextCellEditor;
        }

        public void handleEvent(Event event) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (ValidatingDeactivateListener.this.cellEditor.getLastInvalidElement() != null) {
                        String string = ValidatingDeactivateListener.this.cellEditor.getErrorMessage();
                        String string2 = WorkBreakdownElementGeneralSection.this.getEditor().getTitle();
                        String string3 = PropertiesResources.ProcessEditorFormProperties_textEditCell_problem_msg;
                        MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        msgDialog.displayError(string2, string3, string);
                        WorkBreakdownElementGeneralSection.this.viewer.editElement(ValidatingDeactivateListener.this.cellEditor.getLastInvalidElement(), ValidatingDeactivateListener.this.cellEditor.getColumnIndex());
                    }
                }
            });
        }
    }

    private class ValidatingTextCellEditor
    extends TextCellEditor {
        protected Object lastInvalidElement;
        private int columnIndex;

        public ValidatingTextCellEditor(Composite composite) {
            super(composite);
        }

        void setColumnIndex(int n) {
            this.columnIndex = n;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public Object getLastInvalidElement() {
            return this.lastInvalidElement;
        }

        String isValid(String string) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)WorkBreakdownElementGeneralSection.this.viewer.getSelection();
            if (iStructuredSelection.size() == 1) {
                Object object = iStructuredSelection.getFirstElement();
                String string2 = this.isValid(object, string);
                this.lastInvalidElement = string2 != null ? object : null;
                return string2;
            }
            return null;
        }

        protected String isValid(Object object, String string) {
            return null;
        }
    }
}

