/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.category.CustomCategoryItemProvider;
import org.eclipse.epf.library.edit.category.DisciplineCategoriesItemProvider;
import org.eclipse.epf.library.edit.category.DomainsItemProvider;
import org.eclipse.epf.library.edit.category.RoleSetsItemProvider;
import org.eclipse.epf.library.edit.category.ToolsItemProvider;
import org.eclipse.epf.library.edit.category.WorkProductTypesItemProvider;
import org.eclipse.epf.library.edit.navigator.ConfigurationsItemProvider;
import org.eclipse.epf.library.edit.navigator.PluginUIPackagesItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryContentProvider
extends AdapterFactoryContentProvider {
    private Map<Object, Object> childUIParentMap = new HashMap<Object, Object>();
    private MethodConfiguration config;

    public CategoryContentProvider(AdapterFactory adapterFactory, MethodConfiguration methodConfiguration) {
        super(adapterFactory);
        this.config = methodConfiguration;
    }

    public Object[] getChildren(Object object) {
        Collection<Object> collection = new ArrayList<Object>();
        if (object instanceof MethodPlugin) {
            CustomCategory customCategory;
            ToolsItemProvider toolsItemProvider;
            RoleSetsItemProvider roleSetsItemProvider;
            WorkProductTypesItemProvider workProductTypesItemProvider;
            DomainsItemProvider domainsItemProvider;
            DisciplineCategoriesItemProvider disciplineCategoriesItemProvider = (DisciplineCategoriesItemProvider)TngUtil.getDisciplineCategoriesItemProvider((MethodPlugin)((MethodPlugin)object));
            if (disciplineCategoriesItemProvider != null && !disciplineCategoriesItemProvider.getChildren((Object)disciplineCategoriesItemProvider).isEmpty()) {
                collection.add(disciplineCategoriesItemProvider);
            }
            if ((domainsItemProvider = (DomainsItemProvider)TngUtil.getDomainsItemProvider((MethodPlugin)((MethodPlugin)object))) != null && !domainsItemProvider.getChildren((Object)domainsItemProvider).isEmpty()) {
                collection.add(domainsItemProvider);
            }
            if ((workProductTypesItemProvider = (WorkProductTypesItemProvider)TngUtil.getWorkProductTypesItemProvider((MethodPlugin)((MethodPlugin)object))) != null && !workProductTypesItemProvider.getChildren((Object)workProductTypesItemProvider).isEmpty()) {
                collection.add(workProductTypesItemProvider);
            }
            if ((roleSetsItemProvider = (RoleSetsItemProvider)TngUtil.getRoleSetsItemProvider((MethodPlugin)((MethodPlugin)object))) != null && !roleSetsItemProvider.getChildren((Object)roleSetsItemProvider).isEmpty()) {
                collection.add(roleSetsItemProvider);
            }
            if ((toolsItemProvider = (ToolsItemProvider)TngUtil.getToolsItemProvider((MethodPlugin)((MethodPlugin)object))) != null && !toolsItemProvider.getChildren((Object)toolsItemProvider).isEmpty()) {
                collection.add(toolsItemProvider);
            }
            if ((customCategory = TngUtil.getRootCustomCategory((MethodPlugin)((MethodPlugin)object))) != null && !customCategory.getCategorizedElements().isEmpty()) {
                collection.add(customCategory);
            }
        } else if (object instanceof PluginUIPackagesItemProvider) {
            collection.addAll((Collection)Arrays.asList(super.getChildren(object)));
            collection = this.filterPlugin(collection);
        } else if (object instanceof ContentCategory) {
            collection.addAll((Collection)Arrays.asList(super.getChildren(object)));
            collection = this.filterCategoryElements(object, collection);
        } else if (object instanceof FeatureValueWrapperItemProvider) {
            collection.addAll((Collection<Object>)Arrays.asList(super.getChildren(object)));
            collection = this.filterCategoryElements(object, collection);
        } else if (object instanceof MethodLibrary) {
            collection.addAll((Collection<Object>)Arrays.asList(super.getElements(object)));
            collection = this.filterPlugin(collection);
        } else if (object instanceof TransientGroupItemProvider) {
            collection.addAll((Collection<Object>)Arrays.asList(super.getChildren(object)));
        }
        this.createChildParentMap(object, collection);
        return collection.toArray();
    }

    private void createChildParentMap(Object object, Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        for (Object e : collection) {
            this.childUIParentMap.put(e, object);
        }
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    private Collection<Object> filterPlugin(Collection<Object> collection) {
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof MethodPlugin) {
                if (this.hasChildren((MethodPlugin)object) && this.config.getMethodPluginSelection().contains(object)) continue;
                iterator.remove();
                continue;
            }
            if (object instanceof PluginUIPackagesItemProvider) {
                if (this.hasChildren((PluginUIPackagesItemProvider)object)) continue;
                iterator.remove();
                continue;
            }
            if (!(object instanceof ConfigurationsItemProvider)) continue;
            iterator.remove();
        }
        return collection;
    }

    private Collection<Object> filterCategoryElements(Object object, Collection<Object> collection) {
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if ((object2 = TngUtil.unwrap((Object)object2)) instanceof ContentCategory) continue;
            iterator.remove();
        }
        return collection;
    }

    public Object getParent(Object object) {
        if (this.childUIParentMap.containsKey(object)) {
            return this.childUIParentMap.get(object);
        }
        return null;
    }

    public Object getFirstTreeItemForCC(CustomCategory customCategory) {
        CustomCategoryItemProvider customCategoryItemProvider = (CustomCategoryItemProvider)this.getAdapterFactory().adapt((Notifier)customCategory, ITreeItemContentProvider.class);
        for (Object e : customCategoryItemProvider.getNotifyChangedListeners()) {
            if (!(e instanceof FeatureValueWrapperItemProvider) || TngUtil.unwrap(e) != customCategory) continue;
            return (FeatureValueWrapperItemProvider)e;
        }
        return customCategory;
    }

    public Collection<Object> getTreeItems(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = TngUtil.getNotifyChangedListeners((AdapterFactory)this.adapterFactory, (Object)object);
        if (!list.isEmpty()) {
            for (Object e : list) {
                if (!(e instanceof ITreeItemContentProvider) || TngUtil.unwrap(e) != object) continue;
                arrayList.add(e);
            }
        } else {
            arrayList.add(object);
        }
        return arrayList;
    }

    public boolean hasChildren(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        this.childUIParentMap.clear();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification instanceof IViewerNotification) {
            IViewerNotification iViewerNotification = (IViewerNotification)notification;
            Object object = iViewerNotification.getElement();
            final CheckboxTreeViewer checkboxTreeViewer = (CheckboxTreeViewer)this.viewer;
            if (object != null && (iViewerNotification.getEventType() == 3 || iViewerNotification.getEventType() == 1)) {
                SafeUpdateController.syncExec((Runnable)new Runnable(){

                    public void run() {
                        checkboxTreeViewer.refresh();
                    }
                });
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.childUIParentMap.clear();
    }
}

