/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class UILayoutHelper {
    private static Composite editorComposite;
    private static Composite previewComposite;
    private static CTabFolder tabFolder;

    public static void createTabs(ScrolledForm scrolledForm, FormToolkit formToolkit) {
        tabFolder = new CTabFolder(scrolledForm.getBody(), 0x800080);
        TableWrapData tableWrapData = new TableWrapData(256);
        tabFolder.setLayoutData((Object)tableWrapData);
        Color color = formToolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR");
        tabFolder.setSelectionBackground(new Color[]{color, formToolkit.getColors().getBackground()}, new int[]{50});
        CTabItem cTabItem = new CTabItem(tabFolder, 0);
        cTabItem.setText(AuthoringUIText.EDITOR_TEXT);
        editorComposite = UILayoutHelper.createComposite(formToolkit);
        cTabItem.setControl((Control)editorComposite);
        CTabItem cTabItem2 = new CTabItem(tabFolder, 0);
        cTabItem2.setText(AuthoringUIText.PREVIEW_PAGE_TITLE);
        previewComposite = UILayoutHelper.createComposite(formToolkit);
        cTabItem2.setControl((Control)previewComposite);
        formToolkit.paintBordersFor((Composite)tabFolder);
        formToolkit.adapt((Control)tabFolder, true, true);
        tabFolder.setSelection(0);
    }

    private static Composite createComposite(FormToolkit formToolkit) {
        Composite composite = formToolkit.createComposite((Composite)tabFolder);
        composite.setLayoutData((Object)new TableWrapData(256));
        composite.setLayout((Layout)new TableWrapLayout());
        return composite;
    }

    public static Composite getEditorComposite() {
        return editorComposite;
    }

    public static Composite getPreviewComposite() {
        return previewComposite;
    }
}

