/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewLibraryMainPage
extends BaseWizardPage {
    public static final String PAGE_NAME = NewLibraryMainPage.class.getName();
    private Shell shell;
    private Combo libraryPathCombo;
    private Button browseButton;
    private Text briefDescText;
    private String libraryType;

    public NewLibraryMainPage() {
        super(PAGE_NAME);
        this.setTitle(AuthoringUIResources.newLibraryWizardMainPage_title);
        this.setDescription(AuthoringUIResources.newLibraryWizardMainPage_description);
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
    }

    public void createControl(Composite composite) {
        this.shell = composite.getShell();
        Composite composite2 = NewLibraryMainPage.createGridLayoutComposite((Composite)composite, (int)3);
        NewLibraryMainPage.createLabel((Composite)composite2, (String)AuthoringUIResources.libraryPathLabel_text);
        this.libraryPathCombo = NewLibraryMainPage.createCombobox((Composite)composite2);
        this.browseButton = NewLibraryMainPage.createButton((Composite)composite2, (String)AuthoringUIText.BROWSE_BUTTON_TEXT);
        NewLibraryMainPage.createVerticallyAlignedLabel((Composite)composite2, (String)AuthoringUIText.DESCRIPTION_TEXT);
        this.briefDescText = NewLibraryMainPage.createEditableText((Composite)composite2, (int)400, (int)80, (int)1);
        Map map = LibraryManagerFactory.getInstance().getLibraryTypes();
        Iterator iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            this.libraryType = (String)iterator.next();
        }
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite2);
    }

    protected void initControls() {
        String[] stringArray;
        String string = LibraryUIPreferences.getDefaultLibraryPath();
        File file = new File(string);
        String string2 = null;
        int n = 1;
        while (true) {
            if (!(stringArray = new File(file, "Library" + n)).exists()) break;
            ++n;
        }
        string2 = stringArray.getAbsolutePath();
        List list = LibraryUIPreferences.getNewLibraryPathsList();
        if (string2 != null && string2.length() > 0) {
            list.add(0, string2);
        }
        if (list.size() > 0) {
            stringArray = new String[list.size()];
            list.toArray(stringArray);
            this.libraryPathCombo.setItems(stringArray);
            this.libraryPathCombo.setText(stringArray[0]);
        }
    }

    protected void addListeners() {
        this.libraryPathCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewLibraryMainPage.this.setPageComplete(NewLibraryMainPage.this.isPageComplete());
                NewLibraryMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.libraryPathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewLibraryMainPage.this.setPageComplete(NewLibraryMainPage.this.isPageComplete());
                NewLibraryMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(NewLibraryMainPage.this.shell, 0);
                directoryDialog.setFilterPath(NewLibraryMainPage.this.getLibraryPath());
                String string = directoryDialog.open();
                if (string != null) {
                    NewLibraryMainPage.this.libraryPathCombo.add(string, 0);
                    NewLibraryMainPage.this.libraryPathCombo.setText(string);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return this.getLibraryName().length() > 0;
    }

    public String getLibraryName() {
        String string;
        String string2 = this.getLibraryPath();
        if (!string2.equals(string = new File(string2).getName())) {
            return string;
        }
        return "";
    }

    public String getLibraryPath() {
        return this.libraryPathCombo.getText().trim();
    }

    public String getLibraryDescription() {
        return this.briefDescText.getText().trim();
    }

    public String getLibraryType() {
        return this.libraryType;
    }
}

