/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.custom.figures;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public class DecisionNodeFigure
extends DefaultSizeNodeFigure
implements IPolygonAnchorableFigure {
    private int spacing;

    public DecisionNodeFigure(int n, int n2, int n3) {
        super(n, n2);
        this.spacing = n3;
        this.createFigure(n, n2);
    }

    public DecisionNodeFigure(Dimension dimension) {
        super(dimension);
    }

    public DecisionNodeFigure(int n, int n2) {
        super(n, n2);
    }

    public PointList getPolygonPoints() {
        return this.getPoints();
    }

    protected void paintFigure(Graphics graphics) {
        PointList pointList = this.getPointList(this.getBounds().getCopy());
        graphics.fillPolygon(pointList);
        graphics.drawPolygon(pointList);
    }

    protected PointList getPointList(Rectangle rectangle) {
        PointList pointList = new PointList();
        int n = rectangle.x + rectangle.width / 2;
        int n2 = rectangle.y + rectangle.height / 2;
        Point point = new Point(n, rectangle.y);
        Point point2 = new Point(rectangle.x + rectangle.width - 1, n2);
        Point point3 = new Point(n, rectangle.y + rectangle.height - 1);
        Point point4 = new Point(rectangle.x, n2);
        pointList.addPoint(point);
        pointList.addPoint(point2);
        pointList.addPoint(point3);
        pointList.addPoint(point4);
        pointList.addPoint(point);
        return pointList;
    }

    public IFigure getContentPane() {
        return (IFigure)this.getChildren().get(0);
    }

    public void createFigure(int n, int n2) {
        this.setOpaque(true);
        this.setLayoutManager((LayoutManager)new StackLayout(){

            public void layout(IFigure iFigure) {
                Rectangle rectangle = iFigure.getClientArea();
                List list = iFigure.getChildren();
                int n = 0;
                while (n < list.size()) {
                    IFigure iFigure2 = (IFigure)list.get(n);
                    Dimension dimension = iFigure2.getPreferredSize(rectangle.width, rectangle.height);
                    dimension.width = Math.min(dimension.width, rectangle.width);
                    dimension.height = Math.min(dimension.height, rectangle.height);
                    Rectangle rectangle2 = new Rectangle(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2, dimension.width, dimension.height);
                    iFigure2.setBounds(rectangle2);
                    ++n;
                }
            }
        });
        Figure figure = new Figure();
        ConstrainedToolbarLayout constrainedToolbarLayout = new ConstrainedToolbarLayout();
        constrainedToolbarLayout.setSpacing(this.spacing);
        figure.setLayoutManager((LayoutManager)constrainedToolbarLayout);
        this.add((IFigure)figure);
    }

    public PointList getPoints() {
        return this.getPointList(this.getBounds().getCopy());
    }
}

