/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.expressions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;

public abstract class UMLAbstractExpression {
    private static final boolean DISABLED_NO_IMPL_EXCEPTION_LOG = Boolean.valueOf(Platform.getDebugOption((String)(String.valueOf(ActivityDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/disableNoExprImplExceptionLog")));
    private String body;
    private EClassifier context;
    private Map env;
    private IStatus status = Status.OK_STATUS;

    protected UMLAbstractExpression(EClassifier eClassifier) {
        this.context = eClassifier;
    }

    protected UMLAbstractExpression(String string, EClassifier eClassifier, Map map) {
        this.body = string;
        this.context = eClassifier;
        this.env = map;
    }

    protected void setStatus(int n, String string, Throwable throwable) {
        String string2 = "org.eclipse.epf.diagram.ad";
        this.status = new Status(n, string2, -1, string != null ? string : "", throwable);
        if (!this.status.isOK()) {
            ActivityDiagramEditorPlugin.getInstance().logError("Expression problem:" + string + "body:" + this.body, throwable);
        }
    }

    protected abstract Object doEvaluate(Object var1, Map var2);

    public Object evaluate(Object object) {
        return this.evaluate(object, Collections.EMPTY_MAP);
    }

    public Object evaluate(Object object, Map map) {
        if (this.context().isInstance(object)) {
            try {
                return this.doEvaluate(object, map);
            }
            catch (Exception exception) {
                if (DISABLED_NO_IMPL_EXCEPTION_LOG && exception instanceof NoImplException) {
                    return null;
                }
                ActivityDiagramEditorPlugin.getInstance().logError("Expression evaluation failure: " + this.body, exception);
            }
        }
        return null;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public String body() {
        return this.body;
    }

    public EClassifier context() {
        return this.context;
    }

    public Map environment() {
        return this.env;
    }

    public void assignTo(EStructuralFeature eStructuralFeature, EObject eObject) {
        this.evaluate(eObject);
    }

    protected Object performCast(Object object, ETypedElement eTypedElement) {
        if (eTypedElement.getEType() == null || eTypedElement.getEType().getInstanceClass() == null) {
            return object;
        }
        Class clazz = eTypedElement.getEType().getInstanceClass();
        if (object != null && object instanceof Number) {
            Number number = (Number)object;
            Class<?> clazz2 = object.getClass();
            Class clazz3 = clazz;
            if (clazz.isPrimitive()) {
                clazz3 = EcoreUtil.wrapperClassFor((Class)clazz);
            }
            if (clazz2.equals(clazz3)) {
                return object;
            }
            if (Number.class.isAssignableFrom(clazz3)) {
                if (clazz3.equals(Byte.class)) {
                    return new Byte(number.byteValue());
                }
                if (clazz3.equals(Integer.class)) {
                    return new Integer(number.intValue());
                }
                if (clazz3.equals(Short.class)) {
                    return new Short(number.shortValue());
                }
                if (clazz3.equals(Long.class)) {
                    return new Long(number.longValue());
                }
                if (clazz3.equals(BigInteger.class)) {
                    return BigInteger.valueOf(number.longValue());
                }
                if (clazz3.equals(Float.class)) {
                    return new Float(number.floatValue());
                }
                if (clazz3.equals(Double.class)) {
                    return new Double(number.doubleValue());
                }
                if (clazz3.equals(BigDecimal.class)) {
                    return new BigDecimal(number.doubleValue());
                }
            }
        }
        return object;
    }

    public static final UMLAbstractExpression createNullExpression(EClassifier eClassifier) {
        return new UMLAbstractExpression(eClassifier){

            protected Object doEvaluate(Object object, Map map) {
                return null;
            }
        };
    }

    public static class NoImplException
    extends RuntimeException {
        public NoImplException(String string) {
            super(string);
        }
    }
}

