/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.part;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.ad.part.Messages;
import org.eclipse.epf.diagram.ad.part.UMLDiagramEditorUtil;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class UMLDocumentProvider
extends AbstractDocumentProvider
implements IDiagramDocumentProvider {
    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (!(object instanceof FileEditorInput) && !(object instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.ad", 0, NLS.bind((String)Messages.UMLDocumentProvider_IncorrectInputError, (Object[])new Object[]{object, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"}), null));
        }
        IEditorInput iEditorInput = (IEditorInput)object;
        IDiagramDocument iDiagramDocument = (IDiagramDocument)this.createDocument(iEditorInput);
        ResourceSetInfo resourceSetInfo = new ResourceSetInfo(iDiagramDocument, iEditorInput);
        resourceSetInfo.setModificationStamp(this.computeModificationStamp(resourceSetInfo));
        resourceSetInfo.fStatus = null;
        return resourceSetInfo;
    }

    protected IDocument createDocument(Object object) throws CoreException {
        if (!(object instanceof FileEditorInput) && !(object instanceof URIEditorInput)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.ad", 0, NLS.bind((String)Messages.UMLDocumentProvider_IncorrectInputError, (Object[])new Object[]{object, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"}), null));
        }
        IDocument iDocument = this.createEmptyDocument();
        this.setDocumentContent(iDocument, (IEditorInput)object);
        this.setupDocument(object, iDocument);
        return iDocument;
    }

    protected void setupDocument(Object object, IDocument iDocument) {
    }

    private long computeModificationStamp(ResourceSetInfo resourceSetInfo) {
        int n = 0;
        for (Resource resource : resourceSetInfo.getResourceSet().getResources()) {
            IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
            if (iFile == null) continue;
            n = iFile.getLocation() != null ? (int)((long)n + iFile.getLocation().toFile().lastModified()) : (int)((long)n + iFile.getModificationStamp());
        }
        return n;
    }

    protected IDocument createEmptyDocument() {
        DiagramDocument diagramDocument = new DiagramDocument();
        diagramDocument.setEditingDomain(this.createEditingDomain());
        return diagramDocument;
    }

    private TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain transactionalEditingDomain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
        transactionalEditingDomain.setID("org.eclipse.epf.diagram.ad.EditingDomain");
        final NotificationFilter notificationFilter = NotificationFilter.createNotifierFilter((Object)transactionalEditingDomain.getResourceSet()).and(NotificationFilter.createEventTypeFilter((int)3)).and(NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0));
        transactionalEditingDomain.getResourceSet().eAdapters().add((Object)new Adapter(){
            private Notifier myTarger;

            public Notifier getTarget() {
                return this.myTarger;
            }

            public boolean isAdapterForType(Object object) {
                return false;
            }

            public void notifyChanged(Notification notification) {
                Object object;
                if (notificationFilter.matches(notification) && (object = notification.getNewValue()) instanceof Resource) {
                    ((Resource)object).setTrackingModification(true);
                }
            }

            public void setTarget(Notifier notifier) {
                this.myTarger = notifier;
            }
        });
        return transactionalEditingDomain;
    }

    protected void setDocumentContent(IDocument iDocument, IEditorInput iEditorInput) throws CoreException {
        IDiagramDocument iDiagramDocument = (IDiagramDocument)iDocument;
        TransactionalEditingDomain transactionalEditingDomain = iDiagramDocument.getEditingDomain();
        if (!(iEditorInput instanceof FileEditorInput)) {
            if (iEditorInput instanceof URIEditorInput) {
                URI uRI = ((URIEditorInput)iEditorInput).getURI();
                Resource resource = null;
                try {
                    Object object;
                    resource = transactionalEditingDomain.getResourceSet().getResource(uRI.trimFragment(), false);
                    if (resource == null) {
                        resource = transactionalEditingDomain.getResourceSet().createResource(uRI.trimFragment());
                    }
                    if (!resource.isLoaded()) {
                        try {
                            object = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
                            resource.load(object);
                        }
                        catch (IOException iOException) {
                            resource.unload();
                            throw iOException;
                        }
                    }
                    if (resource == null) {
                        throw new RuntimeException(Messages.UMLDocumentProvider_UnableToLoadResourceError);
                    }
                    if (uRI.fragment() != null) {
                        object = resource.getEObject(uRI.fragment());
                        if (object instanceof Diagram) {
                            iDocument.setContent((Object)((Diagram)object));
                            return;
                        }
                    } else {
                        for (Object e : resource.getContents()) {
                            if (!(e instanceof Diagram)) continue;
                            iDocument.setContent((Object)((Diagram)e));
                            return;
                        }
                    }
                    throw new RuntimeException(Messages.UMLDocumentProvider_NoDiagramInResourceError);
                }
                catch (Exception exception) {
                    String string;
                    CoreException coreException = null;
                    coreException = exception instanceof CoreException ? (CoreException)((Object)exception) : new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.ad", 0, (string = exception.getLocalizedMessage()) != null ? string : Messages.UMLDocumentProvider_DiagramLoadingError, (Throwable)exception));
                    throw coreException;
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.ad", 0, NLS.bind((String)Messages.UMLDocumentProvider_IncorrectInputError, (Object[])new Object[]{iEditorInput, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"}), null));
        }
        IStorage iStorage = ((FileEditorInput)iEditorInput).getStorage();
        Diagram diagram = DiagramIOUtil.load((TransactionalEditingDomain)transactionalEditingDomain, (IStorage)iStorage, (boolean)true, (IProgressMonitor)this.getProgressMonitor());
        iDocument.setContent((Object)diagram);
    }

    public long getModificationStamp(Object object) {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            return this.computeModificationStamp(resourceSetInfo);
        }
        return super.getModificationStamp(object);
    }

    public boolean isDeleted(Object object) {
        Resource resource;
        IDiagramDocument iDiagramDocument = this.getDiagramDocument(object);
        if (iDiagramDocument != null && (resource = iDiagramDocument.getDiagram().eResource()) != null) {
            IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
            return iFile == null || iFile.getLocation() == null || !iFile.getLocation().toFile().exists();
        }
        return super.isDeleted(object);
    }

    public ResourceSetInfo getResourceSetInfo(Object object) {
        return (ResourceSetInfo)super.getElementInfo(object);
    }

    protected void disposeElementInfo(Object object, AbstractDocumentProvider.ElementInfo elementInfo) {
        if (elementInfo instanceof ResourceSetInfo) {
            ResourceSetInfo resourceSetInfo = (ResourceSetInfo)elementInfo;
            resourceSetInfo.dispose();
        }
        super.disposeElementInfo(object, elementInfo);
    }

    protected void doValidateState(Object object, Object object2) throws CoreException {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            ArrayList<IFile> arrayList = new ArrayList<IFile>();
            for (Resource resource : resourceSetInfo.getResourceSet().getResources()) {
                IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
                if (iFile == null || !iFile.isReadOnly()) continue;
                arrayList.add(iFile);
            }
            ResourcesPlugin.getWorkspace().validateEdit(arrayList.toArray(new IFile[arrayList.size()]), object2);
        }
        super.doValidateState(object, object2);
    }

    public boolean isReadOnly(Object object) {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            if (resourceSetInfo.isUpdateCache()) {
                try {
                    this.updateCache(object);
                }
                catch (CoreException coreException) {
                    ActivityDiagramEditorPlugin.getInstance().logError(Messages.UMLDocumentProvider_isModifiable, coreException);
                }
            }
            return resourceSetInfo.isReadOnly();
        }
        return super.isReadOnly(object);
    }

    public boolean isModifiable(Object object) {
        if (!this.isStateValidated(object) && (object instanceof FileEditorInput || object instanceof URIEditorInput)) {
            return true;
        }
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            if (resourceSetInfo.isUpdateCache()) {
                try {
                    this.updateCache(object);
                }
                catch (CoreException coreException) {
                    ActivityDiagramEditorPlugin.getInstance().logError(Messages.UMLDocumentProvider_isModifiable, coreException);
                }
            }
            return resourceSetInfo.isModifiable();
        }
        return super.isModifiable(object);
    }

    protected void updateCache(Object object) throws CoreException {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            for (Resource resource : resourceSetInfo.getResourceSet().getResources()) {
                IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
                if (iFile == null || !iFile.isReadOnly()) continue;
                resourceSetInfo.setReadOnly(true);
                resourceSetInfo.setModifiable(false);
                return;
            }
            resourceSetInfo.setReadOnly(false);
            resourceSetInfo.setModifiable(true);
            return;
        }
    }

    protected void doUpdateStateCache(Object object) throws CoreException {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            resourceSetInfo.setUpdateCache(true);
        }
        super.doUpdateStateCache(object);
    }

    public boolean isSynchronized(Object object) {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            return resourceSetInfo.isSynchronized();
        }
        return super.isSynchronized(object);
    }

    protected ISchedulingRule getResetRule(Object object) {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            ArrayList<ISchedulingRule> arrayList = new ArrayList<ISchedulingRule>();
            for (Resource resource : resourceSetInfo.getResourceSet().getResources()) {
                IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
                if (iFile == null) continue;
                arrayList.add(ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)iFile));
            }
            return new MultiRule(arrayList.toArray(new ISchedulingRule[arrayList.size()]));
        }
        return null;
    }

    protected ISchedulingRule getSaveRule(Object object) {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            ArrayList<ISchedulingRule> arrayList = new ArrayList<ISchedulingRule>();
            for (Resource resource : resourceSetInfo.getResourceSet().getResources()) {
                IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
                if (iFile == null) continue;
                arrayList.add(this.computeSchedulingRule((IResource)iFile));
            }
            return new MultiRule(arrayList.toArray(new ISchedulingRule[arrayList.size()]));
        }
        return null;
    }

    protected ISchedulingRule getSynchronizeRule(Object object) {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            ArrayList<ISchedulingRule> arrayList = new ArrayList<ISchedulingRule>();
            for (Resource resource : resourceSetInfo.getResourceSet().getResources()) {
                IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
                if (iFile == null) continue;
                arrayList.add(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)iFile));
            }
            return new MultiRule(arrayList.toArray(new ISchedulingRule[arrayList.size()]));
        }
        return null;
    }

    protected ISchedulingRule getValidateStateRule(Object object) {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            ArrayList<IFile> arrayList = new ArrayList<IFile>();
            for (Resource resource : resourceSetInfo.getResourceSet().getResources()) {
                IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
                if (iFile == null) continue;
                arrayList.add(iFile);
            }
            return ResourcesPlugin.getWorkspace().getRuleFactory().validateEditRule((IResource[])arrayList.toArray(new IFile[arrayList.size()]));
        }
        return null;
    }

    private ISchedulingRule computeSchedulingRule(IResource iResource) {
        if (iResource.exists()) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(iResource);
        }
        IResource iResource2 = iResource;
        while ((iResource2 = (iResource = iResource2).getParent()) != null && !iResource2.exists()) {
        }
        return ResourcesPlugin.getWorkspace().getRuleFactory().createRule(iResource);
    }

    protected void doSynchronize(Object object, IProgressMonitor iProgressMonitor) throws CoreException {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            for (Resource resource : resourceSetInfo.getResourceSet().getResources()) {
                this.handleElementChanged(resourceSetInfo, resource, iProgressMonitor);
            }
            return;
        }
        super.doSynchronize(object, iProgressMonitor);
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        ResourceSetInfo resourceSetInfo = this.getResourceSetInfo(object);
        if (resourceSetInfo != null) {
            if (!bl && !resourceSetInfo.isSynchronized()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.ad", 0, Messages.UMLDocumentProvider_UnsynchronizedFileSaveError, null));
            }
            resourceSetInfo.stopResourceListening();
            this.fireElementStateChanging(object);
            EList eList = resourceSetInfo.getResourceSet().getResources();
            try {
                try {
                    iProgressMonitor.beginTask(Messages.UMLDocumentProvider_SaveDiagramTask, eList.size() + 1);
                    for (Resource resource : eList) {
                        iProgressMonitor.setTaskName(NLS.bind((String)Messages.UMLDocumentProvider_SaveNextResourceTask, (Object)resource.getURI()));
                        if (resource.isLoaded()) {
                            try {
                                resource.save(UMLDiagramEditorUtil.getSaveOptions());
                            }
                            catch (IOException iOException) {
                                this.fireElementStateChangeFailed(object);
                                throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.ad", 5, iOException.getLocalizedMessage(), null));
                            }
                        }
                        iProgressMonitor.worked(1);
                    }
                    iProgressMonitor.done();
                }
                catch (RuntimeException runtimeException) {
                    this.fireElementStateChangeFailed(object);
                    throw runtimeException;
                }
            }
            finally {
                resourceSetInfo.startResourceListening();
            }
        }
    }

    protected void handleElementChanged(ResourceSetInfo resourceSetInfo, Resource resource, IProgressMonitor iProgressMonitor) {
        IFile iFile = WorkspaceSynchronizer.getFile((Resource)resource);
        if (iFile != null) {
            try {
                iFile.refreshLocal(2, iProgressMonitor);
            }
            catch (CoreException coreException) {
                ActivityDiagramEditorPlugin.getInstance().logError(Messages.UMLDocumentProvider_handleElementContentChanged, coreException);
            }
        }
        resource.unload();
        this.fireElementContentAboutToBeReplaced(resourceSetInfo.getEditorInput());
        this.removeUnchangedElementListeners(resourceSetInfo.getEditorInput(), resourceSetInfo);
        resourceSetInfo.fStatus = null;
        try {
            this.setDocumentContent(resourceSetInfo.fDocument, resourceSetInfo.getEditorInput());
        }
        catch (CoreException coreException) {
            resourceSetInfo.fStatus = coreException.getStatus();
        }
        if (!resourceSetInfo.fCanBeSaved) {
            resourceSetInfo.setModificationStamp(this.computeModificationStamp(resourceSetInfo));
        }
        this.addUnchangedElementListeners(resourceSetInfo.getEditorInput(), resourceSetInfo);
        this.fireElementContentReplaced(resourceSetInfo.getEditorInput());
    }

    protected void handleElementMoved(IEditorInput iEditorInput, URI uRI) {
        if (iEditorInput instanceof FileEditorInput) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(URI.decode((String)uRI.path())).removeFirstSegments(1));
            this.fireElementMoved(iEditorInput, iFile == null ? null : new FileEditorInput(iFile));
            return;
        }
        this.fireElementMoved(iEditorInput, new URIEditorInput(uRI));
    }

    public IEditorInput createInputWithEditingDomain(IEditorInput iEditorInput, TransactionalEditingDomain transactionalEditingDomain) {
        return iEditorInput;
    }

    public IDiagramDocument getDiagramDocument(Object object) {
        IDocument iDocument = this.getDocument(object);
        if (iDocument instanceof IDiagramDocument) {
            return (IDiagramDocument)iDocument;
        }
        return null;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor iProgressMonitor) {
        return null;
    }

    protected class ResourceSetInfo
    extends AbstractDocumentProvider.ElementInfo {
        private long myModificationStamp;
        private WorkspaceSynchronizer mySynchronizer;
        private Collection myUnSynchronizedResources;
        private IDiagramDocument myDocument;
        private IEditorInput myEditorInput;
        private boolean myUpdateCache;
        private boolean myModifiable;
        private boolean myReadOnly;
        private ResourceSetModificationListener myResourceSetListener;

        public ResourceSetInfo(IDiagramDocument iDiagramDocument, IEditorInput iEditorInput) {
            super((AbstractDocumentProvider)UMLDocumentProvider.this, (IDocument)iDiagramDocument);
            this.myModificationStamp = -1L;
            this.myUnSynchronizedResources = new ArrayList();
            this.myUpdateCache = true;
            this.myModifiable = false;
            this.myReadOnly = true;
            this.myDocument = iDiagramDocument;
            this.myEditorInput = iEditorInput;
            this.startResourceListening();
            this.myResourceSetListener = new ResourceSetModificationListener(this);
            this.getResourceSet().eAdapters().add((Object)this.myResourceSetListener);
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        public void setModificationStamp(long l) {
            this.myModificationStamp = l;
        }

        public ResourceSet getResourceSet() {
            return this.myDocument.getEditingDomain().getResourceSet();
        }

        public IEditorInput getEditorInput() {
            return this.myEditorInput;
        }

        public void dispose() {
            this.stopResourceListening();
            this.getResourceSet().eAdapters().remove((Object)this.myResourceSetListener);
            for (Resource resource : this.getResourceSet().getResources()) {
                resource.unload();
            }
        }

        public boolean isSynchronized() {
            return this.myUnSynchronizedResources.size() == 0;
        }

        public void setUnSynchronized(Resource resource) {
            this.myUnSynchronizedResources.add(resource);
        }

        public void setSynchronized(Resource resource) {
            this.myUnSynchronizedResources.remove(resource);
        }

        public final void stopResourceListening() {
            this.mySynchronizer.dispose();
            this.mySynchronizer = null;
        }

        public final void startResourceListening() {
            this.mySynchronizer = new WorkspaceSynchronizer(this.myDocument.getEditingDomain(), (WorkspaceSynchronizer.Delegate)new SynchronizerDelegate());
        }

        public boolean isUpdateCache() {
            return this.myUpdateCache;
        }

        public void setUpdateCache(boolean bl) {
            this.myUpdateCache = bl;
        }

        public boolean isModifiable() {
            return this.myModifiable;
        }

        public void setModifiable(boolean bl) {
            this.myModifiable = bl;
        }

        public boolean isReadOnly() {
            return this.myReadOnly;
        }

        public void setReadOnly(boolean bl) {
            this.myReadOnly = bl;
        }

        private class SynchronizerDelegate
        implements WorkspaceSynchronizer.Delegate {
            private SynchronizerDelegate() {
            }

            public void dispose() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean handleResourceChanged(final Resource resource) {
                ResourceSetInfo resourceSetInfo = ResourceSetInfo.this;
                synchronized (resourceSetInfo) {
                    if (ResourceSetInfo.this.fCanBeSaved) {
                        ResourceSetInfo.this.setUnSynchronized(resource);
                        return true;
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        UMLDocumentProvider.this.handleElementChanged(ResourceSetInfo.this, resource, null);
                    }
                });
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean handleResourceDeleted(Resource resource) {
                ResourceSetInfo resourceSetInfo = ResourceSetInfo.this;
                synchronized (resourceSetInfo) {
                    if (ResourceSetInfo.this.fCanBeSaved) {
                        ResourceSetInfo.this.setUnSynchronized(resource);
                        return true;
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        UMLDocumentProvider.this.fireElementDeleted(ResourceSetInfo.this.getEditorInput());
                    }
                });
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean handleResourceMoved(Resource resource, final URI uRI) {
                ResourceSetInfo resourceSetInfo = ResourceSetInfo.this;
                synchronized (resourceSetInfo) {
                    if (ResourceSetInfo.this.fCanBeSaved) {
                        ResourceSetInfo.this.setUnSynchronized(resource);
                        return true;
                    }
                }
                if (ResourceSetInfo.this.myDocument.getDiagram().eResource() == resource) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            UMLDocumentProvider.this.handleElementMoved(ResourceSetInfo.this.getEditorInput(), uRI);
                        }
                    });
                    return true;
                }
                this.handleResourceDeleted(resource);
                return true;
            }
        }
    }

    private class ResourceSetModificationListener
    extends EContentAdapter {
        private NotificationFilter myModifiedFilter;
        private ResourceSetInfo myInfo;

        public ResourceSetModificationListener(ResourceSetInfo resourceSetInfo) {
            this.myInfo = resourceSetInfo;
            this.myModifiedFilter = NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2)).and(NotificationFilter.createFeatureFilter(Resource.class, (int)3));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyChanged(Notification notification) {
            Resource resource;
            if (notification.getNotifier() instanceof ResourceSet) {
                super.notifyChanged(notification);
            }
            if (!notification.isTouch() && this.myModifiedFilter.matches(notification) && notification.getNotifier() instanceof Resource && (resource = (Resource)notification.getNotifier()).isLoaded()) {
                Object object;
                boolean bl = false;
                Iterator iterator = this.myInfo.getResourceSet().getResources().iterator();
                while (iterator.hasNext() && !bl) {
                    object = (Resource)iterator.next();
                    if (!object.isLoaded()) continue;
                    bl = object.isModified();
                }
                boolean bl2 = false;
                object = this.myInfo;
                synchronized (object) {
                    if (bl != this.myInfo.fCanBeSaved) {
                        this.myInfo.fCanBeSaved = bl;
                        bl2 = true;
                    }
                    if (!resource.isModified()) {
                        this.myInfo.setSynchronized(resource);
                    }
                }
                if (bl2) {
                    UMLDocumentProvider.this.fireElementDirtyStateChanged(this.myInfo.getEditorInput(), bl);
                    if (!bl) {
                        this.myInfo.setModificationStamp(UMLDocumentProvider.this.computeModificationStamp(this.myInfo));
                    }
                }
            }
        }
    }
}

