/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.wizards;

import org.eclipse.epf.export.msp.ui.ExportMSPUIPlugin;
import org.eclipse.epf.export.msp.ui.ExportMSPUIResources;
import org.eclipse.epf.export.msp.ui.preferences.ExportMSPUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class SelectExportDirectoryPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectExportDirectoryPage.class.getName();
    protected Shell shell;
    protected Composite composite;
    protected Composite templateComposite;
    protected Combo projectNameCombo;
    protected Combo exportDirCombo;
    protected Button browseButton;
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            SelectExportDirectoryPage.this.setPageComplete(SelectExportDirectoryPage.this.isPageComplete());
        }
    };

    public SelectExportDirectoryPage(String string) {
        super(string);
        this.setTitle(ExportMSPUIResources.selectExportDirWizardPage_title);
        this.setDescription(ExportMSPUIResources.selectExportDirWizardPage_text);
        this.setImageDescriptor(ExportMSPUIPlugin.getDefault().getImageDescriptor("full/wizban/exp_ms_prj_wizban.gif"));
    }

    public SelectExportDirectoryPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite composite) {
        this.shell = composite.getShell();
        this.composite = SelectExportDirectoryPage.createGridLayoutComposite((Composite)composite, (int)1);
        this.templateComposite = SelectExportDirectoryPage.createGridLayoutComposite((Composite)this.composite, (int)3);
        SelectExportDirectoryPage.createLabel((Composite)this.templateComposite, (String)ExportMSPUIResources.projectNameLabel_text);
        this.projectNameCombo = SelectExportDirectoryPage.createCombobox((Composite)this.templateComposite, (int)2);
        SelectExportDirectoryPage.createLabel((Composite)this.templateComposite, (String)ExportMSPUIResources.dirLabel_text);
        this.exportDirCombo = SelectExportDirectoryPage.createCombobox((Composite)this.templateComposite);
        this.browseButton = SelectExportDirectoryPage.createButton((Composite)this.templateComposite, (String)ExportMSPUIResources.browseButton_text);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void initControls() {
        String[] stringArray;
        String[] stringArray2 = ExportMSPUIPreferences.getMSProjectNames();
        if (stringArray2 != null && stringArray2.length > 0) {
            this.projectNameCombo.setItems(stringArray2);
            this.projectNameCombo.setText(stringArray2[0]);
        }
        if ((stringArray = ExportMSPUIPreferences.getExportDirectories()) != null && stringArray.length > 0) {
            this.exportDirCombo.setItems(stringArray);
            this.exportDirCombo.setText(stringArray[0]);
        }
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    DirectoryDialog directoryDialog = new DirectoryDialog(SelectExportDirectoryPage.this.shell, 0);
                    String string = directoryDialog.open();
                    if (string != null) {
                        SelectExportDirectoryPage.this.exportDirCombo.add(string, 0);
                        SelectExportDirectoryPage.this.exportDirCombo.setText(string);
                    }
                }
                catch (Exception exception) {
                    ExportMSPUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        });
    }

    protected void addListeners() {
        this.projectNameCombo.addModifyListener(this.modifyListener);
        this.exportDirCombo.addModifyListener(this.modifyListener);
    }

    public boolean isPageComplete() {
        return this.getMSProjectName().length() > 0 && this.getExportDirectory().length() > 0;
    }

    public String getMSProjectName() {
        return this.projectNameCombo.getText().trim();
    }

    public String getExportDirectory() {
        return this.exportDirCombo.getText().trim();
    }

    public void dispose() {
        ExportMSPUIPreferences.addMSProjectName(this.getMSProjectName());
        ExportMSPUIPreferences.addExportDir(this.getExportDirectory());
        this.modifyListener = null;
        super.dispose();
    }
}

