/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.DeleteRoleDescriptor;
import org.eclipse.epf.library.edit.process.command.DeleteTaskDescriptor;
import org.eclipse.epf.library.edit.process.command.DeleteTeamProfile;
import org.eclipse.epf.library.edit.process.command.DeleteUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.process.command.DeleteWorkProductDescriptor;
import org.eclipse.epf.library.edit.process.command.ProcessElementDeleteCommand;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDeleteAction
extends MethodElementDeleteAction {
    private boolean deletionConfirmed = false;
    private HashSet<Descriptor> removedDescriptors;

    public ProcessDeleteAction() {
    }

    public ProcessDeleteAction(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public ProcessDeleteAction(EditingDomain editingDomain, boolean bl) {
        super(editingDomain, bl);
    }

    @Override
    public DeleteMethodElementCommand createMethodElementDeleteCommand() {
        return new ProcessElementDeleteCommand(RemoveCommand.create((EditingDomain)this.domain, (Collection)this.selection), this.selection, this.confirm);
    }

    public void run(IActionManager iActionManager) {
        if (this.confirmDelete()) {
            Iterator iterator = this.selection.iterator();
            while (iterator.hasNext()) {
                this.removeReferences(iActionManager, iterator.next());
            }
            this.domain.getCommandStack().execute(this.command);
        }
    }

    protected void saveCurrentEditor() {
    }

    @Override
    protected String getDeleteConfirmationMessage() {
        return LibraryUIResources.ProcessDeleteAction_deletecofirm_text;
    }

    protected Command createDeleteUnusedDescriptorsCommand(Collection<Descriptor> collection, Collection<?> collection2) {
        return new DeleteUnusedDescriptorsCommand(collection, false, collection2){

            protected Command delete(List list) {
                return ProcessDeleteAction.delete(list);
            }
        };
    }

    @Override
    public void run() {
        if (this.confirmDelete()) {
            block8: {
                HashSet<Descriptor> hashSet = new HashSet<Descriptor>();
                for (Object object : this.selection) {
                    ProcessDeleteAction.addRelatedDescriptors(hashSet, object);
                }
                Command command = this.command;
                command.execute();
                if (((DeleteMethodElementCommand)command).executed) {
                    Object object;
                    this.deletionConfirmed = true;
                    object = command.getResult();
                    Command command2 = this.createDeleteUnusedDescriptorsCommand((Collection<Descriptor>)hashSet, (Collection<?>)object);
                    try {
                        try {
                            command2.execute();
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            command2.dispose();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        command2.dispose();
                        throw throwable;
                    }
                    command2.dispose();
                }
            }
            this.saveCurrentEditor();
        }
    }

    private static void addRelatedDescriptors(Collection<Descriptor> collection, Object object) {
        if (object instanceof TaskDescriptor) {
            TaskDescriptor taskDescriptor = (TaskDescriptor)object;
            collection.addAll(taskDescriptor.getAdditionallyPerformedBy());
            collection.addAll(taskDescriptor.getAssistedBy());
            collection.add((Descriptor)taskDescriptor.getPerformedPrimarilyBy());
            collection.addAll(taskDescriptor.getMandatoryInput());
            collection.addAll(taskDescriptor.getExternalInput());
            collection.addAll(taskDescriptor.getOptionalInput());
            collection.addAll(taskDescriptor.getOutput());
        } else if (object instanceof RoleDescriptor) {
            RoleDescriptor roleDescriptor = (RoleDescriptor)object;
            collection.addAll(AssociationHelper.getAssistedTaskDescriptors((RoleDescriptor)roleDescriptor));
            collection.addAll(AssociationHelper.getAdditionalTaskDescriptors((RoleDescriptor)roleDescriptor));
            collection.addAll(AssociationHelper.getPrimaryTaskDescriptors((RoleDescriptor)roleDescriptor));
            collection.addAll(roleDescriptor.getResponsibleFor());
        }
    }

    private void removeReferences(IActionManager iActionManager, Object object) {
        boolean bl;
        DeleteTaskDescriptor deleteTaskDescriptor = null;
        boolean bl2 = bl = !this.confirm;
        if (object instanceof TaskDescriptor) {
            deleteTaskDescriptor = new DeleteTaskDescriptor((TaskDescriptor)object, bl);
        } else if (object instanceof RoleDescriptor) {
            deleteTaskDescriptor = new DeleteRoleDescriptor((RoleDescriptor)object, bl);
        } else if (object instanceof WorkProductDescriptor) {
            deleteTaskDescriptor = new DeleteWorkProductDescriptor((WorkProductDescriptor)object, bl);
        } else if (object instanceof TeamProfile) {
            deleteTaskDescriptor = new DeleteTeamProfile((TeamProfile)object);
        }
        if (deleteTaskDescriptor != null) {
            if (iActionManager != null) {
                iActionManager.execute((IResourceAwareCommand)deleteTaskDescriptor);
            } else {
                deleteTaskDescriptor.execute();
            }
            if (deleteTaskDescriptor instanceof RemoveUnusedDescriptorsCommand) {
                this.removedDescriptors.addAll(((RemoveUnusedDescriptorsCommand)deleteTaskDescriptor).getRemovedDescriptors());
            }
        }
    }

    public boolean updateSelection(IStructuredSelection iStructuredSelection) {
        boolean bl = super.updateSelection(ProcessDeleteAction.filterSelection(iStructuredSelection));
        return bl;
    }

    public static IStructuredSelection filterSelection(IStructuredSelection iStructuredSelection) {
        ArrayList arrayList = new ArrayList();
        for (Object e : iStructuredSelection) {
            if (e instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)e).isReadOnly()) continue;
            arrayList.add(e);
        }
        return new StructuredSelection(arrayList);
    }

    public boolean isDeletionConfirmed() {
        return this.deletionConfirmed;
    }

    protected Command getCommand() {
        return this.command;
    }

    public static Command delete(Collection collection) {
        ProcessDeleteAction processDeleteAction = new ProcessDeleteAction(null, false){

            public Command createCommand(Collection collection) {
                this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
                return super.createCommand(collection);
            }
        };
        if (processDeleteAction.updateSelection((IStructuredSelection)new StructuredSelection(new ArrayList(collection)))) {
            processDeleteAction.run();
            if (!processDeleteAction.isDeletionConfirmed()) {
                throw new OperationCanceledException();
            }
            return processDeleteAction.getCommand();
        }
        return null;
    }
}

