/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.dialogs.LibraryBackupDialog;
import org.eclipse.swt.widgets.Shell;

public class LibraryBackupUtil {
    private String path = null;

    public static void promptBackupCurrentLibrary(Shell shell, ILibraryService iLibraryService) {
        String string = iLibraryService.getCurrentMethodLibraryLocation();
        File file = new File(string);
        new LibraryBackupUtil().doBackup(shell, file, iLibraryService);
    }

    public static void promptBackupLibrary(Shell shell, File file) {
        new LibraryBackupUtil().doBackup(shell, file, null);
    }

    private void doBackup(final Shell shell, final File file, ILibraryService iLibraryService) {
        this.path = null;
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String string;
                String string2;
                String string3;
                LibraryBackupDialog libraryBackupDialog;
                Shell shell2 = shell;
                if (shell2 == null) {
                    shell2 = MsgBox.getDefaultShell();
                }
                if (shell2 == null) {
                    shell2 = new Shell(MsgBox.getDisplay());
                }
                if ((libraryBackupDialog = new LibraryBackupDialog(shell2, string3 = LibraryUIResources.backupLibraryDialog_title, string2 = LibraryUIResources.backupLibraryDialog_text, string = String.valueOf(file.getAbsolutePath()) + ".backup")).open() == 0) {
                    LibraryBackupUtil.this.path = libraryBackupDialog.getPath();
                }
            }
        });
        if (this.path != null) {
            if (iLibraryService == null) {
                LibraryBackupUtil.backup(file, new File(this.path));
            } else {
                iLibraryService.getCurrentLibraryManager().backupMethodLibrary(this.path);
            }
        }
    }

    public static void backup(final File file, final File file2) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String string = ".lock";
                    LayoutResources.copyDir((File)file, (File)file2, (String)"**", (String)string);
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
        };
        UserInteractionHelper.runWithProgress((Runnable)runnable, (String)LibraryUIResources.backingUpLibraryTask_name);
    }
}

