/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.LibraryResourceException;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.FilePathProvider;
import org.eclipse.epf.persistence.IURIProvider;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.TxRecord;
import org.eclipse.epf.persistence.UnnormalizedURIException;
import org.eclipse.epf.persistence.refresh.IRefreshEvent;
import org.eclipse.epf.persistence.refresh.IRefreshListener;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.refresh.internal.RefreshEvent;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.persistence.util.UnresolvedProxyMarkerManager;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.IProxyResolutionListener;
import org.eclipse.epf.uma.ecore.IUmaResourceSet;
import org.eclipse.epf.uma.ecore.ResolveException;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFileResourceSetImpl
extends ResourceSetImpl
implements IProxyResolutionListener,
IUmaResourceSet,
ILibraryResourceSet {
    private static final String[] DEFAULT_DELIVERY_PROCESS_PATH = new String[]{"DeliveryProcesses"};
    private static final String[] DEFAULT_CAPABILITY_PATTERN_PATH = new String[]{"Content", "CapabilityPatterns"};
    private static final String[] DEFAULT_PROCESS_CONTRIBUTION_PATH = new String[]{"ProcessContributions"};
    public static final String[][] PROCESS_PACKAGE_PATHS = new String[][]{DEFAULT_DELIVERY_PROCESS_PATH, DEFAULT_CAPABILITY_PATTERN_PATH, DEFAULT_PROCESS_CONTRIBUTION_PATH};
    public static boolean REPORT_ERROR = true;
    static final Map DEFAULT_SAVE_OPTIONS = new HashMap();
    static final Set DEFAULT_SAVE_SEPARATELY_CLASS_SET = new HashSet();
    public static final String RESMGR_XMI = "resmgr.xmi";
    private HashMap defaultSaveOptions;
    private HashMap guidToMethodElementMap;
    private boolean loading;
    private boolean loadingResourceManagerTree;
    private Map URIToTempURIMap;
    private UnresolvedProxyMarkerManager markerMananger = new UnresolvedProxyMarkerManager((ResourceSet)this);
    private UniqueEList<IRefreshListener> refreshListeners;
    protected IURIProvider uriProvider;
    private Path configFolderPath;
    private Path libFolderPath;

    static {
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getMethodPlugin());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getProcessComponent());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getContentDescription());
        DEFAULT_SAVE_SEPARATELY_CLASS_SET.add(UmaPackage.eINSTANCE.getMethodConfiguration());
        XMLResource.XMLMap xMLMap = MultiFileResourceSetImpl.createSaveXMLMap();
        HashSet<EClass> hashSet = new HashSet<EClass>();
        hashSet.add(UmaPackage.eINSTANCE.getBreakdownElementDescription());
        DEFAULT_SAVE_OPTIONS.put("SAVE_SEPARATELY_CLASS_SET", DEFAULT_SAVE_SEPARATELY_CLASS_SET);
        DEFAULT_SAVE_OPTIONS.put("SAVE_ALL", "false");
        DEFAULT_SAVE_OPTIONS.put("SAVE_TOGETHER_CLASS_SET", hashSet);
        DEFAULT_SAVE_OPTIONS.put("REFRESH_NEW_RESOURCE", "true");
        DEFAULT_SAVE_OPTIONS.put("CHECK_MODIFY", "true");
        DEFAULT_SAVE_OPTIONS.put("ENCODING", "UTF-8");
        DEFAULT_SAVE_OPTIONS.put("PROCESS_DANGLING_HREF", "DISCARD");
        DEFAULT_SAVE_OPTIONS.put("XML_MAP", xMLMap);
        DEFAULT_SAVE_OPTIONS.put("CONFIGURATION_CACHE", Boolean.TRUE);
        AssociationHelper.init();
    }

    private static XMLResource.XMLMap createLoadXMLMap() {
        XMLMapImpl xMLMapImpl = new XMLMapImpl();
        HashSet<EAttribute> hashSet = new HashSet<EAttribute>();
        hashSet.add(UmaPackage.eINSTANCE.getMethodElement_Guid());
        hashSet.add(UmaPackage.eINSTANCE.getNamedElement_Name());
        for (EClassifier eClassifier : UmaPackage.eINSTANCE.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EAttribute eAttribute : eClass.getEAttributes()) {
                if (hashSet.contains(eAttribute)) continue;
                XMLInfoImpl xMLInfoImpl = new XMLInfoImpl();
                xMLInfoImpl.setName(eAttribute.getName());
                xMLInfoImpl.setXMLRepresentation(0);
                xMLMapImpl.add((ENamedElement)eAttribute, (XMLResource.XMLInfo)xMLInfoImpl);
            }
        }
        return xMLMapImpl;
    }

    private static boolean saveAttributeAsElement(EClass eClass, Collection collection) {
        for (EClass eClass2 : collection) {
            if (!eClass2.isSuperTypeOf(eClass)) continue;
            return true;
        }
        return false;
    }

    private static XMLResource.XMLMap createSaveXMLMap() {
        XMLMapImpl xMLMapImpl = new XMLMapImpl();
        HashSet<EAttribute> hashSet = new HashSet<EAttribute>();
        hashSet.add(UmaPackage.eINSTANCE.getMethodElement_Guid());
        hashSet.add(UmaPackage.eINSTANCE.getNamedElement_Name());
        HashSet<EClass> hashSet2 = new HashSet<EClass>();
        hashSet2.add(UmaPackage.eINSTANCE.getContentDescription());
        hashSet2.add(UmaPackage.eINSTANCE.getSection());
        for (EClassifier eClassifier : UmaPackage.eINSTANCE.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || !MultiFileResourceSetImpl.saveAttributeAsElement(eClass = (EClass)eClassifier, hashSet2)) continue;
            for (EAttribute eAttribute : eClass.getEAttributes()) {
                if (hashSet.contains(eAttribute)) continue;
                XMLInfoImpl xMLInfoImpl = new XMLInfoImpl();
                xMLInfoImpl.setName(eAttribute.getName());
                xMLInfoImpl.setXMLRepresentation(0);
                xMLMapImpl.add((ENamedElement)eAttribute, (XMLResource.XMLInfo)xMLInfoImpl);
            }
        }
        return xMLMapImpl;
    }

    public MultiFileResourceSetImpl() {
    }

    public MultiFileResourceSetImpl(boolean bl) {
        this();
        this.markerMananger.setEnabled(bl);
    }

    public UnresolvedProxyMarkerManager getUnresolvedProxyMarkerManager() {
        return this.markerMananger;
    }

    protected IURIProvider getURIProvider() {
        if (this.uriProvider == null) {
            this.uriProvider = new FilePathProvider();
        }
        return this.uriProvider;
    }

    private void handleResourceChange(IResource iResource) {
        System.out.println("MultiFileResourceSetImpl.handleResourceChange(): " + iResource.toString());
        MultiFileXMIResourceImpl multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)this.getResource(URI.createFileURI((String)iResource.getLocation().toString()), false);
        if (multiFileXMIResourceImpl != null) {
            try {
                ArrayList arrayList = new ArrayList();
                multiFileXMIResourceImpl.reload(arrayList);
                NotificationImpl notificationImpl = new NotificationImpl(11, false, true);
                for (EObject eObject : arrayList) {
                    eObject.eNotify((Notification)notificationImpl);
                }
            }
            catch (IOException iOException) {
                CommonPlugin.INSTANCE.log((Object)iOException);
            }
        }
    }

    public Map getLoadOptions() {
        Map map = super.getLoadOptions();
        map.put("ENCODING", "UTF-8");
        map.put("XML_MAP", MultiFileResourceSetImpl.createLoadXMLMap());
        return map;
    }

    public Map getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
            this.defaultSaveOptions.putAll(DEFAULT_SAVE_OPTIONS);
        }
        return this.defaultSaveOptions;
    }

    private Resource getMethodLibraryResource() {
        if (this.getResources().isEmpty()) {
            return null;
        }
        return (Resource)this.getResources().get(0);
    }

    public MethodLibrary getMethodLibrary() {
        Resource resource = this.getMethodLibraryResource();
        return resource == null ? null : (MethodLibrary)PersistenceUtil.getMethodElement(resource);
    }

    protected ResourceManager getRootResourceManager() {
        Resource resource = this.getMethodLibraryResource();
        return resource == null ? null : MultiFileSaveUtil.getResourceManager(resource);
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new MultiFileURIConverter(this);
        }
        return this.uriConverter;
    }

    public Resource getResource(URI uRI) {
        Resource resource;
        block7: {
            if (this.getURIConverter().normalize(uRI) == null) {
                return null;
            }
            resource = null;
            try {
                resource = super.getResource(uRI, false);
                if (resource != null) break block7;
                Map map = this.getURIResourceMap();
                resource = this.createResource(uRI);
                try {
                    this.demandLoadHelper(resource);
                }
                catch (RuntimeException runtimeException) {
                    this.getResources().remove((Object)resource);
                    throw runtimeException;
                }
                if (map != null) {
                    map.put(uRI, resource);
                }
            }
            catch (WrappedException wrappedException) {
                if (wrappedException.exception() instanceof FileNotFoundException) {
                    return null;
                }
                throw wrappedException;
            }
        }
        return resource;
    }

    protected void demandLoad(Resource resource) throws IOException {
        super.demandLoad(resource);
        boolean bl = FileManager.getInstance().refresh(resource);
        if (MultiFileSaveUtil.DEBUG && !bl) {
            System.err.println("MultiFileResourceSetImpl.demandLoad(): could not refresh resource " + resource);
        }
    }

    public void resolveContainer(Resource resource) {
        MethodLibrary methodLibrary = this.getMethodLibrary();
        if (this.loading && methodLibrary == null) {
            return;
        }
        for (Object e : resource.getContents()) {
            Object v;
            Resource resource2;
            ResourceDescriptor resourceDescriptor;
            MethodElement methodElement;
            if (!(e instanceof MethodElement) || (methodElement = (MethodElement)e) == methodLibrary || methodElement.eContainer() != null || (resourceDescriptor = MultiFileSaveUtil.getResourceDescriptor(resource)) == null || !((resource2 = resourceDescriptor.eResource()) instanceof XMLResourceImpl) || !((v = ((XMLResourceImpl)resource2).getIDToEObjectMap().get(methodElement.getGuid())) instanceof EObject)) continue;
            EObject eObject = (EObject)v;
            EReference eReference = eObject.eContainmentFeature();
            EObject eObject2 = eObject.eContainer();
            if (eObject2 == null) continue;
            if (eReference.isMany()) {
                List list = (List)eObject2.eGet((EStructuralFeature)eReference);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            } else {
                eObject2.eGet((EStructuralFeature)eReference);
            }
            this.resolveContainer(resource2);
        }
    }

    public Resource getResource(URI uRI, boolean bl) {
        if (this.getURIConverter().normalize(uRI) == null) {
            return null;
        }
        Resource resource = null;
        try {
            resource = super.getResource(uRI, bl);
        }
        catch (RuntimeException runtimeException) {
            String string = null;
            string = runtimeException.getMessage() != null ? NLS.bind((String)PersistenceResources.loadResourceErrorWithReason_msg, (Object[])new Object[]{uRI, runtimeException.getMessage()}) : NLS.bind((String)PersistenceResources.loadResourceError_msg, (Object)uRI);
            this.handleException(string);
            throw runtimeException;
        }
        return resource;
    }

    @Override
    public void addRefreshListener(IRefreshListener iRefreshListener) {
        if (this.refreshListeners == null) {
            this.refreshListeners = new UniqueEList();
        }
        this.refreshListeners.add((Object)iRefreshListener);
    }

    @Override
    public void removeRefreshListenter(IRefreshListener iRefreshListener) {
        if (this.refreshListeners != null) {
            this.refreshListeners.remove((Object)iRefreshListener);
        }
    }

    public void notifyRefreshListeners(IRefreshEvent iRefreshEvent) {
        if (this.refreshListeners != null && !this.refreshListeners.isEmpty()) {
            for (IRefreshListener iRefreshListener : this.refreshListeners) {
                try {
                    iRefreshListener.notifyRefreshed(iRefreshEvent);
                }
                catch (Exception exception) {
                    PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
    }

    public synchronized Collection reloadResources(Collection collection) {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        for (Object object42 : collection) {
            if (MultiFileSaveUtil.DEBUG) {
                System.out.println("MultiFileResourceSetImpl.reloadResources(): resource=" + object42 + ", element=" + PersistenceUtil.getMethodElement((Resource)object42));
            }
            if ((object3 = MultiFileSaveUtil.getResourceDescriptor((Resource)object42)) == null) continue;
            ((MultiFileXMIResourceImpl)object42).setResourceDescriptor((ResourceDescriptor)object3);
        }
        ArrayList arrayList = new ArrayList();
        object42 = new HashSet();
        object3 = new ArrayList(collection);
        Resource resource = this.getMethodLibraryResource();
        boolean bl = false;
        if (((ArrayList)object3).remove(resource)) {
            object2 = (MultiFileXMIResourceImpl)resource;
            this.markerMananger.clearMarkers((Resource)object2);
            try {
                if (((MultiFileXMIResourceImpl)object2).reload((Collection)object42)) {
                    arrayList.add(object2);
                    object = (MultiFileURIConverter)this.getURIConverter();
                    ((MultiFileURIConverter)((Object)object)).resMgr = null;
                    bl = true;
                }
            }
            catch (IOException iOException) {
                CommonPlugin.INSTANCE.log((Object)iOException);
            }
        }
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            object = (MultiFileXMIResourceImpl)object2.next();
            this.markerMananger.clearMarkers((Resource)object);
            try {
                if (!((MultiFileXMIResourceImpl)object).reload((Collection)object42)) continue;
                arrayList.add(object);
            }
            catch (IOException iOException) {
                CommonPlugin.INSTANCE.log((Object)iOException);
            }
        }
        if (!arrayList.isEmpty()) {
            this.initialize(bl);
            if (this.refreshListeners != null) {
                object2 = new RefreshEvent(arrayList, (Collection<EObject>)object42);
                for (IRefreshListener iRefreshListener : new ArrayList<IRefreshListener>((Collection<IRefreshListener>)this.refreshListeners)) {
                    iRefreshListener.notifyRefreshed((IRefreshEvent)object2);
                }
            }
        }
        return arrayList;
    }

    public void initialize(boolean bl) {
        this.loadResourceManagerTree();
        this.setContainersOfLoadedElements();
        if (bl) {
            this.loadConfigurations();
        }
        this.loadOppositeFeatures();
        MultiFileURIConverter multiFileURIConverter = (MultiFileURIConverter)this.getURIConverter();
        multiFileURIConverter.resMgr = null;
    }

    private void setContainersOfLoadedElements() {
        ResourceManager resourceManager = this.getRootResourceManager();
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(resourceManager, false){
            private static final long serialVersionUID = 2172691017987702506L;

            protected Iterator getChildren(Object object) {
                InternalEObject internalEObject;
                ResourceManager resourceManager = (ResourceManager)object;
                HashSet<String> hashSet = new HashSet<String>();
                ArrayList<ResourceManager> arrayList = new ArrayList<ResourceManager>(resourceManager.getSubManagers());
                Resource resource = arrayList.iterator();
                while (resource.hasNext()) {
                    internalEObject = (InternalEObject)resource.next();
                    if (internalEObject == null || internalEObject.eIsProxy()) continue;
                    MethodElement methodElement = PersistenceUtil.getMethodElement(internalEObject.eResource());
                    hashSet.add(methodElement.getGuid());
                }
                resource = resourceManager.eResource();
                if (resource != null) {
                    internalEObject = PersistenceUtil.getMethodElement(resource);
                    MultiFileSaveUtil.resolveProxies(hashSet, (EObject)internalEObject);
                }
                return resourceManager.getSubManagers().iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            abstractTreeIterator.next();
        }
    }

    public boolean isLibraryResource(IResource iResource) {
        return this.libFolderPath != null && this.libFolderPath.isPrefixOf(iResource.getLocation());
    }

    public boolean isNewResourceToLoad(IResource iResource) {
        IPath iPath = iResource.getLocation();
        return iPath != null && this.configFolderPath != null && ".xmi".equalsIgnoreCase("." + iPath.getFileExtension()) && this.configFolderPath.isPrefixOf(iPath) && !FileManager.getInstance().isTeamPrivate(iPath.toString());
    }

    public void loadNewResources(Collection<IResource> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IResource object : collection) {
            IResource iResource;
            IPath iPath;
            if (!(object instanceof IResource) || (iPath = (iResource = object).getLocation()) == null || this.configFolderPath == null || !".xmi".equalsIgnoreCase("." + iPath.getFileExtension()) || !this.configFolderPath.isPrefixOf(iPath)) continue;
            String string = iPath.toString();
            if (FileManager.getInstance().isTeamPrivate(string)) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            this.loadConfiguration(new File(string));
        }
    }

    protected Collection<Resource> loadConfigurations() {
        MethodLibrary methodLibrary = this.getMethodLibrary();
        File file = new File(new File(methodLibrary.eResource().getURI().toFileString()).getParent(), "configurations");
        return this.loadConfigurations(file);
    }

    protected Collection<Resource> loadConfigurations(File file) {
        File file2;
        Object object;
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        Iterator iterator = MultiFileSaveUtil.listConfigFiles(file);
        HashSet<Object> hashSet = new HashSet<Object>();
        while (iterator.hasNext()) {
            object = (File)iterator.next();
            if (!((File)object).isFile()) continue;
            hashSet.add(object);
        }
        object = this.getMethodLibrary();
        for (MethodConfiguration object2 : object.getPredefinedConfigurations()) {
            file2 = new File(object2.eResource().getURI().toFileString());
            if (!hashSet.contains(file2)) continue;
            hashSet.remove(file2);
        }
        for (File file3 : hashSet) {
            file2 = this.loadConfiguration(file3);
            if (file2 == null) continue;
            arrayList.add((Resource)file2);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Resource loadConfiguration(File file) {
        try {
            MethodLibrary methodLibrary = this.getMethodLibrary();
            URI uRI = URI.createFileURI((String)file.getCanonicalPath());
            Resource resource = super.getResource(uRI, true);
            if (resource == null) return null;
            MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
            if (methodElement instanceof MethodConfiguration) {
                if (!PersistenceUtil.hasDuplicateGUID(methodElement, methodLibrary.getPredefinedConfigurations())) {
                    methodLibrary.getPredefinedConfigurations().add(methodElement);
                    return resource;
                }
                PersistencePlugin.getDefault().getLogger().logError(NLS.bind((String)PersistenceResources.loadConfiguration_couldNotLoad_logMsg, (Object)file));
            } else {
                PersistencePlugin.getDefault().getLogger().logError(NLS.bind((String)PersistenceResources.loadConfiguration_notConfigFile_logMsg, (Object)file));
            }
            this.getResources().remove((Object)resource);
            return null;
        }
        catch (Exception exception) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        return null;
    }

    protected void handleException(Object object) {
        if (object instanceof Throwable) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)((Exception)object));
        } else {
            PersistencePlugin.getDefault().getLogger().logError(object.toString());
        }
        if (MultiFileSaveUtil.DEBUG) {
            if (object instanceof Throwable) {
                ((Exception)object).printStackTrace();
            } else {
                System.err.println(object.toString());
            }
        }
    }

    public void reset() {
        if (this.uriConverter instanceof MultiFileURIConverter) {
            ((MultiFileURIConverter)this.uriConverter).dispose();
        }
        this.uriConverter = null;
        boolean bl = this.eDeliver();
        boolean bl2 = REPORT_ERROR;
        boolean bl3 = RefreshJob.getInstance().isEnabled();
        try {
            if (RefreshJob.getInstance().getResourceSet() == this) {
                RefreshJob.getInstance().setEnabled(false);
                RefreshJob.getInstance().reset();
            }
            this.eSetDeliver(false);
            REPORT_ERROR = false;
            this.markerMananger.setEnabled(false);
            this.markerMananger.clearAll();
            for (Resource resource : new ArrayList(this.getResources())) {
                try {
                    resource.unload();
                }
                catch (Exception exception) {}
            }
            this.clearErrors();
        }
        finally {
            this.eSetDeliver(bl);
            REPORT_ERROR = bl2;
            this.markerMananger.setEnabled(true);
            if (RefreshJob.getInstance().getResourceSet() == this) {
                RefreshJob.getInstance().setEnabled(bl3);
            }
        }
        if (this.guidToMethodElementMap != null) {
            this.guidToMethodElementMap.clear();
        }
        this.getResources().clear();
        if (this.URIToTempURIMap != null) {
            this.URIToTempURIMap.clear();
        }
        MultiFileXMIResourceImpl.clearDetachedEObjectToIDMap();
    }

    private void clearErrors() {
        this.markerMananger.clearAll();
    }

    public MethodLibrary loadLibrary(String string) throws Exception {
        long l = System.currentTimeMillis();
        this.reset();
        long l2 = System.currentTimeMillis();
        if (MultiFileSaveUtil.DEBUG) {
            System.out.println("Reset time: " + (l2 - l));
        }
        MethodLibrary methodLibrary = this.loadLibraryWithoutReset(string);
        if (MultiFileSaveUtil.DEBUG) {
            System.out.println("Load time: " + (System.currentTimeMillis() - l));
        }
        if (MultiFileSaveUtil.DEBUG) {
            System.err.println("Modified resources after loading:");
            for (Resource resource : this.getResources()) {
                if (!resource.isModified()) continue;
                System.err.println("  " + resource.getURI());
            }
        }
        return methodLibrary;
    }

    protected Resource loadLibraryResource(String string) {
        URI uRI = URI.createFileURI((String)string);
        Resource resource = super.getResource(uRI, true);
        if (!resource.getErrors().isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PersistenceResources.loadLibraryError_msg);
            for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                stringBuffer.append(NLS.bind((String)PersistenceResources.loadLibraryError_details, (Object[])new Object[]{String.valueOf(diagnostic.getLine()), String.valueOf(diagnostic.getColumn()), diagnostic.getMessage()}));
            }
            String string2 = stringBuffer.toString();
            CommonPlugin.INSTANCE.log((Object)string2);
            if (MultiFileSaveUtil.DEBUG) {
                System.err.println(string2);
            }
        }
        return resource;
    }

    public MethodLibrary loadLibraryWithoutReset(String string) throws Exception {
        this.loading = true;
        boolean bl = RefreshJob.getInstance().isEnabled();
        if (RefreshJob.getInstance().getResourceSet() == this) {
            RefreshJob.getInstance().setEnabled(false);
            RefreshJob.getInstance().reset();
        }
        boolean bl2 = this.markerMananger.isAutoScheduled();
        this.markerMananger.setAutoScheduled(false);
        try {
            File file = new File(string);
            this.configFolderPath = new Path(new File(file.getParentFile(), "configurations").getCanonicalPath());
            this.libFolderPath = new Path(file.getParentFile().getCanonicalPath());
            Resource resource = this.loadLibraryResource(file.getCanonicalPath());
            try {
                this.initialize(true);
                if (resource != null) {
                    resource.setModified(false);
                }
                MethodLibrary methodLibrary = this.getMethodLibrary();
                return methodLibrary;
            }
            catch (Exception exception) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
                throw new Exception(NLS.bind((String)PersistenceResources.invalidLibraryFileError_msg, (Object)string));
            }
        }
        finally {
            if (RefreshJob.getInstance().getResourceSet() == this) {
                RefreshJob.getInstance().setEnabled(bl);
            }
            this.markerMananger.setAutoScheduled(bl2);
            this.markerMananger.start();
            this.loading = false;
        }
    }

    private void loadOppositeFeatures() {
        ArrayList<OppositeFeature> arrayList = new ArrayList<OppositeFeature>();
        for (OppositeFeature oppositeFeature : AssociationHelper.getPredefinedOppositeFeatures()) {
            if (!oppositeFeature.resolveOwner()) continue;
            arrayList.add(oppositeFeature);
        }
        this.loadOppositeFeatures(arrayList);
    }

    private void loadResourceManagerTree() {
        long l = 0L;
        if (MultiFileSaveUtil.DEBUG) {
            l = System.currentTimeMillis();
        }
        this.markerMananger.setEnabled(false);
        MultiFileURIConverter multiFileURIConverter = (MultiFileURIConverter)this.getURIConverter();
        try {
            multiFileURIConverter.setResolveProxy(false);
            ResourceManager resourceManager = this.getRootResourceManager();
            AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(resourceManager, false){
                private static final long serialVersionUID = 2172691017987702506L;

                protected Iterator getChildren(Object object) {
                    ResourceManager resourceManager = (ResourceManager)object;
                    return resourceManager.getSubManagers().iterator();
                }
            };
            this.loadingResourceManagerTree = true;
            while (abstractTreeIterator.hasNext()) {
                abstractTreeIterator.next();
            }
        }
        finally {
            this.markerMananger.setEnabled(true);
            multiFileURIConverter.setResolveProxy(true);
            this.loadingResourceManagerTree = false;
            try {
                for (InternalEObject internalEObject : new ArrayList(this.getGuidToMethodElementMap().values())) {
                    if (!internalEObject.eIsProxy() || internalEObject.eContainer() == null) continue;
                    URI uRI = internalEObject.eProxyURI();
                    URI uRI2 = this.getURIConverter().normalize(uRI);
                    if (uRI2 != null) continue;
                    ((InternalEObject)internalEObject.eContainer()).eResolveProxy(internalEObject);
                }
            }
            catch (Exception exception) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        if (MultiFileSaveUtil.DEBUG) {
            System.out.println("MultiFileResourceSetImpl.loadResourceManagerTree(): " + (System.currentTimeMillis() - l));
        }
    }

    protected ResourceManager getResourceManager() {
        return ((MultiFileURIConverter)this.getURIConverter()).getResourceManager();
    }

    protected EObject findEObjectInUnloadedResources(String string) {
        return this.findEObjectInUnloadedResources(this.getResourceManager(), string);
    }

    private EObject findEObjectInUnloadedResources(ResourceManager resourceManager, String string) {
        for (ResourceDescriptor resourceDescriptor : resourceManager.getResourceDescriptors()) {
            EObject eObject;
            Resource resource = super.getResource(resourceDescriptor.getResolvedURI(), false);
            if (resource != null && resource.isLoaded()) continue;
            try {
                resource = super.getResource(resourceDescriptor.getResolvedURI(), true);
            }
            catch (Exception exception) {}
            if (resource == null || (eObject = resource.getEObject(string)) == null) continue;
            return eObject;
        }
        Iterator<Object> iterator = resourceManager.getSubManagers().iterator();
        while (iterator.hasNext()) {
            ResourceDescriptor resourceDescriptor;
            resourceDescriptor = this.findEObjectInUnloadedResources((ResourceManager)iterator.next(), string);
            if (resourceDescriptor == null) continue;
            return resourceDescriptor;
        }
        return null;
    }

    @Override
    public EObject getEObject(String string) {
        EObject eObject = (EObject)this.getGuidToMethodElementMap().get(string);
        if (eObject != null) {
            return eObject;
        }
        URI uRI = MultiFileURIConverter.createURI(string).appendFragment(string);
        URI uRI2 = this.getURIConverter().normalize(uRI);
        if (uRI2 == null) {
            eObject = this.findEObjectInUnloadedResources(string);
            if (eObject == null && REPORT_ERROR) {
                this.handleException(NLS.bind((String)PersistenceResources.objNotFoundError_msg, (Object)string));
            }
            return eObject;
        }
        try {
            return this.getEObject(uRI, true);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public EObject getEObject(URI uRI, boolean bl) {
        return this.getEObject(null, uRI, bl);
    }

    public Resource createResource(URI uRI) {
        Resource resource = this.doCreateResource(uRI);
        resource.setTrackingModification(true);
        this.getResources().add((Object)resource);
        return resource;
    }

    protected Resource doCreateResource(URI uRI) {
        return new MultiFileXMIResourceImpl(uRI);
    }

    private static boolean backupRequired(Map map) {
        Boolean bl = (Boolean)map.get("BACK_UP_BEFORE_SAVE");
        return bl != null && bl != false;
    }

    private void backup(Resource resource) {
        try {
            if (resource.getContents().isEmpty()) {
                return;
            }
            Object object = resource.getContents().get(0);
            if (!(object instanceof MethodLibrary || object instanceof ResourceManager || object instanceof MethodPlugin)) {
                return;
            }
            MethodLibrary methodLibrary = this.getMethodLibrary();
            String string = String.valueOf(new File(methodLibrary.eResource().getURI().toFileString()).getParent()) + File.separator + ".bak";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss.S");
            if (resource == methodLibrary.eResource()) {
                DateFormat.getInstance().format(Calendar.getInstance().getTime());
                File file = new File(string, "library.xmi_" + simpleDateFormat.format(Calendar.getInstance().getTime()));
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileUtil.moveFile((File)new File(resource.getURI().toFileString()), (File)file);
            } else {
                String string2 = resource.getURI().deresolve(methodLibrary.eResource().getURI()).toFileString();
                File file = new File(string, String.valueOf(string2) + '_' + simpleDateFormat.format(Calendar.getInstance().getTime()));
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                FileUtil.moveFile((File)new File(resource.getURI().toFileString()), (File)file);
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
            this.handleException(NLS.bind((String)PersistenceResources.backupError_msg, (Object)resource));
        }
    }

    void removeURIMappings(EObject eObject, Set set) {
        ResourceDescriptor resourceDescriptor;
        ResourceManager resourceManager = MultiFileSaveUtil.getResourceManager(eObject.eResource());
        if (resourceManager != null && resourceManager.eContainer() != null) {
            EcoreUtil.remove((EObject)resourceManager);
        }
        if ((resourceManager = this.getRootResourceManager()) != null && (resourceDescriptor = MultiFileSaveUtil.findResourceDescriptor(resourceManager, MultiFileSaveUtil.getGuid(eObject), null, true)) != null) {
            if (set != null && resourceDescriptor.eResource() != null) {
                set.add(resourceDescriptor.eResource());
            }
            EcoreUtil.remove((EObject)resourceDescriptor);
        }
    }

    protected void cleanUp(Resource resource) throws IOException {
        this.cleanUp(resource, null);
    }

    void cleanUp(Resource resource, Set set) throws IOException {
        try {
            if (resource.getContents().isEmpty()) {
                resource.unload();
                try {
                    resource.load(null);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.getResources().remove((Object)resource);
                    URI uRI = ((MultiFileXMIResourceImpl)resource).getOldURI();
                    if (uRI != null) {
                        this.getURIToTempURIMap().remove(uRI);
                    }
                    return;
                }
            }
            MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
            this.removeURIMappings((EObject)methodElement, set);
            resource.unload();
        }
        finally {
            this.getResources().remove((Object)resource);
            URI uRI = ((MultiFileXMIResourceImpl)resource).getOldURI();
            if (uRI != null) {
                this.getURIToTempURIMap().remove(uRI);
            }
        }
    }

    private void cleanUp(ProcessPackage processPackage) {
        this.removeContentDescriptions(processPackage);
        EcoreUtil.remove((EObject)processPackage);
    }

    private void removeContentDescriptions(ProcessPackage processPackage) {
        for (Object object : processPackage.getProcessElements()) {
            if (!ContentDescriptionFactory.hasPresentation((MethodElement)object) || object.getPresentation().eResource() == null) continue;
            this.removePresentation((ProcessElement)object);
        }
        for (Object object : processPackage.getChildPackages()) {
            if (!(object instanceof ProcessPackage)) continue;
            this.removeContentDescriptions((ProcessPackage)object);
        }
    }

    private void removePresentation(ProcessElement processElement) {
        Resource resource = processElement.getPresentation().eResource();
        resource.getContents().remove((Object)processElement.getPresentation());
    }

    private boolean save(Collection collection, Map map, boolean bl) throws Exception {
        if (map == null) {
            map = this.getDefaultSaveOptions();
        }
        HashSet hashSet = new HashSet();
        map.put("MODIFIED_RESOURCE_SET", hashSet);
        try {
            for (Resource resource : collection) {
                this.save(resource, map, bl);
            }
            this.saveModifiedResources(map);
            return true;
        }
        finally {
            map.remove("MODIFIED_RESOURCE_SET");
        }
    }

    boolean save(Resource resource, Map map, boolean bl) throws Exception {
        Set set = (Set)map.get("MODIFIED_RESOURCE_SET");
        TxRecord txRecord = (TxRecord)map.get("TX_RECORD");
        List list = txRecord != null ? txRecord.getResourcesToCommit() : null;
        try {
            MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
            if (methodElement != null) {
                if (bl) {
                    if (methodElement instanceof ProcessComponent) {
                        ProcessComponent processComponent = (ProcessComponent)methodElement;
                        Resource resource2 = processComponent.getProcess() != null && ContentDescriptionFactory.hasPresentation((MethodElement)processComponent.getProcess()) ? processComponent.getProcess().getPresentation().eResource() : null;
                        boolean bl2 = resource2 != null && resource2.isModified();
                        this.prepareSave(processComponent);
                        if (resource2 != null && resource2.isModified() && !bl2) {
                            set.add(resource2);
                        }
                    } else if (methodElement instanceof MethodPlugin) {
                        MultiFileSaveUtil.addResourceManager(resource);
                    }
                }
                if (resource.isModified()) {
                    boolean bl3 = MultiFileResourceSetImpl.backupRequired(map);
                    if (bl3) {
                        this.backup(resource);
                    }
                    if (list != null) {
                        ((MultiFileXMIResourceImpl)resource).setTempURI(txRecord.getTxID());
                        list.add(resource);
                    }
                    MultiFileSaveUtil.save(resource, map);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
            throw exception;
        }
        return false;
    }

    public boolean save(Resource resource, Map map) throws Exception {
        if (resource == null || resource.getContents().isEmpty()) {
            return false;
        }
        if (map == null) {
            map = this.getDefaultSaveOptions();
        }
        HashSet hashSet = new HashSet();
        map.put("MODIFIED_RESOURCE_SET", hashSet);
        boolean bl = map.get("TX_RECORD") == null;
        try {
            Collection collection;
            boolean bl2;
            ArrayList<Resource> arrayList = null;
            if (bl) {
                arrayList = new ArrayList<Resource>();
            }
            if ((bl2 = this.save(resource, map, true)) && bl) {
                arrayList.add(resource);
            }
            if (!(collection = this.saveModifiedResources(map)).isEmpty()) {
                bl2 = true;
                if (bl) {
                    arrayList.addAll(collection);
                }
            }
            if (bl && bl2) {
                for (Object e : arrayList) {
                    if (!(e instanceof MultiFileXMIResourceImpl)) continue;
                    ((MultiFileXMIResourceImpl)e).updateTimeStamps();
                }
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            map.remove("MODIFIED_RESOURCE_SET");
        }
    }

    public void save(Map map) throws LibraryResourceException {
        try {
            this.save(map, false, true);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new LibraryResourceException(exception);
        }
    }

    Collection saveModifiedResources(Map map) throws LibraryResourceException {
        List list;
        Set set = (Set)map.get("MODIFIED_RESOURCE_SET");
        TxRecord txRecord = (TxRecord)map.get("TX_RECORD");
        List list2 = list = txRecord != null ? txRecord.getResourcesToCommit() : null;
        if (set == null) {
            return Collections.EMPTY_LIST;
        }
        boolean bl = MultiFileResourceSetImpl.backupRequired(map);
        boolean bl2 = MultiFileXMISaveImpl.checkModifyRequired(map);
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        while (!set.isEmpty()) {
            ArrayList<Resource> arrayList2 = new ArrayList<Resource>(set);
            set.clear();
            if (bl2) {
                this.checkModify(arrayList2);
                if (list != null) {
                    MultiFileSaveUtil.checkOutOfSynch(arrayList2, map);
                }
            }
            for (Resource resource : arrayList2) {
                if (bl) {
                    this.backup(resource);
                }
                if (list != null) {
                    ((MultiFileXMIResourceImpl)resource).setTempURI(txRecord.getTxID());
                    list.add(resource);
                }
                if (!MultiFileSaveUtil.save(resource, map)) continue;
                arrayList.add(resource);
            }
        }
        return arrayList;
    }

    public void save(Map map, boolean bl) throws Exception {
        this.save(map, bl, false);
    }

    protected void save(Map map, boolean bl, boolean bl2) throws Exception {
        block19: {
            if (map == null) {
                map = new HashMap(this.getDefaultSaveOptions());
            }
            MethodLibrary methodLibrary = this.getMethodLibrary();
            MultiFileSaveUtil.setGuid((MethodElement)methodLibrary);
            this.prepareSave(methodLibrary);
            this.cleanUp();
            MultiFileURIConverter multiFileURIConverter = (MultiFileURIConverter)this.getURIConverter();
            multiFileURIConverter.setLibraryURIs(methodLibrary);
            HashSet hashSet = new HashSet();
            map.put("MODIFIED_RESOURCE_SET", hashSet);
            MethodLibraryPersister.FailSafePersister failSafePersister = null;
            if (bl2) {
                failSafePersister = MethodLibraryPersister.INSTANCE.getFailSafePersister(map);
                map = failSafePersister.getSaveOptions();
            }
            try {
                try {
                    Object object2;
                    EList eList = this.getResources();
                    int n = eList.size();
                    MultiFileResourceSetImpl.backupRequired(map);
                    ArrayList<Resource> arrayList = new ArrayList<Resource>();
                    ArrayList<Resource> arrayList2 = new ArrayList<Resource>();
                    int n2 = 0;
                    while (n2 < n) {
                        MethodElement object3;
                        object2 = (Resource)eList.get(n2);
                        if (object2.isModified() && MultiFileSaveUtil.adjustLocationRequired((MultiFileXMIResourceImpl)object2)) {
                            arrayList2.add((Resource)object2);
                        }
                        if ((object3 = PersistenceUtil.getMethodElement((Resource)object2)) != null && object3 instanceof MethodElement && (bl || object2.isModified())) {
                            arrayList.add((Resource)object2);
                        }
                        ++n2;
                    }
                    if (arrayList.isEmpty()) break block19;
                    Resource resource = this.getMethodLibraryResource();
                    if (!arrayList.contains(resource) && PersistenceUtil.checkToolVersion(resource) != 0) {
                        arrayList.add(resource);
                    }
                    if (MultiFileXMISaveImpl.checkModifyRequired(map)) {
                        this.checkModify(arrayList);
                    }
                    if (bl2) {
                        try {
                            this.save(arrayList, map, false);
                            failSafePersister.commit();
                            failSafePersister.adjustLocation(arrayList2);
                            break block19;
                        }
                        catch (Exception exception) {
                            failSafePersister.rollback();
                            throw exception;
                        }
                    }
                    for (Resource resource2 : arrayList) {
                        if (!MultiFileSaveUtil.save(resource2, map) || !(resource2 instanceof MultiFileXMIResourceImpl)) continue;
                        ((MultiFileXMIResourceImpl)resource2).updateTimeStamps();
                    }
                    for (Resource resource3 : arrayList2) {
                        MultiFileSaveUtil.adjustLocation(resource3, hashSet);
                    }
                    object2 = this.saveModifiedResources(map);
                    if (object2 != null) {
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            Resource resource4 = (Resource)iterator.next();
                            if (!(resource4 instanceof MultiFileXMIResourceImpl)) continue;
                            ((MultiFileXMIResourceImpl)resource4).updateTimeStamps();
                        }
                    }
                }
                catch (Exception exception) {
                    this.handleException(exception);
                    throw exception;
                }
            }
            finally {
                map.remove("MODIFIED_RESOURCE_SET");
            }
        }
    }

    public void saveAs(String string, boolean bl, IProgressMonitor iProgressMonitor) throws Exception {
        Object object;
        EObject eObject;
        MethodLibrary methodLibrary = this.getMethodLibrary();
        if (methodLibrary == null) {
            return;
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setTaskName(PersistenceResources.loadResourcesTask_name);
        }
        TreeIterator treeIterator = methodLibrary.eAllContents();
        while (treeIterator.hasNext()) {
            eObject = (EObject)treeIterator.next();
            if (bl && eObject instanceof MethodElement) {
                ((MethodElement)eObject).setGuid(UmaUtil.generateGUID());
            }
            object = eObject.eCrossReferences().iterator();
            while (object.hasNext()) {
                object.next();
            }
        }
        treeIterator = URI.createFileURI((String)(String.valueOf(new File(methodLibrary.eResource().getURI().toFileString()).getParent()) + File.separator));
        eObject = URI.createFileURI((String)(String.valueOf(string) + File.separator));
        for (Resource resource : this.getResources()) {
            resource.setURI(resource.getURI().replacePrefix((URI)treeIterator, (URI)eObject));
        }
        object = ((MultiFileURIConverter)this.getURIConverter()).getResourceManager();
        if (object != null) {
            object.getResourceDescriptors().clear();
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.setTaskName(PersistenceResources.saveLibraryTask_name);
        }
        this.save(null, true);
    }

    protected boolean unloadWithoutRemove(MultiFileXMIResourceImpl multiFileXMIResourceImpl) {
        MethodLibrary methodLibrary;
        MethodElement methodElement = PersistenceUtil.getMethodElement(multiFileXMIResourceImpl);
        multiFileXMIResourceImpl.unloadWithoutRemove();
        if (methodElement instanceof MethodConfiguration && (methodLibrary = this.getMethodLibrary()) != null) {
            methodLibrary.getPredefinedConfigurations().remove(methodElement);
        }
        return true;
    }

    private void cleanUp() throws IOException {
        MethodLibrary methodLibrary = this.getMethodLibrary();
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        EList eList = this.getResources();
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            Resource resource = (Resource)eList.get(n2);
            boolean bl = false;
            if (resource.getContents().isEmpty()) {
                System.out.println("MultiFileResourceSetImpl.cleanUp(): empty resource: " + resource);
                bl = true;
            } else {
                MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
                if (methodElement == null || methodElement != methodLibrary && methodElement.eContainer() == null) {
                    if (methodElement == null) {
                        System.out.println("MultiFileResourceSetImpl.cleanUp(): resource without any MethodElement: " + resource);
                        bl = true;
                    } else if (methodElement != methodLibrary && methodElement.eContainer() == null) {
                        System.out.println("MultiFileResourceSetImpl.cleanUp(): resource without a container: " + resource);
                    }
                }
            }
            if (bl) {
                arrayList.add(resource);
            }
            ++n2;
        }
        System.out.println("MultiFileResourceSetImpl.cleanUp(): removed resources: " + arrayList);
        for (Resource resource : arrayList) {
            try {
                this.cleanUp(resource);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
    }

    private void prepareSave(MethodLibrary methodLibrary) {
        MultiFileXMIResourceImpl multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)methodLibrary.eResource();
        ResourceManager resourceManager = MultiFileSaveUtil.addResourceManager(multiFileXMIResourceImpl);
        if (resourceManager != null) {
            MultiFileSaveUtil.registerWithResourceManager(resourceManager, methodLibrary, multiFileXMIResourceImpl.getFinalURI());
        }
        List list = methodLibrary.getMethodPlugins();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            this.prepareSave((MethodPlugin)list.get(n2));
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            MultiFileResourceSetImpl.cleanUp((MethodPlugin)list.get(n2));
            ++n2;
        }
    }

    private static void cleanUp(MethodPlugin methodPlugin) {
        int n = 0;
        while (n < PROCESS_PACKAGE_PATHS.length) {
            ProcessPackage processPackage = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])PROCESS_PACKAGE_PATHS[n]);
            if (processPackage != null) {
                MultiFileResourceSetImpl.cleanUpProcesses(processPackage);
            }
            ++n;
        }
    }

    private void prepareSave(MethodPlugin methodPlugin) {
        int n = 0;
        while (n < PROCESS_PACKAGE_PATHS.length) {
            ProcessPackage processPackage = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])PROCESS_PACKAGE_PATHS[n]);
            if (processPackage != null) {
                this.prepareSave(processPackage);
            }
            ++n;
        }
    }

    private static void cleanUpProcesses(ProcessPackage processPackage) {
        List list = processPackage.getChildPackages();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (e instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)e;
                ArrayList arrayList = new ArrayList();
                for (Object e2 : processComponent.getChildPackages()) {
                    if (!(e2 instanceof ProcessPackage)) continue;
                    MultiFileResourceSetImpl.getRemovedPackages((ProcessPackage)e2, arrayList);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    EcoreUtil.remove((EObject)((EObject)iterator.next()));
                }
            }
            ++n2;
        }
    }

    private static void getRemovedPackages(ProcessPackage processPackage, List list) {
        Activity activity = MultiFileResourceSetImpl.getActivity(processPackage);
        if (activity == null || MultiFileResourceSetImpl.getParent((BreakdownElement)activity) == null) {
            list.add(processPackage);
        } else {
            for (Object e : processPackage.getChildPackages()) {
                if (!(e instanceof ProcessPackage)) continue;
                MultiFileResourceSetImpl.getRemovedPackages((ProcessPackage)e, list);
            }
        }
    }

    private static Activity getActivity(ProcessPackage processPackage) {
        Activity activity = null;
        for (Object e : processPackage.getProcessElements()) {
            if (!(e instanceof Activity)) continue;
            activity = (Activity)e;
            break;
        }
        return activity;
    }

    private static Object getParent(BreakdownElement breakdownElement) {
        return UmaUtil.getParentActivity((BreakdownElement)breakdownElement);
    }

    private void prepareSave(ProcessPackage processPackage) {
        List list = processPackage.getChildPackages();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list.get(n2);
            if (e instanceof ProcessComponent) {
                this.prepareSave((ProcessComponent)e);
            }
            ++n2;
        }
    }

    private void prepareSave(ProcessComponent processComponent) {
        Process process = processComponent.getProcess();
        if (process != null) {
            MultiFileResourceSetImpl.prepareSave((Activity)process);
            MultiFileResourceSetImpl.cleanUpDanglingDescriptors((ProcessPackage)processComponent);
            ArrayList arrayList = new ArrayList();
            for (Object e : new ArrayList(processComponent.getChildPackages())) {
                if (!(e instanceof ProcessPackage)) continue;
                ProcessPackage processPackage = (ProcessPackage)e;
                this.reorganize(processPackage, arrayList);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.cleanUp((ProcessPackage)iterator.next());
            }
        }
    }

    private static void prepareSave(Activity activity) {
        MethodElement methodElement;
        Object object;
        ProcessPackage processPackage = (ProcessPackage)activity.eContainer();
        List list = activity.getBreakdownElements();
        for (EObject eObject : list) {
            if (eObject instanceof Activity || eObject.eContainer() != null) continue;
            processPackage.getProcessElements().add(eObject);
        }
        for (EObject eObject : activity.getLinkToPredecessor()) {
            if (eObject.eContainer() == null) {
                if (eObject.getPred() == null || MultiFileResourceSetImpl.getParent((BreakdownElement)eObject.getPred()) == null) continue;
                processPackage.getProcessElements().add(eObject);
                continue;
            }
            if (eObject.getPred() != null && MultiFileResourceSetImpl.getParent((BreakdownElement)eObject.getPred()) != null) continue;
            if (MultiFileSaveUtil.DEBUG) {
                System.err.println("Invalid WorkOrder: " + eObject);
            }
            processPackage.getProcessElements().remove(eObject);
        }
        Iterator iterator = processPackage.getDiagrams().iterator();
        while (iterator.hasNext()) {
            EObject eObject;
            eObject = (Diagram)iterator.next();
            object = eObject.getSemanticModel();
            if (!(object instanceof UMASemanticModelBridge) || !((methodElement = ((UMASemanticModelBridge)object).getElement()) instanceof Activity) || methodElement instanceof Process || MultiFileResourceSetImpl.getParent((BreakdownElement)((Activity)methodElement)) != null) continue;
            iterator.remove();
        }
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            object = list.get(n2);
            if (object instanceof Activity) {
                methodElement = (Activity)object;
                if (methodElement.eContainer() == null) {
                    ProcessPackage processPackage2 = UmaFactory.eINSTANCE.createProcessPackage();
                    processPackage2.setName(methodElement.getName());
                    processPackage2.getProcessElements().add(methodElement);
                    ArrayList arrayList = new ArrayList();
                    int n3 = 0;
                    while (n3 < methodElement.getBreakdownElements().size()) {
                        Object e = methodElement.getBreakdownElements().get(n3);
                        if (e instanceof Descriptor) {
                            arrayList.add(e);
                        }
                        ++n3;
                    }
                    processPackage2.getProcessElements().addAll(arrayList);
                    processPackage.getChildPackages().add(processPackage2);
                }
                MultiFileResourceSetImpl.prepareSave((Activity)methodElement);
            }
            ++n2;
        }
    }

    private static void cleanUpDanglingDescriptors(ProcessPackage processPackage) {
        Iterator iterator = processPackage.getProcessElements().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof BreakdownElement) || ((BreakdownElement)e).getSuperActivities() != null) continue;
            boolean bl = false;
            if (e instanceof RoleDescriptor) {
                if (AssociationHelper.getTeamProfiles((RoleDescriptor)((RoleDescriptor)e)).isEmpty()) {
                    bl = true;
                }
            } else if (e instanceof WorkProductDescriptor) {
                if (AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)((WorkProductDescriptor)e)).isEmpty()) {
                    bl = true;
                }
            } else if (e instanceof TeamProfile) {
                if (((TeamProfile)e).getSuperTeam() == null) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            iterator.remove();
        }
    }

    private void reorganize(ProcessPackage processPackage, List list) {
        EObject eObject;
        Activity activity = MultiFileResourceSetImpl.getActivity(processPackage);
        if (activity == null) {
            return;
        }
        if (!processPackage.getName().equals(activity.getName())) {
            processPackage.setName(activity.getName());
        }
        if ((eObject = (EObject)MultiFileResourceSetImpl.getParent((BreakdownElement)activity)) == null) {
            list.add(processPackage);
        } else if (eObject != MultiFileResourceSetImpl.getActivity((ProcessPackage)processPackage.eContainer())) {
            ProcessPackage processPackage2 = (ProcessPackage)eObject.eContainer();
            processPackage2.getChildPackages().add(processPackage);
        }
        if (eObject != null) {
            MultiFileResourceSetImpl.cleanUpDanglingDescriptors(processPackage);
        }
        for (Object e : processPackage.getChildPackages()) {
            if (!(e instanceof ProcessPackage)) continue;
            this.reorganize((ProcessPackage)e, list);
        }
    }

    public Map getGuidToMethodElementMap() {
        if (this.guidToMethodElementMap == null) {
            this.guidToMethodElementMap = new HashMap();
        }
        return this.guidToMethodElementMap;
    }

    public void eNotify(Notification notification) {
        try {
            super.eNotify(notification);
        }
        catch (RuntimeException runtimeException) {
            CommonPlugin.INSTANCE.log((Object)("ERROR notifying changes: resourceSet=" + this + ", notification=" + notification));
            CommonPlugin.INSTANCE.log((Object)runtimeException);
            runtimeException.printStackTrace();
        }
    }

    public void addMarker(Exception exception) {
        block2: {
            try {
                this.markerMananger.notifyException(exception);
            }
            catch (RuntimeException runtimeException) {
                CommonPlugin.INSTANCE.log((Object)runtimeException);
                if (!MultiFileSaveUtil.DEBUG) break block2;
                runtimeException.printStackTrace();
            }
        }
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public void notifyException(Exception exception) {
        if (this.loadingResourceManagerTree && exception instanceof ResolveException && ((ResolveException)exception).exception() instanceof MultiFileIOException) {
            return;
        }
        try {
            this.addMarker(exception);
        }
        catch (Exception exception2) {}
    }

    public void proxyResolved(Object object, Object object2) {
        String string;
        if (object2 instanceof MethodElement && (string = MultiFileSaveUtil.getGuid(object2)) != null) {
            this.getGuidToMethodElementMap().put(string, object2);
        }
        this.markerMananger.proxyResolved(object, object2);
    }

    private EObject getEObjectByGUID(String string) {
        return (EObject)this.getGuidToMethodElementMap().get(string);
    }

    public EObject getEObject(EObject eObject, URI uRI, boolean bl) {
        URI uRI2 = ((MultiFileURIConverter)this.getURIConverter()).normalize(uRI, eObject);
        if (uRI2 == null) {
            String string = uRI.fragment();
            EObject eObject2 = this.getEObjectByGUID(string);
            if (eObject2 != null) {
                return eObject2;
            }
            String string2 = NLS.bind((String)PersistenceResources.normalizeURIError_msg, (Object)uRI);
            throw new UnnormalizedURIException(string2);
        }
        Resource resource = this.getResource(uRI2.trimFragment(), bl);
        if (resource != null) {
            String string = uRI2.fragment();
            if (string == null || string.length() == 0) {
                return PersistenceUtil.getMethodElement(resource);
            }
            EObject eObject3 = resource.getEObject(string);
            if (eObject3 == null && !string.equals(uRI.authority())) {
                return this.getEObjectByGUID(string);
            }
            return eObject3;
        }
        return null;
    }

    public void loadOppositeFeatures(List list) {
        int n = list.size() - 1;
        if (n < 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.getGuidToMethodElementMap().values());
        HashSet hashSet = new HashSet();
        while (!arrayList.isEmpty()) {
            for (Object v : arrayList) {
                if (!(v instanceof MethodElement)) continue;
                MethodElement methodElement = (MethodElement)v;
                int n2 = n;
                while (n2 > -1) {
                    EStructuralFeature eStructuralFeature = ((OppositeFeature)list.get(n2)).getTargetFeature();
                    if (eStructuralFeature.getContainerClass().isInstance(methodElement)) {
                        if (eStructuralFeature.isMany()) {
                            InternalEList internalEList = (InternalEList)methodElement.eGet(eStructuralFeature);
                            if (!internalEList.isEmpty()) {
                                Iterator iterator = internalEList.iterator();
                                while (iterator.hasNext()) {
                                    iterator.next();
                                }
                            }
                        } else {
                            methodElement.eGet(eStructuralFeature);
                        }
                    }
                    --n2;
                }
            }
            hashSet.addAll(arrayList);
            arrayList = new ArrayList(this.getGuidToMethodElementMap().values());
            arrayList.removeAll(hashSet);
        }
    }

    public void loadOppositeFeatures(List list, Set set) {
        int n = list.size() - 1;
        if (n < 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.getGuidToMethodElementMap().values());
        HashSet hashSet = new HashSet();
        while (!arrayList.isEmpty()) {
            for (Object v : arrayList) {
                if (!(v instanceof MethodElement)) continue;
                MethodElement methodElement = (MethodElement)v;
                MultiResourceEObject multiResourceEObject = (MultiResourceEObject)methodElement;
                int n2 = n;
                while (n2 > -1) {
                    OppositeFeature oppositeFeature = (OppositeFeature)list.get(n2);
                    EStructuralFeature eStructuralFeature = oppositeFeature.getTargetFeature();
                    if (eStructuralFeature.getContainerClass().isInstance(methodElement)) {
                        Object object;
                        HashSet<Object> hashSet2;
                        Object object2;
                        if (eStructuralFeature.isMany()) {
                            object2 = (InternalEList)methodElement.eGet(eStructuralFeature);
                            if (!object2.isEmpty()) {
                                Object object32;
                                boolean bl = false;
                                hashSet2 = object2.basicIterator();
                                while (hashSet2.hasNext()) {
                                    object = (InternalEObject)hashSet2.next();
                                    if (!object.eIsProxy() || !set.contains(object32 = object.eProxyURI().fragment())) continue;
                                    bl = true;
                                    break;
                                }
                                if (bl) {
                                    hashSet2 = new HashSet<Object>();
                                    for (Object object32 : object2) {
                                        if (!(object32 instanceof MethodElement) || !set.contains(((MethodElement)object32).getGuid())) continue;
                                        hashSet2.add(object32);
                                    }
                                    object32 = hashSet2.iterator();
                                    while (object32.hasNext()) {
                                        object = object32.next();
                                        if (oppositeFeature.isMany()) {
                                            multiResourceEObject.oppositeAdd(oppositeFeature, object);
                                            continue;
                                        }
                                        multiResourceEObject.getOppositeFeatureMap().put(oppositeFeature, object);
                                    }
                                }
                            }
                        } else {
                            InternalEObject internalEObject;
                            object2 = methodElement.eGet(eStructuralFeature, false);
                            if (object2 instanceof InternalEObject && (internalEObject = (InternalEObject)object2).eIsProxy() && set.contains(hashSet2 = internalEObject.eProxyURI().fragment())) {
                                object = methodElement.eGet(eStructuralFeature);
                                if (oppositeFeature.isMany()) {
                                    multiResourceEObject.oppositeAdd(oppositeFeature, object);
                                } else {
                                    multiResourceEObject.getOppositeFeatureMap().put(oppositeFeature, object);
                                }
                            }
                        }
                    }
                    --n2;
                }
            }
            hashSet.addAll(arrayList);
            arrayList = new ArrayList(this.getGuidToMethodElementMap().values());
            arrayList.removeAll(hashSet);
        }
    }

    @Override
    public boolean hasUnresolvedProxy() {
        return this.markerMananger.hasUnresolvedProxy();
    }

    protected Map getURIToTempURIMap() {
        if (this.URIToTempURIMap == null) {
            this.URIToTempURIMap = new HashMap();
        }
        return this.URIToTempURIMap;
    }

    public UnresolvedProxyMarkerManager getMarkerMananger() {
        return this.markerMananger;
    }

    private void checkModify(Collection<Resource> collection) throws LibraryResourceException {
        if (!collection.isEmpty()) {
            Resource[] resourceArray = new Resource[collection.size()];
            collection.toArray(resourceArray);
            this.checkModify(resourceArray, (Object)MsgBox.getDefaultShell());
        }
    }

    @Override
    public void checkModify(Resource[] resourceArray, Object object) throws LibraryResourceException {
        MultiFileSaveUtil.doCheckModify((Collection<Resource>)Arrays.asList(resourceArray));
    }

    @Override
    public IStatus checkModify(Collection<EObject> collection, Object object) {
        HashSet<String> hashSet = new HashSet<String>();
        for (EObject eObject : collection) {
            MultiFileXMIResourceImpl multiFileXMIResourceImpl;
            Resource resource = eObject.eResource();
            if (resource == null || resource.getResourceSet() != this || (multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)resource).hasTempURI()) continue;
            String string = multiFileXMIResourceImpl.getURI().toFileString();
            hashSet.add(string);
        }
        if (hashSet.isEmpty()) {
            return Status.OK_STATUS;
        }
        String[] stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return FileManager.getInstance().checkModify(stringArray, object);
    }

    @Override
    public ILibraryPersister getPersister() {
        return MethodLibraryPersister.INSTANCE;
    }

    public boolean unload(Resource resource, Map map) {
        if (resource instanceof MultiFileXMIResourceImpl) {
            return this.unloadWithoutRemove((MultiFileXMIResourceImpl)resource);
        }
        return false;
    }

    @Override
    public void unload() {
        this.reset();
    }

    @Override
    public MethodLibrary getFirstMethodLibrary() {
        return this.getMethodLibrary();
    }

    public List getMethodLibraries() {
        MethodLibrary methodLibrary = this.getMethodLibrary();
        if (methodLibrary == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(methodLibrary);
    }

    @Override
    public void loadMethodLibraries(URI uRI, Map<?, ?> map) throws LibraryResourceException {
        try {
            this.loadLibrary(uRI.toFileString());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new LibraryResourceException(exception);
        }
    }

    @Override
    public String getPersistenceType() {
        return "xmi";
    }

    @Override
    public boolean unload(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource instanceof MultiFileXMIResourceImpl) {
            ((MultiFileXMIResourceImpl)resource).unloaded((InternalEObject)eObject);
            return true;
        }
        return false;
    }

    public Collection reloadObjects(Collection collection) {
        return null;
    }

    public Resource getResource(IResource iResource) {
        IPath iPath = iResource.getLocation();
        return iPath != null ? PersistenceUtil.getResource(iPath, (ResourceSet)this) : null;
    }

    @Override
    public Collection<Resource> loadNewResources() {
        return this.loadConfigurations();
    }

    public void handleLibraryMoved(String string) {
        PersistenceUtil.replaceURIPrefix(new ArrayList<Resource>((Collection<Resource>)this.getResources()), this.libFolderPath.toOSString(), string);
        ResourceManager resourceManager = this.getRootResourceManager();
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(resourceManager, false){
            private static final long serialVersionUID = 1L;

            protected Iterator getChildren(Object object) {
                ResourceManager resourceManager = (ResourceManager)object;
                return resourceManager.getSubManagers().iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            ResourceManager resourceManager2 = (ResourceManager)abstractTreeIterator.next();
            for (ResourceDescriptor resourceDescriptor : resourceManager2.getResourceDescriptors()) {
                resourceDescriptor.clearResolvedURI();
            }
        }
    }
}

