/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.internal.IFailSafeSavable;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.IFileInfo;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIHelperImpl;
import org.eclipse.epf.persistence.MultiFileXMILoadImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.DefaultValueManager;
import org.eclipse.epf.uma.ecore.util.OppositeFeatureNotification;
import org.eclipse.osgi.util.NLS;

public class MultiFileXMIResourceImpl
extends XMIResourceImpl
implements ILibraryResource,
IFailSafeSavable {
    private static String tempDir;
    private URI finalURI;
    private URI oldURI;
    private String backupFile;
    private String currentTxID;
    private long lastLoadTimeStamp;
    private ResourceDescriptor resourceDescriptor;
    private boolean isUnloading;
    private long modificationStamp;
    private IFileInfo fileInfo;
    private static boolean testResourceLoaded;
    private static final String testResourceURIStr = "file:/C:/temp/newlib/library.xmi";

    public MultiFileXMIResourceImpl(URI uRI) {
        super(uRI);
        this.setIntrinsicIDToEObjectMap(new HashMap());
    }

    protected XMLLoad createXMLLoad() {
        return new MultiFileXMILoadImpl(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new MultiFileXMISaveImpl(this.createXMLHelper());
    }

    protected XMLHelper createXMLHelper() {
        return new MultiFileXMIHelperImpl(this);
    }

    public String getID(EObject eObject) {
        String string = MultiFileSaveUtil.getGuid(eObject);
        if (string != null) {
            return string;
        }
        return super.getID(eObject);
    }

    public void setID(EObject eObject, String string) {
        EObject eObject2;
        String string2;
        String string3 = string2 = string != null ? this.getEObjectToIDMap().put(eObject, string) : (String)this.getEObjectToIDMap().remove(eObject);
        if (this.getResourceSet() == null) {
            System.out.println();
        }
        Map map = ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap();
        if (string2 != null) {
            this.getIDToEObjectMap().remove(string2);
            if (eObject instanceof MethodElement) {
                if (eObject.eIsProxy()) {
                    eObject2 = (EObject)map.get(string);
                    if (eObject2 != null && eObject2.eIsProxy()) {
                        map.remove(string);
                    }
                } else {
                    map.remove(string);
                }
            }
        }
        if (string != null) {
            this.getIDToEObjectMap().put(string, eObject);
            if (eObject instanceof MethodElement) {
                map.put(string, eObject);
                eObject2 = (MethodElement)eObject;
                if (!eObject2.getGuid().equals(string)) {
                    eObject2.setGuid(string);
                }
            }
        }
    }

    protected boolean useUUIDs() {
        return true;
    }

    public String getURIFragment(EObject object) {
        try {
            String string = this.getID((EObject)object);
            if (string != null) {
                return string;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object2 = object.eContainer();
            while (object2 != null && object2.eResource() == this) {
                arrayList.add(((InternalEObject)object2).eURIFragmentSegment(object.eContainingFeature(), object));
                object = object2;
                object2 = object.eContainer();
            }
            object2 = new StringBuffer("/");
            ((StringBuffer)object2).append(this.getURIFragmentRootSegment((EObject)object));
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            while (listIterator.hasPrevious()) {
                ((StringBuffer)object2).append('/');
                ((StringBuffer)object2).append((String)listIterator.previous());
            }
            return ((StringBuffer)object2).toString();
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Error getting URI fragment for " + object);
            throw runtimeException;
        }
    }

    protected void attachedHelper(EObject eObject) {
        String string;
        super.attachedHelper(eObject);
        if (this.useIDs() && (string = this.getID(eObject)) != null) {
            this.getEObjectToIDMap().put(eObject, string);
            if (eObject instanceof MethodElement) {
                ((MultiFileResourceSetImpl)this.getResourceSet()).getGuidToMethodElementMap().put(string, eObject);
            }
        }
        if (this.isTrackingModification() && eObject.eResource() != this) {
            eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        }
    }

    private void attachedAllWithIDs(EObject eObject) {
        ContentTreeIterator contentTreeIterator = new ContentTreeIterator(eObject);
        while (contentTreeIterator.hasNext()) {
            this.attachedHelper((EObject)contentTreeIterator.next());
        }
    }

    private void basicAttachedAll(EObject eObject) {
        eObject.eAdapters().add((Object)this.modificationTrackingAdapter);
        EList eList = eObject.eContents();
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            EObject eObject2 = (EObject)eList.get(n2);
            if (eObject2.eResource() == this) {
                this.basicAttachedAll(eObject2);
            }
            ++n2;
        }
    }

    public void attachedAll(EObject eObject) {
        if (this.useIDs()) {
            this.attachedAllWithIDs(eObject);
        } else {
            this.basicAttachedAll(eObject);
        }
    }

    public void attached(EObject eObject) {
        this.attachedAll(eObject);
    }

    private void detachedAllWithIDs(EObject eObject) {
        ContentTreeIterator contentTreeIterator = new ContentTreeIterator(eObject);
        while (contentTreeIterator.hasNext()) {
            this.detachedHelper((EObject)contentTreeIterator.next());
        }
    }

    private void basicDetachedAll(EObject eObject) {
        eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        EList eList = eObject.eContents();
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            EObject eObject2 = (EObject)eList.get(n2);
            if (eObject2.eResource() == this) {
                this.basicDetachedAll(eObject2);
            }
            ++n2;
        }
    }

    protected EObject getEObjectByID(String string) {
        Iterator iterator = this.getContents().iterator();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            String string2 = MultiFileSaveUtil.getGuid(eObject);
            if (string2 == null || !string2.equals(string)) continue;
            return eObject;
        }
        if (this.idToEObjectMap != null && (iterator = (InternalEObject)this.idToEObjectMap.get(string)) != null && !iterator.eIsProxy()) {
            return iterator;
        }
        return null;
    }

    private IFileInfo getFileInfo() {
        if (this.fileInfo == null || !new File(this.getURI().toFileString()).equals(this.fileInfo.getFile())) {
            this.fileInfo = FileManager.getInstance().getFileInfo(this);
        }
        return this.fileInfo;
    }

    public void load(Map map) throws IOException {
        if (this.isUnloading) {
            return;
        }
        boolean bl = DefaultValueManager.INSTANCE.isUseStatic();
        try {
            DefaultValueManager.INSTANCE.setUseStatic(true);
            super.load(map);
            this.updateTimeStamps();
        }
        finally {
            DefaultValueManager.INSTANCE.setUseStatic(bl);
        }
        if (MultiFileSaveUtil.DEBUG && this.getURI().toString().equals(testResourceURIStr)) {
            testResourceLoaded = true;
        }
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    synchronized boolean reload(Collection collection) throws IOException {
        if (this.isLoaded) {
            Notification notification = this.setLoaded(false);
            this.doUnload(collection, false);
            this.isLoaded = false;
            this.contents = null;
            if (notification != null) {
                this.eNotify(notification);
            }
            this.load(this.getResourceSet().getLoadOptions());
            return true;
        }
        return false;
    }

    final void unloadWithoutRemove() {
        if (this.isLoaded) {
            ResourceDescriptor resourceDescriptor = MultiFileSaveUtil.getResourceDescriptor(this);
            if (resourceDescriptor != null) {
                this.setResourceDescriptor(resourceDescriptor);
            }
            Notification notification = this.setLoaded(false);
            this.doUnload(null, false);
            if (notification != null) {
                this.eNotify(notification);
            }
        }
    }

    protected void doUnload() {
        this.doUnload(null, true);
    }

    /*
     * Exception decompiling
     */
    protected void doUnload(Collection var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void unloaded(InternalEObject internalEObject) {
        this.unloaded(internalEObject, true);
    }

    private void unloaded(InternalEObject internalEObject, boolean bl) {
        URI uRI2;
        String string = MultiFileSaveUtil.getGuid(internalEObject);
        if (string != null) {
            uRI2 = this.resourceDescriptor != null ? MultiFileURIConverter.createURI(this.resourceDescriptor.getId()) : this.getURI();
            internalEObject.eSetProxyURI(uRI2.appendFragment(string));
        }
        internalEObject.eAdapters().clear();
        if (internalEObject instanceof MultiResourceEObject && bl) {
            uRI2 = (MultiResourceEObject)internalEObject;
            Map map = uRI2.basicGetOppositeFeatureMap();
            if (map != null) {
                map.clear();
            }
            uRI2.removeFromAllOppositeFeatures();
        }
        if (internalEObject instanceof ContentDescription || internalEObject instanceof Section) {
            for (URI uRI2 : internalEObject.eClass().getEAllAttributes()) {
                if (uRI2 == UmaPackage.eINSTANCE.getMethodElement_Guid() || !uRI2.getEAttributeType().getInstanceClass().isAssignableFrom(String.class)) continue;
                internalEObject.eSet((EStructuralFeature)uRI2, uRI2.getDefaultValue());
            }
            if (internalEObject.eDirectResource() != null && internalEObject instanceof MultiResourceEObject) {
                ((MultiResourceEObject)internalEObject).eSetResource(null);
            }
        }
    }

    public void detachedAll(EObject eObject) {
        if (this.useIDs()) {
            this.detachedAllWithIDs(eObject);
        } else {
            this.basicDetachedAll(eObject);
        }
    }

    public void detached(EObject eObject) {
        this.detachedAll(eObject);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ResourceImpl.ModificationTrackingAdapter((ResourceImpl)this){

            public void notifyChanged(Notification notification) {
                if (notification instanceof OppositeFeatureNotification) {
                    return;
                }
                super.notifyChanged(notification);
            }
        };
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (MultiFileSaveUtil.DEBUG && testResourceLoaded && this.getURI().toString().equals(testResourceURIStr)) {
            System.out.println("isModified=" + bl);
        }
    }

    public boolean eDeliver() {
        ResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null && !resourceSet.eDeliver()) {
            return false;
        }
        return super.eDeliver();
    }

    public void save(Map map) throws IOException {
        block9: {
            boolean bl = DefaultValueManager.INSTANCE.isUseStatic();
            try {
                DefaultValueManager.INSTANCE.setUseStatic(true);
                if (map == null) {
                    map = MultiFileResourceSetImpl.DEFAULT_SAVE_OPTIONS;
                }
                super.save(map);
                MethodElement methodElement = PersistenceUtil.getMethodElement(this);
                if (!(methodElement instanceof MethodLibrary)) break block9;
                MethodLibrary methodLibrary = (MethodLibrary)methodElement;
                ResourceManager resourceManager = MultiFileSaveUtil.getResourceManager(this);
                if (resourceManager != null) {
                    for (MethodConfiguration methodConfiguration : methodLibrary.getPredefinedConfigurations()) {
                        ResourceDescriptor resourceDescriptor = resourceManager.getResourceDescriptor(methodConfiguration.getGuid());
                        if (resourceDescriptor == null) continue;
                        EcoreUtil.remove((EObject)resourceDescriptor);
                    }
                }
                ArrayList arrayList = new ArrayList(methodLibrary.getPredefinedConfigurations());
                boolean bl2 = methodLibrary.eDeliver();
                try {
                    methodLibrary.eSetDeliver(false);
                    methodLibrary.getPredefinedConfigurations().clear();
                    super.save(map);
                }
                finally {
                    methodLibrary.getPredefinedConfigurations().addAll(arrayList);
                    methodLibrary.eSetDeliver(bl2);
                }
            }
            finally {
                DefaultValueManager.INSTANCE.setUseStatic(bl);
            }
        }
    }

    public URI getFinalURI() {
        if (this.finalURI != null) {
            return this.finalURI;
        }
        return this.getURI();
    }

    public void setFinalURI(URI uRI) {
        this.finalURI = uRI;
    }

    public void backUpURI() {
        this.oldURI = this.getURI();
    }

    public boolean hasTempURI() {
        if (this.currentTxID != null) {
            return this.createTempURI().equals((Object)this.getURI());
        }
        return false;
    }

    private URI createTempURI() {
        MethodElement methodElement = PersistenceUtil.getMethodElement(this);
        return URI.createFileURI((String)new StringBuffer(MultiFileXMIResourceImpl.getTempDir()).append(File.separator).append(this.currentTxID).append("new").append(methodElement.getGuid()).toString());
    }

    static String getTempDir() {
        if (tempDir == null) {
            tempDir = new File(FileManager.getTempDir(), "EPF").getAbsolutePath();
        }
        return tempDir;
    }

    public void setTempURI(String string) {
        if (this.finalURI == null) {
            this.finalURI = this.oldURI = this.getURI();
            this.currentTxID = string;
            URI uRI = this.createTempURI();
            this.setURI(uRI);
            MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)this.getResourceSet();
            multiFileResourceSetImpl.getURIToTempURIMap().put(this.oldURI, uRI);
        }
    }

    private void restoreURI() {
        if (this.oldURI != null) {
            this.setURI(this.oldURI);
        }
    }

    public boolean txStarted() {
        return this.moveStarted() || this.saveStarted();
    }

    protected void updateTimeStamps() {
        FileManager.getInstance().refresh(this);
        this.lastLoadTimeStamp = System.currentTimeMillis();
        IFileInfo iFileInfo = this.getFileInfo();
        if (iFileInfo != null) {
            this.modificationStamp = iFileInfo.getModificationStamp();
        }
    }

    public int checkSynchronized() {
        return this.isSynchronized() ? 1 : 0;
    }

    public boolean isSynchronized() {
        IFileInfo iFileInfo = this.getFileInfo();
        if (iFileInfo != null) {
            return this.modificationStamp == iFileInfo.getModificationStamp();
        }
        return true;
    }

    public void txFinished(boolean bl) {
        MultiFileResourceSetImpl multiFileResourceSetImpl;
        boolean bl2;
        boolean bl3 = bl2 = !this.oldURI.equals((Object)this.finalURI);
        if (bl) {
            this.setURI(this.finalURI);
            if (!bl2) {
                this.setModified(false);
            }
            FileManager.getInstance().refresh(this);
            this.updateTimeStamps();
            if (!bl2 && (multiFileResourceSetImpl = (MultiFileResourceSetImpl)this.getResourceSet()) != null) {
                multiFileResourceSetImpl.getUnresolvedProxyMarkerManager().validateMarkers(this);
            }
        } else {
            this.restoreURI();
            if (bl2) {
                this.finalURI = null;
                MultiFileSaveUtil.updateURIMappings(this, this.oldURI, null, true);
            }
        }
        if (this.oldURI != null) {
            multiFileResourceSetImpl = (MultiFileResourceSetImpl)this.getResourceSet();
            if (multiFileResourceSetImpl != null) {
                multiFileResourceSetImpl.getURIToTempURIMap().remove(this.oldURI);
            }
            this.oldURI = null;
        }
        this.currentTxID = null;
        this.finalURI = null;
    }

    public void deleteBackup() {
        block3: {
            if (this.backupFile != null) {
                try {
                    new File(this.backupFile).delete();
                    this.backupFile = null;
                }
                catch (Throwable throwable) {
                    CommonPlugin.INSTANCE.log((Object)throwable);
                    if (!MultiFileSaveUtil.DEBUG) break block3;
                    throwable.printStackTrace();
                }
            }
        }
    }

    public boolean restore() {
        File file = null;
        File file2 = null;
        boolean bl = false;
        if (this.backupFile != null) {
            file = new File(this.backupFile);
            file2 = new File(this.getFinalURI().toFileString());
        } else {
            boolean bl2 = bl = this.oldURI != null && !this.oldURI.equals((Object)this.finalURI);
            if (bl) {
                File file3 = new File(this.getFinalURI().toFileString());
                file2 = new File(this.oldURI.toFileString());
                boolean bl3 = bl = file3.exists() && !file2.exists();
                if (bl) {
                    file = file3;
                }
            }
        }
        if (file != null) {
            boolean bl4;
            if (file2.exists()) {
                FileUtil.moveFile((File)file2, (File)new File(this.getURI().toFileString()));
            }
            if (bl) {
                bl4 = MultiFileSaveUtil.move(this, file, file2);
            } else {
                boolean bl5 = bl4 = file.lastModified() == file2.lastModified() && FileUtil.getSize((File)file) == FileUtil.getSize((File)file2);
                if (!bl4) {
                    bl4 = FileUtil.moveFile((File)file, (File)file2);
                }
            }
            if (!bl4) {
                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.restoreResourceError_msg, (Object)FileManager.toFileString(this.getFinalURI())));
            }
            return true;
        }
        return false;
    }

    URI getOldURI() {
        return this.oldURI;
    }

    boolean moveStarted() {
        return this.oldURI != null && !this.oldURI.equals((Object)this.getFinalURI());
    }

    boolean saveStarted() {
        return this.currentTxID != null;
    }

    private void refreshURIOfChildResources() {
        ResourceDescriptor resourceDescriptor;
        HashMap<URI, ResourceDescriptor> hashMap = null;
        ResourceManager resourceManager = MultiFileSaveUtil.getResourceManager(this);
        if (resourceManager != null) {
            hashMap = new HashMap<URI, ResourceDescriptor>();
            TreeIterator treeIterator = resourceManager.eAllContents();
            while (treeIterator.hasNext()) {
                Iterator iterator = treeIterator.next();
                if (!(iterator instanceof ResourceDescriptor)) continue;
                resourceDescriptor = (ResourceDescriptor)((Object)iterator);
                hashMap.put(resourceDescriptor.getResolvedURI(), resourceDescriptor);
                resourceDescriptor.clearResolvedURI();
            }
        }
        if (hashMap != null) {
            for (TreeIterator treeIterator : this.getResourceSet().getResources()) {
                resourceDescriptor = (ResourceDescriptor)hashMap.get(treeIterator.getURI());
                if (resourceDescriptor == null) continue;
                treeIterator.setURI(resourceDescriptor.getResolvedURI());
            }
        }
    }

    public void commit() {
        if (this.finalURI != null && !this.getContents().isEmpty()) {
            Object object;
            boolean bl;
            File file = new File(this.finalURI.toFileString());
            boolean bl2 = bl = !this.oldURI.equals((Object)this.finalURI);
            if (bl) {
                object = PersistenceUtil.getMethodElement(this);
                if (object instanceof ContentDescription && file.exists()) {
                    this.finalURI = URI.createFileURI((String)MethodLibraryPersister.getNextAvailableFileName(String.valueOf(file.getParent()) + File.separator, (ContentDescription)object));
                    file = new File(this.finalURI.toFileString());
                }
            } else {
                object = this.getBackupFilePath();
                File file2 = new File((String)object);
                if (file2.exists()) {
                    file2.delete();
                }
                if (file.exists()) {
                    if (FileUtil.moveFile((File)file, (File)file2)) {
                        this.backupFile = object;
                    } else {
                        String string = NLS.bind((String)PersistenceResources.renameError_msg, (Object)file, (Object)object);
                        throw new MultiFileIOException(string);
                    }
                }
            }
            object = new File(bl ? this.oldURI.toFileString() : this.getURI().toFileString());
            boolean bl3 = false;
            Exception exception = null;
            if (bl) {
                bl3 = MultiFileSaveUtil.move(this, (File)object, file);
            } else {
                try {
                    FileUtil.doMoveFile((File)object, (File)file);
                    bl3 = true;
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            }
            if (!bl3) {
                String string = NLS.bind((String)PersistenceResources.renameError_msg, (Object)object, (Object)file);
                if (exception != null) {
                    string = String.valueOf(string) + ": " + (exception.getMessage() != null ? exception.getMessage() : exception.toString());
                }
                throw new MultiFileIOException(string);
            }
            if (bl) {
                MethodElement methodElement;
                ResourceDescriptor resourceDescriptor = MultiFileSaveUtil.getResourceDescriptor(this);
                if (resourceDescriptor != null) {
                    resourceDescriptor.clearResolvedURI();
                    resourceDescriptor.getResolvedURI();
                } else if (MultiFileSaveUtil.DEBUG && (methodElement = PersistenceUtil.getMethodElement(this)) != null && !this.getLibraryPersister().hasOwnResourceWithoutReferrer((Object)methodElement)) {
                    String string = "FATAL ERROR: no ResourceDescriptor found in parent resource for " + this;
                    CommonPlugin.INSTANCE.log((Object)string);
                    System.err.println(string);
                }
                this.refreshURIOfChildResources();
            }
            RefreshJob.getInstance().resourceSaved(this);
        }
    }

    public String getBackupFilePath() {
        String string = new StringBuffer(MultiFileXMIResourceImpl.getTempDir()).append(File.separator).append(this.currentTxID).append("old").append(PersistenceUtil.getMethodElement(this).getGuid()).toString();
        return string;
    }

    public long getLastLoadTimeStamp() {
        return this.lastLoadTimeStamp;
    }

    static void clearDetachedEObjectToIDMap() {
        DETACHED_EOBJECT_TO_ID_MAP.clear();
    }

    void setResourceDescriptor(ResourceDescriptor resourceDescriptor) {
        this.resourceDescriptor = resourceDescriptor;
    }

    public long getLoadStamp() {
        return this.getLastLoadTimeStamp();
    }

    public URI getProxyURI(EObject eObject) {
        String string = MultiFileSaveUtil.getGuid(eObject);
        if (string != null) {
            ResourceDescriptor resourceDescriptor = this.resourceDescriptor != null ? this.resourceDescriptor : MultiFileSaveUtil.getResourceDescriptor(this);
            URI uRI = resourceDescriptor != null ? MultiFileURIConverter.createURI(resourceDescriptor.getId()) : this.getURI();
            return uRI.appendFragment(string);
        }
        return this.getURI().appendFragment(this.getID(eObject));
    }

    public void setTxID(String string) {
        this.setTempURI(string);
    }

    private ILibraryPersister getLibraryPersister() {
        return ((MultiFileResourceSetImpl)this.resourceSet).getPersister();
    }

    private final class ContentTreeIterator
    extends AbstractTreeIterator {
        private static final long serialVersionUID = 1L;

        private ContentTreeIterator(Object object) {
            super(object);
        }

        protected Iterator getChildren(Object object) {
            if (object instanceof EObject) {
                ArrayList<EObject> arrayList = new ArrayList<EObject>();
                EContentsEList eContentsEList = new EContentsEList((EObject)object){

                    protected boolean resolve() {
                        return false;
                    }
                };
                Iterator iterator = eContentsEList.basicIterator();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (eObject.eResource() != MultiFileXMIResourceImpl.this && !eObject.eIsProxy()) continue;
                    arrayList.add(eObject);
                }
                return arrayList.iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }
    }
}

