/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramHandler {
    private File sourceLibRoot;
    private File targetLibRoot;
    private Map<String, MapEntryValue> elementMap = new HashMap<String, MapEntryValue>();
    private static boolean debug = false;

    public DiagramHandler(File file, File file2) {
        this.sourceLibRoot = file;
        this.targetLibRoot = file2;
    }

    protected Map<String, MapEntryValue> getElementMap() {
        return this.elementMap;
    }

    private boolean needToProcess(MethodElement methodElement) {
        boolean bl = methodElement instanceof CapabilityPattern || methodElement instanceof DeliveryProcess;
        return bl;
    }

    public void registerElement(MethodElement methodElement) {
        this.registerElement(methodElement, false);
    }

    public void registerElement(MethodElement methodElement, boolean bl) {
        if (!this.needToProcess(methodElement)) {
            return;
        }
        if (this.elementMap.containsKey(methodElement.getGuid())) {
            return;
        }
        MapEntryValue mapEntryValue = new MapEntryValue();
        mapEntryValue.element = methodElement;
        this.elementMap.put(methodElement.getGuid(), mapEntryValue);
        if (bl) {
            this.processEntry(methodElement, mapEntryValue);
        }
    }

    public void postRegisterElements() {
        for (MapEntryValue mapEntryValue : this.elementMap.values()) {
            this.processEntry(mapEntryValue.element, mapEntryValue);
        }
    }

    private void processEntry(MethodElement methodElement, MapEntryValue mapEntryValue) {
        File[] fileArray = this.getFiles(methodElement);
        File file = fileArray[0];
        File file2 = fileArray[1];
        if (file != null && file.exists()) {
            mapEntryValue.sourceFile = file;
        }
        if (file2.exists()) {
            if (mapEntryValue.sourceFile == null || DiagramHandler.needCopy(mapEntryValue.sourceFile, file2)) {
                mapEntryValue.targetFile = file2;
            }
            mapEntryValue.existing = true;
        } else if (mapEntryValue.sourceFile != null) {
            mapEntryValue.targetFile = file2;
        }
        if (debug) {
            System.out.println("LD> mapEntryValue: ");
            System.out.println(mapEntryValue.toDebugString("LD> "));
            System.out.println("");
        }
    }

    public List getModifiedFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MapEntryValue mapEntryValue : this.elementMap.values()) {
            if (!mapEntryValue.existing || mapEntryValue.targetFile == null) continue;
            arrayList.add(mapEntryValue.targetFile.getAbsolutePath());
        }
        return arrayList;
    }

    public void execute() {
        block2: {
            try {
                this.execute_();
            }
            catch (Throwable throwable) {
                if (!debug) break block2;
                throwable.printStackTrace();
            }
        }
    }

    private void execute_() {
        for (MapEntryValue mapEntryValue : this.elementMap.values()) {
            if (mapEntryValue.targetFile == null) continue;
            if (mapEntryValue.sourceFile != null) {
                mapEntryValue.targetFile.getParentFile();
                FileUtil.copyFile((File)mapEntryValue.sourceFile, (File)mapEntryValue.targetFile);
                if (!debug) continue;
                System.out.println("LD: File copied: " + mapEntryValue.sourceFile);
                continue;
            }
            mapEntryValue.targetFile.delete();
        }
    }

    public static boolean needCopy(File file, File file2) {
        boolean bl = true;
        if (file2.exists()) {
            bl = file2.lastModified() != file.lastModified() || file2.length() != file.length();
        }
        return bl;
    }

    protected File[] getFiles(MethodElement methodElement) {
        return this.getFiles(methodElement, true);
    }

    protected File[] getFiles(MethodElement methodElement, boolean bl) {
        File[] fileArray = new File[2];
        String string = ResourceHelper.getElementPath((MethodElement)methodElement);
        if (debug) {
            System.out.println("LD> elementPath: " + string);
        }
        if (string == null || string.length() == 0) {
            if (debug) {
                System.out.println("LD> elementPath is null or empty!");
            }
            return fileArray;
        }
        String string2 = String.valueOf(string) + methodElement.getName() + File.separator + "diagram.xmi";
        File file = this.sourceLibRoot;
        File file2 = this.targetLibRoot;
        if (bl) {
            file = this.getRoot(methodElement);
        } else {
            file2 = this.getRoot(methodElement);
        }
        fileArray[0] = new File(file, string2);
        fileArray[1] = new File(file2, string2);
        return fileArray;
    }

    public void visitElementMap(int n) {
    }

    public File getSourceLibRoot() {
        return this.sourceLibRoot;
    }

    protected File getRoot(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr((MethodElement)methodElement);
        String string = iLibraryResourceManager.getPhysicalPluginPath(methodElement);
        File file = new File(string).getParentFile();
        return file;
    }

    protected static class MapEntryValue {
        public MethodElement element;
        public File sourceFile;
        public File targetFile;
        public boolean existing = false;

        protected MapEntryValue() {
        }

        public String toDebugString(String string) {
            String string2 = String.valueOf(string) + "element: " + this.element.getName();
            string2 = String.valueOf(string2) + "\n" + string + "sourceFile: " + this.sourceFile;
            string2 = String.valueOf(string2) + "\n" + string + "targetFile: " + this.targetFile;
            string2 = String.valueOf(string2) + "\n" + string + "existing: " + this.existing;
            return string2;
        }
    }
}

