/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.library.IConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExportConfigCheckingPage
extends BaseWizardPage {
    public static final String PAGE_NAME = ExportConfigCheckingPage.class.getName();
    private TextViewer textViewer;
    private TextPresentation style;
    private ConfigurationExportData data;
    private IConfigurationClosure closure = null;

    public ExportConfigCheckingPage(ConfigurationExportData configurationExportData) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.checkConfigPage_title);
        this.setDescription(ExportResources.checkConfigPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/exp_lib_conf_wizban.gif"));
        this.data = configurationExportData;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.textViewer = ExportConfigCheckingPage.createTextViewer((Composite)composite2, (int)360, (int)160, (int)1);
        Document document = new Document(" ");
        this.textViewer.setDocument((IDocument)document);
        this.setControl((Control)composite2);
        this.setPageComplete(true);
    }

    private void displaySummary() {
        this.style = new TextPresentation();
        Document document = this.getSummaryText();
        this.textViewer.setDocument((IDocument)document);
        this.textViewer.changeTextPresentation(this.style, true);
    }

    public void onEnterPage(Object object) {
        this.displaySummary();
    }

    public Document getSummaryText() {
        Runnable runnable;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.data.selectedConfigs.size() == 0) {
            stringBuffer.append(ExportResources.ExportConfigCheckingPage_summary_2);
        } else {
            object = (MethodConfiguration)this.data.selectedConfigs.get(0);
            if (this.closure == null || this.closure.getConfiguration() != object) {
                runnable = new Runnable((MethodConfiguration)object){
                    private final /* synthetic */ MethodConfiguration val$config;
                    {
                        this.val$config = methodConfiguration;
                    }

                    public void run() {
                        ExportConfigCheckingPage.this.closure = (IConfigurationClosure)new ConfigurationClosure(null, this.val$config);
                    }
                };
                UserInteractionHelper.runWithProgress((Runnable)runnable, (String)ExportResources.ExportConfigCheckingPage_checking);
            }
        }
        object = this.closure.getAllErrors();
        if (object.size() == 0) {
            stringBuffer.append(ExportResources.ExportConfigCheckingPage_summary_3);
        } else {
            stringBuffer.append(ExportResources.bind((String)ExportResources.ExportConfigCheckingPage_summary_4, (Object[])new Object[]{Integer.toString(object.size())}));
        }
        runnable = new Document(stringBuffer.toString());
        return runnable;
    }
}

