/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.util;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.SupportingMaterial;

public class DiagramInfo {
    private static final String AD_IMAGE_URI = "ad_image_uri";
    private static final String ADD_IMAGE_URI = "add_image_uri";
    private static final String WPD_IMAGE_URI = "wpd_image_uri";
    private static final String PUBLISH_AD_IMAGE = "publish_ad_image";
    private static final String PUBLISH_ADD_IMAGE = "publish_add_image";
    private static final String PUBLISH_WPD_IMAGE = "publish_wpd_image";
    private static final String DELIMITER = "|";
    private Activity activity;
    private String AD_ImageURI;
    private String ADD_ImageURI;
    private String WPD_ImageURI;
    private boolean publishADImage;
    private boolean publishADDImage;
    private boolean publishWPDImage;
    private Constraint constraint;
    private SupportingMaterial activityDiagram;
    private SupportingMaterial activityDetailDiagram;
    private SupportingMaterial wpdDiagram;

    public DiagramInfo(Activity activity) {
        this.activity = activity;
        this.refresh();
    }

    private DiagramInfo() {
        this.WPD_ImageURI = "";
        this.ADD_ImageURI = "";
        this.AD_ImageURI = "";
    }

    private DiagramInfo load() {
        DiagramInfo diagramInfo = new DiagramInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(this.constraint.getBody(), DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf(61);
            int n2 = string.length() - 1;
            if (n == -1 || n >= n2) continue;
            String string2 = string.substring(0, n);
            if (string2.equalsIgnoreCase(AD_IMAGE_URI)) {
                diagramInfo.AD_ImageURI = string.substring(n + 1);
                continue;
            }
            if (string2.equalsIgnoreCase(ADD_IMAGE_URI)) {
                diagramInfo.ADD_ImageURI = string.substring(n + 1);
                continue;
            }
            if (string2.equalsIgnoreCase(WPD_IMAGE_URI)) {
                diagramInfo.WPD_ImageURI = string.substring(n + 1);
                continue;
            }
            if (string2.equalsIgnoreCase(PUBLISH_AD_IMAGE)) {
                diagramInfo.publishADImage = Boolean.valueOf(string.substring(n + 1));
                continue;
            }
            if (string2.equalsIgnoreCase(PUBLISH_ADD_IMAGE)) {
                diagramInfo.publishADDImage = Boolean.valueOf(string.substring(n + 1));
                continue;
            }
            if (!string2.equalsIgnoreCase(PUBLISH_WPD_IMAGE)) continue;
            diagramInfo.publishWPDImage = Boolean.valueOf(string.substring(n + 1));
        }
        return diagramInfo;
    }

    private void save() {
        if (this.constraint == null) {
            this.constraint = ConstraintManager.getConstraint((MethodElement)this.activity, (String)"diagram", (boolean)true);
        }
        if (this.activityDiagram != null) {
            this.AD_ImageURI = this.activityDiagram.getGuid();
        }
        if (this.activityDetailDiagram != null) {
            this.ADD_ImageURI = this.activityDetailDiagram.getGuid();
        }
        if (this.wpdDiagram != null) {
            this.WPD_ImageURI = this.wpdDiagram.getGuid();
        }
        DiagramInfo diagramInfo = this.load();
        if (this.AD_ImageURI != null) {
            diagramInfo.AD_ImageURI = this.AD_ImageURI;
        }
        if (this.ADD_ImageURI != null) {
            diagramInfo.ADD_ImageURI = this.ADD_ImageURI;
        }
        if (this.WPD_ImageURI != null) {
            diagramInfo.WPD_ImageURI = this.WPD_ImageURI;
        }
        diagramInfo.publishADImage = this.publishADImage;
        diagramInfo.publishADDImage = this.publishADDImage;
        diagramInfo.publishWPDImage = this.publishWPDImage;
        String string = new StringBuffer(AD_IMAGE_URI).append('=').append(diagramInfo.AD_ImageURI).append(DELIMITER).append(PUBLISH_AD_IMAGE).append('=').append(String.valueOf(diagramInfo.publishADImage)).append(DELIMITER).append(ADD_IMAGE_URI).append('=').append(String.valueOf(diagramInfo.ADD_ImageURI)).append(DELIMITER).append(PUBLISH_ADD_IMAGE).append('=').append(String.valueOf(diagramInfo.publishADDImage)).append(DELIMITER).append(WPD_IMAGE_URI).append('=').append(String.valueOf(diagramInfo.WPD_ImageURI)).append(DELIMITER).append(PUBLISH_WPD_IMAGE).append('=').append(String.valueOf(diagramInfo.publishWPDImage)).toString();
        this.constraint.setBody(string);
    }

    public void refresh() {
        this.constraint = ConstraintManager.getConstraint((MethodElement)this.activity, (String)"diagram", (boolean)false);
        if (this.constraint == null) {
            return;
        }
        DiagramInfo diagramInfo = this.load();
        this.AD_ImageURI = diagramInfo.AD_ImageURI;
        this.ADD_ImageURI = diagramInfo.ADD_ImageURI;
        this.WPD_ImageURI = diagramInfo.WPD_ImageURI;
        this.publishADImage = diagramInfo.publishADImage;
        this.publishADDImage = diagramInfo.publishADDImage;
        this.publishWPDImage = diagramInfo.publishWPDImage;
        this.activityDiagram = this.getSupportingMaterial(this.AD_ImageURI);
        this.activityDetailDiagram = this.getSupportingMaterial(this.ADD_ImageURI);
        this.wpdDiagram = this.getSupportingMaterial(this.WPD_ImageURI);
    }

    public String getAD_ImageURI() {
        return this.AD_ImageURI;
    }

    public String getADD_ImageURI() {
        return this.ADD_ImageURI;
    }

    public String getWPD_ImageURI() {
        return this.WPD_ImageURI;
    }

    public boolean canPublishADDImage() {
        return this.publishADDImage;
    }

    public void setPublishADDImage(boolean bl) {
        this.publishADDImage = bl;
        this.save();
    }

    public boolean canPublishADImage() {
        return this.publishADImage;
    }

    public void setPublishADImage(boolean bl) {
        this.publishADImage = bl;
        this.save();
    }

    public boolean canPublishWPDImage() {
        return this.publishWPDImage;
    }

    public void setPublishWPDImage(boolean bl) {
        this.publishWPDImage = bl;
        this.save();
    }

    public SupportingMaterial getActivityDiagram() {
        return this.activityDiagram;
    }

    public SupportingMaterial getActivityDetailDiagram() {
        return this.activityDetailDiagram;
    }

    public SupportingMaterial getWPDDiagram() {
        return this.wpdDiagram;
    }

    public void setWPDDiagram(SupportingMaterial supportingMaterial) {
        if (this.wpdDiagram != supportingMaterial) {
            SupportingMaterial supportingMaterial2 = this.wpdDiagram;
            this.wpdDiagram = supportingMaterial;
            this.update(supportingMaterial2, supportingMaterial);
        }
    }

    public void setActivityDetailDiagram(SupportingMaterial supportingMaterial) {
        if (this.activityDetailDiagram != supportingMaterial) {
            SupportingMaterial supportingMaterial2 = this.activityDetailDiagram;
            this.activityDetailDiagram = supportingMaterial;
            this.update(supportingMaterial2, supportingMaterial);
        }
    }

    public void setActivityDiagram(SupportingMaterial supportingMaterial) {
        if (this.activityDiagram != supportingMaterial) {
            SupportingMaterial supportingMaterial2 = this.activityDiagram;
            this.activityDiagram = supportingMaterial;
            this.update(supportingMaterial2, supportingMaterial);
        }
    }

    private SupportingMaterial getSupportingMaterial(String string) {
        for (SupportingMaterial supportingMaterial : this.activity.getSupportingMaterials()) {
            if (!supportingMaterial.getGuid().equals(string)) continue;
            return supportingMaterial;
        }
        return null;
    }

    private void update(SupportingMaterial supportingMaterial, SupportingMaterial supportingMaterial2) {
        if (supportingMaterial != null) {
            this.activity.getSupportingMaterials().remove(supportingMaterial);
        }
        if (supportingMaterial2 != null) {
            this.activity.getSupportingMaterials().add(supportingMaterial2);
        }
        this.save();
    }

    public boolean isDiagram(SupportingMaterial supportingMaterial) {
        return supportingMaterial != null && (supportingMaterial == this.activityDiagram || supportingMaterial == this.activityDetailDiagram || supportingMaterial == this.wpdDiagram);
    }
}

